CONST SectorSize=$200; AskBootSize=$400;

VAR Req:RECORD Sector:Longint; Count:Word; BufAdr:Pointer; END;
    Req_Status:Word; Req_Drive,Req_Large:Byte;
PROCEDURE RegsForDiskIO(Drive:Byte; BufOfs,Sector:Word; Count:Integer);
 INLINE({ $CC/}$59/$5A/$5B/$58/$55/$89/$26/>Req_Status);
PROCEDURE DiskReadIntr; INLINE($CD/$25);
PROCEDURE DiskWriteIntr; INLINE($CD/$26);
PROCEDURE FinishDiskIO;
 INLINE($8B/$26/>Req_Status/$5D/$1B/$D2/$23/$C2/$A3/Req_Status);

CONST Hex:ARRAY[0..$F] OF Char='0123456789abcdef';

PROCEDURE CheckDiskError(Writing:Boolean); VAR Shf:Byte;
 (* error checking after bootsector reading/writing *)
 BEGIN IF Req_Status=0 THEN Exit;
 Write('Disk I/O Error '); Shf:=16;
 WHILE Shf>0 DO BEGIN Dec(Shf,4);Write(Hex[$F AND(Req_Status SHR Shf)]);END;
 IF Writing THEN Write(' writ') ELSE Write(' read');
 Writeln('ing drive ',Char(Byte('A')+Req_Drive),': '); Halt;
 END;

PROCEDURE ReadBootSector(Drive:Byte; VAR Buf);
 (* read boot sector: autodetect what mode is to be used *)
 BEGIN Req.Sector:=0; Req.Count:=1; Req.BufAdr:=@Buf;
 Req_Drive:=Drive; Req_Large:=0; Req_Status:=0;
 REPEAT Inc(Req_Large); IF Req_Large=1
   THEN RegsForDiskIO(Req_Drive,Ofs(Req.BufAdr^),0,1) (* 1st *)
   ELSE RegsForDiskIO(Req_Drive,Ofs(Req),0,-1);       (* 2nd *)
  DiskReadIntr; FinishDiskIO;
  IF Req_Status<>$0207 THEN Inc(Req_Large); (* stop *)
 UNTIL (Req_Large>1); CheckDiskError(FALSE);
 END;

PROCEDURE WriteBootSector;
 (* write boot sector: same drive/buffer/mode as most recent read *)
 BEGIN IF Req_Large=2
  THEN RegsForDiskIO(Req_Drive,Ofs(Req.BufAdr^),0,1)
  ELSE RegsForDiskIO(Req_Drive,Ofs(Req),0,-1);
 DiskWriteIntr; FinishDiskIO; CheckDiskError(TRUE);
 END;

VAR BootSectBuf,FileBuf:ARRAY[0..SectorSize-1] OF Byte; Idx:Word;
    AskBootBuf:ARRAY[0..AskBootSize-1] OF Byte; Drv,Answer:Char;
    BootName:String[3+8+1+3]; FatName:String[8]; FatType:Byte;
    BootFile,InputFile:File; ImageName:String ABSOLUTE BootSectBuf;
CONST BootNameBgn:ARRAY[0..3] OF Char=#15'*:\';
      DummyRom:ARRAY[0..3] OF Byte=($55,$AA,1,$CB);

PROCEDURE SetupBootSector;
 BEGIN ReadBootSector(Byte(Drv)-Byte('A'),BootSectBuf);
(* this code can be used to show the bootsector *) { FOR Idx:=0 TO $3F DO
 BEGIN Write(' ',Hex[BootSectBuf[Idx] SHR 4],Hex[BootSectBuf[Idx] AND $F]);
 IF Idx AND $F=$F THEN Writeln;
 END; }

 (* the file 'BOOTSECT.BIN' contains new bootsector *)
 Assign(InputFile,'BOOTSECT.BIN'); Reset(InputFile,1);
 Seek(InputFile,FileSize(InputFile)-SectorSize);
 BlockRead(InputFile,FileBuf,SectorSize); Close(InputFile);

 (* need set BootName = name of boot file *)
 Move(BootNameBgn,BootName,SizeOf(BootNameBgn));
 Move(FileBuf[SectorSize-14],BootName[SizeOf(BootNameBgn)],8);
 Move(FileBuf[SectorSize-6],BootName[SizeOf(BootNameBgn)+9],3);
 BootName[SizeOf(BootNameBgn)+8]:='.';
 BootName[1]:=Drv; Assign(BootFile,BootName);

 (* examine bootsector - is it original or our? *)
 Idx:=0; WHILE (Idx<11) AND (BootSectBuf[Idx]=FileBuf[Idx]) DO Inc(Idx);
 IF Idx=11 THEN (* our - can eventually uninstall *)
  BEGIN Reset(BootFile,1); Seek(BootFile,2); BlockRead(BootFile,Idx,2);
  Seek(BootFile,Idx); BlockRead(BootFile,BootSectBuf,SectorSize);
  Write('Boot select already installed - uninstall? (U/N) ');
  Readln(Answer); IF UpCase(Answer)<>'U' THEN Exit;
  Close(BootFile); WriteBootSector; Erase(BootFile); Halt;
  END;

 (* first determine or ask about FAT type *)
 FatName[0]:=#8; Move(BootSectBuf[$36],FatName[1],8);
 FatType:=Byte(FatName[5]); FatName[5]:='*';
 IF (FatName<>'FAT1*   ') OR (FatType OR 4 <> Byte('6')) THEN
  BEGIN Write('Is the FAT on the drive 12 or 16 bit (T/S): ');
  Readln(Answer); CASE UpCase(Answer) OF
   'T': FatType:=3; 'S': FatType:=4; ELSE Halt; END;
  END ELSE FatType:=3+((FatType AND 4) SHR 2);
 Writeln(4*FatType,'-bit FAT assumed.');

 (* read the code which will ask for boot type *)
 Assign(InputFile,'ASKBOOT.BIN'); Reset(InputFile,1);
 BlockRead(InputFile,AskBootBuf,AskBootSize,Idx); Close(InputFile);

 (* prepare boot file *)
 Rewrite(BootFile,1); Move(Idx,AskBootBuf[2],2);
 BlockWrite(BootFile,AskBootBuf,Idx);
 BlockWrite(BootFile,BootSectBuf,SectorSize); Idx:=FilePos(BootFile);
 BlockWrite(BootFile,DummyRom,SizeOf(DummyRom)); Close(BootFile);

 (* move our code to boot sector and write it *)
 Move(FileBuf[$3E],BootSectBuf[$3E],SectorSize-$3E);
 Move(FileBuf[0],BootSectBuf[0],3+8);
 BootSectBuf[SectorSize-3]:=FatType; WriteBootSector;

 (* finally open boot file and seek proper position for putting program *)
 Reset(BootFile,1); Seek(BootFile,Idx);
 END;

BEGIN Req_Drive:=$FF; Write('Drive to be setup for boot (e.g. A): ');
Readln(Drv); Drv:=UpCase(Drv); SetupBootSector;
(* now boot file is positioned for putting "bootrom" code on it *)
Write('Name of file containing BootRom image: ');
Readln(ImageName); Assign(InputFile,ImageName); Reset(InputFile,1);
REPEAT BlockRead(InputFile,AskBootBuf,SizeOf(AskBootBuf),Idx);
 BlockWrite(BootFile,AskBootBuf,Idx);
UNTIL Idx=0; Close(BootFile); Writeln('Ready...');
END.
