		title	ncpdisk - "disk" access to image
;		model	tiny,nolanguage
		model	tiny,assembler
		locals	$$

ExecStkSize	=	80h		; size of stack used for exec(in words)
DiskStkSize	=	80h		; size of stack used for disk I/O
SectorSize	=	512

		.seq			; these directives are for infomation
		.code			; only, Turbo Assembler ignores them
		org	100h		; in TINY memory model, but they are
		.data			; here for a case of other assembler...
		.const			; all initialization is put as const

mpush		macro	r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,ra,rb,rc,rd,re,rf
		irp	q,<rf,re,rd,rc,rb,ra,r9,r8,r7,r6,r5,r4,r3,r2,r1,r0>
		ifnb	<q>
		push	q
		endif
		endm
		endm
mpop		macro	r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,ra,rb,rc,rd,re,rf
		irp	q,<r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,ra,rb,rc,rd,re,rf>
		ifnb	<q>
		pop	q
		endif
		endm
		endm
iseq		macro	is
		irp	i,<is>
		i
		endm
		endm
imov		macro	dst,src,tmp
		ifnb	<tmp>
		mov	tmp,src
		mov	dst,tmp
		else
		push	src
		pop	dst
		endif
		endm
getenv		macro	pattern
		lea	si,pattern
		call	getenv_proc
		endm

dblword		struc
lw		dw	?
hw		dw	?
dblword		ends

		assume	ds:Nothing,es:Nothing,ss:Nothing
endresidentcode	label	byte		; end of resident code

		.data
		align	2
StackPattern	=	-1
StackBase	dw	DiskStkSize dup (StackPattern)
Disk_Io_Sp	label	word
		dw	ExecStkSize dup (StackPattern)
Initial_Sp	label	word
EnvSeg		equ	@Code:[2Ch]
Fcb1		equ	@Code:[5Ch]
ExtraSectors	dw	0
NcpIoRequest	db	0
NcpFileHandle	db	6 dup(0)
NcpIoOffset	dd	0
NcpIoLength	dw	2
NcpIoResult	dw	-1
NcpIoBuffer	label	byte
NcpIoBufferW	label	word
		db	NcpFileHandle[24h]-this byte dup (?)
ExecParBlk	dw	0,DummyCmd,-1,DummyFcb,-1,DummyFcb,-1
DummyFcb	db	0,11 dup (' ')
DummyCmd	db	7, '/E:1600',0Dh
		db	NcpIoBuffer[SectorSize]-this byte dup (?)
drive		db	-1
flags		db	0
f_stsok		=	1		; means we have actual diskette status
f_inuse		=	2		; to be used to prevent re-entry
f_nochg		=	4		; set after initial signalling disk chg
status		db	0
sidecnt		db	2		; side count (1 or 2)
					; (take from boot sect word[1Ah])
sectptr		db	15		; # sectors/track
					; (take from boot sect word[18h])
Function	db	?

		.code
		assume	ds:Nothing,es:Nothing,ss:Nothing
start:		jmp	init
Int40Normal	label	near
		db	0EAh
OldInt40Vect	dd	0F000FFF0h
OldInt40Ofs	equ	OldInt40Vect.lw
OldInt40Seg	equ	OldInt40Vect.hw

		.const
comspec_offset	dw	-1
comspec_pattern	db	8,'COMSPEC='
must_be_com_msg	db	'This program must be linked as .COM file!',7,13,10,'$'
init_error_msg	db	'Missed COMSPEC in environment!',7,13,10,'$'
usage_error_msg	db	'Usage: NCPDISK drive(A/B): image_name',7,13,10,'$'
open_error_msg	db	'Image open error, bad name?',7,13,10,'$'
	ifndef	NCPOPEN
open_rdonly_msg	db	'Access=Read-Only',13,10,'$'
open_rdwr_msg	db	'Access=Read-Write',13,10,'$'
	endif
need_fmt_msg	db	'WARNING: not DOS disk, need format!',7,13,10,'$'
i_media		db	0
BootHelp	db	'BootHelp'

		assume	ds:Nothing,es:Nothing,ss:Nothing
Message		proc	near
		imov	ds,cs		; write message to stderr:
		mov	dx,si		; .. address of error message
		xor	cx,cx
$$1:		lodsb
		cmp	al,'$'
		loopnz	$$1
		not	cx		; .. length of error message
		mov	bx,2		; .. stderr handle
		mov	ah,40h
		int	21h
		ret
Message		endp

		assume	ds:Nothing,es:Nothing,ss:Nothing
init		label	near
		mov	ax,cs
		mov	dx,ds
		cmp	ax,dx
		jz	i_com
		lea	si,must_be_com_msg
i_abt:		call	Message
		mov	ah,1		; and wait for key ..
		int	21h
		mov	ax,4CFFh	; .. and exit
		int	21h

		assume	ds:Nothing,es:Nothing,ss:Nothing
i_usage_err:	lea	si,usage_error_msg
		jmp	i_abt
i_open_err:	lea	si,open_error_msg
		jmp	i_abt
i_noshl_err:	lea	si,init_error_msg
		jmp	i_abt
		assume	ds:@Code,es:@Code,ss:@Code	; know it is COM file
;
i_com:		lea	sp,initial_sp
		mov	al,Fcb1		; check parameter (which drive)
		dec	ax
		mov	drive,al
		cmp	al,1
		ja	i_usage_err
		lea	di,Fcb1+1
		mov	al,' '
		mov	cx,11
		cld
		repz	scasb
		jnz	i_usage_err
		mov	si,81h
		call	getnamefcl
		jc	i_usage_err
		call	getnamefcl
		test	dx,dx
		jz	i_usage_err
		ifdef	debug
		int	3
		endif
	ifdef	NCPOPEN
		xchg	dx,si
		lea	di,NcpOpenReq
		push	di
		mov	ax,600h
		imov	es,ds
		cld
		stosw
		scasb
		xor	cx,cx
i_mvfn:		lodsb
		cmp	al,0
		stosb
		loopnz	i_mvfn
i_mvfe:		not	cx
		pop	si
		mov	[si+2],cl
		add	cx,3
		ifdef	debug
		int	3
		endif
		lea	di,NcpFileHandle
		mov	dx,24h
		mov	ax,0F241h
		int	21h
		cmp	al,0
		jnz	i_open_err
	else
		call	i_OpenByDos
		jc	i_open_err
	endif
;
		lea	di,ExecParBlk	; setup EXEC parameter block
		mov	ax,EnvSeg
		scasw
		mov	ax,cs
		iseq	<scasw,stosw,scasw,stosw,scasw,stosw>
		getenv	comspec_pattern	; get COMSPEC
		assume	es:Nothing
		jc	i_noshl_err	; .. not found - error
		mov	comspec_offset,di
;		call	length_esdi2cx
;		mov	comspec_length,cx
		imov	es,ds
;
		ifdef	debug
		int	3
		endif
		xor	ax,ax
		mov	NcpIoOffset.lw,ax
		mov	NcpIoOffset.hw,ax
		mov	NcpIoLength,2
		clc
i_look:		lahf
		push	ax
		call	i_ReadSect
		pop	ax
		jnz	i_l_er
		sahf
		jc	i_l_cf
i_l_fe:		cmp	i_BufferW[SectorSize-2],0AA55h
		jnz	i_l_nb
		lea	di,i_Buffer[3]
		lea	si,BootHelp
		cld
		mov	cx,4
		repz	cmpsw
		jz	i_l_nb
		mov	ax,i_BufferW[18h]; sectors/track
		mov	dx,i_BufferW[1Ah]; head count
		test	ax,0FFC0h
		jnz	i_l_nb
		dec	dx
		cmp	dx,2
		inc	dx
		jnc	i_l_nb
		mov	sectptr,al
		mov	sidecnt,dl
		mov	al,i_Buffer[15h]; media type
		mov	i_Media,al
		jc	i_l_av
i_l_nb:		clc
i_l_av:		pushf
		mov	ax,NcpIoOffset.hw
		add	al,2
		mov	NcpIoOffset.hw,ax
		mov	ax,NcpIoOffset.lw
		adc	ah,0
		adc	al,0
		mov	NcpIoOffset.lw,ax
		inc	ExtraSectors
		popf
		jmp	i_look
i_l_cf:		mov	al,i_Media
		cmp	al,i_Buffer[0]
		jnz	i_l_fe
		cmp	i_BufferW[1],-1
		jnz	i_l_fe
		dec	ExtraSectors
		jmp	short i_done
i_l_er:		mov	ExtraSectors,0
		lea	si,need_fmt_msg
		call	Message
		mov	sectptr,15
		mov	sidecnt,2
;
i_done:	;	mov	ax,3540h	; connect to interrupt 40h
	;	int	21h
	;	mov	OldInt40Seg,es
	;	mov	OldInt40Ofs,bx
	;	lea	dx,Int40Handler
	;	mov	ax,2540h
	;	int	21h
		mov	ah,13h
		int	2fh
		assume	ds:Nothing
		mov	ax,ds
		imov	ds,cs
		assume	ds:@Code
		mov	OldInt40Seg,ax
		mov	OldInt40Ofs,dx
		lea	dx,Int40Handler
		mov	ah,13h
		int	2fh
	;
		mov	dx,comspec_offset; setup registers for EXEC
		mov	ds,EnvSeg
		assume	ds:Nothing
		imov	es,cs
		assume	es:@Code
		lea	bx,ExecParBlk
		mov	ax,4B00h
		mpush	ax,bx		; before EXEC must free memory
		mov	ah,4Ah
		lea	bx,endresidentcode+15
		mov	cl,4
		shr	bx,cl		; bx = resident code size in para
		jmp	exec_comspec	; must continue in resident code

	ifndef	NCPOPEN
i_OpenByDos	proc	near
		int	3
		mov	cx,4
i_obd_try:	mov	ax,cx
		add	al,al
		add	ax,3d40h-4-2
		and	al,42h
		int	21h
		sbb	ch,-1
		loopz	i_obd_try
		stc
		jcxz	i_obd_end
		push	cx
		xchg	ax,bx
		mov	ax,0e909h
		int	21h
		cmp	al,0
		pop	ax
		jnz	i_obd_end
		test	al,1
		lea	di,NcpFileHandle
		xchg	ax,bx
		stosw
		xchg	ax,cx
		stosw
		xchg	ax,dx
		stosw
		lea	si,open_rdonly_msg
		jz	i_obd_msg
		lea	si,open_rdwr_msg
i_obd_msg:	call	Message
		clc
i_obd_end:	ret
i_OpenByDos	endp
	endif

i_ReadSect	proc	near
		lea	si,NcpIoRequest
		lea	di,i_InBuffer
		mov	cx,offset NcpIoResult-offset NcpIoRequest
		mov	dx,SectorSize+2
		mov	ax,0F248h
		int	21h
		cmp	al,0
		jnz	i_rs_error
		cmp	word ptr @Code:i_InBuffer,2
i_rs_error:	ret
i_ReadSect	endp

getnamefcl	proc	near
		xor	dx,dx
$$b:		call	getcmdchar
		jc	$$x
		jz	$$b
		lea	dx,[si-1]
$$n:		call	getcmdchar
		jnz	$$n
		mov	byte ptr [si-1],0
$$x:		ret
getnamefcl	endp

getcmdchar	proc	near
		assume	ds:@Code,es:Nothing,ss:Nothing
		lodsb
		cmp	al,' '
		jnc	$$x
		cmp	al,0Dh
		jnz	$$t
		stc
		ret
$$t:		cmp	al,9
		clc
$$x:		ret
getcmdchar	endp

		.code
		assume	ds:Nothing,es:Nothing
NcpIoHelper	proc	near
		lea	si,NcpIoRequest
		lea	di,NcpIoResult
		mov	ah,0F2h
		int	21h
		cmp	al,0
		ret
NcpIoHelper	endp

exec_comspec	proc	near
		int	21h
		jc	$$1
		mpop	ax,bx
		int	21h
		cli
		imov	ss,cs,dx
		assume	ss:@Code
		lea	sp,Initial_Sp
		ifdef	debug
		int	3
		endif
		sti
		mov	ds,dx
		assume	ds:@Code
		jc	$$1
		mov	ah,4Dh
		int	21h
$$1:		imov	es,ds
		push	ax
;
		mov	cx,7		; get file size
		mov	dx,4
		mov	al,47h
		call	NcpIoHelper
		jnz	$$4
		ifdef	debug
		int	3
		endif
		mov	dx,NcpIoResult
		mov	ax,NcpIoResult[2]
		xchg	al,ah
		xchg	dl,dh
		mov	bx,SectorSize
		cmp	dx,bx
		jnb	$$2
		div	bx
		jmp	short $$3
$$2:		mov	ax,-1
$$3:		xchg	ax,bx		; bx=size in sectors
		xor	ax,ax		; read 1st "sector"
		cmp	ax,ExtraSectors
		jz	$$4		; .. no need to update it
		mov	NcpIoOffset.lw,ax
		mov	NcpIoOffset.hw,ax
		mov	cx,13
		mov	dx,SectorSize+2
		mov	al,48h
		call	NcpIoHelper
		jnz	$$4
		xchg	ax,bx
		cmp	ax,NcpIoBufferW[13h]
		jna	$$4
		mov	NcpIoBufferW[13h],ax
		lea	di,NcpIoResult	; move data for write
		mov	si,di
		cld
		lodsw
		cmp	ax,2
		xchg	al,ah
		xchg	ax,cx
		rep	movsb
		mov	cx,SectorSize+13
		xor	dx,dx
		mov	al,49h
		call	NcpIoHelper
$$4:		xor	dx,dx		; close file
		mov	cx,7
		mov	al,42h
		call	NcpIoHelper
	;
		mov	ah,13h
		int	2fh
		lds	dx,OldInt40Vect
		assume	ds:Nothing
		mov	ah,13h
		int	2fh
	;	mov	ax,2540h
	;	int	21h
		pop	ax
		mov	ah,4Ch
		int	21h
exec_comspec	endp
		assume	ss:Nothing

Int40Handler	proc	far
		assume	ds:Nothing,es:Nothing,ss:Nothing
		cmp	dl,drive
		ifdef	debug
		int	3
		endif
		jz	$$our	; .. our drive
		cmp	ah,1
		jz	$$norm
$$nsts:		and	flags,not f_stsok
$$norm:		clc
		jmp	Int40Normal
$$done:		or	flags,f_stsok
		mov	status,ah
$$exit:		cmp	ah,1
		cmc
		ret	2
$$our:		cmp	ah,05h
		jna	$$bfnc
		cmp	ah,18h
		jnz	$$nofs
$$ignr:		mov	ah,0
		jmp	$$done
$$nofs:		cmp	ah,16h		; don't service functions above 5
		jnz	$$nsts		; except 16h = check disk change
$$bfnc:		cmp	ah,01h
		ja	$$proc		; request to be processed
		jb	$$nsts		; don't service reset
		test	flags,f_stsok
		jz	$$norm		; valid status is from BIOS
		mov	ah,status
		jmp	$$exit
$$chng:		cmp	ah,16h
		mov	ah,6
		jz	$$done
		or	flags,f_nochg
		jmp	$$done
$$proc:		test	flags,f_nochg
		jz	$$chng
		cmp	ah,16h
		jz	$$ignr
		mpush	ax,cx,dx,ds,es,si,di
		imov	ds,cs
		assume	ds:@Code
		cmp	ah,05h
		jnz	$$nfmt
		mov	sectptr,al
		mov	cl,1
$$nfmt:		mov	al,sidecnt	; compute starting offset
		mul	ch
		add	al,dh		; al=track
		mul	sectptr
		mov	ch,0
		add	ax,cx
		dec	ax		; ax=sector (numbered from 0)
;		mov	XfrBgnSector,ax
		add	ax,ExtraSectors
		mov	cx,SectorSize
		mul	cx		; dxax=offset
		xchg	al,ah
		xchg	dl,dh
		mov	NcpIoOffset.hw,ax
		mov	NcpIoOffset.lw,dx
;		mov	NcpIoLength,2
;
		pop	cx		; function code/sector count
		push	cx		; (s: ax,cx,dx,ds,es,si,di)
		mov	si,bx		; buffer offset
		cmp	cl,7Fh		; cl=sector count, ch=function
		jbe	$$scok
		mov	cl,7Fh
$$scok:		shr	ch,1
		dec	ch
		mov	ch,0
		cld
$$loop:		push	cx
		pushf
		mov	cx,SectorSize+2
		mov	di,offset NcpIoResult
		jnc	$$l_io
		mov	cl,0
		push	es
		imov	es,cs
		jz	$$l_wr
		push	bx
		xor	bx,bx
		mov	ds,bx
		lds	bx,[bx+4*1Eh]
		mov	al,[bx+8]
		pop	bx
		rep	stosb
		jmp	short $$l_wf
$$l_wr:		pop	ds
		push	ds
		rep	movsb
$$l_wf:		pop	es
		imov	ds,cs
		stc
$$l_io:		mov	ax,0F248h
		ifdef	debug
		int	3
		endif
		adc	al,0
		push	es
		imov	es,ds
		mpush	si,di
		mov	dx,cx
		mov	cx,di
		mov	si,offset NcpIoRequest
		sub	cx,si
		int	21h
		mpop	di,si,es
		cmp	al,0
		jnz	$$l_er
		mov	ax,NcpIoOffset.hw
		add	al,2
		mov	NcpIoOffset.hw,ax
		mov	ax,NcpIoOffset.lw
		adc	ah,0
		adc	al,0
		mov	NcpIoOffset.lw,ax
		popf
		jc	$$l_nr
		jnz	$$l_nr
		lodsw
		xchg	al,ah
		xchg	ax,cx
		rep	movsb
$$l_nr:		xchg	si,di
		pop	cx
		loop	$$loop
		mov	ah,0
$$l_xx:		pop	dx
		mov	al,dl
		sub	al,cl
		mpop	cx,dx,ds,es,si,di
		jmp	$$done
$$l_er:		mov	ah,4
		popf
		pop	cx
		jmp	$$l_xx
Int40Handler	endp

		.const

		assume	ds:Nothing,es:Nothing,ss:Nothing
length_esdi2cx	proc			; set cx to length of string pointed
		mov	cx,-1		; by es:di, moving di to its terminator
		mov	al,0
		cld
		repnz	scasb
		jnz	$$1
		iseq	<inc cx,dec di>
$$1:		not	cx
		ret
length_esdi2cx	endp

getenv_proc	proc			; get pointer to environment string
		mpush	bx,cx		; entry	CS:SI pointing to pattern
		cld			;	(which must be counted string)
		mov	ax,EnvSeg	; exit	ES:DI pointing to value, CF=0
		mov	es,ax		;	if pattern not found:	 CF=1
		mov	di,1
		cmp	ax,di
		jc	$$err
		mov	cx,-1
		iseq	<segcs,lodsb,cbw>
		xchg	ax,bx
$$cks:		dec	di
		mpush	cx,si
		mov	cx,bx
		iseq	<segcs,repz cmpsb>
		mpop	ax,si
		jz	$$end
		add	cx,ax
		sub	cx,bx
		iseq	<dec di,inc cx>
		mov	al,0
		iseq	<repnz scasb,inc cx,scasb>
		loopnz	$$cks
$$err:		stc
$$end:		dec	si
		mpop	bx,cx
		ret
getenv_proc	endp

i_InBuffer	dw	0
NcpOpenReq	label	byte
i_BufferW	label	word
i_Buffer	db	SectorSize dup(?)
		end	start
