USES Dos;

PROCEDURE ShowUsage;
 BEGIN Writeln('Usage: DOSGEN input-drive: output-file'); Halt(255); END;

CONST SectorSize=512; BufLngt=32; SideCount:Word=1; SectPerTrack:Word=1;
      FloppyBufAlloc:Word=0; FloppyBufSector:Word=0; FloppyBufCount:Word=0;

TYPE BoolArray=ARRAY[0..$FFF] OF Boolean;
     ByteArray=ARRAY[0..$7FFF] OF Byte;
     SectorBufType=ARRAY[0..SectorSize-1] OF Byte;
     SectorPointer=^SectorBufType;
     FloppyBufType=ARRAY[0..$3F] OF SectorBufType;
     BootSectorType=RECORD
       Jump:ARRAY[0..2] OF Byte; Name:ARRAY[1..8] OF CHAR;
       SectSize:Word; ClustSize:Byte; ResCnt:Word; FatCnt:Byte;
       RootCnt,SectCnt:Word; Media:Byte; FatLng,SectPerTr,SideCnt:Word;
       END; BootSectorPtrType=^BootSectorType;

VAR SectorCount,DataBegin,FatLength,ClusterSize:Word;
    Used:^BoolArray; BadAddress:Boolean;
    BootSectorPtr:BootSectorPtrType; FatPtr:^ByteArray;
    FloppyBufPtr:^FloppyBufType;

FUNCTION UsedCluster(Cluster:Word):Boolean;
 VAR cfo,cwv:Word;
 BEGIN UsedCluster:=FALSE; {INLINE($CC);}
 IF Cluster>=2+((SectorCount-DataBegin) DIV ClusterSize) THEN Exit;
 cfo:=(Cluster*3) DIV 2; cwv:=FatPtr^[cfo]+Swap(Word(FatPtr^[cfo+1]));
 IF Odd(Cluster) THEN cwv:=cwv SHR 4; cwv:=cwv AND $FFF; UsedCluster:=cwv>0;
 END;

PROCEDURE SaveDiskInfo(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: Word);
 INTERRUPT;
 VAR Count,Sector:Word;
 BEGIN IF (Hi(AX)=2) AND (Lo(DX)=0) THEN
  BEGIN Count:=Lo(AX);
  Sector:=(Hi(CX)*SideCount+Hi(DX))*SectPerTrack+Lo(CX)-1;
  WHILE Count>0 DO
   BEGIN IF Sector<SectorCount
    THEN Used^[Sector]:=TRUE
    ELSE BadAddress:=TRUE;
   Dec(Count); Inc(Sector);
   END;
  END;
 END;

PROCEDURE Error(msg:String);
 BEGIN Writeln; Writeln('*** ',msg,'. ***'); Halt(255); END;

FUNCTION ReadSector(Drive:Byte; Which:Word):SectorPointer;
 CONST MaxTry=5;
 VAR r:Registers; Try:Word;
 BEGIN IF Word(Which-FloppyBufSector)<FloppyBufCount THEN
  BEGIN ReadSector:=Addr(FloppyBufPtr^[Which-FloppyBufSector]); Exit; END;
 IF FloppyBufAlloc<SectPerTrack*SideCount THEN
  BEGIN IF FloppyBufAlloc>0
   THEN FreeMem(FloppyBufPtr,FloppyBufAlloc*SectorSize);
  FloppyBufAlloc:=SectPerTrack*SideCount;
  GetMem(FloppyBufPtr,FloppyBufAlloc*SectorSize);
  END; FloppyBufSector:=Which;
 r.CX:=Which MOD SectPerTrack; Which:=Which DIV SectPerTrack;
 r.DX:=Swap(Which MOD SideCount)+Drive; Which:=Which DIV SideCount;
 FloppyBufCount:= {$IfDef DualTrack} (SideCount-Hi(r.DX))* {$EndIf}
 SectPerTrack-r.CX; Inc(r.CX,1+Swap(Word(Lo(Which)))+Hi(Which) SHL 6);
 r.ES:=Seg(FloppyBufPtr^); r.BX:=Ofs(FloppyBufPtr^); Try:=0;
 FOR Try:=1 TO MaxTry DO
  BEGIN r.AX:=$200+FloppyBufCount; Intr($13,r); IF NOT Odd(r.Flags)
   THEN BEGIN ReadSector:=Addr(FloppyBufPtr^[0]); Exit; END;
  IF Try>1 THEN FloppyBufCount:=1; r.AX:=0; Intr($13,r);
  END; Writeln;
 Write('Disk read error, AH=',Hi(r.AX),', cyl=',(r.CX AND $C0)*4+Hi(r.CX),
       ', head=',Hi(r.DX),', rec=',r.CX AND $3F);
 Error('Unrecoverable disk read error');
 END;

CONST OurInt40Server:RECORD
  PushF,FarCall:Byte; CallPtr:Pointer; FarJump:Byte; JumpPtr:Pointer;
  END=(PushF:$9C; FarCall:$9A; CallPtr:NIL; FarJump:$EA);
VAR Sector,Cluster,LastClusterUsed,ClusterHole,Count,Index:Word;
    Drive:Byte; DriveName:String[3]; OutFile:File; SectorPtr:SectorPointer;

BEGIN IF (ParamCount=0) OR (ParamCount>2) THEN ShowUsage;
DriveName:=ParamStr(1); DriveName[1]:=UpCase(DriveName[1]);
IF (Length(DriveName)<>2) OR (DriveName[2]<>':')
 OR NOT (DriveName[1] IN ['A'..'Z']) THEN Error('Bad input drive name');
Drive:=Byte(DriveName[1])-Byte('A'); OurInt40Server.CallPtr:=@SaveDiskInfo;

SectorPtr:=ReadSector(Drive,0);
WITH BootSectorPtrType(SectorPtr)^ DO
 BEGIN IF (SectSize=SectorSize) AND (SideCnt IN [1,2]) AND (ResCnt=1)
  THEN
   BEGIN SectorCount:=SectCnt; SideCount:=SideCnt;
   SectPerTrack:=SectPerTr; FatLength:=FatLng; ClusterSize:=ClustSize;
   DataBegin:=ResCnt+FatLng*FatCnt+((RootCnt*32-1) DIV SectSize)+1;
   END
  ELSE
   BEGIN DataBegin:=Byte(Name[1])-1+8*Word(Byte(Name[2]));
   IF DataBegin>8 THEN SideCount:=2; SectorCount:=SideCount*320;
   ClusterSize:=SideCount; FatLength:=1;
   END;
 END; GetMem(FatPtr,FatLength*SectorSize);

FOR Sector:=1 TO FatLength DO
 BEGIN SectorPtr:=ReadSector(Drive,Sector);
 Move(SectorPtr^,FatPtr^[(Sector-1)*SectorSize],SectorSize);
 END;
LastClusterUsed:=1; ClusterHole:=0; Cluster:=2;
FOR Cluster:=2 TO 1+((SectorCount-DataBegin) DIV ClusterSize) DO
 IF UsedCluster(Cluster) THEN
  BEGIN Inc(LastClusterUsed); IF Cluster>LastClusterUsed THEN
   BEGIN Inc(ClusterHole,Cluster-LastClusterUsed);
   Writeln('CAUTION: hole at cluster ',LastClusterUsed);
   LastClusterUsed:=Cluster;
   END;
  END; Writeln('Last cluster used=',LastClusterUsed,', holes=',ClusterHole);
FreeMem(FatPtr,FatLength*SectorSize);
IF ParamCount>1 THEN
 BEGIN SectorCount:=DataBegin+(LastClusterUsed-1)*ClusterSize;
 Assign(OutFile,ParamStr(2)); {$I-} Rewrite(OutFile,SectorSize);
 IF IoResult<>0 THEN Error('Bad output file name'); {$I+}
 Sector:=0; WHILE Sector<SectorCount DO
  BEGIN SectorPtr:=ReadSector(Drive,Sector);
  IF Addr(SectorPtr^)=Addr(FloppyBufPtr^)
   THEN
    BEGIN Count:=FloppyBufCount;
    IF Count>SectorCount-Sector THEN Count:=SectorCount-Sector;
    BlockWrite(OutFile,SectorPtr^,Count); Inc(Sector,Count);
    END
   ELSE BEGIN BlockWrite(OutFile,SectorPtr^,1); Inc(Sector,1); END;
  END; Close(OutFile); Writeln(ParamStr(2),' ready.');
 END;
(*
GetIntVec($40,OurInt40Server.JumpPtr); SetIntVec($40,@OurInt40Server);
*)
IF FloppyBufAlloc>0 THEN FreeMem(FloppyBufPtr,FloppyBufAlloc*SectorSize);
END.
