;++++
;	LoadExe - load .EXE file during boot
;	Jerzy Tarasiuk		23-Oct-1996
;----
;TestWithDos	=	1		; define it for tests only

;+++	LoadExe - load .EXE file during boot
;
;	Entry:	ax		= size of loaded part of a file
;		bx		= handle of the file (still open)
;		ss:sp		points to some valid stack
;		int 21h segment	= segment of boot code copy in RAM
;		int 19h offset	= 2+offset of UsedMemTop in the boot code
;		int 21h service supports file read, handles 0-4 = console
;---

ExePageSize	=	200h
PSP_Size	=	100h
ExtraSize	=	offset ExtraCodeEnd-offset ExtraCodeBgn
;	standard EXE header structure:
exe_hdr		struc
xh_sign		dw	'ZM'		; signature
xh_bilp		dw	?		; used bytes in last page
xh_tpgc		dw	?		; total 512-byte pages (including last)
xh_nrel		dw	?		; # relocation entries
xh_hsip		dw	?		; header size in paragraphs
xh_mina		dw	?		; minalloc (para-s above load module)
xh_maxa		dw	?		; maxalloc
xh_sseg		dw	?		; stack segment
xh_sptr		dw	?		; stack pointer
xh_cksm		dw	?		; checksum
xh_stip		dw	?		; start address IP
xh_stcs		dw	?		; start address CS
xh_rtof		dw	?		; relocation table offset
exe_hdr		ends

Text		segment	para 'CODE'
		org	0
		assume	cs:Text,ds:Nothing,es:Nothing,ss:Nothing
BgnOfCode	label	byte
	ifdef	TestWithDos
		mov	bx,1000h
		mov	ah,4Ah
		int	21h
		mov	cx,es
		add	cx,bx		; CX=top of used memory
		mov	dx,sp
		sub	dh,2		; assume sp-200h to be file size
		mov	bx,-1		; assume file handle -1 (invalid)
		push	bx
		push	dx		; stack=file size, file handle
		mov	ah,4Ah
		int	21h
		mov	ah,4Ah
		int	21h
		mov	ax,es
		add	ax,bx		; AX=top of available memory
	else
		push	bx
		push	ax		; stack=file size, file handle
		mov	ax,3519h
		int	21h
		mov	di,bx
		mov	ax,3521h
		int	21h		; ES:BX=vector 21h
		mov	cx,es:[di-2]	; UsedMemTop
		push	cs
		pop	ds
		int	12h
		push	cx
		mov	cl,6
		shl	ax,cl		; AX=top of available memory
		pop	cx
	endif
		assume	ds:Text
		mov	BootBgnSegment,es
		mov	BootEndSegment,cx
		mov	bx,offset EndOfCode	; now DS:BX -> EXE header
		mov	TopOfAvailMem,ax
		sub	ax,cx
		xchg	ax,di		; DI=available memory in paragraphs
		mov	ax,ExePageSize
		mov	dx,[bx].xh_tpgc
		dec	dx
		mul	dx
		add	ax,[bx].xh_bilp
		adc	dl,dh		; DXAX=the EXE file size
		push	dx		; save on stack, will need it
		push	ax
		jc	AbtNoMemory
		add	ax,0fh+PSP_Size+((ExtraSize+0Fh) AND 0FFF0h)
		nop
		adc	dl,dh
		jc	AbtNoMemory
		mov	si,10h
		cmp	dx,si
		jae	AbtNoMemory
		div	si		; AX=file size in paragraphs
		sub	ax,[bx].xh_hsip	; AX=paragraphs needed for module
		jb	AbtNoMemory
	;	mov	dx,ax		; DX=paragraphs needed for module
	; not needed: if there is enough memory no matter how much it is
		add	ax,[bx].xh_mina	; AX=paragraphs needed for program
		jc	AbtNoMemory
		cmp	ax,di
		jna	EnoughMemory
AbtNoMemory:	call	MsgAndAbort
		db	1,"No enough memory for the program.$"
NoStackInExe:	call	MsgAndAbort
		db	3,"No stack in EXE.$"
EnoughMemory:	mov	es,cx		; destination segment
		mov	si,offset Text:ExtraCodeBgn
		mov	cx,offset ExtraCodeEnd-offset ExtraCodeBgn
		xor	di,di
		cld
		rep	movsb
		mov	cl,4
		test	di,di
		jz	NoExtraCode
		dec	di
		shr	di,cl
		inc	di
NoExtraCode:	mov	dx,es
		add	di,dx
		mov	ax,[bx].xh_hsip	; hope header size < 10000h
		cmp	ax,800h		; (anyway, need be <=8000h, or we don't
		ja	IncompleteHdr	;  have complete header readed into m.)
		shl	ax,cl		; AX=header size in bytes
		push	ax
		add	ax,bx
		xchg	ax,si		; DS:SI->start of load module
		mov	es,di
		xor	di,di		; ES:DI->PSP
		mov	dx,2Ch
		mov	ax,20CDh	; put INT 20h
		stosw
		mov	ax,0a000h	; and top of available memory
TopOfAvailMem	equ	word ptr $-2
		call	FillTillDX
		mov	ax,es		; put segment of empty environment
		inc	ax
		inc	ax
		mov	dl,80h
		call	FillTillDX
		mov	ah,0Dh		; put empty command line
		add	dx,dx
		call	FillTillDX
		mov	di,es
		add	di,10h
		mov	es,di		; PSP ready, ES:0->place for load
	; now set stack of the EXE
		mov	cx,[bx].xh_sseg	; CX=new SS (to be relocated)
		mov	ax,[bx].xh_sptr	; AX=new SP
		add	di,cx		; DI=new SS (relocated now)
		or	cx,ax		; have we any stack?
		jz	NoStackInExe	; no stack - fatal error here!
		pop	cx		; the EXE header size
		pop	bp		; the EXE file size
		pop	dx
		sub	bp,cx
		sbb	dl,dh		; now DXBP=load module size
		jnc	ExeLdModSizOK	; if load module size in EXE>=0
ExeLMSNegative:	call	MsgAndAbort
		db	4,"Negative load module size in EXE.$"
IncompleteHdr:	call	MsgAndAbort
		db	2,"Incomplete EXE header.$"
ExeLdModSizOK:	pop	cx		; byte # read from file
		pop	BootFileHandle	; handle
		mov	ss,di		; change stack
		xchg	ax,sp
	;
		sub	cx,si		; # read bytes of load module
		jc	IncompleteHdr
		xor	di,di
		rep	movsb		; put what we have
		push	ds
		push	bx
		sub	bp,di
		mov	bx,BootFileHandle
		push	es
		pop	ds
		assume	ds:Nothing
CheckNeedMore:	sbb	dl,dh
		push	dx
		push	bp
		jb	ExeLoadDone
		jnz	MoreThan64k
		test	bp,bp
		jns	LessThan32k
MoreThan64k:	mov	bp,8000h
LessThan32k:	mov	ax,ds
		mov	dx,di
p83:		and	dx,0Fh
		org	p83
		db	83h
		org	p83+3
		mov	cl,4
		shr	di,cl
		add	ax,di
		mov	ds,ax
		mov	cx,bp
		jcxz	ExeLoadDone
		mov	ah,3Fh
		int	21h
		jc	ExeReadError
		cmp	ax,cx
		jnz	ExeReadError
		mov	di,dx
		add	di,ax
		pop	bp
		pop	dx
		sub	bp,ax
		jmp	CheckNeedMore
ExeLoadDone:	mov	ah,3Eh
		int	21h
		pop	bp
		pop	dx
		pop	bx
		pop	ds
		assume	ds:Text
		mov	cx,[bx].xh_nrel
		mov	si,[bx].xh_rtof
		add	si,bx
		mov	dx,es
		jcxz	NoRelocations
RelocateLoop:	lodsw
		xchg	ax,di
		lodsw
		add	ax,dx
		mov	es,ax
		add	es:[di],dx
		loop	RelocateLoop
NoRelocations:	mov	ax,dx
	; compute and push new CS:IP
		add	dx,[bx].xh_stcs
		push	dx		; start CS
		push	[bx].xh_stip	; start IP
		sub	ax,10h		; PSP segment
		mov	ds,ax
		assume	ds:Nothing
		mov	es,ax
		xor	ax,ax
		xor	bx,bx
		xor	cx,cx
		xor	si,si
		mov	di,0FFFFh
		xor	bp,bp
StartExecution	proc	far
		ret
StartExecution	endp

ExeReadErrorMsg	db	"Error reading EXE file reading $"
ExeReadErrBytes	db	" bytes at $"
ExeReadError:	push	cs
		pop	ds
		mov	dx,offset ExeReadErrorMsg
		mov	ah,9
		int	21h
		xchg	ax,cx
		call	WordHexOut
		mov	dx,offset ExeReadErrBytes
		mov	ah,9
		int	21h
		mov	ax,4201h
		xor	cx,cx
		xor	dx,dx
		int	21h
		call	LongHexOut
		mov	ah,5
		int	20h

LongHexOut	proc	near
		xchg	ax,dx
		call	WordHexOut
		xchg	ax,dx
WordHexOut	proc	near
		xchg	al,ah
		call	ByteHexOut
		xchg	al,ah
ByteHexOut	proc	near
		push	ax
		push	cx
		mov	cl,4
		shr	al,cl
		pop	cx
		call	NibbleHexOut
		pop	ax
NibbleHexOut	proc	near
		push	ax
		and	al,0Fh
		cmp	al,0ah
		sbb	al,69h
		das
		push	dx
		xchg	ax,dx
		mov	ah,2
		int	21h
		pop	dx
		pop	ax
		ret
NibbleHexOut	endp
ByteHexOut	endp	
WordHexOut	endp
LongHexOut	endp

MsgAndAbort	proc	near
		pop	dx
		mov	si,dx
		inc	dx
		mov	ah,9
		int	21h
		mov	ah,[si]
		int	20h
MsgAndAbort	endp

FillTillDX	proc	near
		stosw
		xor	ax,ax
		cmp	di,dx
		jb	FillTillDX
		ret
FillTillDX	endp

BootBgnSegment	dw	?
BootEndSegment	dw	?
BootFileHandle	dw	?
ExtraCodeBgn	label	byte
ExtraCodeEnd	label	byte
EndOfCode	label	byte
Text		ends
		end
