SectorSize	=	200h
LockDriver	=	1	; if driver lock/unlock is to be used
		extrn	_bhandle:word,_cfgslist:word
_TEXT		segment	byte public 'CODE'
		public	_Trace,_GetBootInt21hSetVect13h
		public	_SetHeadsAndSc4Tr,_SetPktIrqAndVect
		org	0
		assume	cs:_TEXT

pktivect	dw	0Ah
pktimskp	dw	2104h
pkv_ofs		dw	0FFF0h
pkv_seg		dw	0F000h
BootFileIO	proc	near
		mov	bx,5
BootFileHandle	equ	word ptr [$-2]
;ExtraFileIO_	label	near	; caution: must call near, push BX
;				; set BX=handle, then jump here!
	ifdef	iotrace
		pushf
		call	far ptr _Trace
	endif
		pushf
		cli
		db	9Ah
BootInt21hOfs	dw	0FFF0h
BootInt21hSeg	dw	0F000h
	ifdef	iotrace
		pushf
		call	far ptr _Trace
	endif
		ret
BootFileIO	endp

MyInt64h	label	far
		call	BootFileIO
		jmp	short I13SetFlgs

MyInt13h	proc	far
	ifdef	iotrace
		pushf
		call	far ptr _Trace
	endif
		test	dl,dl
		jz	I13MyDrive
I13NotMine:	;pushf
		;call	far ptr _Trace
		int	0F2h
I13SetFlgs:	push	bp
		mov	bp,sp
		rcr	byte ptr [bp+6],1
		rol	byte ptr [bp+6],1
		pop	bp
	ifdef	iotrace
		pushf
		call	far ptr _Trace
	endif
		iret
I13NotReady:	pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	ds
		mov	ah,80h
		stc
		jmp	I13SetFlgs
I13MyDrive:	cmp	ah,2
		jnz	I13NotMine
		mov	ah,al
		test	ax,ax
		jz	I13SetFlgs
		push	ds
		push	dx
		push	cx
		push	bx
		push	ax	; stack: AX,BX,CX,DX,DS,IP,CS,F
	ifdef LockDriver
; here enable packet driver, and disable on end
		xor	ax,ax
		mov	ds,ax
		mov	bx,40
intv_ofs	equ	word ptr [$-2]
		mov	ax,0FFF0h
bpv_ofs		equ	word ptr [$-2]
		cmp	ax,[bx]
		jnz	I13NotReady
		mov	ax,0F000h
bpv_seg		equ	word ptr [$-2]
		cmp	ax,[bx+2]
		jnz	I13NotReady
		mov	ax,pkv_ofs
		mov	[bx],ax
		mov	ax,pkv_seg
		mov	[bx+2],ax
		cli
		in	al,21h
irq_mp1		equ	byte ptr [$-1]
		and	al,not 4
irq_unm		equ	byte ptr [$-1]
		out	21h,al
irq_mp2		equ	byte ptr [$-1]
	endif
		sti
		mov	al,2
I13Heads	equ	byte ptr [$-1]
		mul	ch
		add	al,dh
		mov	dx,9
I13Sc4Tr	equ	word ptr [$-2]
		mul	dx
		mov	ch,0
		dec	cx
		add	ax,cx
		push	ax	; "disk" sector to be read
		mov	cx,SectorSize
		mul	cx
		xchg	ax,dx
		xchg	ax,cx
		push	ax
		mov	ah,42h	; (AL is 0)
		call	BootFileIO
		pop	cx	; CX=SectorSize
		pop	bx	; "disk" sector to be read
		pop	ax	; AL=AH=sector count to read
		pop	dx	; buffer address
		push	dx	; stack: BX,CX,DX,DS,IP,CS,F
I13ReadSec:	push	ax
		xchg	ax,bx	; here will text sector substitution:
				; (can use DS,BX; AX is "disk" sector)
		mov	bx,seg _cfgslist
		mov	ds,bx
		mov	bx,ds:_cfgslist
I13SubstChk:	cmp	word ptr [bx],-1
		jz	I13NoSubst
		cmp	ax,[bx+2]
		jz	I13UseSubst
		add	bx,[bx]
		add	bx,4
		jmp	I13SubstChk
I13NoSubst:	xchg	ax,bx
		push	es
		pop	ds
		mov	ah,3Fh
		push	bx
		call	BootFileIO
		pop	bx
		jc	I13Error
		cmp	ax,cx
		jc	I13Error
		add	dx,cx
I13AfterRead:	inc	bx	; advance "disk" sector
		pop	ax
		dec	ah
		jnz	I13ReadSec
	;	sub	al,ah
		push	ax
I13Error:
	ifdef LockDriver
		call	PktDisable
	endif
		pop	ax
	;	pushf
	;	call	far ptr _Trace
		sbb	ah,ah
		pop	bx
		pop	cx
		pop	dx
		pop	ds
		pushf
		and	ah,4
		popf
		jmp	I13SetFlgs
I13UseSubst:	push	ax	; save "disk" sector
		push	cx	; CX, DI, SI
	;
		push	si
		push	di
		cld		; make sure direction is forward
		mov	di,dx	; ES:DI points to buffer
		mov	al,1Ah	; put full sector of Ctrl-Z-s
		rep	stosb	; (CX was sector size)
		xchg	dx,di	; set advanced DX, ES:DI points to buffer
		mov	cx,[bx]	; size of the data
		lea	si,[bx+4]	; DS:SI points to data
		rep	movsb	; "read" the data (as much as having)
		pop	di	; restore DI, SI
		pop	si
	;
		push	dx	; little problem: must seek image...
		mov	dx,SectorSize	; ...one sector forward (CX=0)
		mov	ax,4201h
		call	BootFileIO
		pop	dx
	;
		pop	cx	; restore CX (sector size)
		pop	bx	; restore "disk" sector
		jmp	I13AfterRead
MyInt13h	endp

_SetPktIrqAndVect	proc	near	; args: intvno,irqm,bios_vector
			push	bp
			mov	bp,sp
			mov	ax,[bp+4]
			mov	pktivect,ax
	ifdef LockDriver
			push	ax
			add	ax,ax
			add	ax,ax
			mov	intv_ofs,ax
			pop	ax
			mov	ah,35h
			int	21h
			mov	pkv_ofs,bx
			mov	pkv_seg,es
			mov	ax,[bp+6]
			mov	pktimskp,ax
			mov	cs:irq_msk,al
			not	al
			mov	irq_unm,al
			mov	al,ah
			mov	irq_mp1,al
			mov	irq_mp2,al
			mov	cs:irq_mp3,al
			mov	cs:irq_mp4,al
			mov	ax,[bp+8]
			mov	bpv_ofs,ax
			mov	ax,[bp+10]
			mov	bpv_seg,ax
			pop	bp
			push	ds
			call	PktDisable
			pop	ds
			ret
PktDisable		proc	near
			pushf
			xor	ax,ax
			mov	ds,ax
			mov	bx,intv_ofs
			cli
			in	al,21h
irq_mp3			equ	byte ptr [$-1]
			or	al,4
irq_msk			equ	byte ptr [$-1]
			out	21h,al
irq_mp4			equ	byte ptr [$-1]
			mov	ax,bpv_ofs
			mov	[bx],ax
			mov	ax,bpv_seg
			mov	[bx+2],ax
			popf
			ret
PktDisable		endp
	else
			mov	ax,[bp+6]
			mov	pktimskp,ax
			mov	ax,[bp+8]
			mov	pkv_ofs,ax
			mov	ax,[bp+10]
			mov	pkv_seg,ax
			pop	bp
			ret
	endif
_SetPktIrqAndVect	endp

_SetHeadsAndSc4Tr	proc	near
			push	bp
			mov	bp,sp
			mov	ax,[bp+4]
			mov	I13Heads,al
			mov	ax,[bp+6]
			mov	I13Sc4Tr,ax
			pop	bp
			ret
_SetHeadsAndSc4Tr	endp

_GetBootInt21hSetVect13h	proc	near
				push	ds
				push	cs
				pop	ds
				lea	dx,MyInt13h
				mov	ax,2513h
				int	21h
				mov	ax,25F3h
				int	21h
				lea	dx,MyInt64h
				mov	ax,2564h
				int	21h
				pop	ds
				mov	ax,_bhandle
				mov	BootFileHandle,ax
				mov	ax,3521h
				int	21h
				mov	ax,es
				mov	BootInt21hOfs,bx
				mov	BootInt21hSeg,ax
				ret
_GetBootInt21hSetVect13h	endp

NibbleHexOut	proc	near		; convert AL (assume 4 low bits used
		cmp	al,0ah		; only) to hex, put result in AL
		sbb	al,69h
		das
CharOut		label	near
		mov	ah,0Eh
		push	bx
		mov	bx,7
		int	10h
		pop	bx
		ret
NibbleHexOut	endp

ShowReg		proc	near
		xchg	ax,dx
ShowRegName:	lods	byte ptr cs:[si]
		cmp	al,0
		jz	ShowRegister
		call	CharOut
		jmp	ShowRegName
ShowRegister:	xchg	ax,dx
WordHexOut	proc	near
		xchg	al,ah
		call	ByteHexOut
		xchg	al,ah
ByteHexOut	proc	near
		push	ax
		xchg	al,ah
		xchg	ax,cx
		mov	cl,4
		shr	ch,cl
		xchg	ax,cx
		xchg	al,ah
		call	NibbleHexOut
		pop	ax
		push	ax
		and	al,0Fh
		call	NibbleHexOut
		pop	ax
		ret
ByteHexOut	endp
WordHexOut	endp
ShowReg		endp

;Count		dw	512

_Trace		proc	far
		push	ax
		push	si
		push	dx
		mov	si,offset FormatStrings
		cld
		call	ShowReg		; ax
		mov	ax,bx
		call	ShowReg		; bx
		mov	ax,cx
		call	ShowReg		; cx
		pop	ax
		push	ax
		call	ShowReg		; dx
		mov	ax,bp
		call	ShowReg		; bp
		pop	dx
		pop	ax
		push	ax
		push	dx
		call	ShowReg		; si
		mov	ax,di
		call	ShowReg		; di
		push	bp
		mov	bp,sp
		mov	ax,[bp+12]
		call	ShowReg		; f
		in	al,0a1h
		mov	ah,al
		in	al,21h
		call	ShowReg		; im
		mov	ax,ds
		call	ShowReg		; ds
		mov	ax,es
		call	ShowReg		; es
		mov	ax,ss
		call	ShowReg		; ss
		lea	ax,[bp+14]
		call	ShowReg		; sp
		mov	ax,[bp+10]
		call	ShowReg		; cs
		mov	ax,[bp+8]
		call	ShowReg		; ip
		push	ds
		push	cx
		mov	cx,10		; code
		lds	si,[bp+8]
TraceOpcLoop:	mov	al,' '
		call	CharOut
		lodsb
		call	ByteHexOut
		loop	TraceOpcLoop
		pop	cx
		xor	si,si
		mov	ds,si
		mov	word ptr [si+4],offset _Trace
		mov	[si+6],cs
		pop	ds
	ifdef	Count
		or	byte ptr [bp+13],1
		dec	Count
		jns	TraceContinue
		and	byte ptr [bp+13],not 1
TraceContinue:
	endif
		pop	bp
		pop	dx
		pop	si
		mov	ah,0
		int	16h
		pop	ax
		iret
_Trace		endp
	if	0
main:		mov	ax,1111h
		mov	bx,2222h
		mov	cx,3333h
		mov	dx,4444h
		mov	bp,5555h
		mov	si,6666h
		mov	di,7777h
		pushf
		call	_Trace
		inc	ax
		dec	bx
		inc	cx
		dec	dx
		inc	si
		dec	di
	;	pushf
	;	call	Trace
		sub	ax,bx
		push	ax
	;	pushf
	;	call	Trace
		pop	dx
		loop	$
		mov	ah,4Ch
		int	21h
	endif
CR		=	0Dh
LF		=	0Ah
FormatStrings	db	CR,LF,'ax=',0,' bx=',0,' cx=',0,' dx=',0,' bp=',0
		db	' si=',0,' di=',0,' f=',0,' im=',0,CR,LF
		db	'ds=',0,' es=',0,' ss:sp=',0,':',0,' cs:ip=',0,':',0
;_STACK		segment	word stack 'STACK'
;		dw	200h dup(?)
;_STACK		ends
_TEXT		ends
		end	;main
