; BootRomX - version with settable ROM page count
; define SAPWAIT to force waiting for SAP reply
; Definitions:
; general...
SaveVectors	=	1		; save all int vectors below ROM copy
PacketVector	=	65h		; packet interrupt vector for driver
MaxServerCount	=	16		; max # servers in server table
SapServerCount	=	15		; max # servers from SAP listening
MaxFileCount	=	8		; max # files to open via net
MaxFileHandle	=	12		; max # file handles (0-4 for console)
Debugging	=	0		; non-zero displays debug marks
OddReadShifted	=	1		; skip junk byte on odd offset read

; sizes and offsets...
BootParagraphs	=	1800h		; # memory paragraphs used by boot
SectorSize	=	200h		; disk sector size (also max net read)
MaxPacketLngt	=	576		; max IPX packet size
EthAddrLngt	=	6		; # bytes in Ethernet address
PacketBufLngt	=	2*EthAddrLngt+2+MaxPacketLngt
nwobj_namelngt	=	48		; length of bindery object name
BootLoadOffset	=	7C00h		; load boot sector to 0:7C00h
BootReadSize	=	8000h		; initial boot file read size
BootReadSegment	=	4000h		; boot file read to 4000:0

; protocol, sockets...
;EthProtocol	equ	<81h,37h>	; "Novell Netware" Ethernet type value
EthPr1		=	81h
EthPr2		=	37h
;SapSrvSocket	equ	<04h,52h>	; SAP Service socket
SapSrvSock1	=	04h
SapSrvSock2	=	52h
;SapCliSocket	equ	<4ah,58h>	; our socket for SAP queries
SapCliSock1	=	4ah
SapCliSock2	=	58h
;BootCliSocket	equ	<4ah,57h>	; our socket for fileserver requests
BootCliSock1	=	4ah
BootCliSock2	=	57h

; flag values for ReceiveFlags
ReceiveDisabled	=	1
MltCastDisabled	=	2
ProcessSapOnly	=	4

; various
;RomSignature	equ	<55h,0aah>
RomSignature1	=	55h
RomSignature2	=	0aah
PageSize	=	200h
	ifdef	ROMPAGES
RomPages	=	ROMPAGES
	else
RomPages	=	20h
	%out	"ROMPAGES not defined, assumed default (20h)"
	endif
dos_exit0	=	4C00h
dos_exit	=	4Ch
ivect_para	=	40h
int_biosvideo	=	10h
biosvideo_wrtty	=	0eh
biosvideo_yellow=	0eh
int_biosmem	=	12h
int_biosdisk	=	13h
disk_timeout	=	80h
hard_disk	=	80h
diskf_query	=	8
int_bioskey	=	16h
int_biostime	=	1ah
int_reboot	=	19h
int_doscall	=	21h
int_bootsav	=	0c0h
bootsav_sign	=	6a6eh
ch_cr		=	0dh
ch_lf		=	0ah
ConvMemSize	=	0a000h		; (in paragraphs)
biosdisk_read1	=	0201h
ncp_conn	=	1111h
ncp_req		=	2222h
ncp_reply	=	3333h
ncp_detach	=	5555h
sap_query	=	0300h
sap_reply	=	0400h
port_switches	=	61h
com_start	=	100h
dos_vect_cnt	=	16
para_size	=	16
id_byte_set	=	0f8h
id_byte_ign	=	4
biosvar		=	40h
biostimer	=	06ch

; Structures:
ipx_adr		struc			; IPX Address
i_net		dd	?
i_node		db	EthAddrLngt dup(?)
i_sock		dw	?
ipx_adr		ends

EthIpxP		struc			; Ethernet IPX Packet Header
;	Ethernet header
eth_dst		db	EthAddrLngt dup(?)
eth_src		db	EthAddrLngt dup(?)
eth_tlw		dw	?
;	IPX header
ipx_cks		dw	?	; usually -1
ipx_lng		dw	?	; hi-lo
ipx_hops	db	?
ipx_type	db	?
ipx_dst		db	size ipx_adr dup(?)
ipx_src		db	size ipx_adr dup(?)
EthIpxP		ends

MyEthAddress	equ	PktSndBuf[EthAddrLngt]	; space for own e.a.
MyIpxAddress	equ	PktSndBuf.ipx_src	; source network
MyNodeAddress	equ	PktSndBuf.ipx_src.i_node; source node
MyCurSocket	equ	PktSndBuf.ipx_src.i_sock; source socket

SapInfo		struc			; Service Advertisement Protocol info
sap_type	dw	?
sap_name	db	nwobj_namelngt dup(?)
sap_ipxa	db	size ipx_adr dup(?)
sap_dist	dw	?
SapInfo		ends

SrvInfo		struc			; Server Table element
srv_name	db	nwobj_namelngt dup(?)
srv_ipxa	db	size ipx_adr dup(?)
srv_path	db	EthAddrLngt dup(?)
srv_seq		db	?
srv_con		db	?
SrvInfo		ends

NFDescr		struc			; NetWare Files Table element
fh_serv		db	0
fh_res1		db	0
fh_nwfh		db	6 dup(?)
fh_ofst		dw	0,0
fh_size		dw	0,0
NFDescr		ends


; Macros:
puss		macro	r1,r2,r3,r4,r5,r6,r7,r8,r9,ra,rb,rc	; push many
		irp	rx,<rc,rb,ra,r9,r8,r7,r6,r5,r4,r3,r2,r1>
		ifnb	<rx>
		push	rx
		endif
		endm
		endm
popp		macro	r1,r2,r3,r4,r5,r6,r7,r8,r9,ra,rb,rc	; pop many
		irp	rx,<r1,r2,r3,r4,r5,r6,r7,r8,r9,ra,rb,rc>
		ifnb	<rx>
		pop	rx
		endif
		endm
		endm
;op2b		macro	op,rm,dv	; use 2 bytes instead word as operand
;cmp2b_value	=	0
;%		irp	vb,<dv>
;cmp2b_value	=	(cmp2b_value shr 8)+(vb shl 8)
;		endm
;		op	rm,cmp2b_value
;		endm
op2b2		macro	op,rm,v1,v2	; use 2 bytes instead word as operand
		op	rm,v1+256*v2
		endm
debug		macro	char
		ifdef	DebugProc
		call	DebugProc
		db	'&char&'
		endif
		endm

Text		segment	para public 'code'
		assume	cs:Text
	ifdef	NETBOOT
		org	com_start
RomHeader	label	near
		jmp	AskNwBoot
	else
RomHeader	label	near
	ifdef	PackedBoot
		dw	EndInitModule	; to be replaced by RomSignature
	else
;		db	RomSignature
		db	RomSignature1,RomSignature2
	endif
RomPageCount	db	RomPages

RomBootInit	proc	far		; sets INT 19h vector if not set yet
RomBootInit_n	label	near		; all registers preserved
		puss	es,bx,ax
		mov	al,int_bootsav+1
		call	IntVectAddr
		mov	ax,bootsav_sign
		cmp	es:[bx],ax
		jz	RomBootInit_x
		mov	es:[bx],ax
		mov	ax,(int_bootsav shl 8)+int_reboot
		call	MoveIntVector
		mov	bx,offset RomBootVect
		push	cs
		pop	es
		call	SetIntVector
RomBootInit_x:	popp	es,bx,ax
		ret
RomBootInit	endp

	if	Debugging
DebugProc	proc	near
		push	ax
		xchg	ax,bp
		mov	bp,sp
		inc	word ptr [bp+2]
		mov	bp,[bp+2]
		mov	bp,cs:[bp-1]
		xchg	ax,bp
		call	BiosCharOut
		pop	ax
		ret
DebugProc	endp
	endif
	endif	; NETBOOT

IntVectAddr	proc	near		; entry AL=vector
		xor	bx,bx		; exit: ES:BX=0:AL*4
		mov	es,bx		; other registers preserved
		mov	bl,al
		add	bx,bx
		add	bx,bx
		ret
IntVectAddr	endp

GetIntVector	proc	near		; Function 35h - get vector
		call	IntVectAddr	; entry AL=vector to get
GetIntVect_1:	les	bx,es:[bx]	; exit: ES:BX=vector value
		ret			; other registers preserved
GetIntVector	endp

SetIntVector	proc	near		; Set Interrupt Vector AL
		pushf			; entry AL=vector to set, ES:BX=value
		push	es		; exit: vector modified
		push	bx		; all registers preserved
		call	IntVectAddr
		cli
		pop	es:[bx]
		pop	es:[bx+2]
		popf
		jmp	GetIntVect_1
SetIntVector	endp

MoveIntVector	proc	near		; Move (copy) Interrupt Vector
		call	GetIntVector	; entry AL=vect to get, AH=vect to set
		xchg	al,ah		; exit: vector set, ES:BX=vector value
		call	SetIntVector	; other registers preserved
		xchg	al,ah
		ret
MoveIntVector	endp

AskNetWareBoot	db	ch_cr,ch_lf
	ifdef	NETBOOT
		db	"T = TFTP boot (X-Windows)",ch_cr,ch_lf
		db	"N = NetWare boot (Novell)...$"
	else
		db	"Boot from NetWare fileserver? $"
	endif

;==	Communication information:
PktSignature	db	"PKT DRVR",0	; packet driver signature pattern
;		db	EthProtocol	; protocol to be used (Novell)
		db	EthPr1,EthPr2
					;(must immediately follow PktSignature)
ReceiveFlags	db	MltCastDisabled	; receive control flags
NcpReqError	db	0		; status in last server reply
RcvExtraLngt	dw	0		; length of data in last NCP packet
ConSeqCompare	dw	-1		; connection and sequence in last...

;==	File Servers Table information:
		db	size SrvInfo	; size of the table entry
		db	MaxServerCount	; total # entries in the table
ServersUsed	db	0		; # of filled entries in the table
CurrentServer	db	1		; 1 is first entry in server table
		dw	ServerTable	; offset of server table

;==	Memory Usage information:
UsedMemTop	dw	ConvMemSize	; first paragraph of free area above us

;++	the above information immediately precedes RomBootVect
;	for the boot programs to be able to find it
;--	(need use segment of vect 21h and offset of vect 19h)

RomBootVect	proc	far		; to be called by INT 19h
	ifdef	NETBOOT
AskNwBoot	label	near
		cld
	else
;	debug	F
		mov	cx,4		; no return: boot or hang
		xor	dx,dx		; net boot: loads driver,
rbv_TryFloppy:	push	cx		; then continues at StayResident
		mov	ah,0
		int	int_biosdisk
		jc	rbv_FlResFlt
	;	call	BootSectorRead
		xor	cx,cx
		mov	es,cx
		inc	cx
	;	mov	dh,0
		mov	bx,BootLoadOffset
		mov	ax,biosdisk_read1
		int	int_biosdisk
	;
		jc	rbv_FlopFlt
rbv_BiosBoot:	mov	ax,(int_reboot shl 8)+int_bootsav
;	debug	B
		call	MoveIntVector
		xor	bx,bx
		mov	es,bx
		call	SetIntVector
		inc	ax
		call	SetIntVector
		int	int_reboot
		sti
;	debug	$
		jmp	$
rbv_FlResFlt:	mov	ah,1
rbv_FlopFlt:	pop	cx
		test	ah,disk_timeout
		loopz	rbv_TryFloppy
;	debug	H
		mov	dl,hard_disk
		mov	ah,diskf_query
		int	int_biosdisk
		push	cs
		pop	ds
		jc	rbv_NetBoot
		test	dl,dl
		jz	rbv_NetBoot
	endif	; NETBOOT
;	debug	A
		mov	dx,offset AskNetWareBoot
		call	DosStringOut
	ifndef	NETBOOT
rbv_AskYN:	mov	ah,0
		int	int_bioskey
		or	al,' '
		cmp	al,'y'
		jz	rbv_NetBoot
		cmp	al,'n'
		jnz	rbv_AskYN
		mov	cx,1
		mov	dx,hard_disk
		jmp	rbv_TryFloppy
	else
rbv_AskYN:	call	TimeMark
		xchg	ax,dx
Ask_Wait:	mov	ah,1
		int	int_bioskey
		jnz	Ask_IsKey
		call	TimeMark
		sub	ax,dx
		cmp	ax,182
		jnb	exec_driver
		jmp	Ask_Wait
Ask_IsKey:	mov	ah,0
		int	int_bioskey
		or	al,' '
		cmp	al,'n'
		jz	rbv_NetBoot
		cmp	al,'t'
		jnz	rbv_AskYN
exec_driver	proc	near
		mov	si,offset EndOfCode
		lodsb			; skip filename
		mov	ah,0
		add	si,ax
		inc	si		; skip 'CD 20'
		inc	si
		lodsb			; skip driver args for NW boot
		add	si,ax
		inc	si
		mov	cx,0ff00h	; move driver (as it were invoked)
		sub	cx,si
		mov	di,com_start-4
		mov	ax,01234h
		org	$-2
		rep	movsb
		stosw
		mov	ax,0ebh		; jmp to next instruction
		stosw
		jmp	RomHeader-4
exec_driver	endp
	endif	; NETBOOT
rbv_NetBoot:
	ifdef	NETBOOT
		call	RomBootInit
	endif
		int	int_biosmem
	debug	Y
		mov	cl,6
		shl	ax,cl
		cld
	if	SaveVectors
		sub	ax,BootParagraphs+ivect_para
		mov	es,ax
		add	ax,ivect_para
		xor	si,si
		xor	di,di
		mov	ds,si
		mov	cx,ivect_para*8
		rep	movsw
	ifndef	PackedBoot
		push	cs
		pop	ds
	endif
	else
		sub	ax,BootParagraphs
	endif
	ifdef	PackedBoot
;	debug	P
		lea	si,EndInitModule-com_start
		mov	ch,RomPageCount
		add	ch,ch
		mov	dx,com_start
;;	destination: ax=segment, dx=start offset
;;	source cs:si=address, ch*100=end of data
		mov	es,ax
		mov	cl,0
		sub	cx,si
		xor	di,di
		push	cs
		push	es
		push	dx
		rep	movs byte ptr es:[di],byte ptr cs:[si]
		ret
	else
	; ax=segment where the code is to be moved to
		mov	es,ax
	ifdef	NETBOOT
		mov	cx,offset EndOfCode-com_start
		mov	si,com_start	; (sorry, it is wasted)
		mov	di,si
	else
		mov	cx,offset EndOfCode
		xor	si,si		; move our code first
		xor	di,di
	endif
	;	push	cs
	;	pop	ds
;	debug	M
		rep	movsb
		xchg	ax,dx
		mov	cx,dos_vect_cnt	; now set interrupt vectors 20h-2Fh
		mov	bx,offset BadIntHdrs
SetBad_l:	mov	al,[bx+3]
		call	SetIntVector
		lea	bx,[bx+4]
		loop	SetBad_l
		mov	al,int_doscall
		mov	bx,offset Int21Serv
		call	SetIntVector
		xchg	ax,cx		; ax=0
	;; the code below was attempter to set SapBroadcast instead having
	;; it already prepared and it has just as many bytes as the data...
	;	stosw			; set SapBroadcast network
	;	stosw
	;	dec	ax
	;	stosw			; set SapBroadcast node
	;	stosw
	;	stosw
	;	push	ax
	;	op2b	mov,ax,SapSrvSocket
	;	stosw			; set SapBroadcast socket
	;	pop	ax
	;	stosw			; set SapBroadcast immediate address
	;	stosw
	;	stosw
	;	mov	ax,sap_reply
	;	stosw			; set SapBroadcast serv. type (nearest)
	;	xor	ax,ax		; clear our blank data
		mov	cx,offset EndOfData-offset EndOfCode
		rep	stosb
		lodsb			; filename for program to load
		xchg	ax,cx
		rep	movsb
		mov	cl,para_size
		rep	stosw
		xchg	ax,di
		and	al,-para_size	; and round to paragraph boundary
	;; these instructions below are correct if the boot is to get
	;; 64kB (1000h paragraphs) of memory; if driver alone will get
	;; 64kB can skip the "sub", if there is to be less should move
	;; the memory size expressed in bytes to BX instead the "xor".
	if	BootParagraphs LT 1000h
		mov	bx,BootParagraphs SHL 4
		sub	bx,ax		; BX is value for driver's SP
	else
		xor	bx,bx
	 if	BootParagraphs LT 1200h	; assume our code+data<8kB
					; (cannot know exact size here)
			; was (1000h+((EndOfData+120h-RomHeader) SHR 4))
		sub	bx,ax		; BX is value for driver's SP
	 endif
	endif
	;
		mov	cl,4
		shr	ax,cl		; paragraph # used by us
		add	ax,dx		; driver's segment
		mov	es:UsedMemTop[di],ax
		mov	es,ax		; prepare driver's PSP
		movsw
		mov	cl,40h-1	; PSP words before args
		xor	ax,ax
		rep	stosw
	;; command line should be compressed, it is usually much < 127 bytes
		lodsb			; command line length
		stosb
		xchg	ax,cx		; ax=0, cx=command line length
		rep	movsb
		movsb			; move ending CR
		mov	ch,com_start shr 8	; zero fill to 100h
		sub	cx,di
		rep	stosb
		push	es		; set SS:SP
		pop	ss
		mov	sp,bx
		push	ax		; push 0
		push	es
		push	di
		mov	ch,RomPages*2	; put the driver
		sub	cx,si
		rep	movsb
		push	es
		pop	ds
;	debug	R
		ret			; start the driver
	endif
RomBootVect	endp

	ifdef	NETBOOT
RomBootInit	proc	near		; sets INT 19h vector if not set yet
					; uses ax,bx,es
		mov	al,int_bootsav+1
		call	IntVectAddr
		mov	ax,bootsav_sign
		cmp	es:[bx],ax
		jz	RomBootInit_x
		mov	es:[bx],ax
		mov	ax,(int_bootsav shl 8)+int_reboot
		call	MoveIntVector
		mov	bx,offset RomBootVect
		push	cs
		pop	es
		call	SetIntVector
RomBootInit_x:	ret
RomBootInit	endp
	endif

;BootSectorRead	proc	near
;		ret
;BootSectorRead	endp

BiosCharOut	proc	near		; outputs char from AL, changes AH
		mov	ah,biosvideo_wrtty
		push	bx
		mov	bx,biosvideo_yellow
		int	int_biosvideo
		pop	bx
		ret
BiosCharOut	endp

DosStringOut	proc	near		; Function 09 - string out
		push	ax		; destroys SI only
		mov	si,dx
		cld
DosStringOut_l:	lodsb
		cmp	al,'$'
		jz	DosStringOut_x
		call	BiosCharOut
		jmp	DosStringOut_l
DosStringOut_x:	pop	ax
		ret
DosStringOut	endp

EndInitModule	label	near
	ifdef	trunc
	%out	Truncated code produced
	else

Int21Functions	=	0
DosFcn		macro	fcn,prc
Int21Functions	=	Int21Functions+1
		db	fcn
		dw	prc
		endm

Int21FuncTable:	DosFcn	02h,DosCharOut		; no registers changed
		DosFcn	09h,DosStringOut	; .
		DosFcn	0F2h,DosNcpRequest	; AL=error code (NC,0=OK)
		DosFcn	19h,GetCurrentDisk	; AL=disk (0=A:)
		DosFcn	25h,DosSetVect		; no registers changed
		DosFcn	2Ch,GetTime		; CH,CL,DH,DL=h,m,s,f
		DosFcn	31h,StayResident	; no return
		DosFcn	35h,DosGetVect		; ES:BX=vector value
		DosFcn	3Dh,DosOpenFile		; AX=handle/error (1-5,12)
		DosFcn	3Eh,DosCloseFile	; AX=3Exx/error (6)
		DosFcn	3Fh,DosReadFile		; AX=byte#/error (5,6)
		DosFcn	40h,DosWriteFile	; .
		DosFcn	42h,DosSeekOnFile	; DXAX=new position/AX=er(1,6)
		DosFcn	49h,ReleaseMemBlk	; AX=undefined/error(7,9)
		DosFcn	4Ah,ResizeMemBlk	; AX=undefined/error(7-9),
						; BX=max available memory
		DosFcn	44h,DosFileIOCtl	; DX=AX=device/handle word
		DosFcn	30h,DosVersion		; AX=0
		DosFcn	0F1h,NwDetachFromS	; AL=FF and CF set on err,0=OK
;		DosFcn	0Dh,NwResetDisk		; returns last NW error in AL
;		DosFcn	4Ch,FatalError

BadIntH		macro	iv
BadInt&iv	label	far
		call	BadIntServ
		db	0&iv&h
		endm

BadIntServ	proc	near		; bad interrupt or function code
		push	cs		; shows INT No and AH, then hangs
		pop	ds
		assume	ds:Text
		mov	al,ah		; encode and put function code in msg
		call	EncByteHex
		mov	BadFunctionCode,ax
		pop	si
		lodsb
		call	EncByteHex
		mov	BadVectorNumber,ax
		mov	dx,offset FatalErrorMsg
		call	DosStringOut	; show message and hangup
	ifdef	SHOWBADCALLER
		pop	cx		; caller's IP
		pop	ax		; caller's CS
		call	WordHexOut	; show CS
		mov	al,':'
		call	BiosCharOut	; show ':'
		xchg	ax,cx
		call	WordHexOut	; show IP
	endif
		sti
		jmp	$
		assume	ds:Nothing
BadIntServ	endp

BadIntHdrs	label	far
		BadIntH	20
		BadIntH	21
		BadIntH	22
		BadIntH	23
		BadIntH	24
		BadIntH	25
		BadIntH	26
		BadIntH	27
		BadIntH	28
		BadIntH	29
		BadIntH	2A
		BadIntH	2B
		BadIntH	2C
		BadIntH	2D
		BadIntH	2E
		BadIntH	2F

Int21Serv	proc	far		; our "DOS" function service
;	debug	*
		cld
		puss	cx,es,ds,di,si,bp,bx,dx,cx
		mov	bp,offset Int21FuncTable
		mov	cx,Int21Functions
i21s_1:		cmp	cs:[bp],ah	; search table for the function
		lea	bp,[bp+3]
		loopnz	i21s_1
		popp	cx
	ifdef	SHOWBADCALLER
		jz	i21s_2
		popp	es,ds,di,si,bp,bx,dx,cx
	endif
		jnz	BadInt21	; .. not found
i21s_2:		call	word ptr cs:[bp-2]
		mov	bp,sp
		xchg	ax,dx
		lahf
		mov	[bp+14h],ah	; skip 8 registers + CS:IP, put flags
		xchg	ax,dx
		popp	es,ds,di,si,bp,bx,dx,cx
		iret
Int21Serv	endp

DosCharOut	proc	near		; Function 02 - char out (from DL)
		push	ax		; all registers preserved
		mov	al,dl
		call	BiosCharOut
		pop	ax
		ret
DosCharOut	endp

GetCurrentDisk	proc	near		; Function 19 - Get Current Disk
		mov	al,0		; (always A:)
		ret
GetCurrentDisk	endp

DosSetVect	proc	near		; Function 25 - Set Vector
		puss	ds		; changes ES,BX
		popp	es
		mov	bx,dx
		jmp	SetIntVector
DosSetVect	endp

GetTime		proc	near		; Function 2C - get time
		xor	ah,ah		; (return BIOS time)
		int	int_biostime
		mov	bp,sp		; caution: must be called by INT 21h!
		mov	[bp+10h],cx
i21r_set_dx:	mov	bp,sp
		mov	[bp+0Eh],dx
		ret
GetTime		endp

DosGetVect	proc	near		; Function 35 - Set Vector
		call	GetIntVector
		mov	bp,sp		; caution: must be called by INT 21h!
		mov	[bp+02h],es
;i21r_set_bx:	mov	bp,sp
		mov	[bp+0Ch],bx
		ret
DosGetVect	endp

;ReleaseMemBlk	proc	near		; Function 49 - release memory clock
;		clc			; ... just ignore, return OK
;		ret
;ReleaseMemBlk	endp

;ResizeMemBlk	proc	near		; Function 4A - resize memory clock
;		clc			; ... just ignore, return OK
;		ret
;ResizeMemBlk	endp

DosVersion	proc	near
		xor	ax,ax
DosVersion_x:	ret
DosVersion	endp

ReleaseMemBlk	=	DosVersion_x
ResizeMemBlk	=	DosVersion_x

	ifdef	SHOWBADCALLER
TwoCharOut	proc	near
		call	OneCharOut
		xchg	ah,al
		call	OneCharOut
		xchg	ah,al
		ret
OneCharOut	proc	near
		push	ax
		call	BiosCharOut
		pop	ax
		ret
OneCharOut	endp
TwoCharOut	endp
	endif

EncByteHex	proc	near		; byte AL to hex (AL,AH=1st,2nd nibble)
		push	cx		; (so can just store AX to display it)
		mov	cl,4
		mov	ah,0
		rol	ax,cl		; AH=high(1st) nibble
		ror	al,cl		; AL=low(2nd) nibble
		pop	cx
		call	Nibble2Hex	; convert low
		xchg	al,ah		; put low in AH, will convert high
Nibble2Hex	proc	near		; convert AL (assume 4 low bits used
		cmp	al,0ah		; only) to hex, put result in AL
		sbb	al,69h
		das
		ret
Nibble2Hex	endp
EncByteHex	endp

	ifdef	SHOWBADCALLER
WordHexOut	proc	near
		xchg	al,ah
		call	ByteHexOut
		xchg	al,ah
ByteHexOut	proc	near
		push	ax
		call	EncByteHex
		call	TwoCharOut
		pop	ax
		ret
ByteHexOut	endp
WordHexOut	endp
	endif

FatalErrorMsg	db	ch_cr,ch_lf,"Fatal Error: "
		db	"Unsupported INT "
BadVectorNumber	dw	0
		db	"h, AH = "
BadFunctionCode	dw	0
	ifdef	SHOWBADCALLER
		db	"h at $"
	else
		db	"h. Cannot continue....$"
	endif

	if	0
IdByteAddress	dw	0000Eh,0FFFFh	; address of machine ID byte

IsAT_Machine	proc	near		;(used to determine if having second
		push	ax		; interrupt controller in the machine)
		push	ds
		push	si
		lds	si,dword ptr cs:IdByteAddress
		lodsb
		pop	si
		pop	ds
		xor	al,id_byte_set
		test	al,not id_byte_ign
		pop	ax
		ret
IsAT_Machine	endp
	endif

TimeMark	proc	near		; get time in clock ticks
	ifdef	DirectTime		; result in AX
		push	ds		; other registers preserved
		xor	ax,ax
		mov	ax,biosvar
		mov	ds,ax
		mov	ax,ds:[biostimer]
		pop	ds
	else
		puss	cx,dx
		mov	ah,0
		int	int_biostime
		xchg	ax,dx
		popp	cx,dx
	endif
		ret
TimeMark	endp

;!!!	maybe it is good idea to set DL outside (Max/SapServerCount)
SrvTableLook	proc	near		; look/put server name in Server Table
		push	cs		; entry	DS:SI->name[48], DL=table limit
		pop	es		; exit:	CF set if not found and t. full
		cld			;	CF clear: name is in table,
					;		SI advanced,ES:DI->ipxa
					;		ServersUsed not changed
					;		ZF set if server known
					;		(JA is met when new)
					; registers changed: ES,AX,CX,DX,SI,DI
		mov	di,offset ServerTable
		lodsw
		mov	dh,ServersUsed
	;	mov	dl,MaxServerCount
SrvTableLook_l:	test	dh,dh
		mov	cx,nwobj_namelngt-2
		jz	SrvTableLook_g
		scasw
		jnz	SrvTableLook_n
		push	si
		repz	cmpsb
		pop	si
		jz	SrvTableLook_x
SrvTableLook_n:	add	di,cx
		add	di,size SrvInfo-nwobj_namelngt
		dec	dh
		dec	dl
		jg	SrvTableLook_l
		stc
		ret
SrvTableLook_g:	;cmp	dl,MaxServerCount-SapServerCount+1
		;jb	SrvTableLook_x	; if all SAP entries filled
		stosw
		rep	movsb
		test	dl,dl		; to clear ZF
SrvTableLook_x:	ret
SrvTableLook	endp

PacketLength	dw	0
PacketReceiver	proc	far		; packet receiver
		push	cs		; always destroys AX
		pop	es		; on space allocation call sets ES:DI;
		dec	ax		; on completion call:
	; set ES=CS, filter off multicasts (if disabled in ReceiveFlags)
	; set CX to length took from IPX header (w/o the header),
	; verify packet is long enough, set AX,DX=destination,source sockets
	; then try recognize packet by its destination socket:
	; as server reply (if ReceiveFlags allows):
	; - verify connection ID and packet sequence match (skip it in case
	;   of connect request), and the received is NCP reply type packet
	; - set RcvExtraLngt = CX = length of data after completion status
	; - disable receiving (to avoid overwriting the data by next packet)
	; as SAP reply (nearest file server only):
	; - verify source socket = SAP server, and sufficient packet size
	; - verify it is nearest fileserver SAP reply
	; - look server table, put info in it if new and have space
	; registers changed: AX,CX,DX,SI,DI,ES
		mov	al,cs:ReceiveFlags
		jz	PktRcvCompl	; .. receive complete, process data
		mov	es:PacketLength,cx
		test	al,ReceiveDisabled
		jnz	PktRcvReject	; .. receiver disabled now
		cmp	cx,PacketBufLngt
		ja	PktRcvReject	; .. packet too big
		mov	di,offset PktRcvBuf
		ret
PktRcvReject:	xor	di,di
		mov	es,di
PktRcvReturn:	ret
PktRcvCompl:	test	[si].eth_dst[0],1
		mov	cx,PacketLength
		jz	PktRcvAccept	; .. not multi/broadcast
		test	al,MltCastDisabled
		jnz	PktRcvReturn	; .. multicasts disabled
PktRcvAccept:	sub	cx,size EthIpxP	; cx=size w/o Eth/IPX header
		jb	PktRcvReturn	; .. no complete Eth/IPX header
		mov	ax,[si].ipx_lng
		xchg	al,ah		; ax=size w/o Eth header (but with IPX)
		add	ax,offset [-size EthIpxP].ipx_cks ; size w/o IPX header
		jnc	PktRcvReturn	; .. bad length in IPX header
		cmp	ax,cx		; is received size .ge. size in header?
		ja	PktRcvReturn	; .. incomplete packet
		xchg	ax,cx		; now CX=size of data after the header
		mov	ax,[si].ipx_dst.i_sock	; ax=destin socket
		mov	dx,[si].ipx_src.i_sock	; dx=source socket
		test	ReceiveFlags,ProcessSapOnly
		jnz	RcvSapReply	; .. SAP only to be processed
;		op2b	cmp,ax,BootCliSocket
		op2b2	cmp,ax,BootCliSock1,BootCliSock2
		jnz	RcvSapReply	; .. not client socket, check SAP
	; server reply processing:
		sub	cx,8		; subtract completion status size
		jb	RcvSrvrReply_r	; .. too short for completion status
		mov	ax,word ptr cs:PktRcvBuf[size EthIpxP+2] ; con id+seq
		cmp	word ptr cs:PktSndBuf[size EthIpxP],ncp_conn ; connect?
		jz	RcvSrvrReply_n	; .. new connection, don't compare seq
		cmp	ax,cs:ConSeqCompare	; check if con id and seq match
		jnz	RcvSrvrReply_r	; .. improper connection or packet seq
RcvSrvrReply_n:	cmp	word ptr cs:PktRcvBuf[size EthIpxP],ncp_reply ; NCP reply?
		jnz	RcvSrvrReply_r	; .. not server reply packet
		or	cs:ReceiveFlags,ReceiveDisabled	; good pkt - keep it!
		mov	cs:RcvExtraLngt,cx	; save length above minimum
RcvSrvrReply_r:	ret
	; SAP reply processing
RcvSapReply:	;op2b	cmp,ax,SapCliSocket	; check destin socket
		op2b2	cmp,ax,SapCliSock1,SapCliSock2
		jnz	RcvSapReply_x	; .. not this expecting SAP reply
;		op2b	cmp,dx,SapSrvSocket	; check source socket
		op2b2	cmp,dx,SapSrvSock1,SapSrvSock2
		jnz	RcvSapReply_1	; .. not SAP service socket
		lea	si,[si+size EthIpxP]	; si->SAP info
		cmp	cx,2+size SapInfo	; enough data?
		jc	RcvSapReply_x		; .. no, error
		lodsw			; verify SAP reply is nearest server
		cmp	ax,[si]		; 00,04 (nearest) 00,04 (fileserver)
		lodsw
		jnz	RcvSapReply_x
		cmp	ax,sap_reply
		jnz	RcvSapReply_x
		mov	dl,SapServerCount ; use SAP part of the table only
		call	SrvTableLook	; is the server already known?
		jna	RcvSapReply_x	; it is known or table full
		mov	cx,size ipx_adr	; get IPX address
		rep	movsb
		sub	si,offset [size EthIpxP+2-EthAddrLngt].sap_dist
		movsw			; get advertising node immediate addr.
		movsw
		movsw
		xor	ax,ax		; flag aren't connected to the server
		stosw
		inc	ServersUsed	; count servers stored in table
		mov	di,offset MyNetwork	; save own net number
		lea	si,[si-2*EthAddrLngt].ipx_dst
		movsw
		movsw
RcvSapReply_x:	ret
RcvSapReply_1:
		ret
PacketReceiver	endp

PacketRelease	proc	near		; release type accessed on pkt driver
					; entry: nothing; changes: AX,BX
		mov	ah,3		; release_type
	;	jmp	PktDrvrCallH
PktDrvrCallH	proc	near		; sets BX=handle, calls packet driver
		mov	bx,1234h	; (modified - value meaningless)
		org	$-2
PktDrvrHandle	dw	0
		int	PacketVector
		ret
PktDrvrCallH	endp
PacketRelease	endp

	ifdef	DELAY
Delay1Second	proc	near
		sti
		push	cx
		xor	cx,cx		; one second delay on start
Delay1Second_l:	in	al,61h
		xor	al,ah
		test	al,10h
		jz	Delay1Second_l
		xor	ah,al
		loop	Delay1Second_l
		pop	cx
		mov	al,'.'
		jmp	BiosCharOut
Delay1Second	endp
	endif

PacketAccess	proc	near		; access Novell type on packet driver
		push	cs		; entry: nothing
		pop	ds		; changes: DS,ES,AX,BX,CX,DX,SI,DI
		assume	ds:Text		; sets DS=ES=CS, CF if error
	ifdef	DELAY
		mov	cx,25
PacketAccDelay:	call	Delay1Second
		loop	PacketAccDelay
	endif
		mov	ServersUsed,0	; init some variables
		mov	ReceiveFlags,MltCastDisabled+ProcessSapOnly
		mov	al,PacketVector
		call	GetIntVector
		mov	si,offset PktSignature
		mov	cx,9
		lea	di,[bx+3]
		cld
		repz	cmpsb
		push	cs
		pop	es
		jz	PktDrvrSignOK
		stc
PktAccess_e:	ret
PktDrvrSignOK:	mov	ax,0201h	; access Novell type packets
		mov	bx,-1
		mov	dl,0		; (was 1 - wrong)
		mov	cl,2		; CX was 0
		mov	di,offset PacketReceiver
		int	PacketVector
		jc	PktAccess_e
		mov	PktDrvrHandle,ax
		mov	ah,6		; get own Ethernet address
		mov	di,offset MyEthAddress
		mov	cx,6
		push	di
		call	PktDrvrCallH
		pop	si		; build own IPX address
		jc	PktAccess_e
		mov	di,offset MyIpxAddress.i_node
		cld
		rep	movsb
		ret
PacketAccess	endp

AskSapQuery	proc	near
		push	cs
		pop	es
		mov	di,offset MyIpxAddress.i_sock
		cld
;		op2b	mov,ax,SapCliSocket
		op2b2	mov,ax,SapCliSock1,SapCliSock2
		stosw
		mov	ax,sap_query	; send SAP "nearest server" query
		stosw
		stosw
		mov	si,offset SapBroadcast
		call	MakeAndSendPkt
		push	cx
		xor	cx,cx		; and wait SAP replies
SapWaitBegin:	call	TimeMark
		xchg	ax,bx
		inc	cx
		mov	ch,0
WaitSapReply:	sti
		in	al,port_switches
		cmp	cl,ServersUsed
		jna	SapWaitBegin
		call	TimeMark
		sub	ax,bx
		shl	ax,cl
		cmp	ax,37
		ja	SapReplyDone
		dec	dx
		jnz	WaitSapReply
		dec	ch
		jnz	WaitSapReply
SapReplyDone:
		pop	cx
		mov	si,offset PktSndBuf
		mov	ah,4
		int	PacketVector
		mov	al,ServersUsed
		cbw
		ret
		assume	ds:Nothing
AskSapQuery	endp

NcpRequest	proc	near
	; entry	AL=server, DI set after storing data to NcpReqBuf
	; keep:	DS,BX,BP
	; exit: CF if error (AL=code, 0 if no answer (timeout))
		mov	si,offset NcpReqBuf
		mov	cx,di
		sub	cx,si
		puss	cs,cs,ds,bx
		popp	es,ds		; ds:si[cx]=data buffer[size]
		assume	ds:Text
;		op2b	mov,MyCurSocket,BootCliSocket
		op2b2	mov,MyCurSocket,BootCliSock1,BootCliSock2
		cld
		cmp	al,0
		jz	NcpRequest_n
		mov	CurrentServer,al
NcpRequest_n:	mov	al,CurrentServer
		mov	ah,size SrvInfo
		mul	ah
		xchg	ax,bx
		mov	ax,word ptr ServerTable[bx-size SrvInfo].srv_seq
		mov	di,offset PktSndBuf[size EthIpxP][6]
		test	ax,ax
		jnz	NcpRequest_c
		mov	ax,ncp_conn
		stosb
		puss	cx,si
		lea	si,ServerTable[bx-size SrvInfo].srv_ipxa
		call	XchgServerPkts
		jc	NcpRequest_p
	;
		mov	al,PktRcvBuf[size EthIpxP+3]
		mov	[bx+ServerTable-size SrvInfo].srv_con,al
	;
		mov	byte ptr [di-1],19h
		mov	ax,ncp_req
		call	XchgServerPkts
		dec	di
NcpRequest_p:	popp	cx,si
		jc	NcpRequest_q
NcpRequest_c:	rep	movsb
		inc	[bx+ServerTable-size SrvInfo].srv_seq
		lea	si,ServerTable[bx-size SrvInfo].srv_ipxa
		mov	ax,ncp_req
		call	XchgServerPkts
NcpRequest_q:	mov	al,0
		jc	NcpRequest_r
		mov	al,PktRcvBuf[size EthIpxP+6]
		cmp	al,1
		cmc
NcpRequest_r:	mov	NcpReqError,al
		popp	ds,bx
		ret

XchgServerPkts	proc	near
	; entry AX=first data word, CS:SI->destination ipx address,
	;	followed by immediate address and sequence/connection info;
	;	packet data in send buffer, ES=CS, ES:DI->end of data
	; changes: CX,DX
	; calls MakeAndSendPkt: need put source socket only in IPX header
	;			and data starting from function code.
		puss	cs,ds
		popp	ds
		assume	ds:Text
		call	ReceiverEnable
		mov	dl,10
XchgSrvrPkts_r:	puss	ax,dx
		call	MakeAndSendPkt
		mov	cx,10
		mov	ax,biosvar
		mov	ds,ax
XchgSrvrPkts_w:	sti
		test	cs:ReceiveFlags,ReceiveDisabled
		jnz	XchgSrvrPkts_q
		mov	al,ds:[biostimer]
		cmp	al,ah
		xchg	al,ah
		jz	XchgSrvrPkts_w
		loop	XchgSrvrPkts_w
		push	cs
		popp	ds,ax,dx
		dec	dl
		jnz	XchgSrvrPkts_r
		stc
		pop	ds
		ret
XchgSrvrPkts_q:	popp	ax,dx,ds
		assume	ds:Nothing
		ret
XchgServerPkts	endp
NcpRequest	endp

MakeAndSendPkt	proc	near
	; entry AX=first data word, DS:SI->destination ipx address,
	;	followed by immediate address and sequence/connection info;
	;	packet data in send buffer, ES=CS, ES:DI->end of data
	; changes: DS,AX,CX,DX
	; fills the following fields of the packet before sending it:
	; - destination IPX and Eth addresses (source Eth address and
	;   node in source IPX address is set on initialization forever)
	; - protocol (it is destroyed by packet driver)
	; - dummy checksum, length, transport ctl, pkt type in IPX header
	; - task id=0 (word at data+4), sequence/connection info (from area
	;   pointed to by DS:SI; word at data+2), NCP type (word at data+0)
	; this means need put source socket only in the IPX header,
	; and for simplest requests need put function byte only in data.
		puss	ax,di,si
		mov	dx,di
		mov	cx,size ipx_adr	; put destination ipx address
		mov	di,offset PktSndBuf.ipx_dst
		rep	movsb
		mov	di,offset PktSndBuf	; and immediate address
		movsw
		movsw
		movsw
		add	di,6		; skip source eth address, it is here
;		op2b	mov,ax,EthProtocol
		op2b2	mov,ax,EthPr1,EthPr2
		stosw			; put protocol
		sub	dx,di		; compute length
		mov	ax,-1		; put dummy checksum
		stosw
		lodsw			; get sequence/connection info
		mov	ConSeqCompare,ax
		xchg	ax,dx		; (will be in dx)
		push	ax		; length, will need it later
		xchg	al,ah		; put length
		stosw
		mov	ax,1100h	; put transport ctl and packet type
		stosw
		mov	cl,size ipx_adr
		add	di,cx		; skip destination ipx address, was put
		push	cs		; put own network in address
		mov	si,offset MyNetwork
		pop	ds
		movsw
		movsw
		add	di,cx		; skip remainder of source ipx address
		cbw			; ax=0, will put it as task id
		std			; (gone 2 words ahead, must move back)
		stosw
		xchg	ax,dx		; put sequence/connection info
		stosw
		pop	cx		; packet length (from ipx header)
		pop	ax		; put first data word of packet
		stosw
		add	cx,offset [0].ipx_cks
	;	cmp	cx,60
	;	jae	MakeAndSendPkt_1
	;	mov	cx,60
		cld
		mov	si,offset PktSndBuf
		mov	ah,4
		int	PacketVector
		popp	di,si
		ret
MakeAndSendPkt	endp

ReceiverEnable	proc	near		; enables all receiving exc. multicast
					; entry: nothing, changes ReceiveFlags
		and	cs:ReceiveFlags,MltCastDisabled
	;	and	cs:ReceiveFlags,not ReceiveDisabled
		ret
ReceiverEnable	endp

	if	0
ExecuteModule	PROC	NEAR
;	entry	AX=starting paragraph of .EXE header
;		BX=paragraph where loadable module starts
		ASSUME	DS:Nothing
		POP	CS:ExecIPsav	; save IP
		MOV	CS:ExecSSsav,SS	; save SS
		MOV	CS:ExecSPsav,SP	; save SP
		CALL	RelocateExeMod	; relocate
		MOV	ES,AX
		SUB	SI,SI
		ADD	BX,ES:[SI+16H]	; initial CS
		MOV	CS:ExecStartCS,BX
		MOV	BX,ES:[SI+14H]	; initial IP
		MOV	CS:ExecStartIP,BX
		MOV	AX,DS		; "PSP" ?
		MOV	ES,AX
		JMP	DWORD PTR CS:ExecStartIP
ExecuteModule	ENDP

RelocateExeMod	PROC	NEAR
;	entry	AX=starting paragraph of .EXE header
;		BX=starting paragraph of loadable module
		ASSUME	DS:Nothing
		PUSH	AX
		PUSH	DS
		PUSH	ES
		MOV	DS,AX
		ASSUME	DS:S3000
		MOV	CX,L0006	; number of relocation items
		JCXZ	rel_2
		MOV	SI,L0018	; offset of first relocation item
rel_1:		MOV	DI,[SI]
		MOV	AX,[SI+2]
		ADD	AX,BX
		MOV	ES,AX		; ES:DI points to word to be relocated
		ADD	ES:[DI],BX	; relocate
		ADD	SI,4		; advance to next item
		LOOP	rel_1
rel_2:		POP	ES
		POP	DS
		ASSUME	DS:Nothing
		POP	AX
		RET
RelocateExeMod	ENDP

StayResident	PROC	NEAR
		MOV	AX,CS
		MOV	ES,AX
		MOV	DS,AX
		ASSUME	DS:S4000,ES:S4000
		MOV	ResidentSize,DX
		CLI
		MOV	SS,ExecSSsav
		MOV	SP,ExecSPsav
		STI
		CALL	NewlineOut
		ASSUME	DS:Nothing,ES:Nothing
		JMP	WORD PTR CS:ExecIPsav
StayResident	ENDP

WaitKeyHit	PROC	NEAR
		PUSH	AX
		MOV	AH,0
		INT	int_bioskey
		CALL	NewlineOut
		POP	AX
		RET
WaitKeyHit	ENDP
	endif

UpCase		proc	near		; convert AL to uppercase
		cmp	al,'a'		; no other registers changed
		jb	UpCase_x
		cmp	al,'z'
		ja	UpCase_x
		sub	al,' '
UpCase_x:	ret
UpCase		endp

NwFileOpen	proc	near		; need better doc!!!
	; DS:DX->file name (eventually preceded by \\servername\)
		push	cs
		pop	es
		cld
		mov	bx,offset NetWareFiles
		xor	ax,ax
		mov	cx,MaxFileHandle
		mov	di,offset FileHandles
		repnz	scasb
		jnz	NwFileOpen_nh
NwFileOpen_lh:	inc	ax
		cmp	cs:[bx].fh_serv,ah
		jz	NwFileOpen_hf
		add	bx,size NFDescr
		cmp	al,MaxFileCount
		jb	NwFileOpen_lh
NwFileOpen_nh:	mov	al,4
		stc
		ret
NwFileOpen_hf:	dec	di
		push	di
		mov	di,offset NcpReqBuf
		puss	di,ax
		mov	si,dx
		mov	ax,[si]
		cmp	ax,'\\'
		jnz	NwFileOpen_fn
		lodsw
		mov	cx,48
NwFileOpen_ms:	lodsb
		cmp	al,ah
		jz	NwFileOpen_sf
		call	UpCase
		stosb
		loop	NwFileOpen_ms
NwFileOpen_sf:	mov	al,0
		rep	stosb
		puss	es,si,ds
		lea	si,[di-48]
		popp	ds
		mov	dl,MaxServerCount ; scan entire table
		call	SrvTableLook
		popp	si,ds
		jnz	NwFileOpen_se	; no such server known
		xchg	ax,di
		sub	ax,offset ServerTable
		xor	dx,dx
		mov	cx,size SrvInfo
		div	cx
		inc	ax
		mov	CurrentServer,al
		pop	di
		push	di
NwFileOpen_fn:	mov	ax,0141h	; (ncp file open fcn=41)
					; (directory handle=1)
		stosw
		mov	al,06h		; (open attributes)
		stosw
		xor	cx,cx
NwFileOpen_l:	lodsb
		cmp	al,0
		stosb
		loopnz	NwFileOpen_l
		dec	di
		not	cx
		puss	cs
		popp	ds,si
		mov	[si+3],cl
		puss	bx
		mov	al,0
		call	NcpRequest
		popp	di
		jc	NwFileOpen_oe
		mov	al,CurrentServer
		cbw
		stosw
		mov	si,offset PktRcvBuf[size EthIpxP+8]
	; [si+00h]	netware_file_handle[6]
	; [si+06h]	[2] (unknown)
	; [si+08h]	file_name[14]
	; [si+16h]	file_attribute
	; [si+18h]	file_size[4]
	; [si+1Ah]	file_creation_date[2]
	; [si+1Ch]	file_last_access_date[2]
	; [si+20h]	modify_date_and_time[4]
		movsw
		movsw
		movsw
		xor	ax,ax
		stosw
		stosw
		add	si,12h		; get file size
		movsw
		movsw
		popp	ax,di
		inc	ax
		stosb			; save descriptor entry index
		xchg	ax,di
		sub	ax,offset FileHandles[1]
		ret
NwFileOpen_oe:	popp	ax,di
		mov	al,2
		ret
NwFileOpen_se:	popp	ax,ax,di
		mov	al,3
		stc
		ret
NwFileOpen	endp

NwGetFileH	proc	near		; need doc!!!
		cld			; changes: DS,ES,AX,SI,DI
		cbw
		push	cs
		pop	es
		push	cs
		pop	ds
		assume	ds:Text
		mov	di,offset NcpReqBuf
		stosw
		cmp	bx,MaxFileHandle
		cmc
		jc	NwGetFileH_e
		mov	al,FileHandles[bx]
		sub	al,1
		jc	NwGetFileH_e
		jz	NwGetFileH_c	; console
		mov	ah,size NFDescr
		mul	ah
		add	ax,offset NetWareFiles-size NFDescr
		xchg	ax,si
		lodsw
		cmp	al,1
		jc	NwGetFileH_e
		movsw
		movsw
		movsw
		test	al,al
NwGetFileH_c:	ret
NwGetFileH_e:	mov	ax,6
		ret
		assume	ds:Nothing
NwGetFileH	endp

NwFileRead	proc	near
		puss	dx,ds,cx,bx,dx
		; stack: offset/segment for read, remaining bytes to read,
		;	 saved BX,DX (CX is destroyed!)
NwFileRead_1:	mov	al,48h		; (ncp file read fcn)
		call	NwGetFileH
		jc	NwFileRead_e
		jz	NwFileRead_c	; console
		movsw
		mov	bx,si
		movsw
		xchg	ax,cx
		cmp	ax,SectorSize
		jbe	NwFileRead_2
		mov	ax,SectorSize
NwFileRead_2:	xchg	al,ah
		stosw
		xchg	ax,cx
		call	NcpRequest
	ifndef	NwReadPassBlock
		jc	NwFileRead_f
	else
		jnc	NwFileRead_k
		push	ax
		call	WordHexOut
		pop	ax
		cmp	al,2Fh		; (failed on block crossing?)
		stc
		jnz	NwFileRead_f
		clc
NwFileRead_k:
	endif
		mov	si,offset PktRcvBuf[size EthIpxP+8]
		lodsw
		xchg	al,ah		; ax=byte count read
		xchg	ax,cx
		jcxz	NwFileRead_5	; .. if nothing read
		popp	di,es,ax
		sub	ax,cx
		jnc	NwFileRead_3
		add	cx,ax
		xor	ax,ax
NwFileRead_3:	push	ax
	if	OddReadShifted
		test	byte ptr [bx+1],1
		jz	NwFileRead_4
		inc	si
	endif
NwFileRead_4:	call	NwFR_AHLC
		dec	bx
		dec	bx
		rep	movsb
		call	NwFR_AHLC
		popp	cx,bx
		puss	di,es,cx,bx
		inc	cx
		loop	NwFileRead_1
NwFileRead_5:	popp	ax
NwFileRead_6:	popp	ds
NwFileRead_7:	popp	cx,bx,dx
		jc	NwFileRead_x
		sub	ax,dx
		clc
NwFileRead_x:	ret
NwFileRead_f:	mov	ax,5
NwFileRead_e:	pop	cx
		jmp	NwFileRead_6
NwFR_AHLC:	mov	ax,[bx]
		xchg	al,ah
		adc	ax,cx
		xchg	al,ah
		mov	[bx],ax
		ret
NwFileRead_c:	popp	di,es		; read from console
		mov	ah,0
		int	int_bioskey
		cld
		stosb
		cmp	al,0
		jnz	NwFileRead_c1
		dec	di
		stosw
NwFileRead_c1:	xchg	ax,di
		jmp	NwFileRead_7
NwFileRead	endp

NwFileWrite	proc	near		; need doc!!!
		push	ds
		call	NwGetFileH	; CF set if error
		pop	ds
		jc	NwFileWrite_e
		mov	ax,5		; allow console write only
		stc
		jnz	NwFileWrite_e
		mov	si,dx
		jcxz	NwFileWrite_f
NwFileWrite_l:	lodsb
		call	BiosCharOut
		loop	NwFileWrite_l
NwFileWrite_f:	xchg	ax,si
		sub	ax,dx
NwFileWrite_e:	ret
NwFileWrite	endp

NwFileIOCtl	proc	near		; need doc!!!
		cmp	al,1		; the only supported subfunction is 0
		jnc	IllegalFcn1	; .. illegal subfunction
		call	NwGetFileH	; CF set if error
		jc	NearReturn1
		mov	ax,00040h	; result for network file
					; (Novell always returns this value)
		jnz	NwFileIOCtl_d
		mov	ax,080A3h	; result for console
					; (bit 15 set because of TC15 bug)
NwFileIOCtl_d:	mov	dx,ax
		jmp	i21r_set_dx
IllegalFcn1:	mov	ax,1		; .. illegal subfunction
		stc
NearReturn1:	ret
NwFileIOCtl	endp

NwFileClose	proc	near		; entry: BX="DOS" file handle
					; changes: DS,ES,AX,CX,DX,SI,DI
		mov	al,42h		; (ncp file close fcn)
		call	NwGetFileH	; CF set if error
		assume	ds:Text
		jc	NwFileClose_e
		mov	byte ptr FileHandles[bx],0	; make the handle free
		jz	NwFileClose_e
		sub	[si-8],al	; make the descriptor "free"
		call	NcpRequest
NwFileClose_e:	ret
		assume	ds:Nothing
NwFileClose	endp

NwFileSeek	proc	near		; entry: AX,BX,CX,DX as for DOS
		push	ax		;	 (AL=0 or 1, no SEEK_END)
		call	NwGetFileH	; need more doc!!!
		pop	bx
		jc	NearReturn1
		jz	IllegalFcn1	; seek on console is not allowed
		cmp	bl,3
		jnc	IllegalFcn1	; subfunction>=3 is invalid
		mov	bh,0
		xor	ax,ax		; (was: dec ax - now is more clear)
		add	bl,bl
		add	bl,bl
		jz	NwFileSeek_s	; SEEK_SET, AX and BX already 0
		mov	ax,[si+bx-2]	; seek relative, AX and BX are
		mov	bx,[si+bx-4]	; low and high word of position
		xchg	al,ah
		xchg	bl,bh
NwFileSeek_s:	add	ax,dx		; AX=low word,
		adc	bx,cx		; BX=high word of final position
		mov	dx,ax		; need return low word in AX
		xchg	dl,dh
		mov	[si+2],dx	; store low word
		mov	dx,bx		; need return high word in DX
		xchg	bl,bh
		mov	[si],bx		; store high word
		clc
		jmp	i21r_set_dx
NwFileSeek	endp

StayResident	proc	far		; need doc!!!
	debug	A
		add	cs:UsedMemTop,dx
		call	PacketAccess
;	debug	Q
		assume	ds:Text
	ifdef	DELAY
		call	AskSapQuery
		call	Delay1Second
		call	Delay1Second
	endif
	ifdef	SAPWAIT
sap_retry:	mov	dx,offset im_asqi
		call	DosStringOut
	endif
		call	AskSapQuery
	ifdef	SAPWAIT
		jnc	sap_send_ok
		push	ax
		mov	dx,offset wm_spsf
		call	DosStringOut
		pop	ax
sap_send_ok:	cmp	al,0
		jz	sap_retry
	endif
		mov	di,offset FileHandles
		mov	ax,0101h	; (store 5 ones)
		cld
		stosw
		stosw
		stosb
boot_nexts:	mov	dx,offset EndOfData
;	debug	O
		call	NwFileOpen
		jnc	boot_opened
		mov	bx,offset em_open
		cmp	word ptr EndOfData,'\\'
		jz	boot_error
		cmp	al,3
		jz	boot_error
		mov	al,CurrentServer
		inc	ax
		cmp	al,ServersUsed
		jnb	boot_error
		mov	CurrentServer,al
		jmp	boot_nexts
boot_opened:
	;- was	xchg	ax,bx	- now display some info
		push	ax
		mov	al,CurrentServer
		push	ax
	;	call	Nibble2Hex
		cmp	al,0ah		; only) to hex, put result in AL
		sbb	al,69h
		das
	;
		call	BiosCharOut
		mov	al,'.'
		call	BiosCharOut
		pop	ax
		mov	ah,size SrvInfo
		mul	ah
		add	ax,offset ServerTable-size SrvInfo
		xchg	ax,dx
		mov	cx,size srv_name
		mov	bx,1
		call	DosWriteFile
		mov	al,ch_cr
		call	BiosCharOut
		mov	al,ch_lf
		call	BiosCharOut
		pop	bx
	;-
		mov	ax,BootReadSegment
		mov	ds,ax
		assume	ds:Nothing
		xor	dx,dx
		puss	bx,dx,ds
		mov	cx,BootReadSize
;	debug	R
		call	NwFileRead
		mov	bx,offset em_read
		jc	boot_error
		pop	bx
;	debug	C
;	do not	call	NwFileClose
;	(need pass open handle and read size to boot program)
	debug	J
		ret
boot_error:	push	cs
	debug	E
		pop	ds
		assume	ds:Text
		mov	dx,offset em_fail
		call	DosStringOut
		mov	dx,bx
		call	DosStringOut
		mov	dx,offset em_boot
		call	DosStringOut
		sti
		jmp	$
		assume	ds:Nothing
em_fail		db	"Fail to $"
em_open		db	"open$"
em_read		db	"read$"
em_boot		db	" boot image file.$"
	ifdef	SAPWAIT
im_asqi		db	"SAP Query...",ch_cr,ch_lf,'$'
wm_spsf		db	"...send failed",ch_cr,ch_lf,'$'
	endif
StayResident	endp

	if	0
NwResetDisk	proc	near
		mov	al,cs:NcpReqError
		clc
		ret
NwResetDisk	endp
	endif

NwDetachFromS	proc	near		; need doc!!!
		cmp	al,1
		jnz	NwDetachFS_e
		dec	dx
		cmp	dl,MaxServerCount
		jnc	NwDetachFS_e
		mov	al,size SrvInfo
		mul	dl
		add	ax,offset ServerTable.srv_ipxa
		xchg	ax,si
		push	cs
		pop	es
con_from_ipxa	=	offset [0].srv_con-offset [0].srv_ipxa
		mov	al,0
		cmp	es:[si+con_from_ipxa],al
		jz	NwDetachFS_e
		mov	di,offset NcpReqBuf-1
;		op2b	mov,<es:[di-size EthIpxP-6].ipx_src.i_sock>,BootCliSocket
		op2b2	mov,<es:[di-size EthIpxP-6].ipx_src.i_sock>,BootCliSock1,BootCliSock2
		stosb
		mov	ax,ncp_detach
		call	XchgServerPkts
	; calls MakeAndSendPkt: need put source socket only in IPX header
	;			and data starting from function code.
		jc	NwDetachFS_e
		xor	ax,ax
		mov	word ptr cs:[si-offset [0].srv_ipxa].srv_seq,ax
NwDetachFS_x:	sbb	al,al
		mov	ah,0F1h	; value to be returned to simulate NETX
		ret
NwDetachFS_e:	stc
		jmp	NwDetachFS_x
NwDetachFromS	endp

DosNcpRequest	proc	near		; need doc!!!
		puss	cs,di,es,dx
		pop	es
		mov	di,offset NcpReqBuf
		cld
		stosb
		rep	movsb
		mov	al,0
		call	NcpRequest
		puss	cs
		popp	ds,di,es,cx
		jc	DosNcpReq_e
		mov	si,offset PktRcvBuf[size EthIpxP+8]
		rep	movsb
DosNcpReq_e:	ret
DosNcpRequest	endp

MyNetwork	label	word
;SapBroadcast	db	4 dup(0),6 dup(0ffh),SapSrvSocket,6 dup(0ffh),0,4
SapBroadcast	db	4 dup(0),6 dup(0ffh),SapSrvSock1,SapSrvSock2,6 dup(0ffh),0,4
EndOfCode	label	near		; end of initialized data
					; (remainder will be cleared)

ServerTable	SrvInfo	MaxServerCount	dup(<>)
FileHandles	db	MaxFileHandle	dup(?)
NetWareFiles	NFDescr	MaxFileCount	dup(<>)
PktRcvBuf	db	PacketBufLngt	dup(?)
PktSndBuf	db	PacketBufLngt	dup(?)
NcpReqBuf	=	PktSndBuf[size EthIpxP+7]
read_buffer	db	128		dup(?)
EndOfData	label	near
	ifndef	NETBOOT
		db	RomHeader+RomPages*PageSize-6-EndOfData dup(0)
		dw	EndOfCode,EndOfData,RomPages*PageSize ; was: StartLabel
	endif

DosOpenFile	=	NwFileOpen	; Function 3D - open file
DosCloseFile	=	NwFileClose	; Function 3E - close file
DosReadFile	=	NwFileRead	; Function 3F - read file
DosSeekOnFile	=	NwFileSeek	; Function 42 - seek on file
DosWriteFile	=	NwFileWrite	; Function 40 - write to file
DosFileIOCtl	=	NwFileIOCtl	; Function 44 - ioctl on file

	endif
Text		ends
		end	RomHeader
RomPages*PageSize
925  PktDrvrSignOK:  mov     ax,0201h        ; access Novell type packets
1021                 mov     byte ptr [di-1],19h
1114                 mov     ax,1100h        ; put transport ctl and packet type
1322                 add     si,12h          ; get file size
1736 SapBroadcast    db      4 dup(0),6 dup(0ffh),SapSrvSocket,6 dup(0ffh),0,4
