#include <stdio.h>
#include <io.h>
#include <string.h>

/* MltBoot - Multiple Boots in single ROM (many bootroms packed)
;
; idea about packing - records consisting of count, then
;   in odd record: count bytes, no more than 5 consecutive identical;
;   in even record: previous byte is to be repeated count times;
;   count of 0 means end of the bootrom
; every packed bootrom image should be preceded by
;   word specifying offset to next bootrom (-1 in last)
;   a zero-terminated description to be displayed in menu
; menu: F-boot from floppy, H-boot from HD, 1..9-use bootrom 1..9
; default (on timeout):
;*/

typedef unsigned char byte;

int readln(char *buf, int bfs) {
	int l; if(fgets(buf,bfs,stdin)==NULL)
		{ if(ferror(stdin)) perror("stdin"); return -1; }
	if((l=strlen(buf))>0 && buf[l-1]=='\n') buf[--l]=0; return l;
}

int readnum(unsigned *val) {
	int c,v;
	do c=fgetc(stdin); while(c==' ' || c=='\t'); if(c=='\n') return -1;
	for(v=0; (unsigned)(c-'0')<10; v=v*10+c-'0',c=fgetc(stdin)); *val=v;
	while(c==' ' || c=='\t') c=fgetc(stdin); return (c=='\n')?0:-1;
}

FILE *inpf,*outf; int lch; unsigned cnt,lng,mcn,pbo,rcs;

int flushpacked(int all) {
	if(mcn>0 && mcn<5) {
		for(; mcn>0; mcn--)
			if(fputc(lch,outf)==EOF) return -1;
			else { rcs-=lch; lng++; cnt++; }
		if(all==0) return 0;
	}
	printf("%04x..%04x %04x*%02x\n",pbo,lng,mcn,lch);
	fseek(outf,pbo,SEEK_SET); if(putw(cnt,outf)==EOF) return -1;
	rcs-=(byte)cnt+((byte*)&cnt)[1]; cnt=0;
	fseek(outf,lng,SEEK_SET); if(putw(mcn,outf)==EOF) return -1;
	lng+=2; rcs-=(byte)mcn+((byte*)&mcn)[1]; return 0;
}

main(void) {
	static const char	mltbprog[]="mltboot.bin",
				multirom[]="mltboot.rom";
	char des[128],ifn[128];
	int b,tty; unsigned bgn,rsz;

	/* boot menu program processing */
	tty=isatty(fileno(stdin)); strcpy(ifn,mltbprog);
	if((inpf=fopen(ifn,"rb"))==NULL) goto inperr;

	if(tty) printf("Enter size of ROM to be produced in kB: ");
	rsz=-1U; if(readnum(&rsz)<0 || rsz>64 || rsz==0) return -1;

	if(tty) printf("Enter selection timeout (seconds, 1-255): ");
	bgn=-1U; if(readnum(&bgn)<0) return -1; if(bgn>255) bgn=255;

	if((outf=fopen(multirom,"wb"))==NULL) goto outerr;

	for(rcs=lng=0; (b=getc(inpf))!=EOF; lng++,rcs-=b) {
		if(lng==2) b=rsz*2; if(lng==5) b=bgn;
		if(putc(b,outf)==EOF) goto outerr;
	}
	if(ferror(inpf)) goto inperr; fclose(inpf);
	rsz=rsz*1024-1; bgn=-1U;

	/* ask for file name and description */
nxtrom:	if(tty) printf("Enter ROM image name (CR to exit): ");
	if(readln(ifn,sizeof(ifn))<=0) goto finish;
	if((inpf=fopen(ifn,"rb"))==NULL) goto inperr;
	if(tty) printf("Enter ROM description: ");
	if(readln(des,sizeof(des))<=0) goto finish;

	/* put description of next ROM image */
	bgn=lng; if(putw(0,outf)==EOF) goto outerr; lng+=2;
	for(b=0; des[b]!=0; rcs-=des[b++],lng++)
		if(fputc(des[b],outf)==EOF) goto outerr;
	if(fputc(0,outf)==EOF) goto outerr; lng++; lch=-1;

nxtrp:	pbo=lng; mcn=cnt=0; if(putw(0,outf)==EOF) goto outerr; lng+=2;
	while((b=getc(inpf))!=EOF) if(b==lch) mcn++; else {
		if(mcn)	if(flushpacked(0)<0) goto outerr;
			else if(mcn) { ungetc(b,inpf); goto nxtrp; }
		if(putc(lch=b,outf)==EOF) goto outerr;
		rcs-=b; cnt++; lng++;
	}
	if(flushpacked(1)<0) goto outerr; fclose(inpf);
	if(mcn!=0) { if(putw(0,outf)==EOF) goto outerr; lng+=2; } lng++;
	fseek(outf,bgn,SEEK_SET); if(putw(lng,outf)==EOF) goto outerr;
	fseek(outf,lng-1,SEEK_SET); rcs-=2*lng+((byte*)&lng)[1];
	if(fputc(rcs,outf)==EOF) goto outerr; rcs=lng; goto nxtrom;

finish:	for(lng--; lng<rsz; lng++) if(fputc(-1,outf)==EOF) goto outerr;
	fclose(outf); printf("%s ready...\n",multirom); return 0;
inperr:	perror(ifn); fclose(outf); return -1;
outerr:	perror(multirom); return -1;
}
