(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15159,        448]
NotebookOptionsPosition[     11815,        381]
NotebookOutlinePosition[     12150,        396]
CellTagsIndexPosition[     12107,        393]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "15", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Clear", "[", "A", "]"}]}]], "Input",
 CellChangeTimes->{{3.847861944763254*^9, 3.847861948680542*^9}, {
  3.8478630948675528`*^9, 3.847863099258327*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"9dc8d33a-5562-46e5-92d6-64fa943e457a"],

Cell[BoxData[
 RowBox[{"Clear", "[", "InvA", "]"}]], "Input",
 CellChangeTimes->{{3.847861951873171*^9, 3.847861956272375*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"1411faf7-5ccb-4494-9fae-04b31b0c21d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "fi", "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "fi", "]"}], ",", 
      RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.847861959672325*^9, 3.8478619687609873`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"31ef89f0-2315-4252-8f92-cc6d739bcbec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "fi", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "fi", "]"}], ",", 
     RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847861969906941*^9, 3.847863106964899*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"243beea0-b146-4a59-baa4-e060e5311862"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvA", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Inverse", "[", "A", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8478619743667*^9, 3.847861981112624*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"c704169f-76c1-4245-994d-149cfd295bf1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "fi", "]"}], ",", 
     RowBox[{"Sin", "[", "fi", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", "fi", "]"}]}], ",", 
     RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847861981683526*^9, 3.847863108959097*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"5298f979-83d4-40b2-92c6-a2e5c37a25f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"A", ".", "InvA"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.847861989831211*^9, 3.8478619994158688`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"e879470b-1c38-4df1-80e4-803ba0f6537d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.847862000120365*^9, 3.847863112019346*^9},
 CellLabel->
  "Out[83]//MatrixForm=",ExpressionUUID->"7587e038-1307-4959-b5ac-\
f6963b8503a4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "16", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Clear", "[", "B", "]"}]}]], "Input",
 CellChangeTimes->{{3.847862921385697*^9, 3.847862924257429*^9}, {
  3.847863124963138*^9, 3.847863128177926*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"0bf38930-59eb-466b-acfe-6178ced32e88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.847862925891245*^9, 3.847862932250107*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"5308fc4e-367b-43e1-a18b-c6966b97f999"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847862933636384*^9, 3.84786313071977*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"8b3f7e82-5700-4484-b43e-ad4e91cbb303"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "B", "]"}]], "Input",
 CellChangeTimes->{{3.8478629356583767`*^9, 3.847862940729686*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"ef927534-84cf-4bdb-bfbd-b6bdf024ea4f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", "3", "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"Log", "[", "4", "]"}]}], ",", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847862941227171*^9, 3.84786313228234*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"04457c5c-55df-4cc3-95c3-7317d2283753"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.847862949970351*^9, 3.847862954818169*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"71df58d9-977b-4302-9510-9dcc51a60a96"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"Log", "[", "3", "]"}], "0"},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
       RowBox[{"Log", "[", "4", "]"}]}], 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.847862955280054*^9, 3.847863134808033*^9},
 CellLabel->
  "Out[87]//MatrixForm=",ExpressionUUID->"f838ddee-cc85-4a33-b99f-\
e3fd3f529896"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"MatrixFunction", "[", 
   RowBox[{"Log", ",", "B"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.847862964089737*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"cea125f2-f250-4431-b10b-0acbe1a0dbab"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "1"},
     {
      RowBox[{"-", "4"}], 
      RowBox[{"-", "2"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.847862964548141*^9, 3.8478631362194138`*^9},
 CellLabel->
  "Out[88]//MatrixForm=",ExpressionUUID->"4e5f8fb7-0ae9-460d-9ff9-\
7853ac14a261"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixLog", "[", "B", "]"}]], "Input",
 CellChangeTimes->{{3.847863021850607*^9, 3.847863027321643*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"1e54d27a-4921-414f-aed1-bfa897f82f94"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8478630277720613`*^9, 3.8478631380984287`*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"52035e9a-2f2e-4a5f-b112-10342fb8df26"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "17", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "M", "]"}], "\[IndentingNewLine]", 
   RowBox[{"M", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8478632341476097`*^9, 3.847863274282098*^9}, {
  3.847863333966607*^9, 3.847863342154106*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"be5b8b45-3edf-46f6-b28c-709bad3e0889"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847863277923321*^9, 3.847863342759191*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"9e7d47af-3d49-4680-859f-702971f8f118"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "M", "]"}]], "Input",
 CellChangeTimes->{{3.8478632909872513`*^9, 3.847863294330127*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"d776f7ed-17b9-4496-b33c-3da8f0410a24"],

Cell[BoxData["9"], "Output",
 CellChangeTimes->{3.847863295629094*^9, 3.847863345803392*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"e2f53b56-ada1-4bd1-b50b-f8a098ee7320"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Eigenvalues", "[", "M", "]"}]}]], "Input",
 CellChangeTimes->{{3.8478633525868683`*^9, 3.84786336007421*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"43d25842-dda5-4cae-88e8-156c33e613d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.847863360676532*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"ea4bb0c8-e5e1-4ce9-b62b-3bb46d204392"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Eigenvectors", "[", "M", "]"}]}]], "Input",
 CellChangeTimes->{{3.847863364002941*^9, 3.847863372762424*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"65070677-b296-4818-9527-2e677c5a5a42"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847863373272781*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"b6028f84-055e-4e8d-83ad-a110de12a5eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"M", ".", 
   RowBox[{"v", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", 
   RowBox[{"v", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.84786338872246*^9, 3.8478634053624067`*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"fa6b69e3-1fb8-40c8-85b0-e1cfe2855c79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.847863406772167*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"da574954-a360-4d81-a562-93f41ec7f6b2"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 313}, {Automatic, 60}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 321, 6, 55, "Input",ExpressionUUID->"9dc8d33a-5562-46e5-92d6-64fa943e457a"],
Cell[882, 28, 206, 3, 31, "Input",ExpressionUUID->"1411faf7-5ccb-4494-9fae-04b31b0c21d2"],
Cell[CellGroupData[{
Cell[1113, 35, 508, 14, 31, "Input",ExpressionUUID->"31ef89f0-2315-4252-8f92-cc6d739bcbec"],
Cell[1624, 51, 472, 13, 35, "Output",ExpressionUUID->"243beea0-b146-4a59-baa4-e060e5311862"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2133, 69, 265, 5, 31, "Input",ExpressionUUID->"c704169f-76c1-4245-994d-149cfd295bf1"],
Cell[2401, 76, 472, 13, 35, "Output",ExpressionUUID->"5298f979-83d4-40b2-92c6-a2e5c37a25f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2910, 94, 272, 5, 31, "Input",ExpressionUUID->"e879470b-1c38-4df1-80e4-803ba0f6537d"],
Cell[3185, 101, 642, 19, 65, "Output",ExpressionUUID->"7587e038-1307-4959-b5ac-f6963b8503a4"]
}, Open  ]],
Cell[3842, 123, 319, 6, 55, "Input",ExpressionUUID->"0bf38930-59eb-466b-acfe-6178ced32e88"],
Cell[CellGroupData[{
Cell[4186, 133, 387, 11, 31, "Input",ExpressionUUID->"5308fc4e-367b-43e1-a18b-c6966b97f999"],
Cell[4576, 146, 355, 10, 35, "Output",ExpressionUUID->"8b3f7e82-5700-4484-b43e-ad4e91cbb303"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4968, 161, 203, 3, 31, "Input",ExpressionUUID->"ef927534-84cf-4bdb-bfbd-b6bdf024ea4f"],
Cell[5174, 166, 491, 13, 35, "Output",ExpressionUUID->"04457c5c-55df-4cc3-95c3-7317d2283753"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5702, 184, 204, 3, 31, "Input",ExpressionUUID->"71df58d9-977b-4302-9510-9dcc51a60a96"],
Cell[5909, 189, 825, 24, 65, "Output",ExpressionUUID->"f838ddee-cc85-4a33-b99f-e3fd3f529896"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6771, 218, 251, 5, 31, "Input",ExpressionUUID->"cea125f2-f250-4431-b10b-0acbe1a0dbab"],
Cell[7025, 225, 688, 21, 65, "Output",ExpressionUUID->"4e5f8fb7-0ae9-460d-9ff9-7853ac14a261"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7750, 251, 207, 3, 31, "Input",ExpressionUUID->"1e54d27a-4921-414f-aed1-bfa897f82f94"],
Cell[7960, 256, 360, 10, 35, "Output",ExpressionUUID->"52035e9a-2f2e-4a5f-b112-10342fb8df26"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8357, 271, 739, 20, 78, "Input",ExpressionUUID->"be5b8b45-3edf-46f6-b28c-709bad3e0889"],
Cell[9099, 293, 487, 14, 35, "Output",ExpressionUUID->"9e7d47af-3d49-4680-859f-702971f8f118"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9623, 312, 203, 3, 31, "Input",ExpressionUUID->"d776f7ed-17b9-4496-b33c-3da8f0410a24"],
Cell[9829, 317, 171, 2, 35, "Output",ExpressionUUID->"e2f53b56-ada1-4bd1-b50b-f8a098ee7320"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10037, 324, 233, 4, 31, "Input",ExpressionUUID->"43d25842-dda5-4cae-88e8-156c33e613d6"],
Cell[10273, 330, 204, 4, 35, "Output",ExpressionUUID->"ea4bb0c8-e5e1-4ce9-b62b-3bb46d204392"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10514, 339, 233, 4, 31, "Input",ExpressionUUID->"65070677-b296-4818-9527-2e677c5a5a42"],
Cell[10750, 345, 402, 11, 35, "Output",ExpressionUUID->"b6028f84-055e-4e8d-83ad-a110de12a5eb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11189, 361, 403, 11, 31, "Input",ExpressionUUID->"fa6b69e3-1fb8-40c8-85b0-e1cfe2855c79"],
Cell[11595, 374, 204, 4, 68, "Output",ExpressionUUID->"da574954-a360-4d81-a562-93f41ec7f6b2"]
}, Open  ]]
}
]
*)

