(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15401,        450]
NotebookOptionsPosition[     12881,        400]
NotebookOutlinePosition[     13216,        415]
CellTagsIndexPosition[     13173,        412]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", "18", "*)"}]], "Input",
 CellChangeTimes->{{3.847871018395475*^9, 
  3.847871022147704*^9}},ExpressionUUID->"03dcd0ae-1811-49ef-88ea-\
3abf583cc0bf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w1", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"x", "-", "y", "+", 
   RowBox[{"2", "*", "z"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w2", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"x", "-", 
   RowBox[{"2", "*", "y"}], "-", "z"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w3", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"3", "*", "x"}], "-", "y", "+", 
   RowBox[{"5", "*", "z"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w4", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", "x"}], "+", 
   RowBox[{"2", "*", "y"}], "+", 
   RowBox[{"3", "*", "z"}]}]}]}], "Input",
 CellChangeTimes->{{3.84787059450806*^9, 3.847870665803134*^9}, {
  3.8478708184932528`*^9, 3.847870862227412*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"66093924-fa08-4b56-a96a-9e4e382c6dab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"w1", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "\[Equal]", "1"}], ",", " ", 
     
     RowBox[{
      RowBox[{"w2", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "\[Equal]", "2"}], ",", " ", 
     
     RowBox[{
      RowBox[{"w3", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "\[Equal]", "3"}], ",", " ", 
     
     RowBox[{
      RowBox[{"w4", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "\[Equal]", 
      RowBox[{"-", "4"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.84787067043542*^9, 3.8478707308198147`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"68792136-272a-4ae0-b354-ad3fce49b478"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["10", "7"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "7"]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["2", "7"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8478707315784683`*^9, 3.847870866174362*^9, 
  3.8478709510151873`*^9, 3.847871030407691*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"37ed2237-830c-4b3f-b973-7189f7d55e12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w1", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", 
  RowBox[{"%", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8478707616916647`*^9, 3.847870781459041*^9}, {
  3.847870900100829*^9, 3.847870917971332*^9}, {3.847870955780285*^9, 
  3.847870961542529*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"0b237545-025b-4b4f-90b1-0478d1e4a087"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.8478707820975*^9, 3.847870869251956*^9, {3.8478709006617527`*^9, 
   3.847870918359874*^9}, 3.847870956697256*^9, 3.847871033895012*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"e646a87e-49ed-4c7f-976b-c7dff207aa29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w2", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", 
  RowBox[{"%61", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847870968859419*^9, 3.8478709727872066`*^9}, {
  3.847871037133072*^9, 3.847871037579606*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"2b6cf027-1f90-4296-b616-5134274c9f71"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.847870969508143*^9, 3.84787097381258*^9}, 
   3.847871038122788*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"fa67b7bf-272a-4508-8919-a54ba9c57fdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w3", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", 
  RowBox[{"%61", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.84787098669164*^9, 3.847870990123351*^9}, {
  3.847871040468288*^9, 3.847871041707447*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"e3dbd8c5-7881-4d9f-916e-787a260cc930"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{{3.8478709873724203`*^9, 3.8478709908628798`*^9}, 
   3.847871042068494*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"81c83abf-919d-449e-8ca7-3058bf72581c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w4", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "/.", 
  RowBox[{"%61", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.84787098669164*^9, 3.8478709951229067`*^9}, {
  3.847871043676347*^9, 3.847871044299437*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"5e1e0570-d479-4ec9-b72a-817842098bcf"],

Cell[BoxData[
 RowBox[{"-", "4"}]], "Output",
 CellChangeTimes->{3.8478709954305763`*^9, 3.8478710446445227`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"dcf29577-39a1-4b5d-a226-94a878c7ce86"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "19", "*)"}]], "Input",
 CellChangeTimes->{{3.847871046785914*^9, 
  3.847871050883801*^9}},ExpressionUUID->"32b8606d-db4a-4ec5-9c9c-\
79e22ed9f67a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "u_"}], "]"}], ":=", 
  RowBox[{"x", "-", "y", "+", 
   RowBox[{"5", " ", "z"}], "-", "u"}]}]], "Input",
 CellChangeTimes->{{3.847871002635846*^9, 3.847871002818925*^9}, {
  3.8478710592010937`*^9, 3.847871089275309*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"1732a645-b3c8-4999-87f6-cbeb31a75d28"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "u_"}], "]"}], ":=", 
  RowBox[{"x", "+", "y", "-", 
   RowBox[{"2", " ", "z"}], "+", 
   RowBox[{"3", " ", "u"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "u_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"3", " ", "x"}], "-", "y", "+", 
   RowBox[{"8", " ", "z"}], "+", "u"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "u_"}], "]"}], ":=", 
  RowBox[{"x", "+", 
   RowBox[{"3", " ", "y"}], "-", 
   RowBox[{"9", " ", "z"}], " ", "+", 
   RowBox[{"7", " ", "u"}]}]}]}], "Input",
 CellChangeTimes->{{3.847871091306514*^9, 3.847871141811624*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"46b148ca-5fb1-48ff-94e9-246c3c61b8b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"p1", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "]"}], "\[Equal]", "0"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"p2", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "]"}], "\[Equal]", "0"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"p3", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "]"}], "\[Equal]", "0"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"p4", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "]"}], "\[Equal]", 
      "0"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.847871157515954*^9, 3.847871205363652*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"60491364-564e-4c7d-98af-5b180a53728c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "u"}], "-", 
      FractionBox[
       RowBox[{"3", " ", "z"}], "2"]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "u"}], "+", 
        RowBox[{"7", " ", "z"}]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.847871205937458*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"0f44c759-3666-45e3-94a1-f110f66b7766"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "20", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
      RowBox[{
       RowBox[{"w0", "^", "2"}], " ", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8478722179172897`*^9, 3.847872285252617*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"ea6ef1c8-3928-44e6-b90f-1f9991cd9bbe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      TemplateBox[{"1"},
       "C"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"w0", " ", "x"}], "]"}]}], "+", 
     RowBox[{
      TemplateBox[{"2"},
       "C"], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"w0", " ", "x"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.847872285692761*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"0c626e65-7ec9-47f3-8820-c126b7616508"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "w0", "]"}]], "Input",
 CellChangeTimes->{{3.847872567501384*^9, 3.847872617645363*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"7bc9a79b-e261-40f2-b0af-e093befd793a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "\[Beta]", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"\[Omega]0", "^", "2"}], " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "a"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", " ", 
   "y", ",", " ", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.847872633130826*^9, 3.847872695133559*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"619d0780-0237-41b3-8ef8-eb5bdc6127c6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "\[Beta]"}], "-", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["\[Beta]", "2"], "-", 
                SuperscriptBox["\[Omega]0", "2"]}]]}], ")"}]}]]}], " ", 
         "\[Beta]"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "\[Beta]"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["\[Beta]", "2"], "-", 
               SuperscriptBox["\[Omega]0", "2"]}]]}], ")"}]}]], " ", 
         "\[Beta]"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "\[Beta]"}], "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["\[Beta]", "2"], "-", 
               SuperscriptBox["\[Omega]0", "2"]}]]}], ")"}]}]], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["\[Beta]", "2"], "-", 
           SuperscriptBox["\[Omega]0", "2"]}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "\[Beta]"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["\[Beta]", "2"], "-", 
               SuperscriptBox["\[Omega]0", "2"]}]]}], ")"}]}]], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["\[Beta]", "2"], "-", 
           SuperscriptBox["\[Omega]0", "2"]}]]}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], "-", 
         SuperscriptBox["\[Omega]0", "2"]}]]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8478726972754307`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"a746fc50-f054-4e10-a49f-b04f7149ac38"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{556, Automatic}, {81, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 178, 4, 31, "Input",ExpressionUUID->"03dcd0ae-1811-49ef-88ea-3abf583cc0bf"],
Cell[739, 26, 984, 27, 101, "Input",ExpressionUUID->"66093924-fa08-4b56-a96a-9e4e382c6dab"],
Cell[CellGroupData[{
Cell[1748, 57, 826, 24, 55, "Input",ExpressionUUID->"68792136-272a-4ae0-b354-ad3fce49b478"],
Cell[2577, 83, 511, 14, 52, "Output",ExpressionUUID->"37ed2237-830c-4b3f-b973-7189f7d55e12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3125, 102, 410, 9, 31, "Input",ExpressionUUID->"0b237545-025b-4b4f-90b1-0478d1e4a087"],
Cell[3538, 113, 268, 4, 35, "Output",ExpressionUUID->"e646a87e-49ed-4c7f-976b-c7dff207aa29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3843, 122, 363, 8, 31, "Input",ExpressionUUID->"2b6cf027-1f90-4296-b616-5134274c9f71"],
Cell[4209, 132, 198, 3, 35, "Output",ExpressionUUID->"fa67b7bf-272a-4508-8919-a54ba9c57fdb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4444, 140, 360, 8, 31, "Input",ExpressionUUID->"e3dbd8c5-7881-4d9f-916e-787a260cc930"],
Cell[4807, 150, 203, 3, 35, "Output",ExpressionUUID->"81c83abf-919d-449e-8ca7-3058bf72581c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5047, 158, 362, 8, 31, "Input",ExpressionUUID->"5e1e0570-d479-4ec9-b72a-817842098bcf"],
Cell[5412, 168, 192, 3, 35, "Output",ExpressionUUID->"dcf29577-39a1-4b5d-a226-94a878c7ce86"]
}, Open  ]],
Cell[5619, 174, 178, 4, 31, "Input",ExpressionUUID->"32b8606d-db4a-4ec5-9c9c-79e22ed9f67a"],
Cell[5800, 180, 390, 8, 31, "Input",ExpressionUUID->"1732a645-b3c8-4999-87f6-cbeb31a75d28"],
Cell[6193, 190, 832, 21, 78, "Input",ExpressionUUID->"46b148ca-5fb1-48ff-94e9-246c3c61b8b0"],
Cell[CellGroupData[{
Cell[7050, 215, 845, 24, 55, "Input",ExpressionUUID->"60491364-564e-4c7d-98af-5b180a53728c"],
Cell[7898, 241, 570, 18, 52, "Output",ExpressionUUID->"0f44c759-3666-45e3-94a1-f110f66b7766"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8505, 264, 550, 14, 55, "Input",ExpressionUUID->"ea6ef1c8-3928-44e6-b90f-1f9991cd9bbe"],
Cell[9058, 280, 525, 17, 35, "Output",ExpressionUUID->"0c626e65-7ec9-47f3-8820-c126b7616508"]
}, Open  ]],
Cell[9598, 300, 204, 3, 31, "Input",ExpressionUUID->"7bc9a79b-e261-40f2-b0af-e093befd793a"],
Cell[CellGroupData[{
Cell[9827, 307, 791, 22, 31, "Input",ExpressionUUID->"619d0780-0237-41b3-8ef8-eb5bdc6127c6"],
Cell[10621, 331, 2244, 66, 174, "Output",ExpressionUUID->"a746fc50-f054-4e10-a49f-b04f7149ac38"]
}, Open  ]]
}
]
*)

