(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     47250,       1389]
NotebookOptionsPosition[     37859,       1217]
NotebookOutlinePosition[     38275,       1233]
CellTagsIndexPosition[     38232,       1230]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "1", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"N", "[", 
   RowBox[{"E", ",", "100"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847793909889982*^9, 3.8477939211518927`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"66d813ae-3a52-44af-a9f0-ebfde7f79afc"],

Cell[BoxData["2.\
718281828459045235360287471352662497757247093699959574966967627724076630353547\
5945713821785251664274274661651602106`100."], "Output",
 CellChangeTimes->{3.8477939219458523`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"65b5532f-aec6-43ba-bc51-894e48ccd015"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "2", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Sin", "[", 
   RowBox[{"Log", "[", 
    RowBox[{"-", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847793925553587*^9, 3.8477939561599827`*^9}, {
  3.8477940711537333`*^9, 3.847794091024653*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"b79a8239-ec85-4867-a393-ff8c8897280c"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Sinh", "[", "\[Pi]", "]"}]}]], "Output",
 CellChangeTimes->{
  3.847793956946241*^9, {3.84779407697254*^9, 3.847794091987512*^9}},
 CellLabel->"Out[6]=",ExpressionUUID->"1d1a5393-000a-410e-a6e4-89ca9e10068d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.84779410414465*^9, 3.8477941100481586`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"5198371d-92f6-4f51-a399-c82565a64d6a"],

Cell[BoxData[
 RowBox[{"0.`", "\[VeryThinSpace]", "+", 
  RowBox[{"11.548739357257748`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.847794110772265*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"0a02a8ab-731e-4d81-83fa-3b3e48acb0dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "3", "*)"}], "\[IndentingNewLine]", 
  RadicalBox["Pi", "4"]}]], "Input",
 CellChangeTimes->{{3.847793962056425*^9, 3.847793966199841*^9}, {
  3.847794050199148*^9, 3.847794056367796*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"82802dbd-ef49-4a21-b8b7-b215ae418b5a"],

Cell[BoxData[
 SuperscriptBox["\[Pi]", 
  RowBox[{"1", "/", "4"}]]], "Output",
 CellChangeTimes->{3.847794057426401*^9, 3.847794128487091*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"99fd4609-8a9b-4089-88a9-cf51fdaa3638"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.847794118001665*^9, 3.847794120775975*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"d28b6fcd-54f7-4e9e-94e1-ae555db3bbc2"],

Cell[BoxData["1.3313353638003897`"], "Output",
 CellChangeTimes->{3.8477941383891573`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"794d7323-190b-40d2-ad95-57bebc8f04e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "4", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], "^", "7"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847794709152677*^9, 3.847794743120504*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"b425bdf7-008f-4b9f-9f14-f6a3f967f9f9"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "7"], "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["a", "6"], " ", "b"}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "2"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "3"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "4"]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "5"]}], "+", 
  RowBox[{"7", " ", "a", " ", 
   SuperscriptBox["b", "6"]}], "+", 
  SuperscriptBox["b", "7"], "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["a", "6"], " ", "c"}], "+", 
  RowBox[{"42", " ", 
   SuperscriptBox["a", "5"], " ", "b", " ", "c"}], "+", 
  RowBox[{"105", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "2"], " ", "c"}], "+", 
  RowBox[{"140", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "3"], " ", "c"}], "+", 
  RowBox[{"105", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "4"], " ", "c"}], "+", 
  RowBox[{"42", " ", "a", " ", 
   SuperscriptBox["b", "5"], " ", "c"}], "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["b", "6"], " ", "c"}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"105", " ", 
   SuperscriptBox["a", "4"], " ", "b", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"105", " ", "a", " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"140", " ", 
   SuperscriptBox["a", "3"], " ", "b", " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"140", " ", "a", " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["c", "4"]}], "+", 
  RowBox[{"105", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", 
   SuperscriptBox["c", "4"]}], "+", 
  RowBox[{"105", " ", "a", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "4"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "4"]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "5"]}], "+", 
  RowBox[{"42", " ", "a", " ", "b", " ", 
   SuperscriptBox["c", "5"]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "5"]}], "+", 
  RowBox[{"7", " ", "a", " ", 
   SuperscriptBox["c", "6"]}], "+", 
  RowBox[{"7", " ", "b", " ", 
   SuperscriptBox["c", "6"]}], "+", 
  SuperscriptBox["c", "7"]}]], "Output",
 CellChangeTimes->{3.847794743817656*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"8f27921d-f2d7-4854-bce9-5f7d6c3e83b0"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.847794131792739*^9, 
  3.847794134040016*^9}},ExpressionUUID->"6b50c3c0-c574-4e26-8f83-\
2f06fc897ddf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "5", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"2", "*", "x"}], "+", 
    RowBox[{"4", "*", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"3", "*", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"3", "*", 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"3", "*", 
     RowBox[{"x", "^", "7"}]}], "+", 
    RowBox[{"x", "^", "9"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847794855793495*^9, 3.847794929360674*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"31eb0b2d-8ec1-4eed-b764-02f934906dd7"],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "6"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.847794930704452*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"3c640796-6d51-4999-a1c5-6241f342a1e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "6", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "+", 
   RowBox[{"6", "*", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"11", "*", "x"}], "+", "6"}]}]], "Input",
 CellChangeTimes->{{3.847795225104987*^9, 3.847795228777158*^9}, 
   3.847795316896934*^9, {3.847795351458116*^9, 3.847795436025281*^9}, {
   3.847795474282423*^9, 3.847795497624866*^9}, {3.847795813210306*^9, 
   3.847795819409968*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"613180bf-c9d2-4427-86df-e6c5dd67c9ea"],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"11", " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 CellChangeTimes->{
  3.847795437019466*^9, {3.847795478796424*^9, 3.847795498480022*^9}, 
   3.847795822274514*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"2d7f59c5-a9b8-49a8-a34a-9c66a0b1d247"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.847795482993787*^9, 3.847795503417345*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"db820f18-cd01-4cb4-b435-88c3e3273ffe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.84779550394311*^9, 3.847795825797879*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"726ed6b9-a208-4d9c-b8d8-0ad03572b1da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%36", " ", "/.", " ", 
  RowBox[{"%37", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8477955074293118`*^9, 3.847795537769075*^9}, {
  3.847795833954661*^9, 3.8477958384256773`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"1d39f994-cc89-434c-97cc-4de223527091"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.847795538996372*^9, 3.847795838773973*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"6fab9044-28d3-4dc3-ac4f-0cc68f237bcc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%36", "/.", " ", 
  RowBox[{"%37", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8477955074293118`*^9, 3.847795544344894*^9}, {
  3.8477958418023376`*^9, 3.8477958453454514`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"0eb8a514-1d11-4a00-a91d-a3d792cb4b67"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.847795544828288*^9, 3.847795845695202*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"18e4debb-c348-4624-90cd-11e6925bcbc4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%36", " ", "/.", " ", 
  RowBox[{"%37", "[", 
   RowBox[{"[", "3", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8477955074293118`*^9, 3.847795551922658*^9}, {
  3.847795847739826*^9, 3.847795850633786*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"42df0d22-50d8-43c1-a5e9-ac87a0e7a0a8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.847795552228389*^9, 3.847795850875407*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"600136b7-e6ae-4421-aa7c-ab0f942ca3a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "7", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"%", "\[Equal]", "0"}], ",", " ", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.847795853443276*^9, 3.847795917529875*^9}, {
  3.8477959503477993`*^9, 3.847795951193762*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"74dc1395-0d08-45e8-a00a-583d47143bc9"],

Cell[BoxData[
 RowBox[{"c", "+", 
  RowBox[{"b", " ", "x"}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 CellChangeTimes->{{3.847795893085968*^9, 3.847795902861816*^9}, 
   3.847795953132278*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"60bbf213-7bb0-4034-8bbe-e9d7a6f870b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.847795893085968*^9, 3.847795902861816*^9}, 
   3.8477959531335983`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"f51f118e-b86b-4f50-97d9-7ce2f53539bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%53", " ", "/.", " ", 
   RowBox[{"%54", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8477960184261227`*^9, 3.847796042401464*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"2e2a28f0-9654-4441-b3a0-cef63acf6ca0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.8477960299058113`*^9, 3.847796043036089*^9}},
 CellLabel->"Out[58]=",ExpressionUUID->"2cbf8c95-b555-41a2-9593-325e1be1c1fa"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "8", "*)"}]], "Input",
 CellChangeTimes->{{3.847796336475156*^9, 
  3.847796339810339*^9}},ExpressionUUID->"45070695-2b77-4d04-9227-\
e5e8e1813190"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.847796346051375*^9, 3.847796386922386*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"45ae8513-ed9a-4936-bcd1-88c839c37e2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 24]}, 0, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.847796388410492*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"e34d6a1c-7c83-4dc4-834a-07a826a63d5b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%59", "]"}]], "Input",
 CellChangeTimes->{{3.847796507786653*^9, 3.847796517234496*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"8973e92f-49f4-4f97-a2fc-28abbcca8f51"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "24"]}]], "Output",
 CellChangeTimes->{3.847796517805633*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"95e4b214-7160-4096-9662-fc71a98abc62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", "x", "]"}], "]"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8477965248345213`*^9, 3.84779652824223*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"402369c4-3199-4d9f-a844-c9a78fadc9ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "6"]}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}], "-", 
  RowBox[{
   FractionBox["1", "30"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "5"]}], "+", "x"}]], "Output",
 CellChangeTimes->{3.847796528764358*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"94c60b19-68cb-4e41-94cb-0bc818dd6a28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", "x", "]"}], "]"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8477965248345213`*^9, 3.84779652824223*^9}, {
  3.847796573002864*^9, 3.847796577650592*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"297dcd9c-a4dc-4d4c-aa6f-0bd9218a4d33"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"Sin", "[", 
    RowBox[{"Log", "[", "2", "]"}], "]"}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Sin", "[", 
     RowBox[{"Log", "[", "2", "]"}], "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"Log", "[", "2", "]"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Sin", "[", 
     RowBox[{"Log", "[", "2", "]"}], "]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"Log", "[", "2", "]"}], "]"}], "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}], "2"], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", "2", "]"}], "]"}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "48"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Sin", "[", 
     RowBox[{"Log", "[", "2", "]"}], "]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "x"}], ")"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], "2"]}], "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}], "3"], "-", 
     RowBox[{"3", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "384"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Sin", "[", 
     RowBox[{"Log", "[", "2", "]"}], "]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "x"}], ")"}], "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], "2"]}], "-", 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], "3"]}], "+", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}], "4"], "-", 
     RowBox[{"10", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}]}], "+", 
     RowBox[{"18", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}]}], "-", 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], "2"], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", "2", "]"}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "3840"], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", "2", "]"}], "]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "x"}], ")"}], "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "10"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "2"]}], "+", 
      RowBox[{"25", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "3"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], "5"], "+", 
      RowBox[{"40", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}]}], "-", 
      RowBox[{"90", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}]}], "+", 
      RowBox[{"60", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "2"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "3"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}]}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "2"]}], "+", 
      RowBox[{"15", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"Log", "[", "2", "]"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}], "2"]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.847796578577055*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"bc66049f-2128-4d0f-8e9e-470fa9602787"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "9", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Sum", "[", 
   RowBox[{"i", ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "100"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847797059452908*^9, 3.847797107995317*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"79e9a555-3d4d-43f8-bb34-63d9f6e6d960"],

Cell[BoxData["5050"], "Output",
 CellChangeTimes->{3.847797108486446*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"0d3e28bd-7b16-49f2-be36-134655134b37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "*", 
      RowBox[{"(", 
       RowBox[{"i", "+", "1"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"i", "+", "2"}], ")"}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8477971521886873`*^9, 3.8477971918675623`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"e87b234b-7762-47f2-b606-178325ed149c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "-", 
  FractionBox["1", 
   RowBox[{"2", "+", "n"}]]}]], "Output",
 CellChangeTimes->{
  3.8477971342073402`*^9, {3.847797172734975*^9, 3.847797192457761*^9}},
 CellLabel->"Out[69]=",ExpressionUUID->"01043abc-c2dc-4514-a985-6e0049e33ec4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.847797195019889*^9, 3.847797199315036*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"fa39e503-c505-4cf4-bf47-0be787cde9ce"],

Cell[BoxData[
 FractionBox["n", 
  RowBox[{"4", "+", 
   RowBox[{"2", " ", "n"}]}]]], "Output",
 CellChangeTimes->{3.847797199673976*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"2e73c3eb-6883-4feb-ab07-c2b3d78f3705"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "10", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RadicalBox[
      RowBox[{
       RowBox[{"n", "^", "100"}], "+", 
       RowBox[{"n", "^", "99"}]}], "100"], "-", "n"}], ",", " ", 
    RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.847797538740918*^9, 3.847797637044002*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"ac9d9c5b-fd4c-4d8d-84de-e4a4e70224e3"],

Cell[BoxData[
 FractionBox["1", "100"]], "Output",
 CellChangeTimes->{3.8477976375941772`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"10debc58-8b3c-4020-a45a-f087c76df1a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"i", "^", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], 
    RowBox[{"n", "^", "6"}]], " ", ",", 
   RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.847797660299614*^9, 3.8477977597506847`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"e362c9e4-514b-416b-8933-2f3b15f1fe62"],

Cell[BoxData[
 FractionBox["1", "6"]], "Output",
 CellChangeTimes->{{3.847797756456152*^9, 3.847797760203784*^9}},
 CellLabel->"Out[73]=",ExpressionUUID->"d9e63f22-e653-4c6d-ae45-96b0f0a2da04"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "11", "*)"}]], "Input",
 CellChangeTimes->{{3.847856015235429*^9, 
  3.847856018753769*^9}},ExpressionUUID->"15e98c99-d31a-450a-bfba-\
55d66a90d0eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "5"}]}], "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", "1"}], ")"}], " ", 
     RowBox[{"x", "^", "3"}]}], " ", "+", 
    RowBox[{"7", " ", "x"}], " ", "+", "1"}], ",", " ", "x"}], "]"}]], "Input",\

 CellChangeTimes->{{3.847854347207662*^9, 3.847854381287973*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"aaec071e-c7ac-4cda-960f-90e845b7590c"],

Cell[BoxData[
 RowBox[{"7", "+", 
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "b"}], ")"}], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"5", " ", "a", " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 CellChangeTimes->{3.847854381820047*^9, 3.847856021849317*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"4fad6b79-d138-43d3-ad59-3907195436cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "3"}], " ", "a", " ", 
      RowBox[{"x", "^", "3"}]}], "]"}]}], ",", " ", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.847854672480857*^9, 3.847854717367559*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"c0df6164-9e64-4e42-a931-b34c33e1eefe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "3"}], " ", "a", " ", 
     SuperscriptBox["x", "3"]}]], " ", "x"}], "-", 
  RowBox[{"9", " ", "a", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "3"}], " ", "a", " ", 
     SuperscriptBox["x", "3"]}]], " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 CellChangeTimes->{3.8478547177413273`*^9, 3.847856025638281*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"13db01e9-01c5-4d68-a3bf-8e7ebb925c57"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "12", "*)"}]], "Input",
 CellChangeTimes->{{3.847856033154436*^9, 
  3.847856044657586*^9}},ExpressionUUID->"381d6d37-4088-4c94-b27a-\
b6b637a0b934"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", "*", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.847855014737913*^9, 3.8478550402883997`*^9}, {
  3.847855269345715*^9, 3.847855269939756*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"0250ce60-10ec-42b9-b1f1-0e8d040229cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.847855409185464*^9, 3.8478554621231833`*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"57af8bc8-ccf7-4cf3-b320-1e06258dab51"],

Cell[BoxData[
 RowBox[{
  RowBox[{"23040", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}], "-", 
  RowBox[{"1024", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}], "-", 
  RowBox[{"10240", " ", "x", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.8478554631339893`*^9, 3.8478560510187187`*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"16038ccb-0cec-45ac-af33-2b17d75aac35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "/.", " ", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellChangeTimes->{{3.8478554935380383`*^9, 3.8478555026013527`*^9}, {
  3.847855603993827*^9, 3.847855616705048*^9}, {3.847856055618607*^9, 
  3.847856055801631*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"0a2e02be-76dc-457a-97f3-486ca88c1efe"],

Cell[BoxData["23040"], "Output",
 CellChangeTimes->{{3.847855612842902*^9, 3.847855617225531*^9}, 
   3.847856057203471*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"27191827-3df8-417b-8482-8c5e3aa39b71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "10"}], "}"}]}], "]"}], " ", "/.", " ", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.847855734841393*^9, 3.84785574826517*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"f7ce5577-fe80-4238-904a-84bafd176eb5"],

Cell[BoxData["23040"], "Output",
 CellChangeTimes->{{3.847855736199375*^9, 3.847855748796666*^9}, 
   3.847856061362225*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"de55b68f-a345-4992-9d61-77ace926bccb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "13", "*)"}]], "Input",
 CellChangeTimes->{{3.847856066546762*^9, 
  3.8478560682095947`*^9}},ExpressionUUID->"eaba5276-75ae-4911-9e85-\
8fc218514fdd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", " ", "x"}], " ", "+", "3"}], ")"}], "*", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", " ", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.847855892417637*^9, 3.847855896457659*^9}, {
  3.8478559270572233`*^9, 3.8478559455295258`*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"8f419dc4-447f-4a4b-9f13-8f7010ea510c"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"7", "-", 
    RowBox[{"4", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.847855946717587*^9, 3.8478560712023487`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"d86e746a-9668-4c56-9258-8419b5a9befa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.84785594961016*^9, 3.847855955897831*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"ec923b5a-2cec-437c-9354-e97921a8a6f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     RowBox[{"2", " ", "x"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{"7", "-", 
     RowBox[{"4", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.847855956841687*^9, 3.847856074080409*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"b5e1ae47-aaa6-48be-82e5-0a4d02eb24d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%117", "]"}]], "Input",
 CellChangeTimes->{{3.8478559678342133`*^9, 3.8478559893133793`*^9}, {
  3.847856082026539*^9, 3.847856083042191*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"08d3e996-b392-4cdd-944f-5149527be6e1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.8478559899231653`*^9, {3.847856076314546*^9, 3.847856083750787*^9}},
 CellLabel->
  "Out[119]=",ExpressionUUID->"fba143f7-8d2b-4d12-844d-859056574673"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Log", "[", "x", "]"}], ")"}], "^", "2"}]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.847856127559083*^9, 3.847856160865738*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"0b76bd03-cdbe-4d08-8e42-96569db82756"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "27"], " ", 
  SuperscriptBox["x", 
   RowBox[{"3", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{"8", "-", 
    RowBox[{"12", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8478561617033253`*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"ca616deb-bcd2-42d2-9120-abea44c87917"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.847856165602481*^9, 3.8478561784976063`*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"4f0751d5-ae75-4823-b9a2-b895b14d7c4d"],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], " ", 
  SuperscriptBox[
   RowBox[{"Log", "[", "x", "]"}], "2"]}]], "Output",
 CellChangeTimes->{3.847856179112039*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"86a31fc2-bab4-4ad1-853e-6cad467ef0c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"x", "^", "3"}], " ", "+", "1"}]], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.847856228954051*^9, 3.84785626960989*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"4450c0fb-8bf1-44b2-9273-9d90f7ccf256"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   SqrtBox["3"]], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.847856274669739*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"b9425a9f-a4eb-4a74-898b-4c6f499a533c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.847856278130231*^9, 3.84785628628335*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"e1f68880-34f1-4922-901a-b8c021a8edcd"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "3"]}]]], "Output",
 CellChangeTimes->{3.847856286899757*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"1662b69b-6b22-4404-954e-161dc139ca54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "14", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", "x", "]"}], "]"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.84785689595397*^9, 3.847856936962735*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"e0e7e85e-b803-45d2-a0b1-e75fc534a2d1"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "1", "2"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Sin", "[", 
     RowBox[{"Log", "[", "x", "]"}], "]"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.847856940708271*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"74e610f4-45e5-4d31-905d-d071c3e17db3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.847856957739523*^9, 3.847856959883045*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"1128d154-9024-496f-b9be-9a4eeafeb45b"],

Cell[BoxData["1.4711450951602507`"], "Output",
 CellChangeTimes->{3.847856960441059*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"7c608861-987d-47ca-bb5b-539296a1d606"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "*", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8478571872594357`*^9, 3.847857261179068*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"ff239172-fc5f-4283-9509-e3bb2891afc6"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.847857262226473*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"43f01a9a-a8d3-45d9-bfad-6c2dfa72c581"]
}, Open  ]]
},
WindowSize->{808.6153846153846, 667.7802197802198},
WindowMargins->{{Automatic, 0}, {0, Automatic}},
FrontEndVersion->"13.1 for Linux x86 (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c3b84dfa-da8e-4043-9780-2dff364560fb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 292, 6, 51, "Input",ExpressionUUID->"66d813ae-3a52-44af-a9f0-ebfde7f79afc"],
Cell[875, 30, 275, 4, 55, "Output",ExpressionUUID->"65b5532f-aec6-43ba-bc51-894e48ccd015"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1187, 39, 370, 8, 51, "Input",ExpressionUUID->"b79a8239-ec85-4867-a393-ff8c8897280c"],
Cell[1560, 49, 265, 5, 36, "Output",ExpressionUUID->"1d1a5393-000a-410e-a6e4-89ca9e10068d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1862, 59, 199, 3, 29, "Input",ExpressionUUID->"5198371d-92f6-4f51-a399-c82565a64d6a"],
Cell[2064, 64, 245, 4, 36, "Output",ExpressionUUID->"0a02a8ab-731e-4d81-83fa-3b3e48acb0dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2346, 73, 306, 6, 54, "Input",ExpressionUUID->"82802dbd-ef49-4a21-b8b7-b215ae418b5a"],
Cell[2655, 81, 220, 4, 33, "Output",ExpressionUUID->"99fd4609-8a9b-4089-88a9-cf51fdaa3638"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2912, 90, 199, 3, 29, "Input",ExpressionUUID->"d28b6fcd-54f7-4e9e-94e1-ae555db3bbc2"],
Cell[3114, 95, 169, 2, 33, "Output",ExpressionUUID->"794d7323-190b-40d2-ad95-57bebc8f04e3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3320, 102, 355, 8, 51, "Input",ExpressionUUID->"b425bdf7-008f-4b9f-9f14-f6a3f967f9f9"],
Cell[3678, 112, 3361, 99, 99, "Output",ExpressionUUID->"8f27921d-f2d7-4854-bce9-5f7d6c3e83b0"]
}, Open  ]],
Cell[7054, 214, 152, 3, 29, "Input",ExpressionUUID->"6b50c3c0-c574-4e26-8f83-2f06fc897ddf"],
Cell[CellGroupData[{
Cell[7231, 221, 649, 18, 51, "Input",ExpressionUUID->"31eb0b2d-8ec1-4eed-b764-02f934906dd7"],
Cell[7883, 241, 434, 12, 37, "Output",ExpressionUUID->"3c640796-6d51-4999-a1c5-6241f342a1e8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8354, 258, 550, 12, 51, "Input",ExpressionUUID->"613180bf-c9d2-4427-86df-e6c5dd67c9ea"],
Cell[8907, 272, 362, 9, 36, "Output",ExpressionUUID->"2d7f59c5-a9b8-49a8-a34a-9c66a0b1d247"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9306, 286, 257, 5, 29, "Input",ExpressionUUID->"db820f18-cd01-4cb4-b435-88c3e3273ffe"],
Cell[9566, 293, 453, 13, 33, "Output",ExpressionUUID->"726ed6b9-a208-4d9c-b8d8-0ad03572b1da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10056, 311, 314, 6, 32, "Input",ExpressionUUID->"1d39f994-cc89-434c-97cc-4de223527091"],
Cell[10373, 319, 171, 2, 33, "Output",ExpressionUUID->"6fab9044-28d3-4dc3-ac4f-0cc68f237bcc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10581, 326, 311, 6, 32, "Input",ExpressionUUID->"0eb8a514-1d11-4a00-a91d-a3d792cb4b67"],
Cell[10895, 334, 171, 2, 33, "Output",ExpressionUUID->"18e4debb-c348-4624-90cd-11e6925bcbc4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11103, 341, 312, 6, 32, "Input",ExpressionUUID->"42df0d22-50d8-43c1-a5e9-ac87a0e7a0a8"],
Cell[11418, 349, 171, 2, 33, "Output",ExpressionUUID->"600136b7-e6ae-4421-aa7c-ab0f942ca3a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11626, 356, 535, 13, 74, "Input",ExpressionUUID->"74dc1395-0d08-45e8-a00a-583d47143bc9"],
Cell[12164, 371, 302, 7, 36, "Output",ExpressionUUID->"60bbf213-7bb0-4034-8bbe-e9d7a6f870b6"],
Cell[12469, 380, 792, 25, 62, "Output",ExpressionUUID->"f51f118e-b86b-4f50-97d9-7ce2f53539bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13298, 410, 300, 6, 33, "Input",ExpressionUUID->"2e2a28f0-9654-4441-b3a0-cef63acf6ca0"],
Cell[13601, 418, 175, 2, 33, "Output",ExpressionUUID->"2cbf8c95-b555-41a2-9593-325e1be1c1fa"]
}, Open  ]],
Cell[13791, 423, 177, 4, 29, "Input",ExpressionUUID->"45070695-2b77-4d04-9227-e5e8e1813190"],
Cell[CellGroupData[{
Cell[13993, 431, 317, 7, 29, "Input",ExpressionUUID->"45ae8513-ed9a-4936-bcd1-88c839c37e2b"],
Cell[14313, 440, 575, 17, 50, "Output",ExpressionUUID->"e34d6a1c-7c83-4dc4-834a-07a826a63d5b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14925, 462, 206, 3, 29, "Input",ExpressionUUID->"8973e92f-49f4-4f97-a2fc-28abbcca8f51"],
Cell[15134, 467, 274, 7, 50, "Output",ExpressionUUID->"95e4b214-7160-4096-9662-fc71a98abc62"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15445, 479, 427, 10, 33, "Input",ExpressionUUID->"402369c4-3199-4d9f-a844-c9a78fadc9ec"],
Cell[15875, 491, 642, 22, 47, "Output",ExpressionUUID->"94c60b19-68cb-4e41-94cb-0bc818dd6a28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16554, 518, 476, 11, 33, "Input",ExpressionUUID->"297dcd9c-a4dc-4d4c-aa6f-0bd9218a4d33"],
Cell[17033, 531, 5497, 165, 243, "Output",ExpressionUUID->"bc66049f-2128-4d0f-8e9e-470fa9602787"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22567, 701, 354, 8, 53, "Input",ExpressionUUID->"79e9a555-3d4d-43f8-bb34-63d9f6e6d960"],
Cell[22924, 711, 152, 2, 33, "Output",ExpressionUUID->"0d3e28bd-7b16-49f2-be36-134655134b37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23113, 718, 497, 13, 33, "Input",ExpressionUUID->"e87b234b-7762-47f2-b606-178325ed149c"],
Cell[23613, 733, 288, 7, 47, "Output",ExpressionUUID->"01043abc-c2dc-4514-a985-6e0049e33ec4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23938, 745, 206, 3, 29, "Input",ExpressionUUID->"fa39e503-c505-4cf4-bf47-0be787cde9ce"],
Cell[24147, 750, 216, 5, 53, "Output",ExpressionUUID->"2e73c3eb-6883-4feb-ab07-c2b3d78f3705"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24400, 760, 476, 12, 59, "Input",ExpressionUUID->"ac9d9c5b-fd4c-4d8d-84de-e4a4e70224e3"],
Cell[24879, 774, 173, 3, 47, "Output",ExpressionUUID->"10debc58-8b3c-4020-a45a-f087c76df1a6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25089, 782, 470, 12, 45, "Input",ExpressionUUID->"e362c9e4-514b-416b-8933-2f3b15f1fe62"],
Cell[25562, 796, 193, 3, 47, "Output",ExpressionUUID->"d9e63f22-e653-4c6d-ae45-96b0f0a2da04"]
}, Open  ]],
Cell[25770, 802, 178, 4, 29, "Input",ExpressionUUID->"15e98c99-d31a-450a-bfba-55d66a90d0eb"],
Cell[CellGroupData[{
Cell[25973, 810, 472, 14, 33, "Input",ExpressionUUID->"aaec071e-c7ac-4cda-960f-90e845b7590c"],
Cell[26448, 826, 372, 10, 36, "Output",ExpressionUUID->"4fad6b79-d138-43d3-ad59-3907195436cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26857, 841, 397, 11, 33, "Input",ExpressionUUID->"c0df6164-9e64-4e42-a931-b34c33e1eefe"],
Cell[27257, 854, 544, 15, 37, "Output",ExpressionUUID->"13db01e9-01c5-4d68-a3bf-8e7ebb925c57"]
}, Open  ]],
Cell[27816, 872, 178, 4, 29, "Input",ExpressionUUID->"381d6d37-4088-4c94-b27a-b6b637a0b934"],
Cell[27997, 878, 382, 10, 32, "Input",ExpressionUUID->"0250ce60-10ec-42b9-b1f1-0e8d040229cb"],
Cell[CellGroupData[{
Cell[28404, 892, 307, 8, 29, "Input",ExpressionUUID->"57af8bc8-ccf7-4cf3-b320-1e06258dab51"],
Cell[28714, 902, 504, 14, 36, "Output",ExpressionUUID->"16038ccb-0cec-45ac-af33-2b17d75aac35"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29255, 921, 335, 7, 32, "Input",ExpressionUUID->"0a2e02be-76dc-457a-97f3-486ca88c1efe"],
Cell[29593, 930, 207, 4, 33, "Output",ExpressionUUID->"27191827-3df8-417b-8482-8c5e3aa39b71"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29837, 939, 371, 10, 32, "Input",ExpressionUUID->"f7ce5577-fe80-4238-904a-84bafd176eb5"],
Cell[30211, 951, 207, 4, 33, "Output",ExpressionUUID->"de55b68f-a345-4992-9d61-77ace926bccb"]
}, Open  ]],
Cell[30433, 958, 180, 4, 29, "Input",ExpressionUUID->"eaba5276-75ae-4911-9e85-8fc218514fdd"],
Cell[CellGroupData[{
Cell[30638, 966, 468, 12, 33, "Input",ExpressionUUID->"8f419dc4-447f-4a4b-9f13-8f7010ea510c"],
Cell[31109, 980, 345, 9, 37, "Output",ExpressionUUID->"d86e746a-9668-4c56-9258-8419b5a9befa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31491, 994, 225, 5, 29, "Input",ExpressionUUID->"ec923b5a-2cec-437c-9354-e97921a8a6f0"],
Cell[31719, 1001, 529, 16, 37, "Output",ExpressionUUID->"b5e1ae47-aaa6-48be-82e5-0a4d02eb24d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32285, 1022, 266, 5, 29, "Input",ExpressionUUID->"08d3e996-b392-4cdd-944f-5149527be6e1"],
Cell[32554, 1029, 372, 10, 38, "Output",ExpressionUUID->"fba143f7-8d2b-4d12-844d-859056574673"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32963, 1044, 384, 11, 31, "Input",ExpressionUUID->"0b76bd03-cdbe-4d08-8e42-96569db82756"],
Cell[33350, 1057, 459, 14, 52, "Output",ExpressionUUID->"ca616deb-bcd2-42d2-9120-abea44c87917"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33846, 1076, 264, 6, 31, "Input",ExpressionUUID->"4f0751d5-ae75-4823-b9a2-b895b14d7c4d"],
Cell[34113, 1084, 242, 7, 38, "Output",ExpressionUUID->"86a31fc2-bab4-4ad1-853e-6cad467ef0c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34392, 1096, 311, 8, 48, "Input",ExpressionUUID->"4450c0fb-8bf1-44b2-9273-9d90f7ccf256"],
Cell[34706, 1106, 605, 21, 70, "Output",ExpressionUUID->"b9425a9f-a4eb-4a74-898b-4c6f499a533c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35348, 1132, 261, 6, 31, "Input",ExpressionUUID->"e1f68880-34f1-4922-901a-b8c021a8edcd"],
Cell[35612, 1140, 221, 6, 53, "Output",ExpressionUUID->"1662b69b-6b22-4404-954e-161dc139ca54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35870, 1151, 466, 12, 55, "Input",ExpressionUUID->"e0e7e85e-b803-45d2-a0b1-e75fc534a2d1"],
Cell[36339, 1165, 368, 10, 52, "Output",ExpressionUUID->"74e610f4-45e5-4d31-905d-d071c3e17db3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36744, 1180, 203, 4, 31, "Input",ExpressionUUID->"1128d154-9024-496f-b9be-9a4eeafeb45b"],
Cell[36950, 1186, 171, 3, 35, "Output",ExpressionUUID->"7c608861-987d-47ca-bb5b-539296a1d606"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37158, 1194, 529, 15, 31, "Input",ExpressionUUID->"ff239172-fc5f-4283-9509-e3bb2891afc6"],
Cell[37690, 1211, 153, 3, 68, "Output",ExpressionUUID->"43f01a9a-a8d3-45d9-bfad-6c2dfa72c581"]
}, Open  ]]
}
]
*)

