(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     89203,       1898]
NotebookOptionsPosition[     86908,       1849]
NotebookOutlinePosition[     87326,       1865]
CellTagsIndexPosition[     87283,       1862]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  "\"\</mnt/27817d28-ee1d-4124-ab41-54755c9ee50d/work/Dydaktyka/TIK_2022_23/\
mathematica\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.882783760940351*^9, 3.882783765050495*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"b4e1483e-ae9c-4403-8080-306ab7e5076b"],

Cell[BoxData["\<\"/mnt/27817d28-ee1d-4124-ab41-54755c9ee50d/work/Dydaktyka/\
TIK_2022_23/mathematica\"\>"], "Output",
 CellChangeTimes->{3.882783767736767*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"87bee128-ede4-4a0f-8b9c-882246ca964b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wahadlo", " ", "=", " ", 
  RowBox[{"Import", "[", 
   RowBox[{"\"\<wahadlo.txt\>\"", ",", "\"\<List\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882783779076874*^9, 3.882783798969954*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"8e574da0-bbf4-4a0d-a8b6-09974395979e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.134832277391945`", ",", "3.015358874649123`", ",", "3.2128736915738285`",
    ",", "3.028258214126786`", ",", "3.4877335432482295`", ",", 
   "3.4245977818908604`", ",", "3.049804421284213`", ",", 
   "3.1590124986675283`", ",", "3.1962785575694785`", ",", 
   "3.366704442057165`", ",", "3.230856104483032`", ",", "3.114271014782915`",
    ",", "3.076372362142421`", ",", "3.367015172681935`", ",", 
   "3.3602921111612187`", ",", "3.1573495427881806`", ",", 
   "3.076757390517038`", ",", "2.9830983495178423`", ",", 
   "3.1262006337948307`", ",", "3.0981747049277404`", ",", 
   "3.4408180353685065`", ",", "3.1304703275047414`", ",", 
   "3.1360024743213937`", ",", "3.1856153272687804`", ",", 
   "3.4098847632087503`", ",", "3.055480502683063`", ",", 
   "2.9971608034719237`", ",", "3.1287383740529005`", ",", 
   "3.1510834550015008`", ",", "2.9441174204461316`", ",", 
   "3.338868160332582`", ",", "3.0653101580872284`", ",", 
   "3.258830079466923`", ",", "3.2820109768158154`", ",", 
   "3.427800685146937`", ",", "3.2072064519896233`", ",", 
   "3.2228921103988974`", ",", "3.0765050122578663`", ",", 
   "3.3283862137519358`", ",", "3.1011254526775134`", ",", 
   "3.1768978719577863`", ",", "3.1925262417238756`", ",", 
   "3.2737649217836817`", ",", "3.2395935833048046`", ",", 
   "3.172102658840812`", ",", "3.4718089088853286`", ",", 
   "3.2359126830232214`", ",", "3.292309967090343`", ",", 
   "3.388980048106495`", ",", "3.1977836389769285`", ",", 
   "3.4332241730076407`", ",", "3.137691330845599`", ",", 
   "3.2145118269025414`", ",", "3.1776553313033293`", ",", 
   "3.2226251952809717`", ",", "3.1711118986502154`", ",", 
   "3.5323736291177954`", ",", "3.0253288440223134`", ",", 
   "3.4042331725411246`", ",", "3.5232624665956758`", ",", 
   "3.2292760913084484`", ",", "3.129557333619419`", ",", 
   "3.2551460241312427`", ",", "3.1680886045349315`", ",", 
   "2.9612927901382857`", ",", "3.236671869818831`", ",", 
   "3.093984852362885`", ",", "3.241203255222412`", ",", 
   "3.2389453507897388`", ",", "3.5963486279763446`", ",", 
   "3.187801562007958`", ",", "3.305796275518823`", ",", 
   "3.3625155010970227`", ",", "3.2563348435065227`", ",", 
   "2.8109224136417827`", ",", "3.103553262916845`", ",", 
   "3.242201424640301`", ",", "3.165404062587251`", ",", "3.049730965913778`",
    ",", "3.4199295916024175`", ",", "3.0604824872675835`", ",", 
   "3.099153930294089`", ",", "3.4935795844353073`", ",", 
   "3.392072477434404`", ",", "3.2621930923708202`", ",", "3.06796462839745`",
    ",", "3.232820840344662`", ",", "3.2512205273746124`", ",", 
   "3.037039267713015`", ",", "3.3627964105538735`", ",", 
   "3.2718172533990404`", ",", "3.3451316983272523`", ",", 
   "3.1143872156934016`", ",", "3.406138260303852`", ",", 
   "3.135699856188638`", ",", "3.4553489173851704`", ",", 
   "3.215253813541957`", ",", "2.8875792859890446`", ",", 
   "3.6128196244154447`", ",", "3.5019694903535266`", ",", 
   "3.3899796759560084`", ",", "2.8860140361485516`", ",", 
   "3.369410345752102`", ",", "2.973415704622599`", ",", "3.381190013716949`",
    ",", "3.1573218785869988`", ",", "3.046563550917068`", ",", 
   "3.3587267418224065`", ",", "3.4438961101550287`", ",", 
   "3.561090728787421`", ",", "3.118230973450746`", ",", 
   "3.5133195113654074`", ",", "3.075280461768154`", ",", 
   "3.1386132011513954`", ",", "3.208176242768607`", ",", 
   "3.073760148743982`", ",", "3.405786088449194`", ",", "3.363890014895647`",
    ",", "3.4881475333598577`", ",", "3.0326954835604267`", ",", 
   "3.1583934080686067`", ",", "3.214844218306566`", ",", 
   "3.5373417057596193`", ",", "3.178595421129613`", ",", 
   "3.3370953964080474`", ",", "3.2091905084838905`", ",", 
   "3.0573519908330717`", ",", "3.339565118484271`", ",", 
   "3.2804583699849625`", ",", "3.1739684952053513`", ",", 
   "3.3819955244876256`", ",", "3.2154289801000835`", ",", 
   "3.167109632245169`", ",", "3.336926071099953`", ",", "3.278572054107201`",
    ",", "3.125244055042421`", ",", "3.10735794486646`", ",", 
   "3.268079746995252`", ",", "3.428751932089884`", ",", "3.372733351927992`",
    ",", "3.524268630175276`", ",", "3.296889754734036`", ",", 
   "3.3021361133168567`", ",", "3.2835306539938753`", ",", 
   "3.206516866085829`", ",", "3.2617027432997077`", ",", 
   "3.107518874291805`", ",", "3.285927465185863`", ",", 
   "3.1448255538305956`", ",", "3.310318045939368`", ",", 
   "3.4382996393957432`", ",", "3.147861226780543`", ",", 
   "3.396784997071652`", ",", "3.758920591027079`", ",", 
   "2.8488466888413186`", ",", "3.3421928646194226`", ",", 
   "3.2254768793370303`", ",", "3.387055805729557`", ",", 
   "3.3562114319764396`", ",", "3.2706173215429875`", ",", 
   "3.487804050304741`", ",", "3.183063040002629`", ",", 
   "3.2456046965887646`", ",", "3.3164271281669433`", ",", 
   "3.4653626049128197`", ",", "3.3947867462277883`", ",", 
   "3.370087488077901`", ",", "3.150669594124033`", ",", 
   "3.1806854164470835`", ",", "3.2978566227299497`", ",", 
   "3.433934388618863`", ",", "3.37757297051389`", ",", "3.5539365873989532`",
    ",", "3.259504236593379`", ",", "3.4330308210857337`", ",", 
   "3.2795592036032777`", ",", "3.3601457457844437`", ",", 
   "3.4706143133317013`", ",", "3.349133128765182`", ",", 
   "3.463963215635737`", ",", "3.4162083842292583`", ",", 
   "3.125843513892632`", ",", "3.288158867205552`", ",", 
   "3.2963817319815085`", ",", "2.9100344289056705`", ",", 
   "3.566957726672253`", ",", "3.090635227212877`", ",", "3.182447033864653`",
    ",", "3.3084866186125885`", ",", "3.213723376632592`", ",", 
   "3.2129077263935732`", ",", "3.2925761726222973`", ",", 
   "3.4912046800048504`", ",", "3.5717451236077835`", ",", 
   "3.1418982819566486`", ",", "3.230595966871123`", ",", 
   "3.4085172530735046`", ",", "3.129156006099378`", ",", 
   "3.223726878438951`", ",", "3.3243594463603388`", ",", 
   "3.2961218309444464`", ",", "3.121145225161194`", ",", 
   "3.3405568144519706`", ",", "3.338156776547858`", ",", 
   "3.259438913828334`", ",", "3.0678694348957762`", ",", 
   "3.2854394126809727`", ",", "3.468415445787872`", ",", 
   "3.1652148816321297`", ",", "3.2865918708406814`", ",", 
   "3.231858000358058`", ",", "3.3126204611967767`", ",", 
   "3.242687694677509`", ",", "3.2298086826446064`", ",", 
   "3.239526910369172`", ",", "3.4225957915658514`", ",", 
   "3.158029484430371`", ",", "3.1991740914467472`", ",", 
   "3.563767910402966`", ",", "3.3136839296438314`", ",", 
   "3.2238552583575664`", ",", "3.0433048397470195`", ",", 
   "3.073496773200242`", ",", "2.9827736221342`", ",", "3.3883791327953543`", 
   ",", "3.3199969576493817`", ",", "3.0738008581579326`", ",", 
   "3.4769362560976558`", ",", "3.0259852440846724`", ",", 
   "3.2075781781115853`", ",", "3.159314856662078`", ",", 
   "3.206375378887864`", ",", "3.349864636054569`", ",", "3.059662267943986`",
    ",", "3.2349478902701345`", ",", "3.325610770456522`", ",", 
   "3.093214666679041`", ",", "3.519792695211691`", ",", "3.422353178595672`",
    ",", "3.2164007898220133`", ",", "3.166154837013978`", ",", 
   "3.2080306126324367`", ",", "3.3610893432802253`", ",", 
   "3.1521678689265236`", ",", "3.291508914531239`", ",", 
   "3.3427721315685806`", ",", "3.22312204767245`", ",", 
   "3.1392526152314977`", ",", "3.1972557198049243`", ",", 
   "3.0546338316675414`", ",", "3.2167237755730285`", ",", 
   "3.4285488867423455`", ",", "3.1478614321073106`", ",", 
   "3.597899383356262`", ",", "3.272248137849541`", ",", 
   "3.0907306984963157`", ",", "3.4003384740936333`", ",", 
   "3.1141082653015406`", ",", "3.115009177305378`", ",", 
   "3.0391137829706247`", ",", "2.942458364472774`", ",", 
   "3.1808808024517776`", ",", "3.135323747450282`", ",", 
   "3.2653929713575245`", ",", "3.347946809790098`", ",", 
   "3.4323175185552572`", ",", "3.2837422916696077`", ",", 
   "3.142650494226254`", ",", "3.193046976417174`", ",", "3.272905176148497`",
    ",", "3.1333484029103866`", ",", "3.172613860511654`", ",", 
   "3.237165664885098`", ",", "3.4152322077526236`", ",", 
   "3.116826158603625`", ",", "3.184410881763623`", ",", "3.245076549542269`",
    ",", "3.329076217598915`", ",", "3.262533966937199`", ",", 
   "3.429188172743483`", ",", "3.288215998883153`", ",", "3.168248489248522`",
    ",", "3.232386834641038`", ",", "3.2262322471228835`", ",", 
   "3.419535260672333`", ",", "3.158994027139708`", ",", "3.417345180636732`",
    ",", "3.4271253340677097`", ",", "3.224095442366938`", ",", 
   "3.2325573008134483`", ",", "3.393451714458977`", ",", 
   "3.2109458412286696`", ",", "3.150164998734719`", ",", 
   "3.234246239847127`", ",", "3.2951561171273265`", ",", 
   "3.4120120832381837`", ",", "3.452147915108439`", ",", 
   "3.3244380779714193`", ",", "3.3885197184099614`", ",", 
   "3.08193301164782`", ",", "3.2343796708275048`", ",", "3.205426350961757`",
    ",", "2.945894845604498`", ",", "3.2285445628662317`", ",", 
   "3.2260895663942093`", ",", "3.0722131263460977`", ",", 
   "3.222962140842639`", ",", "3.409476647160648`", ",", 
   "3.1426623007856787`", ",", "3.3286641266347434`", ",", 
   "3.3541812536857094`", ",", "3.32878382848007`", ",", 
   "3.3900038850665117`", ",", "3.452172348208718`", ",", 
   "3.297868185737397`", ",", "3.5598556095330522`", ",", 
   "3.2674226560075557`", ",", "3.2124553323860097`", ",", 
   "3.0072532980907827`", ",", "3.573624453849482`", ",", 
   "3.0866657210115402`", ",", "3.3307485800133816`", ",", 
   "3.2477724265607297`", ",", "3.4415448577430547`", ",", 
   "3.5382040962353645`", ",", "3.584195587739354`", ",", 
   "3.3019853844317533`", ",", "3.1565621782445854`", ",", 
   "3.3536043528487225`", ",", "3.2599108011425373`", ",", 
   "3.431991577348361`", ",", "3.241156886216298`", ",", "3.3027887223042`", 
   ",", "3.2854223950685264`", ",", "3.4374982188300964`", ",", 
   "3.3577055724414`", ",", "3.1876312970721257`", ",", "3.1447573034126024`",
    ",", "3.4446652328918432`", ",", "3.336856648062375`", ",", 
   "3.353729521096349`", ",", "3.198255856238944`", ",", 
   "3.3485919301916955`", ",", "3.5131974047085928`", ",", 
   "3.152744276508561`", ",", "3.3137571081191948`", ",", 
   "3.236195138564759`", ",", "3.2588464964266253`", ",", 
   "3.145790828494327`", ",", "3.29092382904093`", ",", "3.0451771008068054`",
    ",", "3.295280706276243`", ",", "3.2419410158154194`", ",", 
   "3.4252732377262447`", ",", "3.2078724276045185`", ",", 
   "3.0486811174889907`", ",", "3.5766882231759984`", ",", 
   "3.509478544640123`", ",", "3.382677590026212`", ",", 
   "3.2128632725028856`", ",", "3.0457223808298224`", ",", 
   "3.207839457189056`", ",", "2.967459863158695`", ",", 
   "3.2031438349267223`", ",", "3.035424308651941`", ",", 
   "3.398251759833857`", ",", "3.177292404491991`", ",", "3.440049702023337`",
    ",", "3.164657115293015`", ",", "3.21113003448775`", ",", 
   "3.4065484278623415`", ",", "3.562009247590068`", ",", 
   "3.330967439037301`", ",", "2.9338874901670993`", ",", 
   "3.385216709171407`", ",", "3.340516562393184`", ",", 
   "3.1326428252324154`", ",", "3.1177424675671057`", ",", 
   "3.1384948550422114`", ",", "3.2136475931283246`", ",", 
   "3.0864315567444605`", ",", "3.2514357247246872`", ",", 
   "3.4144392049944665`", ",", "3.2138675501333194`", ",", 
   "3.2276527179230574`", ",", "3.309605746342365`", ",", 
   "3.017701665685943`", ",", "3.1840387353817565`", ",", 
   "3.020127967962205`", ",", "3.2146348188351865`", ",", 
   "3.1913775038791945`", ",", "3.3451473166684735`", ",", 
   "3.440632546781933`", ",", "3.1322816524366073`", ",", 
   "3.444025560739571`", ",", "3.2456297017426965`", ",", "3.40219825077058`",
    ",", "3.3836387718392205`", ",", "3.312128030779867`", ",", 
   "2.9596587465155926`", ",", "3.1293534243113363`", ",", 
   "3.5869927117508054`", ",", "3.1510720001912875`", ",", 
   "3.0847229817683326`", ",", "3.1084724292176826`", ",", 
   "3.1631697825994163`", ",", "3.307507275546057`", ",", 
   "3.235826660142541`", ",", "3.4155129999597786`", ",", 
   "2.9259816996245154`", ",", "3.2234485573556753`", ",", 
   "3.1882947455256705`", ",", "3.2536023104570644`", ",", 
   "3.139933317902576`", ",", "3.312124913740688`", ",", 
   "3.2964373584900035`", ",", "3.1673466456803654`", ",", 
   "3.373291807464234`", ",", "2.991187316933818`", ",", "3.1719205821606`", 
   ",", "3.284968611003676`", ",", "3.0415524765016246`", ",", 
   "3.487147571652474`", ",", "3.1554109149501066`", ",", 
   "3.162400025860728`", ",", "3.2865732934745413`", ",", 
   "3.472435691526254`", ",", "3.435025260486369`", ",", "3.141676963159178`",
    ",", "3.3068808465905226`", ",", "3.5296642640114584`", ",", 
   "3.1346076277850785`", ",", "3.1465379297090723`", ",", 
   "3.2880786638001025`", ",", "3.287690036707827`", ",", 
   "3.271442706168335`", ",", "3.513024236430087`", ",", 
   "3.2718698261583476`", ",", "2.9447366051201582`", ",", 
   "3.4123116666877014`", ",", "3.2159527791259706`", ",", 
   "3.1879664311841043`", ",", "3.1631810196476633`", ",", 
   "3.187278857109335`", ",", "3.3088525833627833`", ",", 
   "3.127418210539714`", ",", "3.1487355761159836`", ",", 
   "3.4500615400438117`", ",", "3.082184613058835`", ",", 
   "3.566795969602024`", ",", "3.150766082051134`", ",", 
   "3.1435860084483678`", ",", "3.423306201594434`", ",", "3.4552255297211`", 
   ",", "3.4838936560190805`", ",", "3.43329716816453`", ",", 
   "3.0738572085302884`", ",", "3.311456668344204`", ",", 
   "3.2472212982449364`", ",", "3.4963239162000344`", ",", 
   "3.2943174493526413`", ",", "2.9520820336238023`", ",", 
   "3.368574198775805`", ",", "3.2706961430933874`", ",", 
   "3.1822130615622113`", ",", "3.233717674481491`", ",", 
   "3.3858772816196114`", ",", "3.172304771102163`", ",", 
   "3.2712787502042335`", ",", "3.2709530017543345`", ",", 
   "3.2457161747467147`", ",", "3.3604393549190696`", ",", 
   "3.181297836721236`", ",", "3.2401299373259103`", ",", 
   "3.2187183557667405`", ",", "3.1282873533110194`", ",", 
   "3.4808631245305572`", ",", "3.2118780710951844`", ",", 
   "3.178478609959347`", ",", "3.2290785153813166`", ",", 
   "3.050840261175633`", ",", "2.9514558569485203`", ",", 
   "3.365693639063121`", ",", "3.387069204010378`", ",", "3.400033738138884`",
    ",", "3.26981336410358`", ",", "3.0962561746071318`", ",", 
   "2.9996708345796073`", ",", "3.1654325616236294`", ",", 
   "3.372595040412503`", ",", "3.1335892472328823`", ",", 
   "3.4805541844021812`", ",", "3.0694050187630606`", ",", 
   "3.281054785250584`", ",", "3.3030419248423075`", ",", 
   "3.0926526853329626`", ",", "3.151416012555953`", ",", 
   "3.2104963752098454`", ",", "3.305855447126524`", ",", 
   "3.1222847023712106`", ",", "3.2541830924654573`", ",", 
   "3.2273277566651304`", ",", "3.407050164987681`", ",", 
   "3.2564351865459704`", ",", "3.140953327290631`", ",", 
   "3.2648124815816417`", ",", "3.035222965513294`", ",", 
   "3.1872122150511393`", ",", "3.2616131346595876`", ",", 
   "3.2644185824811682`", ",", "3.3192698064318473`", ",", 
   "3.2101367004108394`"}], "}"}]], "Output",
 CellChangeTimes->{3.882783800079595*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"a52d25d5-13cf-4d9a-bdd5-dd2d9cd95530"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"histogram", "=", 
  RowBox[{"Histogram", "[", 
   RowBox[{"wahadlo", ",", 
    RowBox[{"{", "0.1", "}"}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<Okres drgan wahadla\>\"", ",", " ", "\"\<zlicznia\>\""}], 
      " ", "}"}]}], ",", " ", 
    RowBox[{"ChartLegends", "->", 
     RowBox[{"{", "\"\<Pomiary\>\"", "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882783806164586*^9, 3.882783900358712*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"153bac55-c9d1-4418-aaed-10000eac5f55"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
      EdgeForm[{
        Opacity[0.616], 
        Thickness[Small]}], {}, {
       RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
       EdgeForm[{
         Opacity[0.616], 
         Thickness[Small]}], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{2.8000000000000003`, 0}, {2.9000000000000004`, 4.},
               "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{23.25545161403852, 47.10001737653863}, {
             69.12559029891469, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 4]& , TagBoxNote -> "4"], 
         StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
         Style[4, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{2.9000000000000004`, 0}, {3.0000000000000004`, 
              18.}, "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{46.60001737653863, 70.44458313903874}, {
             55.247848652808386`, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 18]& , TagBoxNote -> 
          "18"], 
         StyleBox["18", {}, StripOnInput -> False]], Annotation[#, 
         Style[18, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.0000000000000004`, 0}, {3.1000000000000005`, 
              52.}, "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{69.94458313903874, 93.78914890153885}, {
             21.544761797978794`, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 52]& , TagBoxNote -> 
          "52"], 
         StyleBox["52", {}, StripOnInput -> False]], Annotation[#, 
         Style[52, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.1000000000000005`, 0}, {3.2, 114.}, 
              "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{93.28914890153885, 
             117.13371466403896`}, {-39.9138083490634, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 114]& , TagBoxNote -> 
          "114"], 
         StyleBox["114", {}, StripOnInput -> False]], Annotation[#, 
         Style[114, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.2, 0}, {3.3000000000000003`, 141.}, 
              "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{116.63371466403896`, 
             140.47828042653907`}, {-66.67802438083983, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 141]& , TagBoxNote -> 
          "141"], 
         StyleBox["141", {}, StripOnInput -> False]], Annotation[#, 
         Style[141, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.3000000000000003`, 0}, {3.4000000000000004`, 
              87.}, "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{139.97828042653907`, 
             163.82284618903918`}, {-13.14959231728696, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 87]& , TagBoxNote -> 
          "87"], 
         StyleBox["87", {}, StripOnInput -> False]], Annotation[#, 
         Style[87, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.4000000000000004`, 0}, {3.5000000000000004`, 
              68.}, "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{163.32284618903918`, 187.1674119515393}, {
             5.6844856310001575`, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 68]& , TagBoxNote -> 
          "68"], 
         StyleBox["68", {}, StripOnInput -> False]], Annotation[#, 
         Style[68, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.5000000000000004`, 0}, {3.6000000000000005`, 
              26.}, "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{186.6674119515393, 210.5119777140394}, {
             47.31771056931907, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 26]& , TagBoxNote -> 
          "26"], 
         StyleBox["26", {}, StripOnInput -> False]], Annotation[#, 
         Style[26, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.6000000000000005`, 0}, {3.7, 1.}, 
              "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{210.0119777140394, 233.8565434765394}, {
             72.09939208022318, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 1]& , TagBoxNote -> "1"], 
         StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
         Style[1, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.7, 0}, {3.8000000000000003`, 1.}, 
              "RoundingRadius" -> 0]}, 
            ImageSizeCache -> {{233.3565434765394, 257.2011092390396}, {
             72.09939208022318, 73.59065934065934}}], 
           "DelayedMouseEffectStyle"], StatusArea[#, 1]& , TagBoxNote -> "1"], 
         StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
         Style[1, {}], 
         "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
    Axes -> {True, True}, AxesLabel -> {
      FormBox[
       TagBox["\"Okres drgan wahadla\"", HoldForm], TraditionalForm], 
      FormBox[
       TagBox["\"zlicznia\"", HoldForm], TraditionalForm]}, 
    AxesOrigin -> {2.7800000000000002`, 0}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], 
    PlotRange -> {{2.8000000000000003`, 3.8000000000000003`}, {All, All}}, 
    PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Pomiary\""}, "SwatchLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Thickness[Small], 
                    Opacity[0.616]]], 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", "Automatic", "}"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.882783858949991*^9, 3.882783901247643*^9}},
 CellLabel->"Out[5]=",ExpressionUUID->"fee86a97-3619-4bb5-94fa-a3a722b1f397"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"edges", ",", "counts"}], "}"}], "=", 
  RowBox[{"HistogramList", "[", 
   RowBox[{"wahadlo", ",", 
    RowBox[{"{", "0.1", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882783882609805*^9, 3.882783926231501*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"2866e125-2cd2-4e49-a53d-053dc7461921"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.8000000000000003`", ",", "2.9000000000000004`", ",", 
     "3.0000000000000004`", ",", "3.1000000000000005`", ",", "3.2`", ",", 
     "3.3000000000000003`", ",", "3.4000000000000004`", ",", 
     "3.5000000000000004`", ",", "3.6000000000000005`", ",", "3.7`", ",", 
     "3.8000000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "18", ",", "52", ",", "114", ",", "141", ",", "87", ",", "68", 
     ",", "26", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8827839083142548`*^9, 3.882783926802785*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"09ecde0d-917c-44f9-b631-a291dcf46610"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"centres", "=", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"edges", ",", "2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882783936031021*^9, 3.882783947007784*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"687b79dc-da8a-4502-b1af-ab74cb0f7c28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.8500000000000005`", ",", "2.95`", ",", "3.0500000000000007`", ",", 
   "3.1500000000000004`", ",", "3.25`", ",", "3.3500000000000005`", ",", 
   "3.45`", ",", "3.5500000000000007`", ",", "3.6500000000000004`", ",", 
   "3.75`"}], "}"}]], "Output",
 CellChangeTimes->{3.882784096307439*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"91acbe86-b878-446e-93b3-19a60cb2dcc9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fit", "=", 
  RowBox[{"NonlinearModelFit", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"centres", ",", "counts"}], "}"}], "]"}], ",", 
    RowBox[{"a", "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "b"}], ")"}], "^", "2"}]}], "/", "c"}], "]"}]}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8827839541305733`*^9, 3.882784007488803*^9}, {
  3.882784150355034*^9, 3.88278418476184*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"f3d418ec-dbcb-4dec-b37f-791c41269da7"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"132.50657559280657`", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "20.955875975289732`"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3.2473348732566216`"}], "+", "x"}], ")"}], "2"]}]]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Nonlinear", {$CellContext`a -> 132.50657559280657`, $CellContext`b -> 
      3.2473348732566216`, $CellContext`c -> 
      0.04771931276836897}, {{$CellContext`x}, $CellContext`a 
      E^(-$CellContext`c^(-1) (-$CellContext`b + $CellContext`x)^2)}}, {
    1}, {{2.8500000000000005`, 4}, {2.95, 18}, {3.0500000000000007`, 52}, {
     3.1500000000000004`, 114}, {3.25, 141}, {3.3500000000000005`, 87}, {
     3.45, 68}, {3.5500000000000007`, 26}, {3.6500000000000004`, 1}, {
     3.75, 1}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.882784008072082*^9, {3.882784154396614*^9, 3.8827841854766083`*^9}},
 CellLabel->"Out[15]=",ExpressionUUID->"2179cb28-7452-482d-97d8-07761c606213"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fit", "[", "\"\<ParameterTable\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.882784263217318*^9, 3.882784268851307*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"345d43f9-613c-4fe5-8cfa-590cd433521d"],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"Standard Error\"\>", "\<\"t\
\[Hyphen]Statistic\"\>", "\<\"P\[Hyphen]Value\"\>"},
     {"a", "132.50657559280657`", "7.518114149960167`", "17.62497521981741`", 
      "4.664016071084572`*^-7"},
     {"b", "3.2473348732566216`", "0.010117879905488628`", 
      "320.95013022392624`", "7.526975350872276`*^-16"},
     {"c", "0.04771931276836897`", "0.0062579801043203525`", 
      "7.625353863848937`", "0.00012364821597763017`"}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
    GridBoxDividers->{
     "ColumnsIndexed" -> {2 -> GrayLevel[0.7]}, 
      "RowsIndexed" -> {2 -> GrayLevel[0.7]}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    GridBoxSpacings->{
     "ColumnsIndexed" -> {2 -> 1}, "RowsIndexed" -> {2 -> 0.75}}],
   "Grid"], "DialogStyle",
  StripOnInput->False]], "Output",
 CellChangeTimes->{3.882784269514309*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"25a2e7dd-5c64-487c-a941-45567e1b747f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wykresFit", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"fit", "[", "\"\<BestFit\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2.8", ",", "3.8"}], "}"}], ",", " ", 
    RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", " ", 
    RowBox[{"PlotLegends", "->", 
     RowBox[{"{", "\"\<Fit\>\"", "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882784192352181*^9, 3.882784246948053*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"67e0dbed-16fb-4dcb-aad4-80959273219d"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwV12k8lF8bB3DrjHvMjJ2o7ArZE6K6fwlFFELZpyRlCaWi/JOSlKLd0ial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          "]]}, Annotation[#, "Charting`Private`Tag$14362#1"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {2.800000000000006, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {2.8, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.8, 3.8}, {0., 132.5065614108107}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Fit\""}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 
                 TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                  "RGBColorSwatchTemplate"]}], "]"}], "}"}], ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.882784247738694*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"21d22faf-ffab-4a74-8df8-639edcc12676"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"histogram", ",", " ", "wykresFit"}], "]"}]], "Input",
 CellChangeTimes->{{3.882784275970018*^9, 3.8827842901690903`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"13c662e3-2137-41d2-a9a3-26450a825ba3"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{
       Directive[
        EdgeForm[
         Directive[
          Thickness[Small], 
          Opacity[0.616]]], 
        RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`]], {{}, {
         Directive[
          EdgeForm[
           Directive[
            Thickness[Small], 
            Opacity[0.616]]], 
          RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`]], {{
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{2.8000000000000003`, 0}, {2.9000000000000004`,
                    4.}, "RoundingRadius" -> 0]}], 
                "DelayedMouseEffectStyle"]}, StatusArea[#, 4]& , TagBoxNote -> 
              "4"], 
             StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
             Style[4, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{2.9000000000000004`, 0}, {3.0000000000000004`,
                    18.}, "RoundingRadius" -> 0]}], 
                "DelayedMouseEffectStyle"]}, StatusArea[#, 18]& , TagBoxNote -> 
              "18"], 
             StyleBox["18", {}, StripOnInput -> False]], Annotation[#, 
             Style[18, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.0000000000000004`, 0}, {3.1000000000000005`,
                    52.}, "RoundingRadius" -> 0]}], 
                "DelayedMouseEffectStyle"]}, StatusArea[#, 52]& , TagBoxNote -> 
              "52"], 
             StyleBox["52", {}, StripOnInput -> False]], Annotation[#, 
             Style[52, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.1000000000000005`, 0}, {3.2, 114.}, 
                   "RoundingRadius" -> 0]}], "DelayedMouseEffectStyle"]}, 
              StatusArea[#, 114]& , TagBoxNote -> "114"], 
             StyleBox["114", {}, StripOnInput -> False]], Annotation[#, 
             Style[114, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.2, 0}, {3.3000000000000003`, 141.}, 
                   "RoundingRadius" -> 0]}], "DelayedMouseEffectStyle"]}, 
              StatusArea[#, 141]& , TagBoxNote -> "141"], 
             StyleBox["141", {}, StripOnInput -> False]], Annotation[#, 
             Style[141, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.3000000000000003`, 0}, {3.4000000000000004`,
                    87.}, "RoundingRadius" -> 0]}], 
                "DelayedMouseEffectStyle"]}, StatusArea[#, 87]& , TagBoxNote -> 
              "87"], 
             StyleBox["87", {}, StripOnInput -> False]], Annotation[#, 
             Style[87, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.4000000000000004`, 0}, {3.5000000000000004`,
                    68.}, "RoundingRadius" -> 0]}], 
                "DelayedMouseEffectStyle"]}, StatusArea[#, 68]& , TagBoxNote -> 
              "68"], 
             StyleBox["68", {}, StripOnInput -> False]], Annotation[#, 
             Style[68, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.5000000000000004`, 0}, {3.6000000000000005`,
                    26.}, "RoundingRadius" -> 0]}], 
                "DelayedMouseEffectStyle"]}, StatusArea[#, 26]& , TagBoxNote -> 
              "26"], 
             StyleBox["26", {}, StripOnInput -> False]], Annotation[#, 
             Style[26, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.6000000000000005`, 0}, {3.7, 1.}, 
                   "RoundingRadius" -> 0]}], "DelayedMouseEffectStyle"]}, 
              StatusArea[#, 1]& , TagBoxNote -> "1"], 
             StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
             Style[1, {}], "Tooltip"]& ]}, {
           TagBox[
            TooltipBox[
             TagBox[{
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  RectangleBox[{3.7, 0}, {3.8000000000000003`, 1.}, 
                   "RoundingRadius" -> 0]}], "DelayedMouseEffectStyle"]}, 
              StatusArea[#, 1]& , TagBoxNote -> "1"], 
             StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
             Style[1, {}], 
             "Tooltip"]& ]}}}, {}, {}}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}}, {{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0]], 
          LineBox[CompressedData["
1:eJwV12k8lF8bB3DrjHvMjJ2o7ArZE6K6fwlFFELZpyRlCaWi/JOSlKLd0ial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           "]]}, Annotation[#, "Charting`Private`Tag$14362#1"]& ]}}, {}}}, {
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {
       FormBox[
        TagBox["\"Okres drgan wahadla\"", HoldForm], TraditionalForm], 
       FormBox[
        TagBox["\"zlicznia\"", HoldForm], TraditionalForm]}, 
     AxesOrigin -> {2.7800000000000002`, 0}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     PlotRange -> {{2.8000000000000003`, 3.8000000000000003`}, {All, All}}, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TagBox[
     GridBox[{{
        FormBox[
         TemplateBox[{"\"Pomiary\""}, "SwatchLegend", 
          DisplayFunction -> (StyleBox[
            StyleBox[
             PaneBox[
              TagBox[
               GridBox[{{
                  TagBox[
                   GridBox[{{
                    GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Thickness[Small], 
                    Opacity[0.616]]], 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
               "Grid"], Alignment -> Left, AppearanceElements -> None, 
              ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
              "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
            FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
            False]& ), InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Thickness", "[", "Small", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.616`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.987148, 0.8073604000000001, 0.49470040000000004`]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", #, "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"{", "Automatic", "}"}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm]}, {
        FormBox[
         TemplateBox[{"\"Fit\""}, "LineLegend", DisplayFunction -> (StyleBox[
            StyleBox[
             PaneBox[
              TagBox[
               GridBox[{{
                  TagBox[
                   GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
               "Grid"], Alignment -> Left, AppearanceElements -> None, 
              ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
              "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
            FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
            False]& ), InterpretationFunction :> (RowBox[{"LineLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], "}"}], ",", 
               RowBox[{"{", #, "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
      GridBoxSpacings -> {"Columns" -> {{0}}}], "Grid"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.882784290841282*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"20a5ecdc-9b4b-4038-b508-47d84382b144"]
}, Open  ]]
},
WindowSize->{1227.1648351648353`, 669.3626373626374},
WindowMargins->{{Automatic, 0}, {0, Automatic}},
FrontEndVersion->"13.1 for Linux x86 (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"dc3cbe7c-a75d-4124-b01e-0ab393361d19"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 301, 5, 29, "Input",ExpressionUUID->"b4e1483e-ae9c-4403-8080-306ab7e5076b"],
Cell[884, 29, 237, 3, 33, "Output",ExpressionUUID->"87bee128-ede4-4a0f-8b9c-882246ca964b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1158, 37, 295, 5, 32, "Input",ExpressionUUID->"8e574da0-bbf4-4a0d-a8b6-09974395979e"],
Cell[1456, 44, 15238, 247, 699, "Output",ExpressionUUID->"a52d25d5-13cf-4d9a-bdd5-dd2d9cd95530"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16731, 296, 541, 12, 33, "Input",ExpressionUUID->"153bac55-c9d1-4418-aaed-10000eac5f55"],
Cell[17275, 310, 18272, 439, 201, "Output",ExpressionUUID->"fee86a97-3619-4bb5-94fa-a3a722b1f397"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35584, 754, 346, 8, 29, "Input",ExpressionUUID->"2866e125-2cd2-4e49-a53d-053dc7461921"],
Cell[35933, 764, 704, 15, 33, "Output",ExpressionUUID->"09ecde0d-917c-44f9-b631-a291dcf46610"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36674, 784, 268, 5, 29, "Input",ExpressionUUID->"687b79dc-da8a-4502-b1af-ab74cb0f7c28"],
Cell[36945, 791, 413, 8, 33, "Output",ExpressionUUID->"91acbe86-b878-446e-93b3-19a60cb2dcc9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37395, 804, 700, 19, 29, "Input",ExpressionUUID->"f3d418ec-dbcb-4dec-b37f-791c41269da7"],
Cell[38098, 825, 1392, 35, 52, "Output",ExpressionUUID->"2179cb28-7452-482d-97d8-07761c606213"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39527, 865, 222, 3, 29, "Input",ExpressionUUID->"345d43f9-613c-4fe5-8cfa-590cd433521d"],
Cell[39752, 870, 1084, 23, 79, "Output",ExpressionUUID->"25a2e7dd-5c64-487c-a941-45567e1b747f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40873, 898, 511, 11, 33, "Input",ExpressionUUID->"67e0dbed-16fb-4dcb-aad4-80959273219d"],
Cell[41387, 911, 14758, 280, 240, "Output",ExpressionUUID->"21d22faf-ffab-4a74-8df8-639edcc12676"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56182, 1196, 248, 4, 33, "Input",ExpressionUUID->"13c662e3-2137-41d2-a9a3-26450a825ba3"],
Cell[56433, 1202, 30459, 644, 223, "Output",ExpressionUUID->"20a5ecdc-9b4b-4038-b508-47d84382b144"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

