(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    250728,       4484]
NotebookOptionsPosition[    248009,       4432]
NotebookOutlinePosition[    248462,       4449]
CellTagsIndexPosition[    248419,       4446]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "22", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "a", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "2"}], ")"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", " ", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882782256331752*^9, 3.882782310593328*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"004cae00-306d-4c3a-94cb-d1c9fd5e18c2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13dYzd8fAPCGbrTn3e2USEO0OW8qkoi+kpIiLZU0kFGkqEiEVESLaCii
tJQWlaa29tJSad4m/c79/XPv83ruvc/nnPc650rZnje1Z2NhYSHjF+b7i+u2
BFW7kF3VOjccYuIYqKxR0thc8iy6Jjz3f699KwyQlLyCCH0bnZnme/TpPVeb
P3pz74cn0y+KQiU4JO8gtZWPAUwr/rG7v+b4AJ3guRvLdBdfzL/V1keIESVQ
ybTs6w3qyytP0B6Pdeyx2K47L55bkHiKJE9IH2b6Y1Pvqzm95+iQgPxHppdd
jDunHWNRnG6dUhx2HGvnnQWDeLTNp/Ur0/o1DzcyWhPQc4vVq/HYI1H7iufO
vkI04+XDCdj37P5aza4kos9ZoUYvsVVUPi5Oh75Bd/o8nV9hN644hU9JJKN4
VoePidiXysVV/mSkIKetMpveYFMfN1VN6L1FYTYOVUnYhdZ3Hceb05DRhd+x
Kdi2m4H9t+M7tF/eLektNtvK1bo5n/eoRzBlOB27qddMbM4gA/EnW57KwH79
TcVllu8DeqSjI5qJffktd+5M6wc0/oewIRvb6NEQYSbuI3IsubwrD5t+ufjo
9NlMJBFwIKcAe/Lk84SpbVlorVHrSjF2kZ731J+VLFQs9y/gK/YjBdNdf8o+
oYE8045KbDv+rfcmQ7NRQvT0zVpszo5++QmJXHTcer68DbutqODi+Egu4kA1
rt3YKa+jSn9n5KEH9s0ug9iHPA/ZjOl9RsE9FgHT2JLHFdJGeQpQqu6++EXs
mZ3rVkaaC1Db5F5ZlngGitiQFzHs+AXZO1jZCWBneht5epGL0KXVXjkK9vMx
DcqsTxF6fsvMQhrbrV7IccagGI2mjZDVsc31WPg8U4rRjnivVMCGTxOZ03wl
yE2uPOcAttDzCrbp1hLEUvX80BnsFb5Pye66pWjsUnDneezBmy8PT8WVopOV
/FM+2J8cr8f8OVuG8s2LPkRhx7a7GJyvLUObhA47vsEOPmgxPrntKwp0MXz7
CdtSbbv25MpX5H9eZ6YFW++1VN+5U99QMjxdHMZWpPAHT5R9Q5JLG58tYf/7
N9o8HlqOlH1Dc8UTGCj+e6zHb4lKtNJRmumOPReVtbnnXiV6mazwNRh7r2PV
QMNSJep7eT4xHnucfcEsr/E70o/UGWjG1tx5SPtOUDWiEjk+Gr5koBBuu1mf
uWrEMpEQ74jd/fPKW/fTNcgo9sC1IOxblxLFj+vUokBrvb+V2PXvVtnk/9Sh
e556zyxf4XihDda8SvXo9qYsdBNbRy5cO8iuHoVPb/ydhH1/Lnn26o965M12
7vQK9vaHzfa2qT+QYv82hbREBrK+fGpPZ98PVPTKwKoTO8jmt/gxcgO648v7
nuc1A7VvZW3bf7sBseqzl7tj3/iuaKRq04jq8jX4971hoKSMbLnUJ41o7Fjq
qxvYDVF72DdWN6KnPXoXc7FlHY9/Jms1IRlejmaVJAb6zn5LiUW4GV0vdx5T
SsbxG+Pjvrq/GT1Szcj0wBZreDo8e6MZ3d6wqykL2z3uXdzweDOq+SgtuSeF
gYg7O4TqvrUgQ2KYgUsqrh9Zhz+Gf1tQrnuISC72We7pqhK1VrSyPsp0/VsG
+vyTcPtTXCvSrEjflIpte2nbwourbeivIlsEWzoDpb+70+Gq1I52b36stfKe
gcaExu4ZnW5HTfmlCZYZDCR/yWjXpvB2dHfwm3c+dpwud/zAUjsqi7U4f/MD
7sfKew6WXztQhNB8u3gmni8DD6b3WXWhNIcHP+KzGejD3qmEjQ+6kL7sBRlK
DgP9ST58lL2kC53qal//CNvJXTC7UL4bfY4YigzOxfX595HPjtlu9MAqhetO
Pq5n7qoAQYNetBC8+8TPLwy0a+c1Kz/rXiRWHcnhUsRAnW5bdvzx7kU7bkWe
/YdNbggZqk7pRR4t/Y6bSxjoYZTx/mCBPuQc7nU9soyBAjbW8q119KE2rVnh
ikoGckQ/no57DiBpJwP/R80MxJLAyOsIGUAS/AqfTrQwUNQ6euf3VwOIP/5D
i1wrA1VUOogntwwgL/cnv0raGGjT0dUEe+1BRJbc6SHUieezk/zbbtZfKHUx
flJggIH8qoxraqi/0KpJedMSNlnJc/Kz2i+E6qS+DQ4ykOHsZ5Vo+1/ITrjh
R9EQAyX7mmaZV+LvH99S9HCMgZwf+RbWhw2hiHTuu1EzeP7OJ/R8SR5Cz40a
VxJmGeiZeQXLu5Ih9DVK/8m7OVxfdGG90LkhxMk9Z1DHYKAtb5LK9x8fRn1q
WTWbVnA/5jfWl0iMIIdXKSMG6xaQ2y+Fgcz0UaT9kXxKjbyAeq1/ri+uHEUd
z4oyEygL6L+2YKWawVHkd/hOjQhtAWlWDV/5RR1DJb6JpqziC4g9I1GAGDSG
4gVsOldkFlCUj9Qub5vfKIN/0vWyygIqFqY81RKYQD2V5wufHVhA20MrCg22
TKCfzVZV9gcX0GvC5cEjeydQ5VRTrZrJArq31KLs7DOBfBs+F7aZLqBjPeHf
no1MoIjj8w57LRfQWIrA3ErRJDr5dmgq4+wC4pK6Jd+jOYVsswt6f9xdQBW6
D5WvG0yh4ArvlrZ7CyjweIyGmOkU0itPudF/fwGxheXsO+EyhapP6v35+2gB
Lf8bd2x9MYWuPuE/Zha9gH53miXVsU0jx9sdtYFvF1B1lLxCUfU0Mr7hoLFY
v4DuZm5Xtfk5jfxg7POxxgVkWL9b69+vaRRz6Rohp3kBlXFa7dddm0YrxYLD
/u0L6POlsLM5qjNoY/DlIa3BBZR2dCn5fcQM2irfQNq6uIDuC1Rtjj81i9I+
unorSC+iXA2xrENus+jrWeJu2sZFNGh9Hq1em0XXVEZMBDYtIp004aPmkbOo
/UqV7jqlRTSy38qXt3YWyWRsOiKsvYj0AibqrujMofwZin6t6SJanOe/aEqc
R0pO4oFZgYvItuPoF/ZqBrqj/ylbaXERcUX3nfP4ie8B/hrOXSuL6IOlG70H
16HJu0qZB2uLiL096Eoe6wJyT/NKWiEsoVdteWoeGngfM5e6FkWX0FCzZFJ3
wgKaWE+jBGxfQs7142G5VxbRJF/Mf3VeS8jj6y3b8/LLyD5tRxzryhLKcOf5
j7z/L1qt2jf4XHgFxV9zGVMxZ4Fx6Wd/yhxXkX/s6pG5cVZw7rQ6fuPLX8TS
2Aufr7JDlGr4oUtSa0jugsPlo5s5IHsDXx/3MRYYnI88xl1AgAsc4S5H+FnB
6Jez7yOP9SCf++6xRzMrHBoM2yIuzgXf17rhxUM2GCu19atI4wY3cTavRE12
UBJsEdOz4YVZHf1Bln524ELzpztn+cBpW480v9c62DdhuSBtJgDXrIYCbVk4
oK3EjtVSURBUL9/dM3OFA6Z2t1N9lQUhKq8qJeIaB3AWm2yP2yYI2kPudG1f
DlD/ou04pCkI4jVxtOt+HBCeL1DjaSAIsR4lQcuBHGCS+TkqxFoQ9D5/2fD1
MQd8SxRRKQgThOCcRzZxbzkgK7jMWnJeEM48N19z6+CAJKMqctCiICgPEp/P
dnLAM56GhokVQeCXDhT17uYAv7CevflsQrAtLzbmah8HGEctKx0TEIIcRV7u
C8Mc0P9GZS1kixAIvhe2UJnlAL7y57ELp4Xg1GfK/roNBHDguNhbWysElk1K
Bm/VCECVqGxd+SEEs5OT3xq3E6BWU6xuU7MQHLDrPLy8gwDqrl8L/DuEoP1u
s6++JgEIjaLR6iNCcEHHC2p0CZAY98kshlUY0nSNQ94bEGBQZ/H7ue3CsIc1
3e7LMQJEmRmXPNMQBpHBZN0KcwIYn4/LLdcWhnmnQ9L1xwmQmWCYJLVbGBaP
W5G6LAlwa8PT280HhYFYpJz+25oAsq1asNNRGKgeWwo6HAhwxvNaFs8zYRh8
8GB0/SW8vm3dWQovhOHf5iyDP9hcM/Bpb5wwbKv59qXJmwDvPQjZfq+FgcMy
hu/FFQKsuj/MmfsgDIlfy8RkfAkQcf5NfmeVMLyMNdfkuEWAStfG4rd/hSGd
TXujzEMCPFdUL6lkEYGvfDvyJrDdx6NKhthFgKX6yMXsRwQgulqXSnKJgEkU
v41hOAFsXUbLwokicPZGyPpTkfh5Z9fKfZRFwL1Ecc7hBQGUHbfUGp8WgeCK
nXubkwjQfVbifJqdCNDNJUTDkwlwz1VYgM9JBFQvrk0eSSHAqMfKkTo3ERif
svv6PZUAL32qmo/4iABSD1ifkU4A0iOXrmORItCkFLXvcCYB1j6njp+qEYHX
Qh2FnYUESP8SG1pcLwLiCj/LfL8QwKrksZJ0kwgEyfMNihURILf8mvtAuwjE
d7G7nygmgFfDgTn7ERH4cftOVVUpAYaHf684s4tC366+vzcrCFAnpMh9UUsU
7IO31e37QYBd586NRuuKQpZyklAZdnp5enkJEgWnXMlo1ECA+z6qtwT2ikJk
T7PP9kac/yH1v6mmoqDkFPBAtJkA33N3/+l3EQWzCzFHs9oI8PWUeePhGFFY
5mbccushwPb8qAzveFF47zZs0IT9SrT9QcwrUVCgW1pq9eJ6+W5lPJ4iChb0
5BusfQTYs932a1C2KNQRDCvv9BOgiPNcdmG9KCinOJZd/UWA/HT/aEV2Ioxc
i6vsG8P1bGxGjSQQoSovP0PrNwGOjMo/ZeUiglN7TV8Y9rBMTUSLABHsOC7Q
d44TQPgp6ZGfOBH66Ip8oRMEcAl4G9ykRYS9jSXe3FME+CR5gxPtJIL4/cdK
x7FZC48EJgMRCp6sabzCjlxkBFzfRwSHj6cMtKcJUHpu941NZkQINbI5aT1D
ANrxlos+7kQ4b3qMHjSH+3U+aW7IiwidD6VMKrEzHl3zOuJNhLyOhz1c8wTY
VyPpIXedCGdOqdLvYXvtcXGtDyECV5syOYhBgCpFljOyb4jQ5nQ9z2YR1+v3
hr77KURYPZ5Lj8I+7Zh4aimNCC/s2EfqsBfijaxrM4kwt5r6eecSAWRITywu
lxBhSjPLU2iZANdYNx+u7iLC0derWXErBBjS526T6yOCym+1jXXYh4PHbW4O
EiFhTJ/vL7Ys/7vz6r+J8FOg4rD5KgGq6dsfxC0SYfe4cirHXwKIa+6qvSBM
Ag5XFzOjfwQIviZxrI5Igj1bPmW7Y88UsnQrUEkw73MwNgK73KB0oluSBPd/
GrL2Ybv/Z8i7X4kEohcbZd3XCFDiZmostp8Em09tuX+ZhRMUP6g1eRuTIPHG
0PNI7Ih5EasGExL0Pk3R/YTt4tPqEnSMBF/N926bwRa5axUyfQZ/Xvmay56V
E67X7BQ2diRByUf/T37YIwIS0a+dSRB8x2YpGrsgsi/lhAcJtKvo+35gOyQ6
fP96nQSyFrkkDTZOqB/ZZyrpT4Lw0PQwE2xtRYX2q7dJuC/fvnbE5v/4e1T5
Hgk2lVa/jcDOKXLf8OwpCer5fqlPYXN1XjV0yySBGT1o4iE7J6h7J/M+yCaB
W5Hc0ZfYp4XaGt7lkcCfxfB8JnaO4Y6T00Uk8JJ/+LUZ2yHrj8eFGhKoFzay
i67jhEeHxTWe1JNgR7WIpCx2wW/j1axGEoio98xvwxaRTglc+InjORFRb4Jd
fN8u+uoQCVbm9h8NxB5XeHwqehTnp/PeocfY5K/FGz+Pk+BElDNnHLbbivj7
vzMkiOX2z87Bpjv9LPNbIwE/eUl6GNuQff3deDYyPO4elZnB9opRNynhIEMi
V9jIKvb3psc/2XnIAC73vghycMLl3YcmA8lkqLyg80kT+1Wnz8c3NDKYxlYP
7cau8069XCFOhopt6r1G2HLp69m5NpIh30tOxQq7kVpKClUlQ4RM6DEf7H9Z
051p28kweX2mJwB78xHJhFoNMmwVOKERgu0X5KsosIsMzvY1pk+xleY0dj82
IoP4r9OHPmJbPnAgZB4kwzEVbstc7Nubn1Q1HSbDluhRzS/YnadmzIjmZBjJ
6/X8jr1+VZKmYUkGd9l9dXXYapEmveYnybCReJ21GftuzVvnp2fIwFi/PNqN
/cmpQznPgQyEm6HxA9h97Fzz7Wfx793uq45ga2o73qC7k+Hgk0tdU9i/XkuF
x/rg/dioe7MQcH5u9S2x+5HhAKHEZB32jG28jVMAGS58+7fGic0iIbVF9S4Z
Ehx+jfFhE/72hj0JJcNfT115IWzejjjGUhgZCqZidoliUyMlS0oiyRCW2cdK
w5a62CsvH02G/2bOvxPD3vRfXGhIDBlKH9jrSGLv4Je0OJpIBoXOgWlZbN2J
nsKcJDJ46dLE5bH3VMXKir0lw5+TJEUF7MNBElO/PpDhg+rnKUVsc/seM6NP
ZODYKZKshG2tF5ufnksG/7wHe1Ww7aRspIQLyBAeSPiuiu2yJh7kXUSGmgeH
t6the3Z1j3eU4v23GARux76cH2MK5WRQdSks2oEd6C0uvqGWDLrEZzMa2KFm
3QHnfpDBMybttyZ2uFrM6I8mMvAeT6zXwn4maG2i3kaG4DiLBG3s+D9iWc86
yDDan3BaBzuppou61o3rJ9KCXxc7PfWF35l+MmTsPvaW6aw7J4fKf5HhqaeH
1k7sz45ixoqjZDD4GpDNdKlBV0bYOBne9tjL78L+LvOCNP+HDI0eU3eYrmc9
6WsxSwalHas9TLf20AcKGGTgGz+9GWF3F3QaSi+Tgf308lmmB6Ofpwf+xfXh
EBPL9O8rViK/WSiws1mumukZc/pVk3UUiAl1nWJ6aUdnz0dOCohfNOQFZn2I
PDcgc1Mg89JjGaYJMydSffgoQPCX2840bz1NsE+QAvV32xHTIukdlwxEKbA/
OHgf09R70Z3JZArcvbDBmGkp5xN7+OgUmD2gfojpTYa0JE8JCtznGfm/leU6
eFulKXApa+H/Vl8X7aUjRwGtvbtMmNbtt/wZq0ABKAw/zLReERWt20oBZXrT
f0wbxbS/clKhwL6TzRZMH/Z5xlWjRoEGH48zTJtbWrqralDgstdND6atNakt
T7QpkKbefYtpe2K7zvJOCvDnnIph2nXuabz1bgpUDPYVMu3ZYMFZqk+ByVfa
w0xfeU85J29IgaF2PfJubL/7PxtCDlCg3LbFlOlA16eaU4cokCVYFcl0qJFF
zFFTChhmLQ8zHb6Jsi7XjALDQrv092BbWcu9GThOgZRy9tdMy4arGfFZ4fUX
fBbWY/ZzJUxo2lAgWI1yn+nMtYNhZ2wp8Nu6UlQf22fHCbX79hQIP+ebyrS+
i1NLjhMFttz6ZWKAzRN/8cqAC45/QQb7XuymFn8633kKmCk+Kmf6OU/YF01P
CpxvUX++j9lfe17YnrlIgbgcE39DbMXLKRz3L1NApOze1f3Yc2nZSTnXKGDa
/eK2EbOeB8oODFzH++/d9uoA9i1KwySvPwWORK20GGML3x7ffiaYAknk4Wsm
2O15S62hIRQ4rnn2z2HshCnCtZz7FGDJ67piir3NSqqY9wkFRKdPtJhhLz9U
stOMwvkILEs2xy4p1+E8E43Xs6srwgLbVO3YwZx4CiyLdRadZNbf2TNT/a8o
8CRecs0Guz/G/TFvEgX6V35Y2DLzyRXy0zadAsbSGo6O2NoQ5ROaQQG3LEOa
MzbbpUSJnEwKWL71n3TFftT3xZ43nwKs3pvnPbEtSTXrNQspMOc2r3AJW/pg
e6ptMQXUhF76XcH+kDM3nV1OgdUMmwg/7KuTrE/6v1NASKrq2C3m/JPl1+St
pUCsRINOMHbDA4Xrtk0UiE5xvhTGnDdf1aVCW/F+RsxrwrFtV/TKstspkEuJ
OvCU2b8O1ly8fRRge15elIAtuOtxRPYEBbYb/IzLxm7zitPqn6LAubGjBgXY
cclpnTxzFBg9EEosxVYRrZC2XaaADOfw7jpmv4yvpvNwUuE7C61uFJsszWWq
wUUF4oLF+BR2rzlp/jQvFRLX5egsYruXqupkC1PBRcHPi5OTE8KeOZSflqQC
7SyL5SZs70v+Xj4yVCgVOzSpgm1tGiMRKUcF/vrhbC1sRa4W72pFKrQwbk4c
wK68YrBJQ4sK+wS7Zj2x35udbjqiS4VUe5K+L3aUqq+fK6JCWGJsbRC2w2hm
W7wBFdbEyU9eYLNZyN7hMaXClmXhpSrs0e2wQ96MCqofFba2YdcLWPXtPk6F
W99uxw1ix1Y81vK2poKa6t19/7B1NdnH+pyp4LaXO2n7ek64SOo3yg6gQsOR
KN10bKvZv4wfgVQIXZtIL8TWr6O8HL9DBblhS+c6bKGgIytSYVSQ1h8pnMZO
ZxSl3ntOBRRc/kdrAyc8aeg0fxNLhatJtfnG2D7pi+wlCVQ4m1HabIN9wEHF
aiGJChSunvlA7JHmWB7bLCqcp79aaMOuy8jP8cnB+VD9pTeJ/Sm01S4ynwoV
7V397Fy43wz4C6qLqTCQdYymgi2Vdf2cRi0VlNPXAu9hW4afrOUZpkLPlFaN
GTe+j33kormMUUHILK/FE7vnR7Zj5QRe32CJcRi2Hb8Qa+AcXt/mMzersd3u
flNbY6VB+8MQKSMeTvD3U346TacBIT2tz5IXxyO285eJJA1cz3Rz38DmLLyz
LV2GBuXfDNNfYt9bGahy3kyDZnKK9SR2xKWofwMaNPjYn3jzDh8nJLuy2rWY
0uDyxfPnW/nx/A1Jf7/9GA0iap57sgvg+1fKib+PLGjQwX10SRn7w3BWhMkp
Ghz9tzH8LvZnW+fKinM02AlJQnsFcb6PNyrlB9OAz3xXdYsQJyzqJy7FFtJg
Znig/wwRxz8/NqCsmAZlOa3XX2CzbHvGO1pGg38nmmJbsTklHkhtq6KBTfmi
50ESJxCXLu8va6WBTsxBV0TG97c046cjUzQYOd5N30nF+ZDZJ8M7R4PHH4P2
3sDWfrY7TXWBBgrvTP4WY+8JUi+++pcGxVJqIvtpuN9OS47ycNFB8Thj7iQd
x1d0TlNVhg5d5KDJBHHc3yGTJWZydHDI1JedxL7INmp8VYEOA651k1oSeP1/
uk6VKtPhh4iCfiN2SGV5sJkuHRy39azySOH7iG902xUzOgTYefO8kOGEgV97
LpcE0eGo/HzBNgW8ntjahM0hdKATyp2eYscdt6x5dJ8O689wNLJsxv1a5SF9
5gkdDGs7h39gt7+Pq2Z/SYcT0/ZSvop4Xl37J2lQSAezxK0Gi8p4HgvmVZbP
0WEr99FPtzRw/VUZzCkv0qE8ZK/+Ok18Pt76IR61Qgeq07r4W9i7Fka8nNjE
QOpwbEWQFifkdZLENwiIwaK1WWekDs7vm4ueRlvE4J7kda8ehM+Hnaq0mtNi
cEuVtIl/P37eIa6AFTsxOLHRjB6L3W8zMKbgJAY02291ykacIOP/JC/QTQx8
xU9d/O8A/r/wbckCronBySGx0pcHOSHRpCTqY7gYvMjZ/crJFMfr9H/EZ+Vi
oMi6Vfu2FSdUeCper/guBmlflh9vPYn7MYBjiFEjBp/PlWe2YG96nZ31X5MY
GHEqG2+xwfU7RjPj7RMDN5O61q7TnJDiNfjYb1kMtq8nhTo5ckLa7YuCjlvF
YcyrOlHUC5/nuif9b6uIw6eWda6N2Ipz+rMv1cSBmy+d8fAC/r2tSHOvljjc
8q+1ELyE14c+RlnuFYdo1WBLyhW8n6UpiUM24tAxyGZ96AY+L865Ku14KA75
qSICB+9xQpDZmQPs8+IgPxNkFpeE42fSaWW/KA4vqm9LvkrG/bLfzK18RRzU
fD1aklJwve3c9zCETQIMN8yxZb3F805uS6uwgASo6iaebHuPz+OFGVvZLRJg
byDOfyAX3zej/K8anJYAdZkrgz3f8X2/Mz45qEYCAnSfdhdN4XmtEJ1Wc0AS
yvc8TmqD9XCjKDTqQK4k7LHZ0ebyaj0cpJklfpeVgkw+D1dLwQ2w2638hOAd
KYgM9Nw9f30DxNJtZavnpUD+gvYwx+oGkC19E3HohDRs/n173aYLXBC2tWRz
Q6E0NP4m5+WPcYHD7LoflZtlwHe36duss9xgmzEjeeeBDHD6FTlbdnKDq/9/
q0YPZUD4Z33uoW5uuPhfZisPvtq6yFEi9vRyQ/D8xfthETIwnVwxu2mQG9K1
llYiX8iAwroV1anf3LBUvNbyOlUG+HcVbHVa4YawBp7QsnIZMLhS2bZE4YFn
L885BVbKwL2Bbc+7aTzw8kKtnmGVDFj2HP1ZIsYDn4hhy1W1MoBm3ArvSPFA
p6WwU2OzDGiWfpcRVOAB+QGKXv8Aft4png4OTR5Qybwq/uqXDPy7Q5vv0+IB
7dsdS/bDMsAzX36jQIcHjOVfvB8dk4Eps+JBT8QDni6S4tPTMiAiUNPVspcH
fHRvLn2YlYG8MYtz6YY8cJu3v+nCvAwo20qdvW3EA1HvXoYsLsrAwk2Nl6qH
eCDBb51j3rIM9P/17CUc5oHUI/Z7fFbx/gpLgjqO8ECm9DexXf9kwPFoTNS7
/3igcFZuaW0Nr7fCVyjAjAf+BzGstb8=
       "]]},
     Annotation[#, "Charting`Private`Tag$3769#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox["x", HoldForm], HoldForm], TraditionalForm], 
    FormBox[
     TagBox["y", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 1.414213562373098},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {1.414213562373095, 3.5417539066920836`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.882782312016568*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"dabedaa8-c4e7-4d99-aa0d-6a25b442c4bb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "b", "*)"}]], "Input",
 CellChangeTimes->{{3.882782350050673*^9, 
  3.88278235215419*^9}},ExpressionUUID->"41278a30-8599-47c9-9019-\
436e2ba9b398"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "2"}], ")"}], "-", 
       RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", "x", "]"}], "]"}]}], "}"}], " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "10"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882782368325316*^9, 3.882782374366767*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"d0ef2dfc-14f1-457d-998a-10e6a113754e"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJw9mnk8VN//xy2ZkZ0RM7aEFiVLiqScN1FIqEikTUIqhUKl+KRQEUnRZotC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    "], {{{}, {}, {}, {}, {}, {}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[None], 
       GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl13e8j3UUB/CLIrNp773J3nsrM6uMbCGroWjRomXTsGlZmWUWyd5NhOyM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         "]]]}, {}, {}}, {{}, {}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwl1mfYjgUYBuDP3nvPMkKy94wkhGQmomHLphRKRPYIEe1JgzYNe++9954h
WZWKzvvox+m+rvvxeZ/1vYcCHfo0750oISEhZ+KEhJhT/HEXSfSV+iV5CBn0
ofoeuROp9JTmX4wmq97E8eXyoyTXr+nX5OFk1r/ST8r9SKtnM28zgfKOzTWr
cUS+Yg5llnzIfJb0/MM4uttvNp/gjnzTHMkv8jlzILnxMQlTzbtZJb/CXrlz
XEOcq77CbMp1+WtOyf3JTgV9nlmdo/JbHJZ7xD2J89K3mO3i5rHQSMI0uQCr
5WE0ZaXejBvyN1TkK70Gx+S36UFS3rAryBp5OM1YpTfnpvwtleJ89Zocl9+h
J8mYbleItfKrNKdyfK7d/ZyQ36UXyZlhV5h18ghaUCU+x64WJ+X36E0K3rS7
h/XySFpSlZTMtC/CBvk1WlGNVKQmDWlJR3oykJFMZCYLWclGdmb5t4qyUR7F
Y1QnRzwP+2JskkfTmhrxPsf9tL+XzfIYHqcm39nV5pT8Pn3IFffPrjhb5LG0
4X6+t3uA0/IH9CV33D+7+9gqj6MttfjBrg5n5A/pR564f3Yl2CaP5wlqM9/u
Qc7KH9GfvHFudiXZLk+gHav1FvwR18EDLNDrck7+mAFs1duTiEV6vjh3uRQ7
5Im0Z43ekj/jOqnDj/pDnJc/4Yjck4w8p28zn4zfLRbr+eM65dLslCexT+5C
6vi7+lqzVXxfxP3htDyAHHHt+k9mPS7In3JU7kUmnte3m0+RJK6d11hif958
gTzcFffPLMMu+bL5EpPl/WZX0nCLMfHv2a8zHyOFL4pb+nX5VebLZ+J6SedY
TvMOE+N7Qa/r+M9yfZLpv+q/y6/EOeuz9WNyfLmm0TOb/zKebPpAx3fIT5NS
TxrPgFFk0Zc6fkF+kfR63niW5uS4Z+bd8azlsiTVd+u/yS/Hc9Jf1w/I3eIZ
6GnNvxkbn+nYerN17OQb5ggWyGfjfpOL+PKcFO+C+IvZgIvyVXMYc+TjZp84
53gO+k7zmbgnLNN/NQeRjwLxPpnl2CNP4aDcPe5x/Jy+wXycf+I9pB4L9Ye5
JH/GCbkvWeP+6LvMDiRnuV4w3iG5PHvlqXRgo94mnkO8b9Rnkd6Qy/LnDKIQ
s+0qsE+eRkc26W25Hc+eBizWG/Gb/AWDKcwcu4rsl9+gEw+zxK4xV+QvGcI9
cV12lTggT6czDVlq9wi/y3N5iSJxrnaVOSjPoAuNKBrnYV+FQ/KbdKUxxbiX
4txHCUpSitKUoWycl5+tymF5Jt14hGV2Tbgqz+Nldusd4/eHFfpFczD5SRzv
YaL//29RzrH/AEh+Azs=
         "]]},
       Annotation[#, "Charting`Private`Tag$4636#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV02WAVWUQBuBLqYRioHQs3Sjd3ZJLNyyNCCqKYoJ0pwkoZdEuHQIiUhIK
FiBlY6AgBlg88+PZeWfO3b17vjMnKWV48rA0iUQi1Y+caROJ3ukSicxsYL9+
qdqKufJzal22869+pdqJwfIUtRJbuKx/U23HO/ICtQm7SM/bdOde155WS7CJ
b/Wvq23jM/JLakN2kIY1dGWia7PUGmzjL/1ytQN7eU//qtqc3dzIOnpygFyu
91GzsDFm+mVq6/hd5umfV+vF/89/+lVqZ4bIU9XK/CbvYKHclAy00D+jluQ7
OZVJ5CbF7GYOxllyHy3JQ1/zW/ggvpuhtCIv/cyzckh+gftpTT76m9/KYflF
htGG/Awwv40jcZYMpy0FGGh+O0fll3mAZJIYZH4HH8rzeZB2FGSweTY+iufK
Q7SnEEPM7+RYnAkj6EDhuFfzuzguv8LDdKRI3Kt5dj6O58YjdKJo3Kt5Dj6R
FzGSzhSLezXPyafyYh6lC8XjXuM585m8hMfoSom4V/PcfB77zSi6UTLu1TwP
J2IneJzujDYrxffyOiZTKu7fLC8n5dd4gh6MMSvNBXl9vB+UjjMxy8ep2HWe
pCfPmpXhB3lD7Bhl4pzM8vOF/AZP0YuxZmX5Ud7INMrG2ZkV4HS8g/F+xTV9
Fa7IO+nNOH05fpI3MZ1ycb5mSZyR34pdjmv6qvwu76IP4/V387O8OXZIbkRa
ZuhnqzW5Ku+JZxfvOzfF78WzUgtyNs5NbcPy2G+1Pv/Lq9UujJZnqNXYyh/x
v6nteZ93Y6fUZpG5gVR6sJ8U1yeo97CZi3GWajJ72BJ7rjZmJ+lYSzf2MdP1
OWotrskr1I7x3bF38c6TMf5+7JlaiHPxuXgn5QYkGKOfqVbnT3k3fZmoL88v
8lZmMVdfm7/lvZSPPdUX5ry8MnaGfkwyq8Cv8rY4eyrE7poV4Ut5VewM/akY
e2pelK/inGMfGECl2EnzYnwtr4lnzUAqU4WqVKM6NahJLWpTh7rUoz4NaEgj
GtOEpjSLXfYdxflGXhvPiEHxbplV5JK8Pc6eefo6/CPvY4nckkyspxcHae7a
defn1QE=
         "]]},
       Annotation[#, "Charting`Private`Tag$4636#2"]& ]}}], {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["x", HoldForm], TraditionalForm], None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}, "AxesInFront" -> True},
  PlotRange->{{0, 10}, {-0.9999694683645601, 3.5417539066920836`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.882782382074073*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"df53e220-4d17-4db8-8684-5ab790b5b01f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "c", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "0", ",", "5"}], "}"}], ",", " ", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", "\"\<\[CapitalGamma](x)\>\"", "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882782387858984*^9, 3.882782407102068*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"eb925872-c123-4248-94c4-2237bd3f8a6e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJw12Wk4VV/YMPBjzDw1qYQImaf8kepeEkIJIYUSMlVCkSRCRaIoReaUikiE
kISITJkzU8bY5xzHcQbzs9/3fd79ZV+/D+va61r7nva19zhftbrISiAQIlgI
hP9zf5X8Zfnb0xyoq3iLtodoor7qr/7YTA6kcp5yQXqaKPdN0ve5wlxoDGjP
6Xijgcz9zM/PGuTB59hrX789V0eSdvL5//jygWcg6GL9DnW0cIh9ZaYnH3pj
Vm64vFJDz7krnk+7F0B+2FL0UJwqKr5h6ndN9CPMBr9SX6pXQamz2juowR/h
+ptTSg3sKsi7XcR9wbAQKnt8jTpTldBpA4KAX24h+AyGJPxdVESolFhMESiC
S0VV5sbWikgktZGV8rsIYuTtO3XkFNCKQGmOz8FPkJgbQVl4IY8mwl5ZzGd+
Aqq5yuGzIvKo1D0knexZDGVd86QxkX0oY+CS4dW2Ymj8onbFI1kORZ04g5E0
SoD3staey7Jy6Kzm/gOklRJ4y3OVe8FUFhm82fPnilMpeDqUMdnGZZDSDsEo
Yl0pUHJsez6GyKD19X89WOxn6LDlzpeq3oteNmX4zkmUw4Tj9Z8rbtJoMalE
YTSmHIofiQ83C0kjI/fm8c6lcnB+mH/p+lcphLExbCq6KoCc3qNVJy6FdA6Z
H3gQWQknf/WIbFqXRA95XanBi5WwjSv8r/oXSTTSfzPP58JX+DDKLWwZJInu
BmSL2+lVwR7Hy+OqqxKovWCVVY78DQRY/nlf0RRHIsB9jl+lGv72BbB0N+5G
erIJByJdq8FKJhxturAbPVrMoQZ1VIN02ZMetxdiaH98z0Xn9zVw4BerxRm5
XehcoNORoT81YCJLc/ds34kiz8+J24rWwrGPMzIxt3aiAWWWPpN7tZAgyGtR
/XsHCm1SMlU//x2mRMqeC74RRe8KP8u+f4ablBA94CiKOpOOsMm0fIeG8rsG
uttF0V53u0pR3TqwUz2+EPJoO2piu6tC2FwPUZePvvkbuw0tzgrwBpnUQ4jn
vfV1i21od+eLaWpoPRyyM8uw2boN+WQWZE5j9TDJdo4v9uVWtO3QoMivHz8g
eNcyu3bDFoT2upGPrf0AI7q4rdbTLciTl9Jcq9kAtOcWnMpOW1BlP+e90swG
eNVyKJS4uhk5B2gw0oIaQd4saZBVfzP6UPBg8LJKE1iEdf73niSMZkVmY0wv
NIHddbKvaJMwkgswPbwvoQkoM4GuW98Io8yDvC/Hl5ogR2vsY+F5YfTkZ4zb
2fpmKHtU2CTRL4QCxh9TjB1aQa1chD5bJ4iKjOazZB63AkGxN1L0oSAi51hY
s9W2goA3RUrEShB5+Ah/rpJrg/hE0D/zVwCdXXsSrEVtAz9Lr8hmXgGUwdsc
IWzYDgJvk701QvnQ4UO3HO6cawdu6V05Vyz40JC3ohb5RjtUdhb2HZbiQ6Kd
D6dactvBKeepeVIDL4pPOm4SJdQBEzfup4+K8qIImTaBjcEOyNIy1vrYxY2k
TodMX6F1QG6r/1nZfG5UHaVSPSTQCeRI9lH+SG60OvfIt0K/E3h3zz2RP8iN
/ItOdvu/7YQaPseyC++5kDt0vMD8ukClUFfbNXUTImTRKwYfdsH97b/y64M3
oSR2saGm111A82gMu+W4CTX+dBPP6e2CEwUENCqxCe2zXs26eKAbFL8UOV98
x4lmPOTyRlh6YONUlr9vAwe603y8tXVnD/AT2LMe5XEgURU/UqVmD9Q99Sgm
xXOgY9RKtZSLPeDk2TB4zZED5dy2Kjn9swdyp5NsbjLYkdeT21Xtcb3wJkt+
uvQ/dsRKyxr9ltMLFJVp9VQJdpR8upFQUNsLPrusPT5zsaMmsc0GsYu9sC2l
tDNmkA0pvn3XYGL3G8y1bIYzI9gQ9qWrvVaiD7hdOibHhliR96T8ePGHfija
JHZ2oIAFjZ3r56r52Q/yh75FDaWyoFN9USqtE/0g18qewh3NgnSap29O7hyA
wsfSJ/+6siC2wmyhbZEDsHXQvCBUjAUlBe85fOP8IBCrvtasPyEgHnq7S0TQ
IIwUdeteDyeg21fvPHj8bBDsd5cJ8fsRkLPzaPfb5kGYpf7SeWtJQErH0i71
aQ9BvsuUvZ8IAdVs3vFCV2gYdj1WU5fcvwH7YxurDBWHIebT+QO7tm/AG87A
CUujYTh3Zq+h5fI6xCz1qnoFD8OJqTutl2rWwXY04UfyzDBou0momlitw2yu
0OJK9QhUfs19LRmyBjx77sqN6oyBucEF1fvLK9B4MF41xHAM1txvBp6YXIH7
dunau63GoODIwAvd9hVgjSsztr80BsdaMb7QNyuwvI65/04bgzsvzoeXWK/A
3JDNu1+sf2Bv1xWb6M/L0JIkJ1/d8gcKju9UbE9Yguji/ern+/+A9uW3LmkR
S3CsXV93ffIP6MpEed33W4K6TQ4mBzf+wAlXUXquxRJUBsR5lqn/BQvWgjxt
gSXIt17K+fj8Lxg+aJhQecSER0LNCi+dxuGPZhinciYDyrV3l5h7j0NMJ/X1
SBwDJs5dhdVb47AtkjUkJ4wBevmbrU8njkP8GAdPtAsDZkwcbvO3jcNMwUK7
zz4GGEQQf93Um4DsPjOlnFI6MGmC/lbbJkFH523LnXEaSO923tiQnoSLtU4n
VntpYH60+EG++iR4KBiffthEg+wndulcJyYhfrDCe7yQBlaqLxuqIiYh5EpO
8o0wGuR7aOxUpEyCqMyVOKG9NHAetP7G1jIFSsnih8UCFoEn5c8V3/4pOC6y
W4l+aRGKznqLjU5NgQGDd33kwiKwDUTerGCZBkNRkcmhE4vwuq9C01d7GrS1
Ps3fl12EqR7JdyNZ03DKT9U0ZIAKXu1YXPnNGZA/pdF3+jgVROJuglzkDLQk
avSOGlCh4iQnKSFhBroO9g5f06MC7y8JM5+CGYCHTV++KVAhr9WKQ25yBh5U
QtIENxVITWU3Eyz+wfYy8RirpgXwrb/rfFVuFlQ+pOsZnloA8QkjTrrmLBy8
f9Y1+/gCNLNy5wajWWhKct0nYLQAMiiW8uDMLFiqcVst6SxAf8WzO68fzkKa
utnIfokF0P/4Jr2fPAtZ5X++/EekgHBK44BB2RyEq/Zw73hMgary6JCmujlY
mJ7uDXhAgUt9x6UsO+ZgzlpgajCCAvVbOzzPzc5BaG3a6y+BFLgZ188MFMPg
oexgarszBf7cm9324Q4G1jKM8GM6FCj04TslakKEcBW1Rs2ZeWhJ3nwz35YI
/u7h11nG52GqbmfGEVci7LC57NE7PA87d8jPXQ4lwsPnGYTnXfNwt8YwoqaE
CNlvvv7z+jYPtiKhn7ykSNCiNfLUJWkelj9RNn9dIYFdaZfPqZPzsGWEqWvF
TQajujs1TNN5UOEiOE1vI0OIoo7xa6N5cHEQyBPWIEO3f3QX/2F8P+yKR908
yKApoSyhoDwP6Tau1wV7yFCSWKgQxjcPhP97zYPjy9MCfvj95a1Ls2qn58Hk
t9MyJZ0MatXczEjHeWgaGq+VTyJDNfs7jlGXeSjzCx33iifDWOyEZKzPPLSK
/OXgvksG8UzH0/8ezMPGza01nzzJkFx3su5l5Tw8XkvvqviPDE/496eLSFHA
82p0msVvEkhZdb733EeBNdOjaS87SFD43Ke8WoUCB3+e7F9uJkG7RH63tx4F
UmqfT9VXk0BAQ5a32ZoCxvdtg77mkiDaVjQwIpIC65XvuhTvkCA8Y9VyEaOA
aNc99U41EliolfkqUinw3r5rRlOJBOI11+Kdlygw0HYpL1WOBBV/Z9vbORZg
8psAihAnwYJM/8l88QWIPa08/4qPBM55JSfcLBaAS5zHTGWWCPrl3iZ9nxYg
5rXGbcglgoCpgqdgxQKU24U9u/GGCEMDk1FG1XhcD3dtKs0iQuCqQ2NxywJ4
0rynDFOI8BHMjOMnF+BLczKhMIYIkj/kDE23U2H+U6HXRx8iELrGUGUQFQgN
49mah4hw91/Vy6AwKlB5NpljukTgJqSx6kZRQT3O7Pv7/4ggonymruQZFdh2
ShBAjQgykR3GBR+pMFmnrF4qTQRTvVrzrCkq2I5rb/zlJUKbZWaBE5EKG9mB
IpzcRDjlESIksUiFvzscs1Q5ieDw7EBnCssiRO7eKvOcQARvcpHNM7FF2Cwh
pvmRhsHTV68coqwWgem46rvlDwaiFWFfjc4sQmajumzaCAap7efFOZwWYbT7
pYDSEAZv1naNhV1ZBGl+iUsOvzEoO53gcitqEZQ+pA9xtmEwxHvPy7tqEdqa
fbhDKzFwknJpVqpfhLetPYKeFRhM6ugrzTUvAlg6cJ8pw4B0cY3o3r8Ito8C
fpgWY8BS7e97YXERot/NrV/Pw0D2ulugtQINigwtVP6kYaB8YPRUhhoNjI6F
LxqmYrCfYKc6+x8N9Pp3lxYkY3AkxmQq1IAGJB8nySeJGJx7rWT93oEGP/LK
DJ7EY3DRK1uV7kyDGcnKRPE4DC6rifPqe9Ig8IdeR8EjDIIqBWt7/WnwzJR/
duwhBs+7F1RZH9NgV/ctz9v3MUhLvsR74hkNTj+ty1C7h8Frp4mpxBQaUNaL
38xEYFCE9aQpv6OBps81MfcwDNrYy3nP1NAgfjHtQlowBhxaodMFVBp0+nap
E69hwLfCqF1eokFhicRxzA8DkRqfdEMCHR4nRArN+2IgecLZZpCPDu8Unzzi
8MHg4EXD75yydPAYqJH0uIyBgWJVuqUSHR62rR+PuYSBKeW/oFQNOpRlRAuX
eGFgd3ufugbQgYswf3aLJwbXn/FmONrh6409PnG7YXDL/m7Qu3N06AwLdLO6
iEH4njUbqisdDh5cysxwxSAun8T3wJcOHHV7Xhu7YJB4zX2m6wYdyIe/emQ5
Y5CuO/ZdPIQO4jEf81hw59V3BBVH08GlLC+31QmDTw9NbTfi6HDfsd7pAO4K
y+/qpol0CLWzefT+PAaNw8Uzo6/oIDcqeSzlHAYTtERb3q90oGvwsXx0wCBL
X/Pa8Hc69If5CWjjPh/b9rigiQ6KBv4m3+0xGNjL8fNUHx1IguwwdxaDJJ/M
SZlROtT60hbv47at1GNlTtJh8/SJX3K4O0756aVS6WB2QG0m8AwGjzL47byX
6fCflYGUPO7jc++uIxYGHJ36dWPEDgMe7aPxIlwMGE/NnkrC3Rg+mj8hwICE
4KTLdrjvtwU1lW5lgOvUnU27cRvs3DYdJcYAzzi9kqnTGBDcCtnspRlgfifn
WgnuqsLjksoKDPjH8RE9wB28Nn1wQ40BwyU6O51x65pEnOnQZoC+q/o64KYn
iAe8OsyAMxIxs1K4i8fKn/gbMsBKAYZ5cPsp2RQYH2cAP/NoN8MWA9XA+eYd
pxhAkUlt/Ycb+/5wZu4MA5oDjBvGcOcKynFUOTHgU+uJb0O4Pexr98S5M2Bj
X8WnYdwybx0PO3sz4HBaStY47r8LzLP7/RlwwIIjmoQ783DCDc5gBnBfF/BY
x30uWjWhL5wBMkc6D2zG9yPW2/Qx9wEDYulXCcq4B/a4tQbjcxexieezGe7E
Kyyz5okM6KP8dLiK27o8lXNPOv78+D5yIm4RDh1p6msG3K656F2Pu92iC+rf
M0Aq7HUvA/ejVG+HxCIGtH1ullXFz/v4DPdNz3IG9Chvc7yEm3t/9jO9aga4
RNXeyMN9t3mwbbSVAUPF5qcO4e/3yPYbc4XdDMhlVgnF4t5wFuG6O8iAwZXC
939wBy0f09/3jwHyTV7XXuDxomM04bhMZgBBbzR1FTctPjSohc4Alg+aaa54
/PnIl37yYWdCQAurmAEenyr+lu1HeJkw/MMksRz3XDWGbRFhAsmOe3y/IwZu
dtKy5RJMeCfwaVIXj/e9r6uOPJRlAvvr+y++4/5LPnPeUZkJpnnZ263w/HCM
jEti0WOCk2/15dt4/uzsUizp0mfCPlSLdl7AoE+8oSP7GBP+pO3q/4LbunSN
x9SWCS+omyz58Xw1nfS6/cSXCVnVJK1/eH4b3ZbOOxrIBI1Jiuc7PP+PbB0a
oIcwwQodUbzsjsEBwxM69jFMoF8psWDB64VCtipV+i0TEmsJ7M54vZE9NLOn
N58JyVF+oYZXMJDqybSIKmZCj5pdiLI3vj8OkQ9YDRP0+VtZePF6xXtx0aNk
iAlNVLmNFbzeca3lJbqPMyHTkuTP5o8B+7OLP3bMMqGmRcRdMACD1bpe6RAG
vp4sXbw/EI/fveUjRiJLIC3bMliM18+WidvWfcZLIDXy93Y0Xo8bg/+LiDZf
gulRsnh/JAZ1W8iFB22WIIrVWUHpAQaVR50EXzovwb28geBRvJ7nvT7S5Hl7
CXZevcUIwvtBrOsmtFK0hM+RTpF38f5iPhGnKC6+DI2e8HUI708tihPdDnuX
wViFhT0R719m17RDUhSW4beGJb8N3t+OsY60i2ovg9Ry1cWhb/h5SioGbLZY
BpkrqntEGzDQcqiv5gpfBo4tl1wMevH86F6yoU4ug/49k9tuDAySd53YUMfw
58VHWSYtYbDDJfOdz8IyrPXNDLWuYLBtwWiFuL4MnzW2iR7F+7eQUELmzPYV
SOn/vsMR7/dsx1Xmhk1WoGNkTUxfjAiz353vNOavwMuRa4LtR4kgEd/n9ah4
BbR8axWLjIlgfc7cxvrLCoh0ZrxMMiVCFVNXYaxxBQadB1/4WRDhibJwN2N8
BU6mZXw560AEvcRvcnI7V0Exs7t+5ToRYrzEft27vwpup0t9w3KIUKP9pNws
dhU65gq6SHlEoLNzvRZOWIXqIXq800ciOGVQA9NersLZJsu9lp+JsL+7Saqk
chUaPlPeuNUTYfjQzYCJhVVItj7s5PKXCCrCvbsNzuPfoRPn57MlSDAVOxX+
7OIarOdMR9hLkyCNhzE9fWkNKPkRxC34vMfHLloUE7gG3O/Djz5VIcEs/YxR
b/waCO/7zFd1iATZQ8PennVrMPP8nUuLAwnE3k1+eyy/Due9JN1+pZGAB2gX
hqjrkOJ0yDJWkQyB+vu4SvHv5pIGQnWmGhmmDOw/PGbZgB3jygNlWmSoPVaz
fERwA2LM4rYwgAxBVrFPcxQ2IKXxauV7azLMXZSpD7iwATbC30rpIWRoibHZ
J/xrA3YVUt7v/E3+3/mcgFqCB378xudzY+JZhpQNAWGue1uI+PyfviWiK9SO
gHaYZWayms/Dot77giF7AsqKr+jfYTkPmdEr7s+dCcj8ZEjwSXyuX5ZL7eP2
ISAa24XE3/gcn+c8XD4fTUBkr4Aq+9vzINR3PriqmoA4k/nGdIrmoa/WleWs
Egt6Ns7f5ytNgZKounOSNBZUaEtV/SKyAG4c/mNtbayoZw//1NcjVHDxu1XC
l8yG7DXuW07HLIKqu2Lb8QvsSIFowsXLQodfIkq8/rocqOjmQFVdBwO+fAhP
UWLjRHdEs/9q1S3BLRYFi5ZhTnTssMt+gvoq8AwFHfMu3oR0z98mTJHX//c8
uNDugnnbFg4CmnyzJyEjmAuR7+mUlpMJKGHfDvZyG26UuhbT9eI7K4pLdmu4
IMmD3MxSnL6Vs6OzCY5tfNM8SHPt2dAAxomYR7OXMqp40bWHPMVd77nR+OSR
wNpIPkQ1Y/4ZyeBDWYfUd7Ve4EfhVzY/jZUXQvn3/IXdlQVQdrmfcbO8CIq0
cTFjowmg1VuuV0oub0FaQy9zIlsFUXwuu9Yhw+3o/+1XCJFNTxZ+5hFFSfIp
+a1mQihaLV4Ks9+JQqtjk8zKhdDELZqTqYE4OrHLJrtprzAaj0QCdy7sQfre
DfbCD4TRyaJs/r5uaZQh5ry3hSaMXs5FR+dRZNHe72+fm9uLoCQnxSAtewUU
p1yr0Fklgkw/j7NHGqggNyp7x0+FzShjYfMjgUx11PhTw/Tc1c3o//8f+B+f
YgNt
          "]]}, Annotation[#, "Charting`Private`Tag$5157#1"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 5}, {0., 19.492542305898283`}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"\[CapitalGamma](x)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                  "RGBColorSwatchTemplate"], ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
             "}"}], ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8827824084680767`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"cfaac8b2-0164-49b2-b36a-77b61f749da4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "d", "*)"}]], "Input",
 CellChangeTimes->{{3.882782420984352*^9, 
  3.882782422977839*^9}},ExpressionUUID->"b4010fef-3614-498e-9494-\
43451aeb95e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"1", "+", 
     RowBox[{"Log", "[", "x", "]"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"y", ">", "0"}], ",", " ", "Green", ",", " ", "Red"}], 
       "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"1a6972d9-8e5c-4f29-a55b-0e3edd01353b"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxleXk41c37/znHcpDsW7bsWZJCC+GeRNIiKpQWIpEU9VQkSUTZt1CRJXuW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    "], {{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[{1, 425},
        VertexColors->Automatic], 
       LineBox[{394, 311, 417, 118, 383, 300, 412, 232, 401, 318, 421, 74, 
        370, 287, 221, 163, 47, 352, 269, 203, 397, 314, 145, 386, 303, 234, 
        402, 319, 100, 378, 295, 411, 228, 399, 316, 171, 391, 308, 416, 239, 
        405, 322, 423, 2, 326, 243, 409, 177, 395, 312, 418, 119, 384, 301, 
        413, 434},
        VertexColors->Automatic], LineBox[CompressedData["
1:eJwl0zdPlWEYBuBzYm/0pk6ogzIYAVEBMRoHewELrqLYhcVesGIcjDF20eig
IoMO9oLlD2Avo2XQxFjioNjL9cThyn0/z0fg/d5zyK+pr6pLJhKJ11xUTslG
WcQJPpj3yzE0M8Q8V6bQRJt5tyznJHvN2+LnOM478z45mlp9vRyY/P/39sgK
zuo7ZQmf9INyLB30cfKzvMAuvZQ1+hY5mLf6JFbo+TzXT7NDL+ajXkiNnsrd
OA/b9ULe6wvYoA/ijX6Ojow3f4l7YS2TWWnXjxd6M0XMM6dxL+6KhXRigl27
vMQ6plDMfPt07usHWERnJtp9lZfjnpjKULrEO3r2TV6JszKNErrSje70oCe9
SCGVNNLJIDPewe/5Lq+ykekMIyvO59kPeY0GKhlOdpzFs5/yOpuoYgS19hk8
iM+NxeTE+ex+yRtsZgalcdf2mTzUD7GE3DiH3W/ZGp8tMymLu7TP4pF+mKXk
xdns/sibbGUW5XGX9tk81o+wjN5xXru/8lZ8P5nNyDivfQ5P9CaW0yfOG/8U
3I7vCtWsMvfnpX6Giji/OZen+lHq6Bvnt0tyR29kDqvNA3iltzAq3secxzP9
GPXxuZgLOM8/QI9nmg==
        "],
        VertexColors->Automatic], LineBox[CompressedData["
1:eJwt0DdOXFEUgOExYKI3QBgyQxigpCWnFglMDkMLDFGyG0qyDR0VyZVNYy8B
MMFmA8QKCmp2wHclik/3P0eaefe9kkSyZ+ZDJBJZ4Y8ocPY6Uzh53w/wxVzB
k/5FI1PmXG70HrNE6bNL5VSvMshXc4xnfUwT0+Y8bvU+cxTy2S6NM73GEM2E
i+Zzpw+Yp4h+u4/81esM00IyvA/3+pAFisP72KVzrjcYoTXc3y7Kgz5ikZJw
f7sMLvQmo7RRGu5mn8ml3mKMdsrCPeyzuNLfGKeD8vBM+2z+6e9M0ElF+H/7
HP7rbRJ0EaOSKqqpIU4tdeHZfvOJa73DJN3hu9oV8qh/sMSyOc6L/h2+m27g
Ve862/hJvfkNFR037w==
        "],
        VertexColors->Automatic], LineBox[{242, 408},
        VertexColors->Automatic]},
      Annotation[#, "Charting`Private`Tag$5815#1"]& ], {}},
    VertexColors->CompressedData["
1:eJztlsENwkAMBA1UQiX0QAlIvCmPtiiBP8EyJ3zyOLd5zjr2Kt5ccr49rvej
mT0PZif7vF6XDfrKf63L5tXzxedyig/x/7in0/zslVN8rMqr5ytvNdzTlTeW
j4h7uvaYyyk+qrmnK28sH5FetRea/7366c4pPqq5pytXLB+RrnOV6Sdr7uh9
tOfcnVN8VHNPV65YPiJ9tf/zqj5Zc7vsnfbcaH1oOel+3o5yio9q7unKFctH
xD1d3/HcPllzae/paP/Z9d37jPafXb/a3rPqZ/Mu5/BWfwPxRgoe
     "]], {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 3}, {-14.133645179780196`, 13.027047189132087`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8827824499070587`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"670f409b-4a4c-42ad-af63-7ddc55439c54"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "e", "*)"}]], "Input",
 CellChangeTimes->{{3.8827824545318604`*^9, 
  3.882782456119095*^9}},ExpressionUUID->"4b1d4c8f-117d-494d-8e45-\
9feb48087beb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"\[Theta]", "/", "10"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "30"}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"\[Theta]", "/", "10"}], ")"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.882782544783101*^9, 3.882782550923709*^9}, {
  3.8827825843483047`*^9, 3.882782611341053*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"aa741d06-74a1-4156-b6c8-cb998e0d827d"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}}, {}, {{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJw0d3k8lN/7/ox9N/akaKFkV0RJ96Mia7a3pFRKkRLZWkhCSkJotxSRkES2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        "]]},
      Annotation[#, 
       "Charting`Private`Tag$10406#1"]& ]}, {}, {{{}, {}, {}, {}}, {}}}, {}},
  Axes->True,
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "RangePadding" -> Scaled[0.05]},
  PlotLabel->FormBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[Theta]", "/", "10"}]], TraditionalForm],
  PlotRange->{{Automatic, Automatic}, {Automatic, Automatic}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.882782551685917*^9, 3.8827826122360907`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"c29c9519-6c8a-4083-8c75-aab76f5e2e4c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "f", "*)"}]], "Input",
 CellChangeTimes->{{3.8827826264451437`*^9, 
  3.882782627100298*^9}},ExpressionUUID->"1a32c9fe-a07f-42a2-b33e-\
5071289cca08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotLegends", "->", "\"\<Expressions\>\""}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"0522808a-e627-4063-9e7c-6e244ba6223c"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyFfXu8VVW1/9ZQEx9gYZZdxW5Y2ENNEMPOZZTPyEf3ipXm497EB5mooSVa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      "], {{{
         EdgeForm[], 
         Directive[
          Specularity[
           GrayLevel[1], 3], 
          RGBColor[0.880722, 0.611041, 0.142051], Lighting -> {{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJw1mXXAF8Xahpd9nXFHRewOkJBuEAkBAZWSkm6QkhQBBVQwUbADPCoWINiN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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtmgXYFdXahocZ97g/uzsAA1BExcIEuwNQUQQDAUERuzCxsbsT7A5UbOw+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             "]], 
            Polygon3DBox[CompressedData["
1:eJwt13d4ldUZAPAYEBDEqgwV2YRNmCGssAkjCTPMgOypQJBNmcpURguEgEwh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             "]]}, Annotation[#, "Charting`Private`Tag$12002#1"]& ]]}, {
         EdgeForm[], 
         Directive[
          Specularity[
           GrayLevel[1], 3], 
          RGBColor[0.368417, 0.506779, 0.709798], Lighting -> {{"Ambient", 
             RGBColor[
             0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
            "Directional", 
             RGBColor[
             0.15473514000000002`, 0.21284718000000002`, 
              0.29811516000000005`], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[
             0.15473514000000002`, 0.21284718000000002`, 
              0.29811516000000005`], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[
             0.15473514000000002`, 0.21284718000000002`, 
              0.29811516000000005`], 
             ImageScaled[{2, 0, 2}]}}], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJw1mnWgVkXXxe+93OfMM0MogiIdigp2oyjYoL62otj92p0YiIWBmBgoKiBI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             "]], 
            Polygon3DBox[CompressedData["
1:eJxNmmWgHUW6Re/JqU73vTgkuLu7u7u7u/sMMLi76wCDzuDu7g7BJUAIIXgS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             "]], 
            Polygon3DBox[CompressedData["
1:eJwt13fcT+UbB/Cv8fg+Dw2bys7KLBGp0LCVEZURJVqKhpa9GkqkJCQhlUqp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             "]], 
            
            Polygon3DBox[{{2056, 1396, 1064, 1065, 1397, 2057}, {1856, 1855, 
             2265, 1399, 1400, 2266}, {2070, 1413, 1167, 1168, 1414, 2071}, {
             1869, 1868, 2270, 1408, 1409, 2271}, {2167, 1193, 984, 983, 1390,
              2051}, {2002, 1286, 1406, 2269, 1844, 1845}}]}, 
           Annotation[#, 
            "Charting`Private`Tag$12002#2"]& ]]}, {}, {}, {}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwt0jsvZVEUAODter+vRJQmYohMuIlXRFCIchSiJJliOgpa8wtQS6gVlKKg
IwqXSIgCM8x4x9vMkCi8pjDfSRRrf2uvnLX3Pvucsq+D3QMpIYRRUSCJ8hzD
GcfSQ4hzkh84ywSX2MZNdvKQvVzPCOEf+0W00Kv6N2mm+ghLOMEKTrOB8+xg
kit8YFzvNvMYE+exEHbML/idl/zBK+7ymnu84U+upYaQqu+XPI236vvy3zzg
Hx7yL494x2Pe84RJ/Y8s0nvKfKaLL863Zd7FZbZzjnWcYjnHWcxhbjBF35D8
TTy7jz7esof7/Bw9x1YusoYzLOWC/isWWqOQudGdssU5C9jMfDYxj43MZT1z
WMtsrnqfF2ZFZxAJ9UxW0xbhE20ZqpjGSmoJHxmLvovJ0/v/8R/YD0Wa
          "]]}, {
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0stKW1EUBuCtUZNqB2ouTUyiRnDcQsFhfQKDdGwQnFZ03tAHqBfQkcZb
qxP7BPYJdCBSiqSFYotItK233uhAHPkdHCy+f3HO2py99ylNTD+fagohzKu+
5hC6NXn+54e2EEr8yie85DBvWeaDeAgVZjnJXCKEh2arckHukoc8m9GPssZx
vuMU3/MV9zjHT0yai5krqVN9kUm11BLCmX6Z31njD67wJ1d5zjVecKE1hJS5
S3lRTsvrnl3pN3jNN/zFt/zNTf7hFv9yxlzc3ID6p+9lRm371kb0DaxH73GX
Ve5wktuscDnagz11myvrX+s75afyS3mQL5jhGOMc4Y0zfsZzPmaLNW7Yb7Y/
Ol92qEbMvelP2MtjFvmNBR4xzy/sic7ZntrNfdbnojuU63JWPuQjfmQmun+m
ecAU95nkrDUSzff/yx3WM0U9
          "]]}, {
         GrayLevel[0.2], 
         Line3DBox[{1427, 1721, 752, 1426, 2272, 1631, 1428, 2273, 1632, 1429,
           2274, 1633, 1430, 2275, 1634, 1431, 2276, 1635, 1432, 2446, 1722, 
          1636, 1433, 1723, 2078, 2447, 1434, 2277, 1637, 1435, 2278, 1638, 
          1436, 2279, 1639, 1437, 2280, 1640, 1438, 2281, 1641, 1439, 945, 
          1642, 1724}], 
         Line3DBox[{1441, 2079, 2359, 1440, 765, 1442, 2282, 1643, 1443, 2283,
           1644, 1444, 2284, 1645, 1445, 2285, 1646, 1446, 2286, 1647, 1447, 
          2080, 2360, 1448, 2081, 2361, 1449, 2287, 1648, 1450, 2288, 1649, 
          1451, 2289, 1650, 1452, 2290, 1651, 1453, 2291, 1652, 1454}], 
         Line3DBox[{1456, 2082, 2362, 1455, 2083, 2363, 1457, 780, 1458, 2292,
           1653, 1459, 2293, 1654, 1460, 2294, 1655, 1461, 2295, 1656, 1462, 
          2084, 2364, 1463, 2085, 2365, 1464, 2086, 2366, 1465, 2296, 1657, 
          1466, 2297, 1658, 1467, 2298, 1659, 1468, 2299, 1660, 1469}], 
         Line3DBox[{1471, 2087, 2367, 1470, 2088, 2368, 1472, 2089, 2369, 
          1473, 795, 1474, 2300, 1661, 1475, 2301, 1662, 1476, 2302, 1663, 
          1477, 2090, 2370, 1478, 2091, 2371, 1479, 2092, 2372, 1480, 2093, 
          2373, 1481, 2303, 1664, 1482, 2304, 1665, 1483, 2305, 1666, 1484}], 
         
         Line3DBox[{1486, 2094, 2374, 1485, 2095, 2375, 1487, 2096, 2376, 
          1488, 2097, 2377, 1489, 810, 1490, 2306, 1667, 1491, 2307, 1668, 
          1492, 2098, 2378, 1493, 2099, 2379, 1494, 2100, 2380, 1495, 2101, 
          2381, 1496, 2102, 2382, 1497, 2308, 1669, 1498, 2309, 1670, 1499}], 
         
         Line3DBox[{1501, 2103, 2383, 1500, 2104, 2384, 1502, 2105, 2385, 
          1503, 2106, 2386, 1504, 2107, 2387, 1505, 825, 1506, 2310, 1671, 
          1507, 2108, 2388, 1508, 2109, 2389, 1509, 2110, 2390, 1510, 2111, 
          2391, 1511, 2112, 2392, 1512, 2113, 2393, 1513, 2311, 1672, 1514}], 
         
         Line3DBox[{106, 643, 107, 644, 108, 645, 109, 646, 110, 647, 111, 
          648, 112, 967, 253, 113, 254, 649, 114, 650, 115, 651, 116, 652, 
          117, 653, 118, 654, 119, 655, 120}], 
         Line3DBox[{1528, 1729, 2405, 2165, 1527, 2404, 2123, 1526, 2403, 
          2122, 1525, 2402, 2121, 1524, 2401, 2120, 1523, 2400, 2119, 1522, 
          949, 1727, 1521, 1726, 947, 1520, 2399, 2118, 1519, 2398, 2117, 
          1518, 2397, 2116, 1517, 2396, 2115, 1516, 2395, 2114, 1515, 2164, 
          2394, 1725, 1739}], 
         Line3DBox[{1530, 1730, 2312, 1673, 1529, 2313, 1674, 1531, 2314, 
          1675, 1532, 2315, 1676, 1533, 2316, 1677, 1534, 2317, 1678, 1535, 
          951, 1679, 1731, 1728, 852, 1536, 2318, 1680, 1537, 2319, 1681, 
          1538, 2320, 1682, 1539, 2321, 1683, 1540, 2322, 1684, 1541, 2166, 
          2323, 1685, 1740}], 
         Line3DBox[{1543, 2124, 2406, 1542, 2324, 1686, 1544, 2325, 1687, 
          1545, 2326, 1688, 1546, 2327, 1689, 1547, 2328, 1690, 1548, 2329, 
          1691, 1549, 2125, 2407, 1550, 866, 1551, 2330, 1692, 1552, 2331, 
          1693, 1553, 2332, 1694, 1554, 2333, 1695, 1555, 2334, 1696, 1556}], 
         
         Line3DBox[{1558, 2126, 2408, 1557, 2127, 2409, 1559, 2335, 1697, 
          1560, 2336, 1698, 1561, 2337, 1699, 1562, 2338, 1700, 1563, 2339, 
          1701, 1564, 2128, 2410, 1565, 2129, 2411, 1566, 881, 1567, 2340, 
          1702, 1568, 2341, 1703, 1569, 2342, 1704, 1570, 2343, 1705, 1571}], 
         
         Line3DBox[{1573, 2130, 2412, 1572, 2131, 2413, 1574, 2132, 2414, 
          1575, 2344, 1706, 1576, 2345, 1707, 1577, 2346, 1708, 1578, 2347, 
          1709, 1579, 2133, 2415, 1580, 2134, 2416, 1581, 2135, 2417, 1582, 
          896, 1583, 2348, 1710, 1584, 2349, 1711, 1585, 2350, 1712, 1586}], 
         Line3DBox[{1588, 2136, 2418, 1587, 2137, 2419, 1589, 2138, 2420, 
          1590, 2139, 2421, 1591, 2351, 1713, 1592, 2352, 1714, 1593, 2353, 
          1715, 1594, 2140, 2422, 1595, 2141, 2423, 1596, 2142, 2424, 1597, 
          2143, 2425, 1598, 911, 1599, 2354, 1716, 1600, 2355, 1717, 1601}], 
         Line3DBox[{1603, 2144, 2426, 1602, 2145, 2427, 1604, 2146, 2428, 
          1605, 2147, 2429, 1606, 2148, 2430, 1607, 2356, 1718, 1608, 2357, 
          1719, 1609, 2149, 2431, 1610, 2150, 2432, 1611, 2151, 2433, 1612, 
          2152, 2434, 1613, 2153, 2435, 1614, 926, 1615, 2358, 1720, 1616}], 
         Line3DBox[{1630, 1738, 962, 1629, 2445, 2163, 1628, 2444, 2162, 1627,
           2443, 2161, 1626, 2442, 2160, 1625, 2441, 2159, 1624, 2449, 1737, 
          1736, 1623, 1735, 1734, 2448, 1622, 2440, 2158, 1621, 2439, 2157, 
          1620, 2438, 2156, 1619, 2437, 2155, 1618, 2436, 2154, 1617, 958, 
          1732, 1733}], 
         Line3DBox[{1742, 2050, 1187, 1741, 2550, 1960, 1743, 2551, 1961, 
          1744, 2552, 1962, 1745, 2553, 1963, 1746, 2554, 1964, 1747, 2263, 
          2649, 1965, 1748, 2555, 2051, 2167, 2450, 1749, 2556, 1966, 1750, 
          2557, 1967, 1751, 2558, 1968, 1752, 2559, 1969, 1753, 2560, 1970, 
          1754, 2264, 2650, 1971, 2052}], 
         Line3DBox[{1756, 2168, 2451, 1755, 1200, 1757, 2561, 1972, 1758, 
          2562, 1973, 1759, 2563, 1974, 1760, 2564, 1975, 1761, 2565, 1976, 
          1762, 2566, 2169, 2452, 1763, 2170, 2453, 1764, 2567, 1977, 1765, 
          2568, 1978, 1766, 2569, 1979, 1767, 2570, 1980, 1768, 2571, 1981, 
          1769}], 
         Line3DBox[{1771, 2171, 2454, 1770, 2172, 2455, 1772, 1216, 1773, 
          2572, 1982, 1774, 2573, 1983, 1775, 2574, 1984, 1776, 2575, 1985, 
          1777, 2576, 2173, 2456, 1778, 2174, 2457, 1779, 2175, 2458, 1780, 
          2577, 1986, 1781, 2578, 1987, 1782, 2579, 1988, 1783, 2580, 1989, 
          1784}], 
         Line3DBox[{1786, 2176, 2459, 1785, 2177, 2460, 1787, 2178, 2461, 
          1788, 1232, 1789, 2581, 1990, 1790, 2582, 1991, 1791, 2583, 1992, 
          1792, 2584, 2179, 2462, 1793, 2180, 2463, 1794, 2181, 2464, 1795, 
          2182, 2465, 1796, 2585, 1993, 1797, 2586, 1994, 1798, 2587, 1995, 
          1799}], 
         Line3DBox[{1801, 2183, 2466, 1800, 2184, 2467, 1802, 2185, 2468, 
          1803, 2186, 2469, 1804, 1248, 1805, 2588, 1996, 1806, 2589, 1997, 
          1807, 2590, 2187, 2470, 1808, 2188, 2471, 1809, 2189, 2472, 1810, 
          2190, 2473, 1811, 2191, 2474, 1812, 2591, 1998, 1813, 2592, 1999, 
          1814}], 
         Line3DBox[{1816, 2192, 2475, 1815, 2193, 2476, 1817, 2194, 2477, 
          1818, 2195, 2478, 1819, 2196, 2479, 1820, 1264, 1821, 2593, 2000, 
          1822, 2594, 2197, 2480, 1823, 2198, 2481, 1824, 2199, 2482, 1825, 
          2200, 2483, 1826, 2201, 2484, 1827, 2202, 2485, 1828, 2595, 2001, 
          1829}], 
         Line3DBox[{1843, 2060, 2653, 2268, 1842, 2497, 2212, 1841, 2496, 
          2211, 1840, 2495, 2210, 1839, 2494, 2209, 1838, 2493, 2208, 1837, 
          2492, 2057, 2056, 2658, 1836, 2055, 1394, 1835, 2491, 2207, 1834, 
          2490, 2206, 1833, 2489, 2205, 1832, 2488, 2204, 1831, 2487, 2203, 
          1830, 2486, 2054, 2053, 2073}], 
         Line3DBox[{1846, 2062, 2655, 2002, 1845, 2596, 2003, 1848, 2597, 
          2004, 1850, 2598, 2005, 1852, 2599, 2006, 1854, 2600, 2007, 1856, 
          2266, 2652, 2008, 2063, 2601, 2059, 1292, 1859, 2602, 2009, 1861, 
          2603, 2010, 1863, 2604, 2011, 1865, 2605, 2012, 1867, 2606, 2013, 
          1869, 2271, 2657, 2014, 2077}], 
         Line3DBox[{1870, 2064, 2656, 2270, 1868, 2507, 2222, 1866, 2506, 
          2221, 1864, 2505, 2220, 1862, 2504, 2219, 1860, 2503, 2218, 1858, 
          2267, 2659, 2075, 1401, 1857, 2058, 2074, 2651, 2265, 1855, 2502, 
          2217, 1853, 2501, 2216, 1851, 2500, 2215, 1849, 2499, 2214, 1847, 
          2498, 2213, 1844, 2269, 2654, 2061, 2076}], 
         Line3DBox[{1872, 2223, 2508, 1871, 2607, 2015, 1873, 2608, 2016, 
          1874, 2609, 2017, 1875, 2610, 2018, 1876, 2611, 2019, 1877, 2612, 
          2020, 1878, 2613, 2224, 2509, 1879, 1307, 1880, 2614, 2021, 1881, 
          2615, 2022, 1882, 2616, 2023, 1883, 2617, 2024, 1884, 2618, 2025, 
          1885}], 
         Line3DBox[{1887, 2225, 2510, 1886, 2226, 2511, 1888, 2619, 2026, 
          1889, 2620, 2027, 1890, 2621, 2028, 1891, 2622, 2029, 1892, 2623, 
          2030, 1893, 2624, 2227, 2512, 1894, 2228, 2513, 1895, 1323, 1896, 
          2625, 2031, 1897, 2626, 2032, 1898, 2627, 2033, 1899, 2628, 2034, 
          1900}], 
         Line3DBox[{1902, 2229, 2514, 1901, 2230, 2515, 1903, 2231, 2516, 
          1904, 2629, 2035, 1905, 2630, 2036, 1906, 2631, 2037, 1907, 2632, 
          2038, 1908, 2633, 2232, 2517, 1909, 2233, 2518, 1910, 2234, 2519, 
          1911, 1339, 1912, 2634, 2039, 1913, 2635, 2040, 1914, 2636, 2041, 
          1915}], 
         Line3DBox[{1917, 2235, 2520, 1916, 2236, 2521, 1918, 2237, 2522, 
          1919, 2238, 2523, 1920, 2637, 2042, 1921, 2638, 2043, 1922, 2639, 
          2044, 1923, 2640, 2239, 2524, 1924, 2240, 2525, 1925, 2241, 2526, 
          1926, 2242, 2527, 1927, 1355, 1928, 2641, 2045, 1929, 2642, 2046, 
          1930}], 
         Line3DBox[{1932, 2243, 2528, 1931, 2244, 2529, 1933, 2245, 2530, 
          1934, 2246, 2531, 1935, 2247, 2532, 1936, 2643, 2047, 1937, 2644, 
          2048, 1938, 2645, 2248, 2533, 1939, 2249, 2534, 1940, 2250, 2535, 
          1941, 2251, 2536, 1942, 2252, 2537, 1943, 1371, 1944, 2646, 2049, 
          1945}], 
         Line3DBox[{1959, 2072, 1416, 1958, 2549, 2262, 1957, 2548, 2261, 
          1956, 2547, 2260, 1955, 2546, 2259, 1954, 2545, 2258, 1953, 2544, 
          2071, 2070, 2648, 1952, 2069, 2068, 2647, 1951, 2543, 2257, 1950, 
          2542, 2256, 1949, 2541, 2255, 1948, 2540, 2254, 1947, 2539, 2253, 
          1946, 2538, 2066, 2065, 2067}]}, {
         GrayLevel[0.2], 
         Line3DBox[{548, 753, 2272, 549, 765, 574, 2363, 779, 588, 2368, 793, 
          602, 2375, 807, 616, 2384, 821, 630, 2395, 835, 644, 847, 2313, 657,
           859, 2324, 671, 2409, 873, 685, 2413, 887, 699, 2419, 901, 713, 
          2427, 915, 727, 2436, 929, 741}], 
         Line3DBox[{550, 754, 2273, 551, 766, 2282, 575, 780, 589, 2369, 794, 
          603, 2376, 808, 617, 2385, 822, 631, 2396, 836, 645, 848, 2314, 658,
           860, 2325, 672, 874, 2335, 686, 2414, 888, 700, 2420, 902, 714, 
          2428, 916, 728, 2437, 930, 742}], 
         Line3DBox[{552, 755, 2274, 553, 767, 2283, 576, 781, 2292, 590, 795, 
          604, 2377, 809, 618, 2386, 823, 632, 2397, 837, 646, 849, 2315, 659,
           861, 2326, 673, 875, 2336, 687, 889, 2344, 701, 2421, 903, 715, 
          2429, 917, 729, 2438, 931, 743}], 
         Line3DBox[{554, 756, 2275, 555, 768, 2284, 577, 782, 2293, 591, 796, 
          2300, 605, 810, 619, 2387, 824, 633, 2398, 838, 647, 850, 2316, 660,
           862, 2327, 674, 876, 2337, 688, 890, 2345, 702, 904, 2351, 716, 
          2430, 918, 730, 2439, 932, 744}], 
         Line3DBox[{556, 757, 2276, 557, 769, 2285, 578, 783, 2294, 592, 797, 
          2301, 606, 811, 2306, 620, 825, 634, 2399, 839, 648, 851, 2317, 661,
           863, 2328, 675, 877, 2338, 689, 891, 2346, 703, 905, 2352, 717, 
          919, 2356, 731, 2440, 933, 745}], 
         Line3DBox[{558, 941, 2446, 942, 559, 770, 2286, 579, 784, 2295, 593, 
          798, 2302, 607, 812, 2307, 621, 826, 2310, 635, 947, 948, 967, 950, 
          951, 662, 864, 2329, 676, 878, 2339, 690, 892, 2347, 704, 906, 2353,
           718, 920, 2357, 732, 959, 2448, 960, 968}], 
         Line3DBox[{8, 1433, 23, 1447, 38, 1462, 53, 1477, 68, 1492, 83, 1507,
           98, 1521, 252, 113, 239, 1731, 128, 1549, 143, 1564, 158, 1579, 
          173, 1594, 188, 1609, 203, 1623, 218}], 
         Line3DBox[{561, 759, 2277, 562, 2361, 772, 581, 2365, 786, 595, 2371,
           800, 609, 2379, 814, 623, 2389, 828, 637, 2400, 841, 650, 853, 
          2318, 664, 866, 678, 2411, 880, 692, 2416, 894, 706, 2423, 908, 720,
           2432, 922, 734, 2441, 935, 747}], 
         Line3DBox[{563, 760, 2278, 564, 773, 2287, 582, 2366, 787, 596, 2372,
           801, 610, 2380, 815, 624, 2390, 829, 638, 2401, 842, 651, 854, 
          2319, 665, 867, 2330, 679, 881, 693, 2417, 895, 707, 2424, 909, 721,
           2433, 923, 735, 2442, 936, 748}], 
         Line3DBox[{565, 761, 2279, 566, 774, 2288, 583, 788, 2296, 597, 2373,
           802, 611, 2381, 816, 625, 2391, 830, 639, 2402, 843, 652, 855, 
          2320, 666, 868, 2331, 680, 882, 2340, 694, 896, 708, 2425, 910, 722,
           2434, 924, 736, 2443, 937, 749}], 
         Line3DBox[{567, 762, 2280, 568, 775, 2289, 584, 789, 2297, 598, 803, 
          2303, 612, 2382, 817, 626, 2392, 831, 640, 2403, 844, 653, 856, 
          2321, 667, 869, 2332, 681, 883, 2341, 695, 897, 2348, 709, 911, 723,
           2435, 925, 737, 2444, 938, 750}], 
         Line3DBox[{569, 763, 2281, 570, 776, 2290, 585, 790, 2298, 599, 804, 
          2304, 613, 818, 2308, 627, 2393, 832, 641, 2404, 845, 654, 857, 
          2322, 668, 870, 2333, 682, 884, 2342, 696, 898, 2349, 710, 912, 
          2354, 724, 926, 738, 2445, 939, 751}], 
         Line3DBox[{571, 944, 945, 572, 777, 2291, 586, 791, 2299, 600, 805, 
          2305, 614, 819, 2309, 628, 833, 2311, 642, 2405, 953, 954, 655, 956,
           957, 2323, 669, 871, 2334, 683, 885, 2343, 697, 899, 2350, 711, 
          913, 2355, 725, 927, 2358, 739, 962, 963, 964}], 
         Line3DBox[{740, 928, 958, 726, 914, 2426, 712, 900, 2418, 698, 886, 
          2412, 684, 872, 2408, 670, 858, 2406, 656, 2312, 846, 955, 643, 834,
           946, 2394, 629, 820, 2383, 615, 806, 2374, 601, 792, 2367, 587, 
          778, 2362, 573, 764, 2359, 547, 752, 940, 965}], 
         Line3DBox[{746, 934, 2449, 961, 733, 921, 2431, 719, 907, 2422, 705, 
          893, 2415, 691, 879, 2410, 677, 865, 2407, 663, 852, 952, 649, 840, 
          949, 636, 827, 2388, 622, 813, 2378, 608, 799, 2370, 594, 785, 2364,
           580, 771, 2360, 560, 758, 2447, 943, 966}], 
         Line3DBox[{970, 1188, 2550, 971, 1200, 998, 2455, 1215, 1013, 2460, 
          1230, 1028, 2467, 1245, 1043, 2476, 1260, 1058, 2487, 1275, 1073, 
          2498, 1287, 2596, 1086, 1299, 2607, 1101, 2511, 1314, 1116, 2515, 
          1329, 1131, 2521, 1344, 1146, 2529, 1359, 1161, 2539, 1374, 1176}], 
         
         Line3DBox[{972, 1189, 2551, 973, 1201, 2561, 999, 1216, 1014, 2461, 
          1231, 1029, 2468, 1246, 1044, 2477, 1261, 1059, 2488, 1276, 1074, 
          2499, 1288, 2597, 1087, 1300, 2608, 1102, 1315, 2619, 1117, 2516, 
          1330, 1132, 2522, 1345, 1147, 2530, 1360, 1162, 2540, 1375, 1177}], 
         
         Line3DBox[{974, 1190, 2552, 975, 1202, 2562, 1000, 1217, 2572, 1015, 
          1232, 1030, 2469, 1247, 1045, 2478, 1262, 1060, 2489, 1277, 1075, 
          2500, 1289, 2598, 1088, 1301, 2609, 1103, 1316, 2620, 1118, 1331, 
          2629, 1133, 2523, 1346, 1148, 2531, 1361, 1163, 2541, 1376, 1178}], 
         
         Line3DBox[{976, 1191, 2553, 977, 1203, 2563, 1001, 1218, 2573, 1016, 
          1233, 2581, 1031, 1248, 1046, 2479, 1263, 1061, 2490, 1278, 1076, 
          2501, 1290, 2599, 1089, 1302, 2610, 1104, 1317, 2621, 1119, 1332, 
          2630, 1134, 1347, 2637, 1149, 2532, 1362, 1164, 2542, 1377, 1179}], 
         
         Line3DBox[{978, 1192, 2554, 979, 1204, 2564, 1002, 1219, 2574, 1017, 
          1234, 2582, 1032, 1249, 2588, 1047, 1264, 1062, 2491, 1279, 1077, 
          2502, 1291, 2600, 1090, 1303, 2611, 1105, 1318, 2622, 1120, 1333, 
          2631, 1135, 1348, 2638, 1150, 1363, 2643, 1165, 2543, 1378, 1180}], 
         
         Line3DBox[{980, 1386, 1387, 2649, 981, 1205, 2565, 1003, 1220, 2575, 
          1018, 1235, 2583, 1033, 1250, 2589, 1048, 1265, 2593, 1063, 1394, 
          1395, 1422, 2651, 1399, 1400, 2652, 1091, 1304, 2612, 1106, 1319, 
          2623, 1121, 1334, 2632, 1136, 1349, 2639, 1151, 1364, 2644, 1166, 
          1411, 2647, 1412, 1424}], 
         Line3DBox[{982, 1388, 2555, 1390, 983, 1206, 2566, 1004, 1221, 2576, 
          1019, 1236, 2584, 1034, 1251, 2590, 1049, 1266, 2594, 1064, 1396, 
          2658, 1421, 1398, 1423, 1401, 1407, 2601, 1403, 1092, 1305, 2613, 
          1107, 1320, 2624, 1122, 1335, 2633, 1137, 1350, 2640, 1152, 1365, 
          2645, 1167, 1413, 2648, 1415, 1425}], 
         Line3DBox[{985, 1194, 2556, 986, 2453, 1208, 1006, 2457, 1223, 1021, 
          2463, 1238, 1036, 2471, 1253, 1051, 2481, 1268, 1066, 2493, 1281, 
          1079, 2503, 1293, 2602, 1094, 1307, 1109, 2513, 1322, 1124, 2518, 
          1337, 1139, 2525, 1352, 1154, 2534, 1367, 1169, 2545, 1380, 1182}], 
         
         Line3DBox[{987, 1195, 2557, 988, 1209, 2567, 1007, 2458, 1224, 1022, 
          2464, 1239, 1037, 2472, 1254, 1052, 2482, 1269, 1067, 2494, 1282, 
          1080, 2504, 1294, 2603, 1095, 1308, 2614, 1110, 1323, 1125, 2519, 
          1338, 1140, 2526, 1353, 1155, 2535, 1368, 1170, 2546, 1381, 1183}], 
         
         Line3DBox[{989, 1196, 2558, 990, 1210, 2568, 1008, 1225, 2577, 1023, 
          2465, 1240, 1038, 2473, 1255, 1053, 2483, 1270, 1068, 2495, 1283, 
          1081, 2505, 1295, 2604, 1096, 1309, 2615, 1111, 1324, 2625, 1126, 
          1339, 1141, 2527, 1354, 1156, 2536, 1369, 1171, 2547, 1382, 1184}], 
         
         Line3DBox[{991, 1197, 2559, 992, 1211, 2569, 1009, 1226, 2578, 1024, 
          1241, 2585, 1039, 2474, 1256, 1054, 2484, 1271, 1069, 2496, 1284, 
          1082, 2506, 1296, 2605, 1097, 1310, 2616, 1112, 1325, 2626, 1127, 
          1340, 2634, 1142, 1355, 1157, 2537, 1370, 1172, 2548, 1383, 1185}], 
         
         Line3DBox[{993, 1198, 2560, 994, 1212, 2570, 1010, 1227, 2579, 1025, 
          1242, 2586, 1040, 1257, 2591, 1055, 2485, 1272, 1070, 2497, 1285, 
          1083, 2507, 1297, 2606, 1098, 1311, 2617, 1113, 1326, 2627, 1128, 
          1341, 2635, 1143, 1356, 2641, 1158, 1371, 1173, 2549, 1384, 1186}], 
         
         Line3DBox[{995, 1391, 1392, 2650, 996, 1213, 2571, 1011, 1228, 2580, 
          1026, 1243, 2587, 1041, 1258, 2592, 1056, 1273, 2595, 1071, 2653, 
          1404, 1405, 1084, 2656, 1408, 1409, 2657, 1099, 1312, 2618, 1114, 
          1327, 2628, 1129, 1342, 2636, 1144, 1357, 2642, 1159, 1372, 2646, 
          1174, 1416, 1417, 1418}], 
         Line3DBox[{1175, 1373, 2538, 1410, 1160, 1358, 2528, 1145, 1343, 
          2520, 1130, 1328, 2514, 1115, 1313, 2510, 1100, 1298, 2508, 1085, 
          2655, 1286, 1406, 2654, 1072, 1274, 2486, 1393, 1057, 1259, 2475, 
          1042, 1244, 2466, 1027, 1229, 2459, 1012, 1214, 2454, 997, 1199, 
          2451, 969, 1187, 1385, 1419}], 
         Line3DBox[{1181, 1379, 2544, 1414, 1168, 1366, 2533, 1153, 1351, 
          2524, 1138, 1336, 2517, 1123, 1321, 2512, 1108, 1306, 2509, 1093, 
          1292, 1402, 2659, 1078, 1280, 2492, 1397, 1065, 1267, 2480, 1050, 
          1252, 2470, 1035, 1237, 2462, 1020, 1222, 2456, 1005, 1207, 2452, 
          984, 1193, 2450, 1389, 1420}]}, {}, {}, {}, {}, {}}}, 
      VertexNormals -> CompressedData["
1:eJx0XXVcVV2zxsbuVlQUu7ADHTGxUFQwsBBFxULBTuxu7FZsUcQWGTExUEE6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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, DisplayFunction :> 
     Identity, FaceGridsStyle -> Automatic, 
     Method -> {"DefaultBoundaryStyle" -> Directive[
         GrayLevel[0.3]], 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "RotationControl" -> "Globe"}, 
     PlotRange -> {{-1, 1}, {-1, 1}, {-1., 1.9999994285714693`}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{
         SuperscriptBox[
          TagBox["x", HoldForm], "2"], "+", 
         SuperscriptBox[
          TagBox["y", HoldForm], "2"]}], 
       RowBox[{
         SuperscriptBox[
          TagBox["x", HoldForm], "2"], "-", 
         SuperscriptBox[
          TagBox["y", HoldForm], "2"]}]}, "SwatchLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]}, {
                    "Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]}, {
                    "Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}]], AspectRatio -> Full, 
                    ImageSize -> {12, 12}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #}, {
                   GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}]], AspectRatio -> Full, 
                    ImageSize -> {12, 12}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]|>, 
                    "RGBColorSwatchTemplate"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]|>, "RGBColorSwatchTemplate"]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             Graphics3DBox[
              SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                DirectedInfinity[1]}, 
              PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, ImagePadding -> 
              0]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "12"}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8827826749795933`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"9ad5428d-d464-44c0-b588-0ef69f38e256"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "23", "*)"}]], "Input",
 CellChangeTimes->{{3.882782677476466*^9, 
  3.882782686721098*^9}},ExpressionUUID->"d5c6ca21-6cb2-420f-8602-\
dcdec0336956"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", "a"}], "]"}], ",", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"x", "+", "a"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", 
       RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "0", ",", " ", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"f2f6a33b-8b8b-4aef-b4de-c2ed7a8c55cb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, Pi}}, Typeset`size$$ = {
    208., {57., 61.15566084397358}}, Typeset`update$$ = 0, Typeset`initDone$$,
     Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         Sin[$CellContext`x + $CellContext`a$$], 
         Cos[$CellContext`x + $CellContext`a$$]}, {$CellContext`x, 0, 2 Pi}], 
      "Specifications" :> {{$CellContext`a$$, 0, Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{254., {101.20604395604396`, 106.79395604395604`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.882782758510158*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"55c1c2d8-143a-4a5f-b0ff-6d6c8709c54e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "24", "*)"}]], "Input",
 CellChangeTimes->{{3.882782765151925*^9, 
  3.882782766599416*^9}},ExpressionUUID->"e7fe75a2-792b-497c-a22a-\
7d39b7a1bbbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "t"}], "]"}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"b", " ", "t"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", "10"}], "}"}]}], "]"}], " ", ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", " ", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"b61208b8-17c4-425e-91aa-589274c8ea6a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 
    1.6552194595336913`, $CellContext`b$$ = 4.1380486488342285`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 2}, {
      Hold[$CellContext`b$$], 0, 5}}, Typeset`size$$ = {
    360., {168., 171.79158459737397`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      PolarPlot[
       Log[1 + $CellContext`t] + $CellContext`a$$ 
         Sin[$CellContext`b$$ $CellContext`t], {$CellContext`t, 0, 10}], 
      "Specifications" :> {{$CellContext`a$$, 0, 2, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {$CellContext`b$$, 0, 5, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, DefaultBaseStyle -> 
        "Animate", DefaultLabelStyle -> "AnimateLabel", SynchronousUpdating -> 
        True, ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {260.70604395604397`, 266.29395604395603`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Animate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.882782794197908*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"73bb0606-0180-4f3e-b4fe-ab0c12a8a561"]
}, Open  ]]
},
WindowSize->{374.24175824175825`, 563.3406593406594},
WindowMargins->{{Automatic, -4.747252747252787}, {
  63.2967032967033, Automatic}},
FrontEndVersion->"13.1 for Linux x86 (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"adbada16-03eb-4885-af14-16cfec896289"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 662, 17, 96, "Input",ExpressionUUID->"004cae00-306d-4c3a-94cb-d1c9fd5e18c2"],
Cell[1245, 41, 12490, 226, 249, "Output",ExpressionUUID->"dabedaa8-c4e7-4d99-aa0d-6a25b442c4bb"]
}, Open  ]],
Cell[13750, 270, 176, 4, 29, "Input",ExpressionUUID->"41278a30-8599-47c9-9019-436e2ba9b398"],
Cell[CellGroupData[{
Cell[13951, 278, 769, 20, 98, "Input",ExpressionUUID->"d0ef2dfc-14f1-457d-998a-10e6a113754e"],
Cell[14723, 300, 25563, 442, 149, "Output",ExpressionUUID->"df53e220-4d17-4db8-8684-5ab790b5b01f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40323, 747, 503, 11, 75, "Input",ExpressionUUID->"eb925872-c123-4248-94c4-2237bd3f8a6e"],
Cell[40829, 760, 14166, 272, 182, "Output",ExpressionUUID->"cfaac8b2-0164-49b2-b36a-77b61f749da4"]
}, Open  ]],
Cell[55010, 1035, 177, 4, 29, "Input",ExpressionUUID->"b4010fef-3614-498e-9494-43451aeb95e4"],
Cell[CellGroupData[{
Cell[55212, 1043, 683, 18, 122, "Input",ExpressionUUID->"1a6972d9-8e5c-4f29-a55b-0e3edd01353b"],
Cell[55898, 1063, 12825, 233, 156, "Output",ExpressionUUID->"670f409b-4a4c-42ad-af63-7ddc55439c54"]
}, Open  ]],
Cell[68738, 1299, 179, 4, 29, "Input",ExpressionUUID->"4b1d4c8f-117d-494d-8e45-9feb48087beb"],
Cell[CellGroupData[{
Cell[68942, 1307, 559, 14, 51, "Input",ExpressionUUID->"aa741d06-74a1-4156-b6c8-cb998e0d827d"],
Cell[69504, 1323, 43917, 759, 315, "Output",ExpressionUUID->"c29c9519-6c8a-4083-8c75-aab76f5e2e4c"]
}, Open  ]],
Cell[113436, 2085, 179, 4, 29, "Input",ExpressionUUID->"1a32c9fe-a07f-42a2-b33e-5071289cca08"],
Cell[CellGroupData[{
Cell[113640, 2093, 662, 19, 75, "Input",ExpressionUUID->"0522808a-e627-4063-9e7c-6e244ba6223c"],
Cell[114305, 2114, 128005, 2174, 294, "Output",ExpressionUUID->"9ad5428d-d464-44c0-b588-0ef69f38e256"]
}, Open  ]],
Cell[242325, 4291, 178, 4, 29, "Input",ExpressionUUID->"d5c6ca21-6cb2-420f-8602-dcdec0336956"],
Cell[CellGroupData[{
Cell[242528, 4299, 589, 16, 77, "Input",ExpressionUUID->"f2f6a33b-8b8b-4aef-b4de-c2ed7a8c55cb"],
Cell[243120, 4317, 1697, 34, 227, "Output",ExpressionUUID->"55c1c2d8-143a-4a5f-b0ff-6d6c8709c54e"]
}, Open  ]],
Cell[244832, 4354, 178, 4, 29, "Input",ExpressionUUID->"e7fe75a2-792b-497c-a22a-7d39b7a1bbbe"],
Cell[CellGroupData[{
Cell[245035, 4362, 628, 18, 100, "Input",ExpressionUUID->"b61208b8-17c4-425e-91aa-589274c8ea6a"],
Cell[245666, 4382, 2327, 47, 568, "Output",ExpressionUUID->"73bb0606-0180-4f3e-b4fe-ab0c12a8a561"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

