(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     37109,        906]
NotebookOptionsPosition[     34227,        848]
NotebookOutlinePosition[     34561,        863]
CellTagsIndexPosition[     34518,        860]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"SetDirectory", "[", "]"}]], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"97b394b0-733f-4539-a85d-970104f64933"],

Cell[BoxData["\<\"/home/mk_fuw\"\>"], "Output",
 CellChangeTimes->{3.781335332311509*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"a27b29bc-ff55-4719-8172-a901527e9120"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataIn", "=", 
  RowBox[{"Import", "[", 
   RowBox[{"\"\<time.dat\>\"", ",", " ", "\"\<Table\>\""}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.781335431353236*^9, 3.7813354525109053`*^9}},
 CellLabel->
  "In[274]:=",ExpressionUUID->"a2b06100-2d55-433a-a07f-9fcd0395a123"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1226"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1178"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "928"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "837"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "724"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "654"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "580"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "509"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "422"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "357"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "344"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "284"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "237"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "202"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "213"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "137"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "147"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "124"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "113"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "83"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "97"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "71"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "72"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "53"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "53"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"54", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"58", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"68", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"69", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"77", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"79", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"82", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"92", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"94", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"98", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.781335453436022*^9, 3.781338836398304*^9},
 CellLabel->
  "Out[274]=",ExpressionUUID->"674edf26-b5fa-4aeb-802f-3d16f17c1952"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "DataIn", "]"}]], "Input",
 CellChangeTimes->{{3.781335459631565*^9, 3.7813354668948708`*^9}},
 CellLabel->
  "In[273]:=",ExpressionUUID->"04493b21-292d-417a-a8ff-a5540f9c4aea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.781335467466366*^9, 3.781338834734386*^9},
 CellLabel->
  "Out[273]=",ExpressionUUID->"8f182359-13ca-41f9-adc0-44fae02d3129"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataInPlot", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"DataIn", ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1300"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781335474783031*^9, 3.7813354948707952`*^9}, {
  3.78133553602013*^9, 3.7813355898631496`*^9}, {3.781335934328443*^9, 
  3.781335937264009*^9}},
 CellLabel->
  "In[275]:=",ExpressionUUID->"f0aef62d-a72c-428a-a33f-5481433b54a4"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd08sug1EUBeAVI0MDAwODEpFGpHG/09+17toqOpCgIUEiGDAwsSNiIDHh
BTzKeQSP4hFcztrkrD9pVr/u/9xPOxqX1ZMmAMffn59MnvxbFr98Fn/j9JUG
84XZHDP/TLfEfH+iW2NePdJtMXMPdHvMj3s6F/Pwju6MWb6lu2LaDd0dM1zT
eY5/QffEzM7oXtbP6QLnc0T3cfwG3c88YA6wv316kOPX6CHW6/Qw6xV6hFll
jnI9q/QYc5E5LvUJepaeFE+lv2NaPJOOi2K6LmTpvM3t++DjFGRc7hvmmNxn
c/PcMc/kuZkYC0zeA3P7vfN94b0zMZaYvIfm5j1GyfuLj5XS97Gcvm9irEjd
zXsOPyfvX4w1qYuxLnUxNqTu9vltSl2MLamLUU77y8pp3cRBjErqTGxu9h+k
/ve/8PZiEwe3r39b2otNHMSopc7EJg5i7Eh7sYmDGLvSXmziIMaetBebOIhR
T52JTRz+/QXvonkN
      "]]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {0, 1300}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7813354958412943`*^9, 3.781335550102536*^9, 3.781335590706047*^9, 
   3.781335937965106*^9, {3.7813388288935223`*^9, 3.781338837674341*^9}},
 CellLabel->
  "Out[275]=",ExpressionUUID->"41660a5a-5c01-40fc-90a0-b510f6246dad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataX", "=", 
  RowBox[{"DataIn", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781335603607026*^9, 3.781335617710836*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"ace87d5c-ba50-456d-9d87-77d580b46a6a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
   ",", "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", 
   ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
   "21", ",", "22", ",", "23", ",", "24", ",", "25", ",", "26", ",", "27", 
   ",", "28", ",", "29", ",", "30", ",", "31", ",", "32", ",", "33", ",", 
   "34", ",", "35", ",", "36", ",", "37", ",", "38", ",", "39", ",", "40", 
   ",", "41", ",", "42", ",", "43", ",", "44", ",", "45", ",", "46", ",", 
   "47", ",", "48", ",", "49", ",", "50", ",", "51", ",", "52", ",", "53", 
   ",", "54", ",", "55", ",", "56", ",", "57", ",", "58", ",", "59", ",", 
   "60", ",", "61", ",", "62", ",", "63", ",", "64", ",", "65", ",", "66", 
   ",", "67", ",", "68", ",", "69", ",", "70", ",", "71", ",", "72", ",", 
   "73", ",", "74", ",", "75", ",", "76", ",", "77", ",", "78", ",", "79", 
   ",", "80", ",", "81", ",", "82", ",", "83", ",", "84", ",", "85", ",", 
   "86", ",", "87", ",", "88", ",", "89", ",", "90", ",", "91", ",", "92", 
   ",", "93", ",", "94", ",", "95", ",", "96", ",", "97", ",", "98", ",", 
   "99"}], "}"}]], "Output",
 CellChangeTimes->{3.781335620337099*^9, 3.78133594215689*^9, 
  3.781338831215508*^9},
 CellLabel->
  "Out[270]=",ExpressionUUID->"ba8e1a7f-e5e2-4a1c-9d56-58ac62538b46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataY", "=", 
  RowBox[{"DataIn", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781335622239959*^9, 3.781335632606744*^9}},
 CellLabel->
  "In[271]:=",ExpressionUUID->"a60ff406-06f7-4196-b023-cf32488babae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1226", ",", "1178", ",", "928", ",", "837", ",", "724", ",", "654", ",", 
   "580", ",", "509", ",", "422", ",", "357", ",", "344", ",", "284", ",", 
   "237", ",", "202", ",", "213", ",", "137", ",", "147", ",", "124", ",", 
   "113", ",", "83", ",", "97", ",", "71", ",", "72", ",", "53", ",", "42", 
   ",", "53", ",", "35", ",", "35", ",", "27", ",", "27", ",", "23", ",", 
   "18", ",", "21", ",", "17", ",", "15", ",", "16", ",", "14", ",", "6", ",",
    "11", ",", "11", ",", "8", ",", "2", ",", "3", ",", "3", ",", "4", ",", 
   "1", ",", "0", ",", "4", ",", "1", ",", "1", ",", "1", ",", "5", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.781335633222334*^9, 3.781338832023076*^9},
 CellLabel->
  "Out[271]=",ExpressionUUID->"d57531ac-dd5b-411f-b8ee-ef8ad0a10a9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataFit", "=", 
  RowBox[{"NonlinearModelFit", "[", 
   RowBox[{
    RowBox[{"DataIn", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"n", "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "l"}], "*", "x"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", " ", "1200"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"l", ",", " ", "0.13"}], "}"}]}], "}"}], ",", " ", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.781336636752136*^9, 3.781336706600893*^9}, {
  3.7813367648563633`*^9, 3.781336778361539*^9}, {3.781336902007677*^9, 
  3.7813369437775908`*^9}, {3.78133699709595*^9, 3.781337011336233*^9}, {
  3.781337091681568*^9, 3.781337095810195*^9}, {3.781337130522756*^9, 
  3.7813371431286097`*^9}, {3.781337195177395*^9, 3.7813371989391212`*^9}, {
  3.781337276850112*^9, 3.781337277561311*^9}, {3.781337330257998*^9, 
  3.781337363913574*^9}, {3.781337471930189*^9, 3.7813374847447567`*^9}, {
  3.781337546311582*^9, 3.781337599152672*^9}, {3.781337749306045*^9, 
  3.781337760448794*^9}, {3.7813379064443083`*^9, 3.781337974057775*^9}, {
  3.781338196178156*^9, 3.78133821687341*^9}, {3.781338643121902*^9, 
  3.781338657513742*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"0b89f795-c311-406a-a300-4ae971af2ac3"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"1263.7833486068444`", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "0.13514825071819214`"}], " ", "x"}]]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Nonlinear", {$CellContext`n -> 1263.7833486068444`, $CellContext`l -> 
      0.13514825071819214`}, {{$CellContext`x}, 
      E^(-$CellContext`l $CellContext`x) $CellContext`n}}, {
    1}, CompressedData["
1:eJwt0EdSAkEYhuFfxZxzwoCYc8KsGEAwKxgwC+pWy70XcOPGnStXHsa1HsMj
WOU31S/Fy0N39cz0dCDzmHjINrM75el9vnxmWfLd5+Y+csz0tah+NGXfmsyV
rzJPRmS+/NNFBfJTFsp7WSRTslj6ZYn8VaXec1SZ+lHl6kVVqDdVqZ5VlXpS
1SqpalRa1aqYqlNxVa9CqkH1q0bGTSqomtHP/xZs5do2ntXOvQPsoYO9Bdlb
J3vuMvfu3eberQd7zZ1BH+fp7cU7uwEcNHeGQ+bOeJgzH2F+lPkxHMcJc2c+
yfoQTuE0zuAszuE891lgvIhLGMZl1q0wXsU1jGAU11kfYxzHDdzELdZtM97B
XdzDfTzABCbxEI/wGE8whad4hud4gZd4hdd4g2nM4C3+A4rXI5o=
    "], 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`l, $CellContext`n, \
$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.781338650657959*^9, 3.7813386581338377`*^9}, 
   3.781338833239571*^9},
 CellLabel->
  "Out[272]=",ExpressionUUID->"aadac231-4707-484b-9242-3602ea7f2344"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataFit", "[", "\"\<ParameterTable\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.781338679554491*^9, 3.7813386869665937`*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"40db34cb-4da6-415e-9556-1e0ca5008cdf"],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"Standard Error\"\>", "\<\"t\
\[Hyphen]Statistic\"\>", "\<\"P\[Hyphen]Value\"\>"},
     {"n", "1263.7833486068444`", "7.268105344960645`", "173.8807142473645`", 
      "7.285870149408647`*^-124"},
     {"l", "0.13514825071819214`", "0.0011742626586308236`", 
      "115.09201090987038`", "2.1755900302129044`*^-106"}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
    GridBoxDividers->{
     "ColumnsIndexed" -> {2 -> GrayLevel[0.7]}, 
      "RowsIndexed" -> {2 -> GrayLevel[0.7]}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    GridBoxSpacings->{
     "ColumnsIndexed" -> {2 -> 1}, "RowsIndexed" -> {2 -> 0.75}}],
   "Grid"], "DialogStyle",
  StripOnInput->False]], "Output",
 CellChangeTimes->{3.781338687849847*^9},
 CellLabel->
  "Out[262]=",ExpressionUUID->"0a244d85-42ac-4cab-8d55-2dc1a315a40f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataFit", "[", "\"\<BestFit\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.781338692458097*^9, 3.7813387000275927`*^9}},
 CellLabel->
  "In[263]:=",ExpressionUUID->"1969f46f-e99e-4d98-ad5b-3d06588ecd3a"],

Cell[BoxData[
 RowBox[{"1263.7833486068444`", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "0.13514825071819214`"}], " ", "x"}]]}]], "Output",
 CellChangeTimes->{3.781338700780398*^9},
 CellLabel->
  "Out[263]=",ExpressionUUID->"58992c78-4bc4-4257-9c54-629fc05e651a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FitPlot", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"DataFit", "[", "\"\<BestFit\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "0", ",", " ", "50"}], "}"}], ",", " ", 
    RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781338704905567*^9, 3.781338756065546*^9}, {
  3.781338988482903*^9, 3.7813390295937433`*^9}},
 CellLabel->
  "In[280]:=",ExpressionUUID->"7b0f7725-5404-4deb-896b-579f1d0c2487"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVxXk4lHkAB/AZW2xTkqOknS0pia4ZbCPS7zsavMrRWD1FkkLNIOQo5Bjx
yKCIp9MRj9yrNBKtVJQ8ZdtK9nHVLtb5VNaW7Z0j7O4fn+ez+kioe4Aag8EQ
/Of/n6Q7luQcWohXiwRC1fs0BGxRanI1l+DHK2FWzC+pcDEN+HuZox4Ex5Tm
/WPJkHXFRz2zWo7KvhUKveAk2OiY3ZqXyEbdbddlJesTcEyVU1C63xA225Rt
CzbGIvTpmMUtFyP8lSBerD55Eule6sYzwWth7sQxffouAn7tp49yRetQbnv/
p3jfE2jRMBAGea5HqfqhqrLYEHC1JZcmIs2QbXMnkREaCN/PthtdgzeiWHq6
mWl8DMWFbWz63GZ4e22KtWL5o+68dX+nOwdW0sPWjwMOI/Jn2z0FzlzUx+Ax
K9EHD5+XfpIeMEfrgNm310K8IHbc1izeb4F09UpnheE+5Fdw64MCLTH7wrst
/RsPXPjcnBR26gc0PU62tDgoxGhV1ElR+FZEne6I4wS54olDzpUzZ3ho2GH1
vYXnLjDd+oayJFYYWtr9MZflCAb/LrMoZhv4smRZp4UAafq0S+dZa7w3edPk
nMJHmJdfK51sg2ixvf+Lqh0YTLL0Jxe3o8Tjy7hOpjX0cq/2SYttwdXaJchi
8VC2xCymPW8HhJU1NZc5lmgJX2VvUk1wqKIj+24CF4WGRWxbD8BQxRs1zt+M
5jglQ/QKKAl6runWa4bVuzW+rtnHh3HZ1MyQkwnuvDTN6O3iw8OpfeQ3/7XI
fDrLMTxoB4Zb7q8bKlcjN2Ii0PetHQJe3o5PGVyJuKUrtYw8d8IjNFLQo/0d
Kk3nP48c2Infq3uyOKf0oT7NNGjxEYCnNvJuu1QP5ZzbCYVjAtR5R8e9a9OG
6ZEq15nj9rhwwyGV3bMY/U73ZHvf2+Nq2Iih8/yF6CyJ3UQiHJAUry+/KNKA
vE643eiTA/zv56SYx8zDXGN4fWqII6RZOuXsaSZ2cxzs4/5xxL4r9c3iNXOk
/eAWcVAEBe9hp4wPdiqi4ydqKoiiMPyx5lmLuYr4iIo1X52icHREUlhkpCJf
wnVllnEUohoap2PVVGRtGq2cSaFQqNKqL25VEonsYWb2JQq619wLZAIlsdbY
U1t/jwIrqjS6yU1BUhdJ1cabKCivf33UCAV5rd3qseIBBb9h86kHXAURsS0V
Ca0UTFhGkyO6CnKZu9yO6qBQMz7bVdAjJ9MHBt70vaWwF5JHtX5ygsMG6zT/
oKAoWDbPeq+cZBx1jyaDFHJi0vo7HOTE6MQT9o0RCqPPKrgLzOREmFoRcHyS
ArZu+DgxRZP8jMGG61MUfOq6+Q1DNBnPXsHq/ETBTc5UO9dFE0le5s2tNIXJ
6t5aYSNNfilqY4gVFLji3Iuoool+2ax7norC1Nk/X/PyaXKkmlf6YobC18xu
X955mtysDaPn5iis/5BoSyQ0+RfzUvKM
       "]]},
     Annotation[#, "Charting`Private`Tag$91089#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {0., 797.4977135960016}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.78133898945286*^9, 3.7813390004331408`*^9}, 
   3.781339030485238*^9},
 CellLabel->
  "Out[280]=",ExpressionUUID->"ee88cd4d-f710-4ea1-9990-91c8461aaa22"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7813389762286053`*^9, 
  3.7813390032017107`*^9}},ExpressionUUID->"48107dc7-3ac5-4daa-ab4b-\
2cdd5119587b"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.781339022335794*^9, 
  3.7813390261876783`*^9}},ExpressionUUID->"ff7e6f98-33f1-4576-948e-\
ead134fdf63b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"DataInPlot", ",", " ", "FitPlot"}], "]"}]], "Input",
 CellChangeTimes->{{3.781339034241682*^9, 3.78133903939401*^9}},
 CellLabel->
  "In[281]:=",ExpressionUUID->"c5036df4-b02f-49e7-aafa-3fbc109b9fe0"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd08sug1EUBeAVI0MDAwODEpFGpHG/09+17toqOpCgIUEiGDAwsSNiIDHh
BTzKeQSP4hFcztrkrD9pVr/u/9xPOxqX1ZMmAMffn59MnvxbFr98Fn/j9JUG
84XZHDP/TLfEfH+iW2NePdJtMXMPdHvMj3s6F/Pwju6MWb6lu2LaDd0dM1zT
eY5/QffEzM7oXtbP6QLnc0T3cfwG3c88YA6wv316kOPX6CHW6/Qw6xV6hFll
jnI9q/QYc5E5LvUJepaeFE+lv2NaPJOOi2K6LmTpvM3t++DjFGRc7hvmmNxn
c/PcMc/kuZkYC0zeA3P7vfN94b0zMZaYvIfm5j1GyfuLj5XS97Gcvm9irEjd
zXsOPyfvX4w1qYuxLnUxNqTu9vltSl2MLamLUU77y8pp3cRBjErqTGxu9h+k
/ve/8PZiEwe3r39b2otNHMSopc7EJg5i7Eh7sYmDGLvSXmziIMaetBebOIhR
T52JTRz+/QXvonkN
       "]]}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.009166666666666668], AbsoluteThickness[1.6]}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.009166666666666668], AbsoluteThickness[
       1.6]}, {}}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVxXk4lHkAB/AZW2xTkqOknS0pia4ZbCPS7zsavMrRWD1FkkLNIOQo5Bjx
yKCIp9MRj9yrNBKtVJQ8ZdtK9nHVLtb5VNaW7Z0j7O4fn+ez+kioe4Aag8EQ
/Of/n6Q7luQcWohXiwRC1fs0BGxRanI1l+DHK2FWzC+pcDEN+HuZox4Ex5Tm
/WPJkHXFRz2zWo7KvhUKveAk2OiY3ZqXyEbdbddlJesTcEyVU1C63xA225Rt
CzbGIvTpmMUtFyP8lSBerD55Eule6sYzwWth7sQxffouAn7tp49yRetQbnv/
p3jfE2jRMBAGea5HqfqhqrLYEHC1JZcmIs2QbXMnkREaCN/PthtdgzeiWHq6
mWl8DMWFbWz63GZ4e22KtWL5o+68dX+nOwdW0sPWjwMOI/Jn2z0FzlzUx+Ax
K9EHD5+XfpIeMEfrgNm310K8IHbc1izeb4F09UpnheE+5Fdw64MCLTH7wrst
/RsPXPjcnBR26gc0PU62tDgoxGhV1ElR+FZEne6I4wS54olDzpUzZ3ho2GH1
vYXnLjDd+oayJFYYWtr9MZflCAb/LrMoZhv4smRZp4UAafq0S+dZa7w3edPk
nMJHmJdfK51sg2ixvf+Lqh0YTLL0Jxe3o8Tjy7hOpjX0cq/2SYttwdXaJchi
8VC2xCymPW8HhJU1NZc5lmgJX2VvUk1wqKIj+24CF4WGRWxbD8BQxRs1zt+M
5jglQ/QKKAl6runWa4bVuzW+rtnHh3HZ1MyQkwnuvDTN6O3iw8OpfeQ3/7XI
fDrLMTxoB4Zb7q8bKlcjN2Ii0PetHQJe3o5PGVyJuKUrtYw8d8IjNFLQo/0d
Kk3nP48c2Infq3uyOKf0oT7NNGjxEYCnNvJuu1QP5ZzbCYVjAtR5R8e9a9OG
6ZEq15nj9rhwwyGV3bMY/U73ZHvf2+Nq2Iih8/yF6CyJ3UQiHJAUry+/KNKA
vE643eiTA/zv56SYx8zDXGN4fWqII6RZOuXsaSZ2cxzs4/5xxL4r9c3iNXOk
/eAWcVAEBe9hp4wPdiqi4ydqKoiiMPyx5lmLuYr4iIo1X52icHREUlhkpCJf
wnVllnEUohoap2PVVGRtGq2cSaFQqNKqL25VEonsYWb2JQq619wLZAIlsdbY
U1t/jwIrqjS6yU1BUhdJ1cabKCivf33UCAV5rd3qseIBBb9h86kHXAURsS0V
Ca0UTFhGkyO6CnKZu9yO6qBQMz7bVdAjJ9MHBt70vaWwF5JHtX5ygsMG6zT/
oKAoWDbPeq+cZBx1jyaDFHJi0vo7HOTE6MQT9o0RCqPPKrgLzOREmFoRcHyS
ArZu+DgxRZP8jMGG61MUfOq6+Q1DNBnPXsHq/ETBTc5UO9dFE0le5s2tNIXJ
6t5aYSNNfilqY4gVFLji3Iuoool+2ax7norC1Nk/X/PyaXKkmlf6YobC18xu
X955mtysDaPn5iis/5BoSyQ0+RfzUvKM
        "]]},
      Annotation[#, "Charting`Private`Tag$91089#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {0, 1300}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.781339040026428*^9},
 CellLabel->"Out[281]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"25967135-5d6b-40ef-9bcb-43f91db4e350"]
}, Open  ]]
},
WindowSize->{1879, 1062},
WindowMargins->{{Automatic, 0}, {0, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 143, 3, 31, "Input",ExpressionUUID->"97b394b0-733f-4539-a85d-970104f64933"],
Cell[726, 27, 172, 3, 35, "Output",ExpressionUUID->"a27b29bc-ff55-4719-8172-a901527e9120"]
}, Open  ]],
Cell[CellGroupData[{
Cell[935, 35, 296, 7, 31, "Input",ExpressionUUID->"a2b06100-2d55-433a-a07f-9fcd0395a123"],
Cell[1234, 44, 6250, 205, 128, "Output",ExpressionUUID->"674edf26-b5fa-4aeb-802f-3d16f17c1952"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7521, 254, 219, 4, 31, "Input",ExpressionUUID->"04493b21-292d-417a-a8ff-a5540f9c4aea"],
Cell[7743, 260, 222, 5, 35, "Output",ExpressionUUID->"8f182359-13ca-41f9-adc0-44fae02d3129"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8002, 270, 592, 15, 31, "Input",ExpressionUUID->"f0aef62d-a72c-428a-a33f-5481433b54a4"],
Cell[8597, 287, 2053, 48, 238, "Output",ExpressionUUID->"41660a5a-5c01-40fc-90a0-b510f6246dad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10687, 340, 286, 7, 31, "Input",ExpressionUUID->"ace87d5c-ba50-456d-9d87-77d580b46a6a"],
Cell[10976, 349, 1377, 22, 59, "Output",ExpressionUUID->"ba8e1a7f-e5e2-4a1c-9d56-58ac62538b46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12390, 376, 286, 7, 31, "Input",ExpressionUUID->"a60ff406-06f7-4196-b023-cf32488babae"],
Cell[12679, 385, 1319, 20, 59, "Output",ExpressionUUID->"d57531ac-dd5b-411f-b8ee-ef8ad0a10a9c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14035, 410, 1427, 32, 31, "Input",ExpressionUUID->"0b89f795-c311-406a-a300-4ae971af2ac3"],
Cell[15465, 444, 1387, 36, 50, "Output",ExpressionUUID->"aadac231-4707-484b-9242-3602ea7f2344"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16889, 485, 232, 4, 31, "Input",ExpressionUUID->"40db34cb-4da6-415e-9556-1e0ca5008cdf"],
Cell[17124, 491, 976, 22, 70, "Output",ExpressionUUID->"0a244d85-42ac-4cab-8d55-2dc1a315a40f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18137, 518, 225, 4, 31, "Input",ExpressionUUID->"1969f46f-e99e-4d98-ad5b-3d06588ecd3a"],
Cell[18365, 524, 294, 7, 35, "Output",ExpressionUUID->"58992c78-4bc4-4257-9c54-629fc05e651a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18696, 536, 493, 11, 31, "Input",ExpressionUUID->"7b0f7725-5404-4deb-896b-579f1d0c2487"],
Cell[19192, 549, 3359, 76, 239, "Output",ExpressionUUID->"ee88cd4d-f710-4ea1-9990-91c8461aaa22"]
}, Open  ]],
Cell[22566, 628, 156, 3, 31, InheritFromParent,ExpressionUUID->"48107dc7-3ac5-4daa-ab4b-2cdd5119587b"],
Cell[22725, 633, 154, 3, 31, "Input",ExpressionUUID->"ff7e6f98-33f1-4576-948e-ead134fdf63b"],
Cell[CellGroupData[{
Cell[22904, 640, 248, 5, 31, "Input",ExpressionUUID->"c5036df4-b02f-49e7-aafa-3fbc109b9fe0"],
Cell[23155, 647, 11056, 198, 238, 3517, 74, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"25967135-5d6b-40ef-9bcb-43f91db4e350"]
}, Open  ]]
}
]
*)

