(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8423,        243]
NotebookOptionsPosition[      6091,        199]
NotebookOutlinePosition[      6426,        214]
CellTagsIndexPosition[      6383,        211]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", "x"}], "+", "3"}], ")"}], 
    RowBox[{"E", "^", "x"}]}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.78091174191154*^9, 3.780911741912785*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"fb70baf5-e845-4e46-b32e-a935ab12461d"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"7", "-", 
    RowBox[{"4", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.780911743125148*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"718e0743-6065-49dc-ab8e-58191447a0b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.780911753393526*^9, 3.780911753393901*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"b3d87890-4d79-4b62-8ee9-096e04f96315"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.780911754376938*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"a0875b95-0fca-4431-adf1-7491f3e2f06f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], 
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], "^", "2"}]}], ",", "x"}], "]"}]], "Input",\

 CellChangeTimes->{{3.78091194599582*^9, 3.780911945996464*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"d97e3504-6dd2-4be7-b510-b9f9ff043a75"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "27"], " ", 
  SuperscriptBox["x", 
   RowBox[{"3", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{"8", "-", 
    RowBox[{"12", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7809119471776667`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"9d411429-83c5-4d84-bf34-dd9b4d1b05be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.78091195436325*^9, 3.780911954363934*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"323c7e7d-1474-4e9d-a89f-d5d0297b11a3"],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], " ", 
  SuperscriptBox[
   RowBox[{"Log", "[", "x", "]"}], "2"]}]], "Output",
 CellChangeTimes->{3.780911955251001*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"6f430f0e-1a85-4d35-aa02-3911fde27d25"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7809120584646187`*^9, 3.780912058465097*^9}, {
   3.780912097389542*^9, 3.780912105415649*^9}, 
   3.780912236128098*^9},ExpressionUUID->"49fb0038-f38d-461d-bd87-\
820309471273"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"2", "x"}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"E", "^", "x"}]}], "+", "4"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.780912234575055*^9, 3.780912250267085*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"0f68ff35-3434-418e-a85c-9afc7b5ae4ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "x"}]], "2"], "+", 
  RowBox[{"4", " ", "x"}]}]], "Output",
 CellChangeTimes->{3.780912251137648*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"fddc7c2a-0eff-44cd-a3ba-0d87b2452d0a"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.78091218322369*^9, 3.7809121934364233`*^9}, 
   3.7809122332797003`*^9},ExpressionUUID->"db94d3c4-ec9e-479e-af7c-\
7b15d6c3f14e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.780912210207327*^9, 3.780912258092841*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"f682a43c-5c06-4660-812e-4c8f2cea377b"],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "x"}]]}]], "Output",
 CellChangeTimes->{3.780912259151678*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"64eef9a1-1c32-4513-ab7f-5e49c375a698"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.780912231318953*^9, 
  3.780912231330388*^9}},ExpressionUUID->"983bc126-c019-44ed-908a-\
ef5c5438cebd"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7809122302489*^9, 
  3.780912230257012*^9}},ExpressionUUID->"3f3705cf-f78e-40cb-9273-\
073d49ce1996"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.780912067584215*^9, 3.780912067584816*^9}, {
   3.780912122992041*^9, 3.780912141358905*^9}, 
   3.7809121816875343`*^9},ExpressionUUID->"ac5aa87b-b3f6-4527-af10-\
533b2f67a4f3"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7809121782085752`*^9, 
  3.7809121802798777`*^9}},ExpressionUUID->"2891a203-78bb-4e02-b446-\
18928ae6c6a3"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7809121216795883`*^9, 
  3.7809121216914053`*^9}},ExpressionUUID->"dea49f4e-83b2-4110-8721-\
faa25be32650"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7809121186870937`*^9, 
  3.780912118693941*^9}},ExpressionUUID->"f0e6a5b7-c1b1-4130-9f47-\
4c59d109e208"]
},
WindowSize->{808, 911},
WindowMargins->{{491, Automatic}, {Automatic, 39}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 383, 10, 31, "Input",ExpressionUUID->"fb70baf5-e845-4e46-b32e-a935ab12461d"],
Cell[966, 34, 317, 8, 38, "Output",ExpressionUUID->"718e0743-6065-49dc-ab8e-58191447a0b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1320, 47, 258, 5, 31, "Input",ExpressionUUID->"b3d87890-4d79-4b62-8ee9-096e04f96315"],
Cell[1581, 54, 317, 8, 38, "Output",ExpressionUUID->"a0875b95-0fca-4431-adf1-7491f3e2f06f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1935, 67, 341, 9, 31, "Input",ExpressionUUID->"d97e3504-6dd2-4be7-b510-b9f9ff043a75"],
Cell[2279, 78, 455, 13, 52, "Output",ExpressionUUID->"9d411429-83c5-4d84-bf34-dd9b4d1b05be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2771, 96, 257, 5, 31, "Input",ExpressionUUID->"323c7e7d-1474-4e9d-a89f-d5d0297b11a3"],
Cell[3031, 103, 238, 6, 38, "Output",ExpressionUUID->"6f430f0e-1a85-4d35-aa02-3911fde27d25"]
}, Open  ]],
Cell[3284, 112, 227, 4, 31, "Input",ExpressionUUID->"49fb0038-f38d-461d-bd87-820309471273"],
Cell[CellGroupData[{
Cell[3536, 120, 388, 10, 31, InheritFromParent,ExpressionUUID->"0f68ff35-3434-418e-a85c-9afc7b5ae4ef"],
Cell[3927, 132, 351, 9, 56, "Output",ExpressionUUID->"fddc7c2a-0eff-44cd-a3ba-0d87b2452d0a"]
}, Open  ]],
Cell[4293, 144, 178, 3, 31, InheritFromParent,ExpressionUUID->"db94d3c4-ec9e-479e-af7c-7b15d6c3f14e"],
Cell[CellGroupData[{
Cell[4496, 151, 258, 5, 31, InheritFromParent,ExpressionUUID->"f682a43c-5c06-4660-812e-4c8f2cea377b"],
Cell[4757, 158, 305, 7, 68, "Output",ExpressionUUID->"64eef9a1-1c32-4513-ab7f-5e49c375a698"]
}, Open  ]],
Cell[5077, 168, 152, 3, 31, InheritFromParent,ExpressionUUID->"983bc126-c019-44ed-908a-ef5c5438cebd"],
Cell[5232, 173, 150, 3, 31, InheritFromParent,ExpressionUUID->"3f3705cf-f78e-40cb-9273-073d49ce1996"],
Cell[5385, 178, 227, 4, 31, "Input",ExpressionUUID->"ac5aa87b-b3f6-4527-af10-533b2f67a4f3"],
Cell[5615, 184, 156, 3, 31, InheritFromParent,ExpressionUUID->"2891a203-78bb-4e02-b446-18928ae6c6a3"],
Cell[5774, 189, 156, 3, 31, InheritFromParent,ExpressionUUID->"dea49f4e-83b2-4110-8721-faa25be32650"],
Cell[5933, 194, 154, 3, 31, InheritFromParent,ExpressionUUID->"f0e6a5b7-c1b1-4130-9f47-4c59d109e208"]
}
]
*)

(* End of internal cache information *)

