(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32895,        587]
NotebookOptionsPosition[     32478,        571]
NotebookOutlinePosition[     32813,        586]
CellTagsIndexPosition[     32770,        583]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"5", "t"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.780915356013256*^9, 3.780915358401767*^9}, {
  3.7809155996274157`*^9, 3.7809156229136353`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"38afefbb-3f0c-4cfd-bea1-a3ea8dd8287c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw0mXc8l//3/xukSEOFrIaSvKUUZXYaomG0s5VRIpQkJaOSJJSsSpS0ZGQL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       "]]},
     Annotation[#, "Charting`Private`Tag$67082#1"]& ]}, {}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-0.9999981790614159, 1.}, {-0.9999990682297951, 
   0.9999987335310796}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.780915359678791*^9, {3.780915601278357*^9, 3.780915623432325*^9}},
 CellLabel->
  "Out[126]=",ExpressionUUID->"8073a842-3fb7-44d5-94c8-7e6c3774a5a2"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{341, Automatic}, {24, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 532, 15, 31, "Input",ExpressionUUID->"38afefbb-3f0c-4cfd-bea1-a3ea8dd8287c"],
Cell[1115, 39, 31347, 529, 410, "Output",ExpressionUUID->"8073a842-3fb7-44d5-94c8-7e6c3774a5a2"]
}, Open  ]]
}
]
*)

