(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     19250,        447]
NotebookOptionsPosition[     16963,        400]
NotebookOutlinePosition[     17297,        415]
CellTagsIndexPosition[     17254,        412]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input",
 CellChangeTimes->{{3.78127228383142*^9, 3.781272299901819*^9}, {
  3.7812725140792637`*^9, 3.78127254353409*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"fd91828d-26a4-4a20-80c8-9e211fa467e3"],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 CellChangeTimes->{
  3.781272301007739*^9, {3.781272518101431*^9, 3.781272544557485*^9}},
 CellLabel->"Out[9]=",ExpressionUUID->"21cf1326-1918-48d4-b0b7-fee4a6bee1af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "Pi"}], " ", 
    RowBox[{"x", "^", "3"}]}], "+", 
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{"x", "^", "2"}]}], "-", "1"}]}]], "Input",
 CellChangeTimes->{{3.7812723042012863`*^9, 3.781272371661968*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"dcbd9c49-a5c7-4807-b9fa-00c1e64fa1a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "\[Pi]"]}]], "Output",
 CellChangeTimes->{3.781272372439494*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"05b36302-9a55-4f76-ad71-96023dbcca46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", " ", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "Pi"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.781272401432088*^9, 3.7812725082011433`*^9}, {
  3.781272548376437*^9, 3.7812725509661922`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"bdc0b254-c99c-4f1b-8c95-bb06a92763e4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2Hk0VV/YB3BD5VIqUyU0aJZIioS+l1+lKFOlQYRSkjIVDaJBKkpIkgyV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       "]]},
     Annotation[#, "Charting`Private`Tag$6513#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Ak01FscB3B7pIXEQ2WtFEpFjyS/PxXRi1aVpUXKVmSIHooQioQoVIzK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       "]]},
     Annotation[#, "Charting`Private`Tag$6513#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->
   NCache[{{0, Pi}, {-0.9999999999999979, 9.455366874873942}}, {{
     0, 3.141592653589793}, {-0.9999999999999979, 9.455366874873942}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7812724730042877`*^9, 3.781272521087525*^9}, 
   3.781272552304091*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"9fe46b1a-505a-455b-ada9-2641fe97f502"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "\[Equal]", 
     RowBox[{"g", "[", "x", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781272901846442*^9, 3.78127294127043*^9}, {
  3.7812730360389433`*^9, 3.7812730568165913`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"0b7fc83f-787b-4616-94ab-94b92701917c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.4412725347789603`"}], "}"}]], "Output",
 CellChangeTimes->{3.781273080954131*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"0d31cecd-c0a4-439b-9808-82d06783c8a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "\[Equal]", 
     RowBox[{"g", "[", "x", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781273334190847*^9, 3.781273392560157*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"6b3b4728-dd50-4af8-be20-6b565199f556"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.4412725347789603`"}], "}"}]], "Output",
 CellChangeTimes->{3.781273393622237*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"d1350047-34ae-43ea-adcb-5f6cd63dfb62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"df", "[", "x_", "]"}], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781273396607204*^9, 3.7812734124628487`*^9}, {
  3.7812734547748747`*^9, 3.781273470927615*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"6af23462-897b-4081-9fe5-b1bd1689204a"],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output",
 CellChangeTimes->{3.781273473378541*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"5aab2ad6-6d8b-46eb-8771-a111edcbfc73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dg", "[", "x_", "]"}], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"g", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.781273476208647*^9, 3.78127349719022*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"87e57e58-73ee-4fb7-a6bf-33fc36574105"],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], "\[Pi]"]}]], "Output",
 CellChangeTimes->{3.7812735153224382`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"39e389ff-ddbd-4031-ab2e-bdd299ba5928"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTan", "[", 
   RowBox[{"Abs", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"df", "[", "x", "]"}], "-", 
      RowBox[{"dg", "[", "x", "]"}]}], 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"df", "[", "x", "]"}], " ", 
       RowBox[{"dg", "[", "x", "]"}]}]}]], "]"}], "]"}], " ", "/.", " ", 
  "x1"}]], "Input",
 CellChangeTimes->{{3.781273521752717*^9, 3.7812735423359823`*^9}, {
  3.7812736007268867`*^9, 3.781273665342784*^9}, {3.781273710777711*^9, 
  3.7812737295112677`*^9}, {3.781274166552162*^9, 3.781274188135502*^9}, {
  3.781274248082735*^9, 3.781274249623871*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"1d17e1bd-b431-480d-baa1-0bc5f0a9ef43"],

Cell[BoxData["1.158264563604005`"], "Output",
 CellChangeTimes->{3.7812736712256737`*^9, 3.781273730314826*^9, 
  3.781274188934349*^9, 3.781274249897162*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"0d8c4cb1-e06f-4955-b13d-0556103762bb"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.781273494270596*^9, 
  3.781273494278964*^9}},ExpressionUUID->"4feac96b-4e10-47e7-b66e-\
ec61545958af"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.781273402022806*^9, 
  3.781273402024642*^9}},ExpressionUUID->"3e302dc2-0a77-43ee-a96a-\
1ad01b757ab6"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.781273054873756*^9, 
  3.781273054893038*^9}},ExpressionUUID->"758697a1-56f8-4f87-b947-\
6eebc8a5aee3"]
},
WindowSize->{808, 911},
WindowMargins->{{41, Automatic}, {Automatic, 78}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 301, 6, 31, "Input",ExpressionUUID->"fd91828d-26a4-4a20-80c8-9e211fa467e3"],
Cell[884, 30, 226, 4, 35, "Output",ExpressionUUID->"21cf1326-1918-48d4-b0b7-fee4a6bee1af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1147, 39, 406, 11, 31, "Input",ExpressionUUID->"dcbd9c49-a5c7-4807-b9fa-00c1e64fa1a3"],
Cell[1556, 52, 294, 8, 57, "Output",ExpressionUUID->"05b36302-9a55-4f76-ad71-96023dbcca46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1887, 65, 469, 11, 31, "Input",ExpressionUUID->"bdc0b254-c99c-4f1b-8c95-bb06a92763e4"],
Cell[2359, 78, 10570, 196, 242, "Output",ExpressionUUID->"9fe46b1a-505a-455b-ada9-2641fe97f502"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12966, 279, 468, 11, 55, InheritFromParent,ExpressionUUID->"0b7fc83f-787b-4616-94ab-94b92701917c"],
Cell[13437, 292, 218, 4, 35, "Output",ExpressionUUID->"0d31cecd-c0a4-439b-9808-82d06783c8a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13692, 301, 404, 10, 31, "Input",ExpressionUUID->"6b3b4728-dd50-4af8-be20-6b565199f556"],
Cell[14099, 313, 218, 4, 35, "Output",ExpressionUUID->"d1350047-34ae-43ea-adcb-5f6cd63dfb62"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14354, 322, 364, 8, 31, "Input",ExpressionUUID->"6af23462-897b-4081-9fe5-b1bd1689204a"],
Cell[14721, 332, 178, 3, 35, "Output",ExpressionUUID->"5aab2ad6-6d8b-46eb-8771-a111edcbfc73"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14936, 340, 310, 7, 31, "Input",ExpressionUUID->"87e57e58-73ee-4fb7-a6bf-33fc36574105"],
Cell[15249, 349, 248, 6, 57, "Output",ExpressionUUID->"39e389ff-ddbd-4031-ab2e-bdd299ba5928"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15534, 360, 708, 17, 52, "Input",ExpressionUUID->"1d17e1bd-b431-480d-baa1-0bc5f0a9ef43"],
Cell[16245, 379, 237, 3, 68, "Output",ExpressionUUID->"0d8c4cb1-e06f-4955-b13d-0556103762bb"]
}, Open  ]],
Cell[16497, 385, 152, 3, 31, InheritFromParent,ExpressionUUID->"4feac96b-4e10-47e7-b66e-ec61545958af"],
Cell[16652, 390, 152, 3, 31, InheritFromParent,ExpressionUUID->"3e302dc2-0a77-43ee-a96a-1ad01b757ab6"],
Cell[16807, 395, 152, 3, 31, InheritFromParent,ExpressionUUID->"758697a1-56f8-4f87-b947-6eebc8a5aee3"]
}
]
*)

