(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      7395,        230]
NotebookOptionsPosition[      5667,        190]
NotebookOutlinePosition[      6002,        205]
CellTagsIndexPosition[      5959,        202]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"z", "^", "2"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}], "z"}], "+", "6", "+", 
  RowBox[{"3", "I"}]}]], "Input",
 CellChangeTimes->{{3.780907894270097*^9, 3.78090789427077*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"dc29e81d-31c5-4d47-bc04-1a36ef2c9a1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"6", "+", 
    RowBox[{"3", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "z"}], "+", 
  SuperscriptBox["z", "2"]}]], "Output",
 CellChangeTimes->{3.780907895219789*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"cf484475-0559-4d87-933d-3914d0104053"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "0"}], ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.780907902292897*^9, 3.780907902293457*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"c24e7761-87b1-4563-8ce7-c7c9f28eb337"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"3", " ", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.780907903229581*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"9dcf3850-cccb-4848-9da5-a83e782abb29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%24", "/.", 
  RowBox[{"%25", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.780907913633218*^9, 3.780907922131647*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"626e5cb4-aa58-497b-88f2-85f3e591371a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.780907923784526*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"5895e476-516a-4169-bb3a-cf85e4801e34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%24", "/.", 
  RowBox[{"%25", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.780907954819818*^9, 3.780907954987748*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"cf592f62-ecba-45e0-9b43-ee4ec0aa6f38"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.7809079565511312`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"80bb1621-97a2-4d32-a44c-3c5351065cf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", " ", 
   RowBox[{"Conjugate", "[", "z", "]"}]}], "+", 
  RowBox[{"(", 
   RowBox[{"z", "-", 
    RowBox[{"Conjugate", "[", "z", "]"}]}], ")"}], "-", "3", "+", 
  RowBox[{"2", "I"}]}]], "Input",
 CellChangeTimes->{{3.780908078514963*^9, 3.780908078515641*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"50b0cd6f-8dff-4614-a118-5cd98200ece3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], "+", "z", "-", 
  RowBox[{"Conjugate", "[", "z", "]"}], "+", 
  RowBox[{"z", " ", 
   RowBox[{"Conjugate", "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{3.780908079943883*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"be329b8a-ae47-4775-9b05-24da085223ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "0"}], ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.780908092475584*^9, 3.7809080924760942`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"a44435ec-4945-407b-8fbd-570634b6fb14"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "+", 
      SqrtBox["2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.78090809413822*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"ca9bbaf0-d951-49a4-a8f8-c77f6c16b75b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "I"}], ")"}], "z1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "I"}], ")"}], "z2"}]}], "\[Equal]", 
      RowBox[{"1", "+", "I"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "I"}], ")"}], "z1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "I"}], ")"}], "z2"}]}], "\[Equal]", 
      RowBox[{"1", "+", 
       RowBox[{"3", "I"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.780908472614485*^9, 3.780908472615025*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"dd9bec8f-7556-4e00-8123-f681a4289147"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z1", "\[Rule]", "\[ImaginaryI]"}], ",", 
    RowBox[{"z2", "\[Rule]", 
     RowBox[{"1", "+", "\[ImaginaryI]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.78090848224376*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"4cee6673-ff1f-480c-8d11-c435925bedd6"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 406}, {11, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 321, 8, 31, "Input",ExpressionUUID->"dc29e81d-31c5-4d47-bc04-1a36ef2c9a1d"],
Cell[904, 32, 373, 10, 35, "Output",ExpressionUUID->"cf484475-0559-4d87-933d-3914d0104053"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1314, 47, 257, 5, 31, "Input",ExpressionUUID->"c24e7761-87b1-4563-8ce7-c7c9f28eb337"],
Cell[1574, 54, 407, 11, 35, "Output",ExpressionUUID->"9dcf3850-cccb-4848-9da5-a83e782abb29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2018, 70, 251, 5, 31, "Input",ExpressionUUID->"626e5cb4-aa58-497b-88f2-85f3e591371a"],
Cell[2272, 77, 149, 2, 35, "Output",ExpressionUUID->"5895e476-516a-4169-bb3a-cf85e4801e34"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2458, 84, 251, 5, 31, "Input",ExpressionUUID->"cf592f62-ecba-45e0-9b43-ee4ec0aa6f38"],
Cell[2712, 91, 151, 2, 35, "Output",ExpressionUUID->"80bb1621-97a2-4d32-a44c-3c5351065cf7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2900, 98, 377, 9, 31, "Input",ExpressionUUID->"50b0cd6f-8dff-4614-a118-5cd98200ece3"],
Cell[3280, 109, 391, 10, 35, "Output",ExpressionUUID->"be329b8a-ae47-4775-9b05-24da085223ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3708, 124, 259, 5, 31, "Input",ExpressionUUID->"a44435ec-4945-407b-8fbd-570634b6fb14"],
Cell[3970, 131, 455, 14, 41, "Output",ExpressionUUID->"ca9bbaf0-d951-49a4-a8f8-c77f6c16b75b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4462, 150, 855, 27, 31, "Input",ExpressionUUID->"dd9bec8f-7556-4e00-8123-f681a4289147"],
Cell[5320, 179, 331, 8, 92, "Output",ExpressionUUID->"4cee6673-ff1f-480c-8d11-c435925bedd6"]
}, Open  ]]
}
]
*)

