(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15916,        509]
NotebookOptionsPosition[     13969,        467]
NotebookOutlinePosition[     14304,        482]
CellTagsIndexPosition[     14261,        479]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "fi", "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "fi", "]"}], ",", 
      RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.780908628717313*^9, 3.780908628718018*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"97bf3854-b93a-4b4e-b23e-6145d87d4ab1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "fi", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "fi", "]"}], ",", 
     RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.780908629669092*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"bee16faf-0222-4347-972d-4c44d51c931e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "m", "]"}]], "Input",
 CellChangeTimes->{{3.780908635358322*^9, 3.78090863535886*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"9f6f9b82-fb07-4b0a-a32c-3afc15009880"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"Cos", "[", "fi", "]"}], 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "fi", "]"}]}]},
     {
      RowBox[{"Sin", "[", "fi", "]"}], 
      RowBox[{"Cos", "[", "fi", "]"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.780908681218134*^9},
 CellLabel->
  "Out[40]//MatrixForm=",ExpressionUUID->"2732c8e6-81f9-4c15-a996-\
42936c76a962"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "fi", "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "fi", "]"}], ",", 
      RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[48]:=",ExpressionUUID->"8f284b7a-535b-475f-8f26-529b80230786"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", "fi", "]"}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"Sin", "[", "fi", "]"}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Sin", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"Cos", "[", "fi", "]"}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.780909194926002*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"e264c517-a1e7-4c5e-93ce-eaada349358f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], ",", 
      FractionBox[
       RowBox[{"Sin", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Sin", "[", "fi", "]"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], ",", 
      FractionBox[
       RowBox[{"Cos", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[49]:=",ExpressionUUID->"760580c7-c192-4c5c-ae3f-225affb8d78f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"Cos", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], 
      FractionBox[
       RowBox[{"Sin", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Sin", "[", "fi", "]"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], 
      FractionBox[
       RowBox[{"Cos", "[", "fi", "]"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.78090920363859*^9},
 CellLabel->
  "Out[49]//MatrixForm=",ExpressionUUID->"a79aed34-aea7-46dc-9e99-\
7fd9d00d889d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "fi", "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "fi", "]"}], ",", 
      RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[46]:=",ExpressionUUID->"2f6bbd6a-5f02-4cfa-a2c1-5346ba28b4a1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "Output",
 CellChangeTimes->{3.780909174867714*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"7a43b787-3934-43a3-b3a5-a7a1dfa9fc96"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "fi", "]"}], "2"]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[47]:=",ExpressionUUID->"aeda23de-07f8-4c4f-9427-025da9674b01"],

Cell[BoxData[
 RowBox[{"1", "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7809091833336573`*^9, 
  3.780909212332712*^9}},ExpressionUUID->"82a399e3-cfc8-4de2-b608-\
bc03d463d087"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "fi", "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "fi", "]"}], ",", 
      RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}], ".", 
  RowBox[{"Inverse", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "fi", "]"}], ",", 
       RowBox[{"-", 
        RowBox[{"Sin", "[", "fi", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "fi", "]"}], ",", 
       RowBox[{"Cos", "[", "fi", "]"}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.780909218829064*^9, 3.780909222096246*^9}, {
  3.780910515575099*^9, 3.7809105199416313`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"aeca1d80-58c2-487b-9f97-beda18f423f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"Cos", "[", "fi", "]"}], "2"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Sin", "[", "fi", "]"}], "2"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"Cos", "[", "fi", "]"}], "2"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Sin", "[", "fi", "]"}], "2"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.780909223247055*^9, 3.7809105204278173`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"823e66e1-8d58-4fe0-843e-ef350eececbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], ",", "0"}], "}"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[58]:=",ExpressionUUID->"923c223f-67c2-4f2d-8690-8c9545564962"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}], "0"},
     {"0", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"Cos", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sin", "[", "fi", "]"}], "2"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "fi", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "fi", "]"}], "2"]}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.78091052545372*^9},
 CellLabel->
  "Out[58]//MatrixForm=",ExpressionUUID->"b3ab22da-51c7-49bb-8e19-\
899d558c5914"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 256}, {Automatic, 39}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 506, 14, 31, "Input",ExpressionUUID->"97bf3854-b93a-4b4e-b23e-6145d87d4ab1"],
Cell[1089, 38, 450, 13, 35, "Output",ExpressionUUID->"bee16faf-0222-4347-972d-4c44d51c931e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1576, 56, 207, 3, 31, "Input",ExpressionUUID->"9f6f9b82-fb07-4b0a-a32c-3afc15009880"],
Cell[1786, 61, 783, 24, 65, "Output",ExpressionUUID->"2732c8e6-81f9-4c15-a996-42936c76a962"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2606, 90, 472, 14, 31, "Input",ExpressionUUID->"8f284b7a-535b-475f-8f26-529b80230786"],
Cell[3081, 106, 1194, 38, 57, "Output",ExpressionUUID->"e264c517-a1e7-4c5e-93ce-eaada349358f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4312, 149, 1244, 39, 99, "Input",ExpressionUUID->"760580c7-c192-4c5c-ae3f-225affb8d78f"],
Cell[5559, 190, 1548, 48, 89, "Output",ExpressionUUID->"a79aed34-aea7-46dc-9e99-7fd9d00d889d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7144, 243, 468, 14, 31, "Input",ExpressionUUID->"2f6bbd6a-5f02-4cfa-a2c1-5346ba28b4a1"],
Cell[7615, 259, 283, 7, 35, "Output",ExpressionUUID->"7a43b787-3934-43a3-b3a5-a7a1dfa9fc96"]
}, Open  ]],
Cell[7913, 269, 300, 8, 34, "Input",ExpressionUUID->"aeda23de-07f8-4c4f-9427-025da9674b01"],
Cell[8216, 279, 213, 4, 78, InheritFromParent,ExpressionUUID->"82a399e3-cfc8-4de2-b608-bc03d463d087"],
Cell[CellGroupData[{
Cell[8454, 287, 914, 27, 55, "Input",ExpressionUUID->"aeca1d80-58c2-487b-9f97-beda18f423f6"],
Cell[9371, 316, 1391, 43, 110, "Output",ExpressionUUID->"823e66e1-8d58-4fe0-843e-ef350eececbf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10799, 364, 1426, 45, 106, "Input",ExpressionUUID->"923c223f-67c2-4f2d-8690-8c9545564962"],
Cell[12228, 411, 1725, 53, 154, "Output",ExpressionUUID->"b3ab22da-51c7-49bb-8e19-899d558c5914"]
}, Open  ]]
}
]
*)

