#!/usr/bin/python3.6
import pylab

data = pylab.loadtxt('bell_curve.dat')
x = data[:, 0]
y = data[:, 1]
dx = data[:, 2]
dy = data[:, 3]
pylab.errorbar(x, y, xerr = dx, yerr = dy, capsize = 0, fmt = 'go', label='badanie')
pylab.legend()

pylab.text(7.8, 90, r'$\sim exp \left(\frac{-(x-\mu)^2}{2\sigma^2}\right)$')

pylab.axis([0, 10, 0, 110])
pylab.grid(True)

pylab.xlabel('Populacja')
pylab.ylabel('Wynik')
pylab.title('Rozklad normalny')

pylab.savefig('bell.pdf', bbox_inches = 'tight')
