#!/usr/bin/python3

import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit


def jedenrys(nazwa):
  data=np.loadtxt(nazwa)
  x=np.array((2, 3, 4, 6, 8, 12, 18, 24))
  y=np.array([])
  # Pętla po różnych podziałach 216-elementowej próbki
  for i,num in enumerate(x):
      przedzial=int(len(data)/num)
      dev_avg=0
      # Pętla po kolejnych grupach n-elementowych
      for p in range(0,przedzial):
          srednia=0
          # Pętla po elementach w ramach jednej grupy
          for j in range(0,num):
              srednia=srednia+data[j+p*num]
          srednia=srednia/num
          dev=0
          # Pętla po elementach w ramach jednej grupy       
          for j2 in range(0,num):
              dev=dev+(data[j2+p*num]-srednia)**2
          dev_avg=dev_avg+dev
      dev_avg=dev_avg/przedzial
      y=np.append(y,dev_avg)
  plt.plot(x,y,'ro')

  def f(x,a,b):
      return a*x+b
  start=np.array([1,0])
  par,cov=curve_fit(f,x,y,p0=start)
  x2=np.arange(0,30,0.1)
  plt.plot(x2,f(x2,*par))
  plt.xlabel('n - liczebność próbki')
  plt.ylabel(r'$Średnie \sum(x_i-\overline{x})^2$')  
  #print("parametry= ",par)

for ip in range(1,15):
    nazwa='wahadlo_'+str(ip)+'.txt'    
    jedenrys(nazwa)
plt.savefig('odchylenie_std.pdf')
#plt.show()        


