#!/usr/bin/python3.6

import matplotlib.pyplot as plt
import numpy


means=[]

plt.figure()    
for i in range(1,56):
    name='wahadlo_'+str(i)+'.txt'
    data=numpy.loadtxt(name)
    means.append(data.mean())
    range=(2.00,4.00)
    n,b,p=plt.hist(data,20,range)    
    print("next")

plt.xlabel("okres wahadła [s]")
plt.ylabel("krotność")

r1=(min(means), max(means))

plt.figure()
n_means, b_means, hist_means=plt.hist(means, 100, r1,  facecolor='red')
plt.xlim(r1) 
plt.xlabel("średni okres wahadła [s]")
plt.ylabel("krotność")
plt.savefig('wahadla.pdf', bbox_inches = 'tight')
plt.show()
