#!/usr/bin/python3.6

import pylab
import numpy

data=pylab.loadtxt('wahadlo_1.txt')
interval = data
r1=(interval.min(), interval.max())
n_bins=10
pylab.figure()
n_interval, bins_interval, hist_interval=pylab.hist(interval, n_bins, r1, facecolor='green')
print(n_interval)
print(bins_interval)
print(hist_interval)
pylab.xlabel("okres wahadła [s]")
pylab.ylabel("krotność")
pylab.savefig('okres.pdf', bbox_inches = 'tight')

weights1 = numpy.ones_like(interval)/float(len(interval))    

bin_width=bins_interval[1]-bins_interval[0]
weights2 = numpy.ones_like(interval)/(float(len(interval))*bin_width)
pylab.figure()
n_frequency, b_frequency, hist_frequency=pylab.hist(interval, n_bins, r1, weights=weights1, facecolor='blue')
pylab.ylabel("częstość")
pylab.xlabel("okres wahadła [s]")
pylab.savefig('czestosc.pdf', bbox_inches = 'tight')

pylab.figure()
n_probability, b_probability, hist_probability=pylab.hist(interval, n_bins, r1, weights=weights2, facecolor='red')
pylab.ylabel("gęstość prawdopodobieństwa")
pylab.xlabel("okres wahadła [s]")
pylab.savefig('prawdopodobieństwo.pdf', bbox_inches = 'tight')

#print(n_probability)
#print("suma= ",sum(n_probability)) 
#pylab.figure()
#npp,bpp,hpp=pylab.hist(interval, n_bins, r1, density=True, color='pink')
#pylab.ylabel("gęstość prawdopodobieństwa")
#pylab.xlabel("okres wahadła [s]")
#pylab.savefig('prawdopodobienstwo2.pdf', bbox_inches = 'tight')

#print(npp)
#print("sum_density= ",sum(npp)) 
pylab.show()
