#!/usr/bin/python3.6
import pylab
from scipy.optimize import curve_fit

def g(x, s, m, n):
    return n*pylab.exp(-(x-m)**2/(2*s*s))

data = pylab.loadtxt('bell_curve.dat')
x = data[:, 0]
y = data[:, 1]
dx = data[:, 2]
dy = data[:, 3]
pylab.errorbar(x, y, xerr = dx, yerr = dy, capsize = 0, fmt = 'go', label='badanie')

par, cov = curve_fit(g, x, y, p0 = pylab.array([2.5, 5.3, 101]), sigma = dy, absolute_sigma = True)
print(par)
print(pylab.sqrt(pylab.diag(cov)))

pylab.text(7.8, 90, r'$n*exp \left(\frac{-(x-m)^2}{2 s^2}\right)$')

pylab.axis([0, 10, 0, 120])
pylab.grid(True)

pylab.plot(x, g(x, *par), 'r-', label="fit: s=%5.1f, m=%5.1f, n=%5.1f" % tuple(par))

pylab.legend()
pylab.xlabel('Populacja')
pylab.ylabel('Wynik')
pylab.title('Rozklad normalny')

pylab.savefig('bell_fit.pdf', bbox_inches = 'tight')

s1, m1, n1 = tuple(par)
ndf=len(x)-3
chi2=0
for i in range(len(x)):
  chi2+=((y[i]-g(x[i], s1, m1, n1))/dy[i])**2

print("Chi^2 dopasowania: ", (chi2/ndf))
