from random import sample

base  = 3  # Will generate any size of random sudoku board in O(n^2) time
side  = base*base
nums  = sample(range(1,side+1),side) # random numbers
board = [[nums[(base*(r%base)+r//base+c)%side] for c in range(side) ] for r in range(side)]
rows  = [ r for g in sample(range(base),base) for r in sample(range(g*base,(g+1)*base),base) ] 
cols  = [ c for g in sample(range(base),base) for c in sample(range(g*base,(g+1)*base),base) ]            
board = [[board[r][c] for c in cols] for r in rows]

#for line in board: print(line)

#[6, 2, 5, 8, 4, 3, 7, 9, 1]
#[7, 9, 1, 2, 6, 5, 4, 8, 3]
#[4, 8, 3, 9, 7, 1, 6, 2, 5]
#[8, 1, 4, 5, 9, 7, 2, 3, 6]
#[2, 3, 6, 1, 8, 4, 9, 5, 7]
#[9, 5, 7, 3, 2, 6, 8, 1, 4]
#[5, 6, 9, 4, 3, 2, 1, 7, 8]
#[3, 4, 2, 7, 1, 8, 5, 6, 9]
#[1, 7, 8, 6, 5, 9, 3, 4, 2]

squares = side*side
empties = squares * 3//4
for p in sample(range(squares),empties):
    board[p//side][p%side] = 0

numSize = len(str(side))
for line in board: print("["+"  ".join(f"{n or '.':{numSize}}" for n in line)+"]")