*********************************************************************
****   LO parametrization of the parton densities in the real    ****
****             photon for the FFNS 2 fit based on              ****
****                                                             ****
****            F.Cornet, P.Jankowski and M.Krawczyk             ****
****      "CJK-Improved 5 Flavour LO Parton Distributions        ****
****                   in the Real Photon"                       ****
****                     hep-ph/0404244                          ****
*********************************************************************
****                                                             ****
****   valid for 10^(-5) < x < 1 and 1 < Q^2 < 2*10^5 GeV^2      ****
****                                                             ****
****       x      - Bjorken x variable                           ****
****       Q2     - square of momentum scale (in GeV**2)         ****
****   XPDF(-3:3) - matrix containing x*f(x,Q2)/alfa             ****
****                                                             ****
****   PDF =   -3 ,  -2 ,  -1 ,0 ,1,2,3                          **** 
****         s_bar,u_bar,d_bar,gl,d,u,s                          ****
****                                                             ****
****  All antiquark and corresponding quark densities are equal. ****  
****                                                             ****
****   heavy-quark masses:                                       ****
****             M_charm=1.3, M_beauty=4.3 GeV                   ****
****                                                             ****
****   Lambda_QCD values for active N_f falvours:                ****
****   N_f =   3      4      5                                   ****
****         0.138  0.115  0.084 GeV                             ****
****                                                             ****
****   IOPT = 1 : light partons (gl,up,dn,str)                   ****
****        = 2 : light partons + F2^gamma                       ****
****                                                             ****
****                                                             ****
****  Grid parametrization utilizing the bicubic interpolation   ****
****  in the Hermite polynomials basis. Program reads            ****
****                   "ffns2best.dat"                           ****
****                                                             ****
****  To use it one must add in ones main program:               ****
****        INTEGER IREAD                                        ****
****        common /IREADF2/ IREAD                               ****
****        IREAD = 0                                            ****
****  This allows for fast multiple use of the parametrization.  ****
****                                                             ****
*********************************************************************
****  Evolution, parametrization, checks performed and programs  ****
****  written by                                                 ****
****     Pawel Jankowski, (pjank@fuw.edu.pl)                     ****
****                      Institute of Theoretical Physics,      ****
****                      Warsaw University                      ****
****                      ul. Hoza 69                            ****
****                      00-681 Warsaw                          ****
****                      Poland                                 ****
****                                                             ****
****  Last changes - 17 June 2003                                ****
*********************************************************************

      SUBROUTINE FFNS2GRID(IOPT,X,Q2,XPDF,F2ALF)
      IMPLICIT DOUBLE PRECISION (a-z)
      INTEGER flav,Nf,step,IOPT
      parameter (Pi=3.1415926535897932d0,alfa=7.29735308D-3,
     %           e1=1.d0/3.d0,e2=2.d0/3.d0)
      logical t
      dimension XPDF(-3:3)
      common /Lam/ Lam3
      common /mass/ mc,mb
      common /flavf2/ flav

      XX = X
      QQ2 = Q2

      if ((XX.LE.1.d-5).OR.(XX.GE.1.d0)) then
         print *,'X out of range: ',XX
         stop
      endif
      if ((QQ2.LE.5.d-1).OR.(QQ2.GE.5.d5)) then
         print *,'Q2 out of range: ',QQ2
         stop
      endif

      Lam3 = 0.138d0
      mc = 1.3d0
      mc2 = mc*mc
      mb = 4.3d0
      mb2 = mb*mb

      if (QQ2.LT.mc2) then
         Nf = 3
      elseif (QQ2.LT.mb2) then
         Nf = 4
      else
         Nf = 5
      endif

      ec2 = e2*e2
      ec4 = ec2*ec2
      eb2 = e1*e1
      eb4 = eb2*eb2

      if (IOPT.EQ.1) then

         call GRIDF2(1,XX,QQ2,XGLU,XDN,XUP,XSTR)

         XPDF(0) = xglu/alfa
         XPDF(1) = xdn/alfa
         XPDF(2) = xup/alfa
         XPDF(3) = xstr/alfa
         F2ALF   = 0.d0

         goto 1000

      endif

      if (IOPT.EQ.2) then

         call GRIDF2(2,XX,QQ2,XGLU,XDN,XUP,XSTR)

         XPDF(0) = xglu/alfa
         XPDF(1) = xdn/alfa
         XPDF(2) = xup/alfa
         XPDF(3) = xstr/alfa

**********************************************************************
****   The Bethe-Heitler cross-section for gamma*gamma -> ccbar   ****
**********************************************************************
         W2 = QQ2*(1.d0/XX-1.d0)
         W = DSQRT(W2)

         if (W.GT.2.d0*mc) then
            beta2 = 1.d0-4.d0*mc2*XX/((1.d0-XX)*QQ2)
            beta = DSQRT(beta2)
            mcQ = 4.d0*mc2/QQ2
            F2c = XX*3*ec4*alfa/Pi*( 
     %            beta*( -1.+8.*XX*(1.-XX)-XX*(1.-XX)*mcQ ) +
     %        (XX*XX+(1.-XX)*(1.-XX)+XX*(1.-3.*XX)*mcQ-XX*XX*mcQ*mcQ/2.)
     %            *DLOG((1.+beta)/(1.-beta)) )
         else
            F2c = 0.d0
         endif

**********************************************************************
****   The Bethe-Heitler cross-section for gamma*gamma -> bbbar   ****
**********************************************************************
         if (W.GT.2.d0*mb) then
            beta2 = 1.d0-4.d0*mb2*XX/((1.d0-XX)*QQ2)
            beta = DSQRT(beta2)
            mbQ = 4.d0*mb2/QQ2
            F2b = XX*3*eb4*alfa/Pi*( 
     %            beta*( -1.+8.*XX*(1.-XX)-XX*(1.-XX)*mbQ ) +
     %        (XX*XX+(1.-XX)*(1.-XX)+XX*(1.-3.*XX)*mbQ-XX*XX*mbQ*mbQ/2.)
     %            *DLOG((1.+beta)/(1.-beta)) )
         else
            F2b = 0.d0
         endif

**********************************************************************
****          CHARM - 'resolved' = gamma*G -> ccbar              ****
**********************************************************************
         zetac = XX*(1.d0+4.d0*mc2/QQ2)
         if (zetac.LT.1.d0) then
            step = 2
            eps = 1.d-6
            flav = 1
            call intresf2(XX,zetac,QQ2,zetac,1.d0,step,eps,resres,t)
            ALS = alfasf2(QQ2,Nf)
            F2cres = ec2 * ALS/(2.d0*Pi) * resres
         else
            F2cres = 0.d0
         endif

**********************************************************************
****           BEAUTY - 'resolved' = gamma*G -> bbbar             ****
**********************************************************************
         zetab = XX*(1.d0+4.d0*mb2/QQ2)
         if (zetab.LT.1.d0) then
            step = 2
            eps = 1.d-6
            flav = 2
            call intresf2(XX,zetab,QQ2,zetab,1.d0,step,eps,resres,t)
            ALS = alfasf2(QQ2,Nf)
            F2bres = eb2 * ALS/(2.d0*Pi) * resres
         else
            F2bres = 0.d0
         endif

**********************************************************************

         F2 = 2.d0*(ec2*xup + eb2*xdn + eb2*xstr) 
     %      + F2c + F2cres + F2b + F2bres

         F2ALF = F2/alfa

      endif

 1000 continue

      do 10 I=1,3
 10      XPDF(-I) = XPDF(I)

      RETURN
      END

*************************************************************************
****                    Running alpha strong                         ****
*************************************************************************

      DOUBLE PRECISION FUNCTION alfasf2(Q2,Nf)
      IMPLICIT DOUBLE PRECISION (a-z)
      PARAMETER(PI=3.1415926535898d0)
      INTEGER Nf
      common /Lam/ Lam
      common /mass/ mc,mb

      Lamm = Lam

      if (Nf.EQ.3) goto 20

      Lamm = mc*(Lamm/mc)**(27.d0/25.d0)

      if (Nf.EQ.4) goto 20

      Lamm = mb*(Lamm/mb)**(25.d0/23.d0)

 20   alfasf2 = 12.0d0*PI/((33.0d0-2.0d0*Nf)*DLOG(Q2/(Lamm*Lamm)) )

      END

****************************************************************************

      subroutine intresf2(x0,x,Q2,a,b,n,eps,result,t)
      implicit double precision (a-z)
      integer *4 iadr(60)
      integer n,I,ind
      dimension aa(60),bb(60)
      logical t
      t=.true.

      result=0.d0
      reslt2=0.d0

      ind=1
      iadr(1)=-1
      aa(1)=a
      bb(1)=b
1     c=(aa(ind)+bb(ind))/2.0d0

      call gauscresf2(x0,x,Q2,aa(ind),c,ra1,ra2)
      call gauscresf2(x0,x,Q2,c,bb(ind),rb1,rb2)

      eps1=dabs(ra1-ra2)/(dabs(ra1+result)+1.0d-300)
      eps2=dabs(rb1-rb2)/(dabs(rb1+result)+1.0d-300)
      if(eps1-eps2) 10,10,20
10    if(eps1-eps) 12,12,11
11    if(ind-n) 13,15,15
15    t=.false.
12    result=result+ra1
      reslt2=reslt2+ra2
      iadr(ind)=iadr(ind)+100
      if(iadr(ind)-150) 20,20,30
13    ind=ind+1
      iadr(ind)=0
      aa(ind)=aa(ind-1) 
      bb(ind)=(aa(ind-1)+bb(ind-1))/2.
      go to 1
14    iadr(ind)=iadr(ind)+100
      if(iadr(ind)-150) 23,23,30
20    if(eps2-eps) 22,22,21
21    if(ind-n) 23,25,25
25    t=.false.
22    result=result+rb1
      reslt2=reslt2+rb2
      iadr(ind)=iadr(ind)+100
      if(iadr(ind)-150) 10,10,30
23    ind=ind+1
      iadr(ind)=1
      aa(ind)=(aa(ind-1)+bb(ind-1))/2.
      bb(ind)=bb(ind-1)
      go to 1
24    iadr(ind)=iadr(ind)+100
      if(iadr(ind)-150) 13,13,30
30    ind=ind-1
      if(iadr(ind+1)-200) 100,14,24 
100   eps=dabs(result-reslt2)/(dabs(result)+1.d-300)
      return
      end

****************************************************************************

      subroutine gauscresf2(x0,x,Q2,a,b,gauskr,gaus)
      implicit double precision(a-z)
      integer l,I
      dimension g(3,8)
      logical t
      Parameter (Pi=3.1415926535897932d0)
      data g/
     $9.933798 7588 1716d-1,0.,1.782238 3320 7104d-2,
     $9.602898 5649 7536d-1,1.012285 36290376d-1,4.943939 5002 1394d-2,
     $8.941209 0684 7456d-1,0.  ,8.248229 8931 3584d-2,
     $7.966664 7741 3626d-1,2.223810 3445 3374d-1,1.116463 7082 6840d-1,
     $6.723540 7094 5158d-1,0.  ,1.362631 0925 5172d-1,
     $5.255324 0991 6329d-1,3.137066 4587 7887d-1,1.566526 0616 8188d-1,
     $3.607010 9792 8132d-1,0.  ,1.720706 0855 5211d-1,
     $1.834346 4249 5650d-1,3.626837 8337 8362d-1,1.814000 2506 8035d-1/
      data g39/1.844464 0574 4692d-1/

      gaus=0.d0
      gauskr=0.d0

      d=(b-a)/2.
      e=(b+a)/2.

      z3 = e

      CALL GRIDF2(3,z3,Q2,XGLU3,XDN,XUP,XSTR)
      glu3 = XGLU3/z3
      res3 = glu3*funf2(x0/z3,Q2)

      do 100 l=1,8
      y=d*g(1,l)

      z1 = e+y
      z2 = e-y

      CALL GRIDF2(3,z1,Q2,XGLU1,XDN,XUP,XSTR)
      glu1 = XGLU1/z1
      res1 = glu1*funf2(x0/z1,Q2)

      CALL GRIDF2(3,z2,Q2,XGLU2,XDN,XUP,XSTR)
      glu2 = XGLU2/z2
      res2 = glu2*funf2(x0/z2,Q2)

      c = res1 + res2
      gaus = gaus+c*g(2,l)
      gauskr = gauskr+c*g(3,l)
100   continue
      gaus = d*gaus
      gauskr = d*(gauskr+g39*res3)

      return
      end

****************************************************************************

      DOUBLE PRECISION FUNCTION funf2(X,Q2)
      IMPLICIT DOUBLE PRECISION (a-z)
      integer flav
      common /flavf2/ flav
      common /mass/ mc,mb

      if (flav.EQ.1) then

        mc2 = mc*mc
        beta2 = 1.d0-4.d0*mc2*X / ((1.d0-X)*Q2)

        if (beta2.GT.0.d0) then
           mcQ = 4.d0*mc2/Q2
           beta = DSQRT(beta2)
           funf2 = X*(
     %         beta*( -1.d0+8.d0*X*(1.d0-X)-X*(1.d0-X)*mcQ )
     %         + ( X*X+(1.-X)*(1.-X)+X*(1.-3.*X)*mcQ
     %         - X*X*mcQ*mcQ/2. )
     %         *DLOG((1.+beta)/(1.-beta)) )
        else
           funf2 = 0.d0
        endif

      elseif (flav.EQ.2) then

        mb2 = mb*mb
        beta2 = 1.d0-4.d0*mb2*X / ((1.d0-X)*Q2)

        if (beta2.GT.0.d0) then
           mbQ = 4.d0*mb2/Q2
           beta = DSQRT(beta2)
           funf2 = X*(
     %         beta*( -1.d0+8.d0*X*(1.d0-X)-X*(1.d0-X)*mbQ )
     %         + ( X*X+(1.-X)*(1.-X)+X*(1.-3.*X)*mbQ
     %         - X*X*mbQ*mbQ/2. )
     %         *DLOG((1.+beta)/(1.-beta)) )
        else
           funf2 = 0.d0
        endif

      endif

      END

*********************************************************************
*********************************************************************

      SUBROUTINE GRIDF2(IOPT,XIN,Q2IN,XGLU,XDN,XUP,XSTR)
      IMPLICIT DOUBLE PRECISION (a-z)
      INTEGER I,J,K,L,M,N,bord,NX,NQ2,NQQ2,IOPT,IREAD
      parameter (NX=52,NQ2=32,alfa=7.29735308D-3)
      dimension gl(0:NQ2+1,0:NX+1),dn(0:NQ2+1,0:NX+1),
     %          up(0:NQ2+1,0:NX+1),st(0:NQ2+1,0:NX+1),
     %          x(4),q2(4),glh(4,4),dnh(4,4),uph(4,4),sth(4,4),
     %          xdata(0:NX+1),q2data(0:NQ2+1)
      data xdata/0d0,1d-5,2d-5,4d-5,6d-5,8d-5,
     %	         1d-4,2d-4,4d-4,6d-4,8d-4,
     %	         1d-3,2d-3,4d-3,6d-3,8d-3,
     %	         1d-2,1.4d-2,2d-2,3d-2,4d-2,6d-2,8d-2,
     %	        .1d0,.125d0,.15d0,.175d0,.2d0,.225d0,.25d0,.275d0,
     % 	        .3d0,.325d0,.35d0,.375d0,.4d0,.425d0,.45d0,.475d0,
     %	        .5d0,.525d0,.55d0,.575d0,.6d0,.65d0,.7d0,.75d0,
     %	        .8d0,.85d0,.9d0,.95,.98,1d0,0d0/
      data q2data/0d0,0.5d0,0.75d0,1.d0,1.25d0,1.5d0,2d0,2.5d0,3.2d0,
     %            4d0,5d0,6.4d0,8d0,1d1,1.2d1,1.8d1,2.6d1,4d1,6.4d1,
     %            1d2,1.6d2,2.4d2,4d2,6.4d2,1d3,1.8d3,3.2d3,5.6d3,1d4,
     %            1.8d4,3.2d4,5.6d4,1d5,0d0/
      common /IREADF2/ IREAD
      common /PARTF2/ gl,dn,up,st

      XX = XIN
      QQ2 = Q2IN

      bord = 1

*****************************************************************
****                  reading grid data                      ****
*****************************************************************

      if (IREAD.EQ.0) then
         call readtabf2
      endif
      IREAD = 100

*****************************************************************
****   searching for the J such that: Q2(J) < QQ2 < Q2(J+1)  ****
****    searching for the I such that: x(I) < XX < x(I+1)    ****
*****************************************************************

      NQQ2 = NQ2
      call findq2f2(NQQ2,q2data,QQ2,J)
      call findxf2(xdata,XX,I)
      if (I.EQ.1.OR.I.EQ.NX-1) bord = 0
      if (J.EQ.1.OR.J.EQ.NQ2-1) bord = 0

*****************************************************************
****     *x1(I-1)   $x2(I)   $$xx   $x3(I+1)   *x4(I+2)      ****
*****************************************************************
****              Only 3 points at borders!!!                ****
*****************************************************************

      do 10 K=1,4
         x(K)  = xdata(I+K-2)
 10      q2(K) = q2data(J+K-2)

*****************************************************************
****                  tbh(1,1) = tb(J-1,I-1)                 ****
****                  tbh(1,2) = tb(J-1,I)                   ****
****                  tbh(1,3) = tb(J-1,I+1)                 ****
****                  tbh(1,4) = tb(J-1,I+2) ...             ****
*****************************************************************

      if (IOPT.EQ.3) then
         do 20 K=J-1,J+2
            do 20 L=I-1,I+2
               M = K+2-J
               N = L+2-I
 20            glh(M,N) = gl(K,L)
         call fitf2(bord,QQ2,XX,q2,x,glh,xglu)
         xglu = alfa*xglu
      else
         do 30 K=J-1,J+2
            do 30 L=I-1,I+2
               M = K+2-J
               N = L+2-I
               glh(M,N) = gl(K,L)
               dnh(M,N) = dn(K,L)
               uph(M,N) = up(K,L)
 30            sth(M,N) = st(K,L)
         call fitf2(bord,QQ2,XX,q2,x,glh,xglu)
         call fitf2(bord,QQ2,XX,q2,x,dnh,xdn)
         call fitf2(bord,QQ2,XX,q2,x,uph,xup)
         call fitf2(bord,QQ2,XX,q2,x,sth,xstr)
         xglu = alfa*xglu
         xdn  = alfa*xdn
         xup  = alfa*xup
         xstr = alfa*xstr
      endif

      RETURN
      END

*****************************************************************

      SUBROUTINE READTABF2
      DOUBLE PRECISION gl,dn,up,st
      parameter (NX=52,NQ2=32)
      dimension gl(0:NQ2+1,0:NX+1),dn(0:NQ2+1,0:NX+1),
     %          up(0:NQ2+1,0:NX+1),st(0:NQ2+1,0:NX+1)
      character*14 name
      common /PARTF2/ gl,dn,up,st

      open(12,file='ffns2best.dat',status='old')

      do 1 I=0,NQ2+1
         do 1 J=0,NX+1
            gl(I,J) = 0.d0
            dn(I,J) = 0.d0
            up(I,J) = 0.d0
 1          st(I,J) = 0.d0

      do 10 I=1,NQ2
         do 10 J=1,NX
 10         read(12,100) gl(I,J),dn(I,J),up(I,J),st(I,J)
 100        format (F11.7,3(2X,F10.7))

      close(12)

      RETURN
      END

*********************************************************************
****            Here I use the bisection method                  ****
*********************************************************************

      SUBROUTINE FINDQ2F2(NQ2,q2data,QQ2,I)
      DOUBLE PRECISION QQ2,Q2,q2data
      INTEGER I,iu,ul,NQ2
      dimension q2data(0:NQ2+1)

      il = 1
      iu = NQ2

 10   if (iu-il.GT.1) then
         I = (iu+il)/2
         Q2 = q2data(I)
         if (QQ2.GE.Q2) then
            il = I
         else
            iu = I
         endif
      goto 10
      endif  
      I = il

 100  continue

      RETURN
      END

*********************************************************************
****            Here I use the bisection method                  ****
*********************************************************************

      SUBROUTINE FINDXF2(xdata,XX,I)
      DOUBLE PRECISION XX,x,xdata
      INTEGER I,il,iu
      parameter (NX=52)
      dimension xdata(0:NX+1)

      il = 1
      iu = NX

 10   if (iu-il.GT.1) then
         I = (iu+il)/2
         x = xdata(I)
         if (XX.GE.x) then
            il = I
         else
            iu = I
         endif
      goto 10
      endif  
      I = il

 100  continue

      RETURN
      END

*********************************************************************
****         Here I use the bicubic interpolation in             ****
****              the Hermit polynomials basis                   ****
*********************************************************************

      SUBROUTINE FITF2(bord,xx1,xx2,x1,x2,yg,result)
      IMPLICIT DOUBLE PRECISION (a-z)
      dimension x1(4),x2(4),yg(4,4),y(4),y1(4),y2(4),y12(4)
      integer bord
      external d1ff2,d2ff2

*****************************************************************
****              4 *(x1l,x2u)    3 *(x1u,x2u)               ****
****              1 *(x1l,x2l)    2 *(x1u,x2l)               ****
*****************************************************************

      x1l = x1(2)
      x1u = x1(3)
      x2l = x2(2)
      x2u = x2(3)

*****************************************************************
****      Function values, first and cross-derivatives       ****
****              at 4 corners of a grid cell                ****
*****************************************************************

      y(1) = yg(2,2)
      y(2) = yg(3,2)
      y(3) = yg(3,3)
      y(4) = yg(2,3)

      if (bord.EQ.1) then

         y1(1) = d1ff2(x1(1),x1(3),yg(1,2),yg(3,2))
         y1(2) = d1ff2(x1(2),x1(4),yg(2,2),yg(4,2))
         y1(3) = d1ff2(x1(2),x1(4),yg(2,3),yg(4,3))
         y1(4) = d1ff2(x1(1),x1(3),yg(1,3),yg(3,3))

         y2(1) = d1ff2(x2(1),x2(3),yg(2,1),yg(2,3))
         y2(2) = d1ff2(x2(1),x2(3),yg(3,1),yg(3,3))
         y2(3) = d1ff2(x2(2),x2(4),yg(3,2),yg(3,4))
         y2(4) = d1ff2(x2(2),x2(4),yg(2,2),yg(2,4))

         y12(1) = d2ff2(x1(1),x1(3),x2(1),x2(3),
     %                  yg(1,1),yg(1,3),yg(3,1),yg(3,3))
         y12(2) = d2ff2(x1(2),x1(4),x2(1),x2(3),
     %                  yg(2,1),yg(2,3),yg(4,1),yg(4,3))
         y12(3) = d2ff2(x1(2),x1(4),x2(2),x2(4),
     %                  yg(2,2),yg(2,4),yg(4,2),yg(4,4))
         y12(4) = d2ff2(x1(1),x1(3),x2(2),x2(4),
     %                  yg(1,2),yg(1,4),yg(3,2),yg(3,4))

      else

         y1(1) = d1ff2(x1(2),x1(3),yg(2,2),yg(3,2))
         y1(2) = y1(1)
         y1(3) = d1ff2(x1(2),x1(3),yg(2,3),yg(3,3))
         y1(4) = y1(3)

         y2(1) = d1ff2(x2(2),x2(3),yg(2,2),yg(2,3))
         y2(2) = d1ff2(x2(2),x2(3),yg(3,2),yg(3,3))
         y2(3) = y2(2)
         y2(4) = y2(1)

         y12(1) = d2ff2(x1(2),x1(3),x2(2),x2(3),
     %                  yg(2,2),yg(2,3),yg(3,2),yg(3,3))
         y12(2) = y12(1)
         y12(3) = y12(1)
         y12(4) = y12(1)

      endif

      call iterf2(y,y1,y2,y12,x1l,x1u,x2l,x2u,xx1,xx2,result)

      RETURN
      END

*********************************************************************

      SUBROUTINE iterf2(y,y1,y2,y12,x1l,x1u,x2l,x2u,x1,x2,res)
      IMPLICIT DOUBLE PRECISION (a-z)
      DIMENSION y(4),y1(4),y2(4),y12(4),p(4,4),c(4,4),ht(4),hu(4),ph(4)
      INTEGER I,J

      d1 = x1u-x1l
      d2 = x2u-x2l
      d1d2 = d1*d2

****  local variables  ****
      t = (x1-x1l)/d1
      u = (x2-x2l)/d2

****  local derivatives  ****
      p(1,1) = y(1)
      p(2,1) = y(2)
      p(2,2) = y(3)
      p(1,2) = y(4)
      p(3,1) = y1(1)*d1
      p(4,1) = y1(2)*d1
      p(4,2) = y1(3)*d1
      p(3,2) = y1(4)*d1
      p(1,3) = y2(1)*d2
      p(2,3) = y2(2)*d2
      p(2,4) = y2(3)*d2
      p(1,4) = y2(4)*d2
      p(3,3) = y12(1)*d1d2
      p(4,3) = y12(2)*d1d2
      p(4,4) = y12(3)*d1d2
      p(3,4) = y12(4)*d1d2

****  Hermite polynomials  ****
      t1 = t-1.
      ht(1) = (2.*t+1.)*t1*t1
      ht(2) = t*t*(-2.*t+3.)
      ht(3) = t*t1*t1
      ht(4) = t*t*t1

      u1 = u-1
      hu(1) = (2.*u+1.)*u1*u1
      hu(2) = u*u*(-2.*u+3.)
      hu(3) = u*u1*u1
      hu(4) = u*u*u1

      do 10 I=1,4
         ph(I) = 0.d0
         do 10 J=1,4
 10         ph(I) = ph(I) + p(I,J)*hu(J)

      res = 0.d0
      do 20 I=1,4
 20      res = res + ht(I)*ph(I)

      RETURN
      END

*********************************************************************
****                   First derivative: df/dx                   ****
*********************************************************************
      DOUBLE PRECISION FUNCTION d1ff2(x1,x2,f1,f2)
      IMPLICIT DOUBLE PRECISION (a-z)

      d1ff2 = (f2-f1)/(x2-x1)

      END

*********************************************************************
****                Second derivative: d2f/dxdy                  ****
*********************************************************************
      DOUBLE PRECISION FUNCTION d2ff2(x1,x2,y1,y2,f11,f12,f21,f22)
      IMPLICIT DOUBLE PRECISION (a-z)

      d2ff2 = (f22 - f21 - f12 + f11)/((x2-x1)*(y2-y1))

      END
