*********************************************************************
****   NLO parametrization of the parton densities in the real   ****
****          photon for the FFNS 2 NLO fit based on             ****
****    "A New 5 Flavour NLO Analysis and Parametrizations       ****
****       of Parton Distributions of the Real Photon"           ****
****           by F.Cornet, P.Jankowski & M.Krawczyk             ****
****                     hep-ph/0404063                          ****
*********************************************************************
****                                                             ****
****   valid for 10^(-5) < x < 1 and 1 < Q^2 < 2*10^5 GeV^2      ****
****                                                             ****
****       x      - Bjorken x variable                           ****
****       Q2     - square of momentum scale (in GeV**2)         ****
****   XPDF(-3:3) - matrix containing x*f(x,Q2)/alfa             ****
****                                                             ****
****   PDF =   -3 ,  -2 ,  -1 ,0 ,1,2,3                          **** 
****         s_bar,u_bar,d_bar,gl,d,u,s                          ****
****                                                             ****
****  All antiquark and corresponding quark densities are equal. ****  
****                                                             ****
****   heavy-quark masses:                                       ****
****             M_charm=1.3, M_beauty=4.3 GeV                   ****
****                                                             ****
****   Lambda_QCD values for active N_f falvours:                ****
****   N_f =   3      4      5                                   ****
****         0.323  0.280  0.200 GeV                             ****
****                                                             ****
****                                                             ****
****  Grid parametrization utilizing the bicubic interpolation   ****
****  in the Hermite polynomials basis. Program reads            ****
****                  "ffnsho2best.dat"                          ****
****                                                             ****
****  To use it one must add in ones main program:               ****
****        INTEGER IREAD                                        ****
****        common /IREADFH2/ IREAD                              ****
****        IREAD = 0                                            ****
****  This allows for fast multiple use of the parametrization.  ****
****                                                             ****
*********************************************************************
****  Evolution, parametrization, checks performed and programs  ****
****  written by                                                 ****
****     Pawel Jankowski, (pjank@fuw.edu.pl)                     ****
****                      Institute of Theoretical Physics,      ****
****                      Warsaw University                      ****
****                      ul. Hoza 69                            ****
****                      00-681 Warsaw                          ****
****                      Poland                                 ****
****                                                             ****
****  Last changes - 07 April 2004                                ****
*********************************************************************

      SUBROUTINE FFNSHO2GRID(X,Q2,XPDF)
      IMPLICIT DOUBLE PRECISION (a-z)
      parameter (alfa=7.29735308D-3)
      dimension XPDF(-3:3)

      XX = X
      QQ2 = Q2

      if ((XX.LE.1.d-5).OR.(XX.GE.1.d0)) then
         print *,'X out of range: ',XX
         stop
      endif
      if ((QQ2.LE.5.d-1).OR.(QQ2.GE.5.d5)) then
         print *,'Q2 out of range: ',QQ2
         stop
      endif

      call GRIDFH2(1,XX,QQ2,XGLU,XDN,XUP,XSTR)

      XPDF(0) = xglu/alfa
      XPDF(1) = xdn/alfa
      XPDF(2) = xup/alfa
      XPDF(3) = xstr/alfa

      do 10 I=1,3
 10      XPDF(-I) = XPDF(I)

      RETURN
      END

*********************************************************************
*********************************************************************

      SUBROUTINE GRIDFH2(IOPT,XIN,Q2IN,XGLU,XDN,XUP,XSTR)
      IMPLICIT DOUBLE PRECISION (a-z)
      INTEGER I,J,K,L,M,N,bord,NX,NQ2,NQQ2,IOPT,IREAD
      parameter (NX=52,NQ2=32,alfa=7.29735308D-3)
      dimension gl(0:NQ2+1,0:NX+1),dn(0:NQ2+1,0:NX+1),
     %          up(0:NQ2+1,0:NX+1),st(0:NQ2+1,0:NX+1),
     %          x(4),q2(4),glh(4,4),dnh(4,4),uph(4,4),sth(4,4),
     %          xdata(0:NX+1),q2data(0:NQ2+1)
      data xdata/0d0,1d-5,2d-5,4d-5,6d-5,8d-5,
     %	         1d-4,2d-4,4d-4,6d-4,8d-4,
     %	         1d-3,2d-3,4d-3,6d-3,8d-3,
     %	         1d-2,1.4d-2,2d-2,3d-2,4d-2,6d-2,8d-2,
     %	        .1d0,.125d0,.15d0,.175d0,.2d0,.225d0,.25d0,.275d0,
     % 	        .3d0,.325d0,.35d0,.375d0,.4d0,.425d0,.45d0,.475d0,
     %	        .5d0,.525d0,.55d0,.575d0,.6d0,.65d0,.7d0,.75d0,
     %	        .8d0,.85d0,.9d0,.95,.98,1d0,0d0/
      data q2data/0d0,0.5d0,0.75d0,1.d0,1.25d0,1.5d0,2d0,2.5d0,3.2d0,
     %            4d0,5d0,6.4d0,8d0,1d1,1.2d1,1.8d1,2.6d1,4d1,6.4d1,
     %            1d2,1.6d2,2.4d2,4d2,6.4d2,1d3,1.8d3,3.2d3,5.6d3,1d4,
     %            1.8d4,3.2d4,5.6d4,1d5,0d0/
      common /IREADFH2/ IREAD
      common /PARTFH2/ gl,dn,up,st

      XX = XIN
      QQ2 = Q2IN

      bord = 1

*****************************************************************
****                  reading grid data                      ****
*****************************************************************

      if (IREAD.EQ.0) then
         call readtabfh2
      endif
      IREAD = 100

*****************************************************************
****   searching for the J such that: Q2(J) < QQ2 < Q2(J+1)  ****
****    searching for the I such that: x(I) < XX < x(I+1)    ****
*****************************************************************

      NQQ2 = NQ2
      call findq2fh2(NQQ2,q2data,QQ2,J)
      call findxfh2(xdata,XX,I)
      if (I.EQ.1.OR.I.EQ.NX-1) bord = 0
      if (J.EQ.1.OR.J.EQ.NQ2-1) bord = 0

*****************************************************************
****     *x1(I-1)   $x2(I)   $$xx   $x3(I+1)   *x4(I+2)      ****
*****************************************************************
****              Only 3 points at borders!!!                ****
*****************************************************************

      do 10 K=1,4
         x(K)  = xdata(I+K-2)
 10      q2(K) = q2data(J+K-2)

*****************************************************************
****                  tbh(1,1) = tb(J-1,I-1)                 ****
****                  tbh(1,2) = tb(J-1,I)                   ****
****                  tbh(1,3) = tb(J-1,I+1)                 ****
****                  tbh(1,4) = tb(J-1,I+2) ...             ****
*****************************************************************

      if (IOPT.EQ.3) then
         do 20 K=J-1,J+2
            do 20 L=I-1,I+2
               M = K+2-J
               N = L+2-I
 20            glh(M,N) = gl(K,L)
         call fitfh2(bord,QQ2,XX,q2,x,glh,xglu)
         xglu = alfa*xglu
      else
         do 30 K=J-1,J+2
            do 30 L=I-1,I+2
               M = K+2-J
               N = L+2-I
               glh(M,N) = gl(K,L)
               dnh(M,N) = dn(K,L)
               uph(M,N) = up(K,L)
 30            sth(M,N) = st(K,L)
         call fitfh2(bord,QQ2,XX,q2,x,glh,xglu)
         call fitfh2(bord,QQ2,XX,q2,x,dnh,xdn)
         call fitfh2(bord,QQ2,XX,q2,x,uph,xup)
         call fitfh2(bord,QQ2,XX,q2,x,sth,xstr)
         xglu = alfa*xglu
         xdn  = alfa*xdn
         xup  = alfa*xup
         xstr = alfa*xstr
      endif

      RETURN
      END

*****************************************************************

      SUBROUTINE READTABFH2
      DOUBLE PRECISION gl,dn,up,st
      parameter (NX=52,NQ2=32)
      dimension gl(0:NQ2+1,0:NX+1),dn(0:NQ2+1,0:NX+1),
     %          up(0:NQ2+1,0:NX+1),st(0:NQ2+1,0:NX+1)
      character*14 name
      common /PARTFH2/ gl,dn,up,st

      open(12,file='ffnsho2best.dat',status='old')

      do 1 I=0,NQ2+1
         do 1 J=0,NX+1
            gl(I,J) = 0.d0
            dn(I,J) = 0.d0
            up(I,J) = 0.d0
 1          st(I,J) = 0.d0

      do 10 I=1,NQ2
         do 10 J=1,NX
 10         read(12,100) gl(I,J),dn(I,J),up(I,J),st(I,J)
 100        format (F11.7,3(2X,F10.7))

      close(12)

      RETURN
      END

*********************************************************************
****            Here I use the bisection method                  ****
*********************************************************************

      SUBROUTINE FINDQ2FH2(NQ2,q2data,QQ2,I)
      DOUBLE PRECISION QQ2,Q2,q2data
      INTEGER I,iu,ul,NQ2
      dimension q2data(0:NQ2+1)

      il = 1
      iu = NQ2

 10   if (iu-il.GT.1) then
         I = (iu+il)/2
         Q2 = q2data(I)
         if (QQ2.GE.Q2) then
            il = I
         else
            iu = I
         endif
      goto 10
      endif  
      I = il

 100  continue

      RETURN
      END

*********************************************************************
****            Here I use the bisection method                  ****
*********************************************************************

      SUBROUTINE FINDXFH2(xdata,XX,I)
      DOUBLE PRECISION XX,x,xdata
      INTEGER I,il,iu
      parameter (NX=52)
      dimension xdata(0:NX+1)

      il = 1
      iu = NX

 10   if (iu-il.GT.1) then
         I = (iu+il)/2
         x = xdata(I)
         if (XX.GE.x) then
            il = I
         else
            iu = I
         endif
      goto 10
      endif  
      I = il

 100  continue

      RETURN
      END

*********************************************************************
****         Here I use the bicubic interpolation in             ****
****              the Hermit polynomials basis                   ****
*********************************************************************

      SUBROUTINE FITFH2(bord,xx1,xx2,x1,x2,yg,result)
      IMPLICIT DOUBLE PRECISION (a-z)
      dimension x1(4),x2(4),yg(4,4),y(4),y1(4),y2(4),y12(4)
      integer bord
      external d1ffh2,d2ffh2

*****************************************************************
****              4 *(x1l,x2u)    3 *(x1u,x2u)               ****
****              1 *(x1l,x2l)    2 *(x1u,x2l)               ****
*****************************************************************

      x1l = x1(2)
      x1u = x1(3)
      x2l = x2(2)
      x2u = x2(3)

*****************************************************************
****      Function values, first and cross-derivatives       ****
****              at 4 corners of a grid cell                ****
*****************************************************************

      y(1) = yg(2,2)
      y(2) = yg(3,2)
      y(3) = yg(3,3)
      y(4) = yg(2,3)

      if (bord.EQ.1) then

         y1(1) = d1ffh2(x1(1),x1(3),yg(1,2),yg(3,2))
         y1(2) = d1ffh2(x1(2),x1(4),yg(2,2),yg(4,2))
         y1(3) = d1ffh2(x1(2),x1(4),yg(2,3),yg(4,3))
         y1(4) = d1ffh2(x1(1),x1(3),yg(1,3),yg(3,3))

         y2(1) = d1ffh2(x2(1),x2(3),yg(2,1),yg(2,3))
         y2(2) = d1ffh2(x2(1),x2(3),yg(3,1),yg(3,3))
         y2(3) = d1ffh2(x2(2),x2(4),yg(3,2),yg(3,4))
         y2(4) = d1ffh2(x2(2),x2(4),yg(2,2),yg(2,4))

         y12(1) = d2ffh2(x1(1),x1(3),x2(1),x2(3),
     %                  yg(1,1),yg(1,3),yg(3,1),yg(3,3))
         y12(2) = d2ffh2(x1(2),x1(4),x2(1),x2(3),
     %                  yg(2,1),yg(2,3),yg(4,1),yg(4,3))
         y12(3) = d2ffh2(x1(2),x1(4),x2(2),x2(4),
     %                  yg(2,2),yg(2,4),yg(4,2),yg(4,4))
         y12(4) = d2ffh2(x1(1),x1(3),x2(2),x2(4),
     %                  yg(1,2),yg(1,4),yg(3,2),yg(3,4))

      else

         y1(1) = d1ffh2(x1(2),x1(3),yg(2,2),yg(3,2))
         y1(2) = y1(1)
         y1(3) = d1ffh2(x1(2),x1(3),yg(2,3),yg(3,3))
         y1(4) = y1(3)

         y2(1) = d1ffh2(x2(2),x2(3),yg(2,2),yg(2,3))
         y2(2) = d1ffh2(x2(2),x2(3),yg(3,2),yg(3,3))
         y2(3) = y2(2)
         y2(4) = y2(1)

         y12(1) = d2ffh2(x1(2),x1(3),x2(2),x2(3),
     %                  yg(2,2),yg(2,3),yg(3,2),yg(3,3))
         y12(2) = y12(1)
         y12(3) = y12(1)
         y12(4) = y12(1)

      endif

      call iterfh2(y,y1,y2,y12,x1l,x1u,x2l,x2u,xx1,xx2,result)

      RETURN
      END

*********************************************************************

      SUBROUTINE iterfh2(y,y1,y2,y12,x1l,x1u,x2l,x2u,x1,x2,res)
      IMPLICIT DOUBLE PRECISION (a-z)
      DIMENSION y(4),y1(4),y2(4),y12(4),p(4,4),c(4,4),ht(4),hu(4),ph(4)
      INTEGER I,J

      d1 = x1u-x1l
      d2 = x2u-x2l
      d1d2 = d1*d2

****  local variables  ****
      t = (x1-x1l)/d1
      u = (x2-x2l)/d2

****  local derivatives  ****
      p(1,1) = y(1)
      p(2,1) = y(2)
      p(2,2) = y(3)
      p(1,2) = y(4)
      p(3,1) = y1(1)*d1
      p(4,1) = y1(2)*d1
      p(4,2) = y1(3)*d1
      p(3,2) = y1(4)*d1
      p(1,3) = y2(1)*d2
      p(2,3) = y2(2)*d2
      p(2,4) = y2(3)*d2
      p(1,4) = y2(4)*d2
      p(3,3) = y12(1)*d1d2
      p(4,3) = y12(2)*d1d2
      p(4,4) = y12(3)*d1d2
      p(3,4) = y12(4)*d1d2

****  Hermite polynomials  ****
      t1 = t-1.
      ht(1) = (2.*t+1.)*t1*t1
      ht(2) = t*t*(-2.*t+3.)
      ht(3) = t*t1*t1
      ht(4) = t*t*t1

      u1 = u-1
      hu(1) = (2.*u+1.)*u1*u1
      hu(2) = u*u*(-2.*u+3.)
      hu(3) = u*u1*u1
      hu(4) = u*u*u1

      do 10 I=1,4
         ph(I) = 0.d0
         do 10 J=1,4
 10         ph(I) = ph(I) + p(I,J)*hu(J)

      res = 0.d0
      do 20 I=1,4
 20      res = res + ht(I)*ph(I)

      RETURN
      END

*********************************************************************
****                   First derivative: df/dx                   ****
*********************************************************************
      DOUBLE PRECISION FUNCTION d1ffh2(x1,x2,f1,f2)
      IMPLICIT DOUBLE PRECISION (a-z)

      d1ffh2 = (f2-f1)/(x2-x1)

      END

*********************************************************************
****                Second derivative: d2f/dxdy                  ****
*********************************************************************
      DOUBLE PRECISION FUNCTION d2ffh2(x1,x2,y1,y2,f11,f12,f21,f22)
      IMPLICIT DOUBLE PRECISION (a-z)

      d2ffh2 = (f22 - f21 - f12 + f11)/((x2-x1)*(y2-y1))

      END
