import numpy as np
from sklearn import datasets
import torch

features = 64
classes = 10

source = datasets.load_digits()
data0 = source.data
target0 = source.target
design0 = np.insert(data0, 0, 1., 1)

DESIGN0 = torch.tensor(design0, dtype = torch.float32)
TARGET0 = torch.tensor(target0, dtype = torch.int64)

PARAM = torch.zeros(1 + features, classes, requires_grad = True)

optimizer = torch.optim.SGD([PARAM], lr = 0.0001)
for epoch in range(1000):
    optimizer.zero_grad()
    ACTIVATION = DESIGN0 @ PARAM
    LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET0, reduction = "sum")
    LOSS.backward()
    optimizer.step()
    print("%5d %12.3f" % (epoch, LOSS), flush = True)
