import numpy as np
from sklearn import datasets
import torch

samples = 1797
features = 64
classes = 10

source = datasets.load_digits()
data0 = source.data
target0 = source.target
design0 = np.insert(data0, 0, 1., 1)

DESIGN0 = torch.tensor(design0, dtype = torch.float32)
TARGET0 = torch.tensor(target0, dtype = torch.int64)

PARAM = torch.zeros(1 + features, classes, requires_grad = True)

batch = 100
optimizer = torch.optim.SGD([PARAM], lr = 0.1)
for epoch in range(100):
    LOSS0 = torch.zeros(())
    ACCURACY0 = torch.zeros(())
    count0 = 0
    for index in range(0, samples, batch):
        optimizer.zero_grad()
        DESIGN = DESIGN0[index : index + batch]
        TARGET = TARGET0[index : index + batch]
        count = TARGET.size(0)
        ACTIVATION = DESIGN @ PARAM
        LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET)
        LOSS0 += LOSS * count
        VALUE = torch.argmax(ACTIVATION, 1)
        ACCURACY0 += torch.sum(VALUE == TARGET)
        count0 += count
        LOSS.backward()
        optimizer.step()
    LOSS0 /= count0
    ACCURACY0 /= count0
    print("%4d %12.3f %4.3f" % (epoch, LOSS0, ACCURACY0), flush = True)
