from matplotlib import pyplot as plt
import numpy as np
from sklearn import datasets

samples0 = 200
data0, target0 = datasets.make_circles(samples0, noise = 0.25, factor = 0.1)

def model(data):
    return np.sum(data**2, 1)

grid = 401
x, y = np.meshgrid(np.linspace(-2., 2., grid), np.linspace(-2., 2., grid))
data = np.moveaxis(np.array([x, y]), 0, 2).reshape(grid**2, 2)
value = model(data)

plt.figure(figsize = (5, 5))
plt.xlim(-2., 2.)
plt.ylim(-2., 2.)
plt.scatter(data0[:, 0], data0[:, 1], marker = '.', c = target0)
plt.contour(x, y, value.reshape(grid, grid), [0.5])

plt.show()
