from matplotlib import pyplot as plt
import numpy as np
from sklearn import datasets

samples0, samples1 = 200, 200
data0, target0 = datasets.make_circles(samples0, noise = 0.25, factor = 0.1)
data1, target1 = datasets.make_circles(samples1, noise = 0.25, factor = 0.1)

def model(data):
    square = np.sum(data**2, 1)
    return np.where(square < 0.5, 0., 1.)

grid = 401
x, y = np.meshgrid(np.linspace(-2., 2., grid), np.linspace(-2., 2., grid))
data = np.moveaxis(np.array([x, y]), 0, 2).reshape(grid**2, 2)
value = model(data)

plt.figure(figsize = (5, 5))
plt.xlim(-2., 2.)
plt.ylim(-2., 2.)
plt.scatter(data0[:, 0], data0[:, 1], marker = '.', c = target0)
plt.contour(x, y, value.reshape(grid, grid), [0.5])

plt.figure(figsize = (5, 5))
plt.xlim(-2., 2.)
plt.ylim(-2., 2.)
plt.scatter(data1[:, 0], data1[:, 1], marker = '.', c = target1)
plt.contour(x, y, value.reshape(grid, grid), [0.5])

plt.show()
