from PIL import Image, ImageDraw
import torchvision as tv
import torch

count = torch.randint(10, ()).item()
POSITIONS = torch.randint(64, (count, 2))
image = Image.new('L', (64, 64))
draw = ImageDraw.Draw(image)
for index in range(count):
    draw.ellipse([tuple(POSITIONS[index] - 4), tuple(POSITIONS[index] + 4)], fill = 255)

DATA = tv.transforms.functional.to_tensor(image)
print(DATA.shape, DATA.dtype, flush = True)
print(DATA.min(), DATA.max(), flush = True)

image.show()
