from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torchvision as tv
import torch

batch = 100
DATA0 = torch.empty(batch, 1, 64, 64)
TARGET0 = torch.empty(batch, dtype = torch.int64)
for sample in range(batch):
    count = torch.randint(10, ()).item()
    POSITIONS = torch.randint(64, (count, 2))
    image = Image.new('L', (64, 64))
    draw = ImageDraw.Draw(image)
    for index in range(count):
        draw.ellipse([tuple(POSITIONS[index] - 4), tuple(POSITIONS[index] + 4)], fill = 255)
    DATA0[sample] = tv.transforms.functional.to_tensor(image)
    TARGET0[sample] = count

GRID0 = tv.utils.make_grid(DATA0, nrow = 10)
plt.imshow(GRID0.permute(1, 2, 0))

plt.show()
