from PIL import Image, ImageDraw
import torch
import torchvision as tv

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 8, 5), #60
    torch.nn.ReLU(),
    torch.nn.MaxPool2d(2), #30
    torch.nn.Flatten(),
    torch.nn.Linear(8 * 30 * 30, 10))
variables = model.parameters()

batch = 1000
optimizer = torch.optim.Adam(variables)
for epoch in range(1000):
    optimizer.zero_grad()
    DATA0 = torch.empty(batch, 1, 64, 64)
    TARGET0 = torch.empty(batch, dtype = torch.int64)
    for sample in range(batch):
        count = torch.randint(10, ()).item()
        POSITIONS = torch.randint(64, (count, 2))
        image = Image.new('L', (64, 64))
        draw = ImageDraw.Draw(image)
        for index in range(count):
            draw.ellipse([tuple(POSITIONS[index] - 4), tuple(POSITIONS[index] + 4)], fill = 255)
        DATA0[sample] = tv.transforms.functional.to_tensor(image)
        TARGET0[sample] = count
    ACTIVATION0 = model(DATA0)
    LOSS0 = torch.nn.functional.cross_entropy(ACTIVATION0, TARGET0)
    VALUE0 = ACTIVATION0.argmax(1)
    ACCURACY0 = torch.eq(VALUE0, TARGET0).float().mean()
    LOSS0.backward()
    optimizer.step()
    print("%4d %12.3f %4.3f" % (epoch, LOSS0, ACCURACY0), flush = True)

#accuracy: 847
