import torch
import torchvision as tv

set0 = tv.datasets.MNIST("../MNIST", train = True, download = True,
                         transform = tv.transforms.ToTensor())
set1 = tv.datasets.MNIST("../MNIST", train = False, download = True,
                         transform = tv.transforms.ToTensor())
loader0 = torch.utils.data.DataLoader(set0, batch_size = 1000)
loader1 = torch.utils.data.DataLoader(set1, batch_size = 1000)

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 8, 5), #24
    torch.nn.ReLU(),
    torch.nn.Flatten(),
    torch.nn.Linear(8 * 24 * 24, 10)).cuda()
#model.load_state_dict(torch.load("dictionary.pt"))

accuracy0, accuracy1 = 0., 0.
optimizer = torch.optim.Adam(model.parameters())
for epoch in range(10):
    model.train()
    LOSS0 = torch.zeros((), device = "cuda")
    ACCURACY0 = torch.zeros((), device = "cuda")
    count0 = 0
    for DATA, TARGET in loader0:
        optimizer.zero_grad()
        DATA = DATA.cuda()
        TARGET = TARGET.cuda()
        count = TARGET.size(0)
        ACTIVATION = model(DATA)
        LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET)
        LOSS0 += LOSS * count
        VALUE = ACTIVATION.argmax(1)
        ACCURACY0 += torch.eq(VALUE, TARGET).sum()
        count0 += count
        LOSS.backward()
        optimizer.step()
    LOSS0 /= count0
    ACCURACY0 /= count0
    model.eval()
    with torch.no_grad():
        LOSS1 = torch.zeros((), device = "cuda")
        ACCURACY1 = torch.zeros((), device = "cuda")
        count1 = 0
        for DATA, TARGET in loader1:
            DATA = DATA.cuda()
            TARGET = TARGET.cuda()
            ACTIVATION = model(DATA)
            LOSS1 += torch.nn.functional.cross_entropy(ACTIVATION, TARGET,
                                                       reduction = "sum")
            VALUE = ACTIVATION.argmax(1)
            ACCURACY1 += torch.eq(VALUE, TARGET).sum()
            count1 += TARGET.size(0)
        LOSS1 /= count1
        ACCURACY1 /= count1
    if accuracy1 < ACCURACY1.item():
        accuracy0, accuracy1 = ACCURACY0.item(), ACCURACY1.item()
        torch.save(model.state_dict(), "dictionary.pt")
    print("%4d %12.3f %4.3f %4.3f %12.3f %4.3f %4.3f" % \
          (epoch, LOSS0, ACCURACY0, accuracy0, LOSS1, ACCURACY1, accuracy1),
          flush = True)
