from matplotlib import pyplot as plt
import torchvision as tv

transform = tv.transforms.Compose([tv.transforms.ColorJitter(0.1, 0.1, 0.1, 0.1),
                                   tv.transforms.RandomHorizontalFlip(0.5),
                                   tv.transforms.RandomAffine(10., (0.1, 0.1)),
                                   tv.transforms.ToTensor()])

set0 = tv.datasets.CIFAR10("../CIFAR10", train = True, download = True)

for image, target in set0:
    DATA = transform(image)
    plt.imshow(DATA.permute(1, 2, 0))
    plt.show()
    input()
