import torch
import torchvision as tv

source0 = tv.datasets.STL10("../STL10", split = "train", download = True,
                            transform = tv.transforms.ToTensor())
source1 = tv.datasets.STL10("../STL10", split = "test", download = True,
                            transform = tv.transforms.ToTensor())
loader0 = torch.utils.data.DataLoader(source0, batch_size = 100)
loader1 = torch.utils.data.DataLoader(source1, batch_size = 100)

model = torch.nn.Sequential(
    torch.nn.Conv2d(3, 32, 7), #90
    torch.nn.ReLU(),
    torch.nn.MaxPool2d(2), #45
    torch.nn.Flatten(),
    torch.nn.Linear(32 * 45 * 45, 10)).cuda()
#model.load_state_dict(torch.load("dictionary.pt"))

accuracy0, accuracy1 = 0., 0.
optimizer = torch.optim.Adam(model.parameters())
for epoch in range(1000):
    model.train()
    LOSS0 = torch.zeros((), device = "cuda")
    ACCURACY0 = torch.zeros((), device = "cuda")
    count0 = 0
    for DATA, TARGET in loader0:
        optimizer.zero_grad()
        DATA = DATA.cuda()
        TARGET = TARGET.cuda()
        count = TARGET.size(0)
        ACTIVATION = model(DATA)
        LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET)
        LOSS0 += LOSS * count
        VALUE = ACTIVATION.argmax(1)
        ACCURACY0 += torch.eq(VALUE, TARGET).sum()
        count0 += count
        LOSS.backward()
        optimizer.step()
    LOSS0 /= count0
    ACCURACY0 /= count0
    with torch.no_grad():
        model.eval()
        LOSS1 = torch.zeros((), device = "cuda")
        ACCURACY1 = torch.zeros((), device = "cuda")
        count1 = 0
        for DATA, TARGET in loader1:
            DATA = DATA.cuda()
            TARGET = TARGET.cuda()
            ACTIVATION = model(DATA)
            LOSS1 += torch.nn.functional.cross_entropy(ACTIVATION, TARGET,
                                                       reduction = "sum")
            VALUE = ACTIVATION.argmax(1)
            ACCURACY1 += torch.eq(VALUE, TARGET).sum()
            count1 += TARGET.size(0)
        LOSS1 /= count1
        ACCURACY1 /= count1
    if accuracy1 < ACCURACY1.item():
        accuracy0, accuracy1 = ACCURACY0.item(), ACCURACY1.item()
        torch.save(model.state_dict(), "dictionary.pt")
    print("%4d %12.3f %4.3f %4.3f %12.3f %4.3f %4.3f" % \
          (epoch, LOSS0, ACCURACY0, accuracy0, LOSS1, ACCURACY1, accuracy1),
          flush = True)

#accuracy: train: 1000 test: 484
