from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torch
import torchvision as tv

count = torch.randint(10, ()).item()
POSITIONS = torch.randint(64, (count, 2))
DATA = torch.rand(64, 64)
data = tv.transforms.functional.to_pil_image(DATA)
target = Image.new('L', (64, 64))
data_draw = ImageDraw.Draw(data)
target_draw = ImageDraw.Draw(target)
for index in range(count):
    data_draw.ellipse([tuple(POSITIONS[index] - 8), tuple(POSITIONS[index] + 8)],
                      fill = torch.randint(256, ()).item())
    target_draw.ellipse([tuple(POSITIONS[index] - 8), tuple(POSITIONS[index] + 8)],
                        fill = 255)
DATA = tv.transforms.functional.to_tensor(data)
TARGET = tv.transforms.functional.to_tensor(target).type(torch.int64)

plt.figure()
plt.imshow(DATA[0], cmap = "gray")

plt.figure()
plt.imshow(TARGET[0], cmap = "gray")

plt.show()
