from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torch
import torchvision as tv

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 2, 1))

batch = 256
optimizer = torch.optim.Adam(model.parameters(), lr = 0.1)
for epoch in range(32):
    optimizer.zero_grad()
    DATA0 = torch.empty(batch, 1, 64, 64)
    TARGET0 = torch.empty(batch, 1, 64, 64, dtype = torch.int64)
    ONEHOT0 = torch.empty(batch, 2, 64, 64, dtype = torch.int64)
    for sample in range(batch):
        count = torch.randint(10, ()).item()
        POSITIONS = torch.randint(64, (count, 2))
        image = Image.new('L', (64, 64))
        draw = ImageDraw.Draw(image)
        for index in range(count):
            draw.ellipse([tuple(POSITIONS[index] - 8), tuple(POSITIONS[index] + 8)], fill = 255)
        DATA = tv.transforms.functional.to_tensor(image)
        TARGET = DATA.type(torch.int64)
        ONEHOT = (TARGET == torch.arange(2)[:, None, None])
        DATA0[sample] = DATA
        TARGET0[sample] = TARGET
        ONEHOT0[sample] = ONEHOT
    ACTIVATION0 = model(DATA0)
    LOGARITHM0 = torch.nn.functional.log_softmax(ACTIVATION0, 1)
    ENTROPY0 = -LOGARITHM0 * ONEHOT0
    LOSS0 = ENTROPY0.sum()
    VALUE0 = ACTIVATION0.argmax(1)
    ACCURACY0 = torch.eq(VALUE0, TARGET0[:, 0, :, :]).float().mean()
    LOSS0.backward()
    optimizer.step()
    print("%4d %12.3f %4.3f" % (epoch, LOSS0, ACCURACY0), flush = True)

while True:
    count = torch.randint(10, ()).item()
    POSITIONS = torch.randint(64, (count, 2))
    image = Image.new('L', (64, 64))
    draw = ImageDraw.Draw(image)
    for index in range(count):
        draw.ellipse([tuple(POSITIONS[index] - 8), tuple(POSITIONS[index] + 8)], fill = 255)
    DATA = tv.transforms.functional.to_tensor(image)
    ACTIVATION = model(DATA[None, :])
    VALUE = ACTIVATION.argmax(1)
    plt.figure()
    plt.imshow(DATA[0])
    plt.figure()
    plt.imshow(VALUE.detach()[0])
    plt.show()
    input()
