from matplotlib import pyplot as plt
import torch

DATA0 = 10. * torch.rand(30, 1)
TARGET0 = torch.sin(DATA0)
plt.plot(DATA0, TARGET0, 'o')

model = torch.nn.Sequential(
    torch.nn.Linear(1, 8),
    torch.nn.Tanh(),
    torch.nn.Linear(8, 1))

optimizer = torch.optim.Adam(model.parameters())
for epoch in range(10000):
    optimizer.zero_grad()
    VALUE0 = model(DATA0)
    LOSS0 = torch.nn.functional.mse_loss(VALUE0, TARGET0)
    LOSS0.backward()
    optimizer.step()
    print('%4d %12.3f' % (epoch, LOSS0), flush = True)

DATA1 = torch.linspace(0., 10., 101).unsqueeze(1)
VALUE1 = model(DATA1)
plt.plot(DATA1, VALUE1.detach())

plt.show()
