import torch

DATA0 = 10. * torch.rand(30, 1)
VALUE0 = torch.sin(DATA0)

model = torch.nn.Sequential(
    torch.nn.Linear(1, 8),
    torch.nn.Tanh(),
    torch.nn.Linear(8, 1))

optimizer = torch.optim.Adam(model.parameters())
for epoch in range(10000):
    optimizer.zero_grad()
    VALUE1 = model(DATA0)
    LOSS = torch.nn.functional.mse_loss(VALUE1, VALUE0)
    LOSS.backward()
    optimizer.step()
    print('%4d %12.3f' % (epoch, LOSS), flush = True)
