from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torch
import torchvision as tv

batch = 25
DATA0 = torch.empty(batch, 1, 64, 64)
POSITION0 = 64. * torch.rand(batch, 2)
for sample in range(batch):
    image = Image.new('L', (64, 64))
    draw = ImageDraw.Draw(image)
    draw.ellipse([tuple(POSITION0[sample] - 4.), tuple(POSITION0[sample] + 4.)], fill = 255)
    DATA0[sample] = tv.transforms.functional.to_tensor(image)

GRID = tv.utils.make_grid(DATA0, nrow = 5, pad_value = 0.5)
plt.imshow(GRID.permute(1, 2, 0))

print(POSITION0, flush = True)

plt.show()
