from PIL import Image, ImageDraw
import torch
import torchvision as tv

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 32, 5), #60
    torch.nn.ReLU(),
    torch.nn.MaxPool2d(2), #30
    torch.nn.BatchNorm2d(32),
    torch.nn.Flatten(),
    torch.nn.Linear(32 * 30 * 30, 256),
    torch.nn.ReLU(),
    torch.nn.Linear(256, 2))

batch = 256
optimizer = torch.optim.Adam(model.parameters())
for epoch in range(256):
    optimizer.zero_grad()
    DATA0 = torch.empty(batch, 1, 64, 64)
    POSITION0 = 64. * torch.rand(batch, 2)
    for sample in range(batch):
        image = Image.new('L', (64, 64))
        draw = ImageDraw.Draw(image)
        draw.ellipse([tuple(POSITION0[sample] - 4.), tuple(POSITION0[sample] + 4.)], fill = 255)
        DATA0[sample] = tv.transforms.functional.to_tensor(image)
    POSITION1 = model(DATA0)
    LOSS = torch.nn.functional.mse_loss(POSITION1, POSITION0)
    LOSS.backward()
    optimizer.step()
    print('%4d %12.3f' % (epoch, LOSS.sqrt()), flush = True)
