from matplotlib import pyplot as plt
import torch

torch.pi = 4. * torch.tensor(1.).atan()
torch.sqrt2 = torch.tensor(2.).sqrt()

radius = 2.

def position(t):
    return torch.stack([torch.sqrt2 * radius * t.cos() / (1. + t.sin().square()),
                        torch.sqrt2 * radius * t.cos() * t.sin() / (1. + t.sin().square())]).T

n = 100
t = torch.linspace(0., 2. * torch.pi, n)
r = position(t)

plt.plot(r[:, 0], r[:, 1])
plt.show()
