from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torch
import torchvision as tv

torch.pi = 4. * torch.tensor(1.).atan()
torch.sqrt2 = torch.tensor(2.).sqrt()

radius = 2.

def position(t):
    return torch.stack([torch.sqrt2 * radius * t.cos() / (1. + t.sin().square()),
                        torch.sqrt2 * radius * t.cos() * t.sin() / (1. + t.sin().square())]).T

def angle(t):
    return 3. * t.sin().atan()

n = 100
t = torch.linspace(0., 2. * torch.pi, n)
r = position(t)
a = angle(t)

def car(r, r0, a0):
    return (r - r0) @ torch.tensor([[a0.cos(), -a0.sin()], [a0.sin(), a0.cos()]])

def ground(p, r0, a0):
    return r0 + p @ torch.tensor([[a0.cos(), a0.sin()], [- a0.sin(), a0.cos()]])

def scan(r0, a0):
    p = car(r, r0, a0)
    image = Image.new('L', (64, 64))
    draw = ImageDraw.Draw(image)
    draw.line(list(map(tuple, 32. + torch.tensor([32, -32]) * p)), fill = 255, width = 8, joint = 'curve')
    image.thumbnail((16, 16), Image.ANTIALIAS)
    return tv.transforms.functional.to_tensor(image)

def go(r0, a0, k):
    s = torch.tensor(0.5)
    dp = torch.tensor([s * s * k / 2, s])
    da = s * k
    return ground(dp, r0, a0), a0 - da

index = 0

def kappa(r0, a0):
    global index
    while torch.norm(r[index] - r0) < 1.:
        index = (index + 1) % n
    dp = car(r[index], r0, a0)
    return 2. * dp[0] / dp[1] / dp[1]

r0 = r[index]
a0 = a[index]

rr = torch.empty(28, 2)

for counter in range(28):
    rr[counter] = r0
    k = kappa(r0, a0)
    r0, a0 = go(r0, a0, k)

plt.plot(r[:, 0], r[:, 1])
plt.plot(rr[:, 0], rr[:, 1], 'o')
plt.show()
