import gym
import torch

env = gym.make("CartPole-v1")

model = torch.nn.Sequential(
    torch.nn.Linear(4, 128),
    torch.nn.ReLU(),
    torch.nn.Linear(128, 128),
    torch.nn.ReLU(),
    torch.nn.Linear(128, 2))

epochs = 1000
epsilon = 1.
optimizer = torch.optim.Adam(model.parameters())
for epoch in range(epochs):
    state0 = torch.tensor(env.reset(), dtype = torch.float)
    step1 = 0
    gain1 = 0.
    done1 = False
    while not done1:
        quality0 = model(state0)
        action0 = torch.randint(2, ()) if torch.rand(()) < epsilon else quality0.argmax()
        state1, reward1, done1, info = env.step(action0.item())
        state1 = torch.tensor(state1, dtype = torch.float)
        step1 += 1
        gain1 += reward1
        quality1 = model(state1)
        target0 = reward1 + 0.9 * (not done1) * quality1.max()
        loss = torch.nn.functional.mse_loss(quality0[action0], target0.detach())
        optimizer.zero_grad()
        loss.backward()
        optimizer.step()
        state0 = state1
    print("%4d %4d %12.3f" % (epoch, step1, gain1), flush = True)
    epsilon = epsilon - 1. / epochs if 0.1 < epsilon else epsilon

epochs = 1000
stats = torch.empty(epochs)
for epoch in range(epochs):
    state0 = torch.tensor(env.reset(), dtype = torch.float)
    step1 = 0
    done1 = False
    while not done1:
        quality0 = model(state0)
        action0 = quality0.argmax()
        state1, reward1, done1, info = env.step(action0.item())
        state1 = torch.tensor(state1, dtype = torch.float)
        step1 += 1
        state0 = state1
    stats[epoch] = step1
print(stats.mean().item(), stats.std().item())

env.close()
