#include <iostream>

class Complex
{
private:
	double x;
	double y;
public:
	void setX(double a){x=a;}
	void setY(double a){y=a;}
	double getX() const {return x;}
	double getY() const {return y;}
	Complex(double a=0, double b=0) : x(a),y(b){}
	friend std::ostream& operator<<(std::ostream &out, const Complex& c);
	//operatory tutaj
	Complex operator+(const Complex& z) const
	{
		return Complex(x+z.getX(), y+z.getY());
	}
	Complex operator-(const Complex& z) const
	{
		return Complex(x-z.getX(), y-z.getY());
	}
	Complex operator*(const Complex& z) const
	{
		double re = x*z.getX() - y*z.getY();
		double im = y*z.getX() + x*z.getY();
		return Complex(re, im);
	}
	Complex operator/(const Complex& z) const
	{
		Complex num = (*this) * (Complex(z.getX(), -1*z.getY()));
		double den = z.getX()*z.getX() + z.getY()*z.getY();
		return Complex(num.getX()/den, num.getY()/den);
	}
};

std::ostream& operator<<(std::ostream &os, const Complex& c)
{
	os << c.getX() << "+i(" << c.getY() << ")";
	return os;
};



int main()
{
	Complex a(3.0, 6.0);
	Complex b(2.3, 1.0);
	std::cout << "(a+b): " << (a+b) << std::endl
		<< "(a-b): " << (a-b) << std::endl
		<< "(a*b): " << (a*b) << std::endl
		<< "(a/b): " << (a/b) << std::endl;
	return 0;
}