#include <iostream>

class Complex
{
private:
	double x;
	double y;
public:
	void setX(double a){x=a;}
	void setY(double a){y=a;}
	double getX() const {return x;}
	double getY() const {return y;}
	Complex(double a=0, double b=0) : x(a),y(b){}
	friend std::ostream& operator<<(std::ostream &out, const Complex& c);
	friend 	Complex operator+(const Complex& z1, const Complex& z2) ;
	friend 	Complex operator-(const Complex& z1, const Complex& z2) ;
	friend 	Complex operator*(const Complex& z1, const Complex& z2) ;
	friend 	Complex operator/(const Complex& z1, const Complex& z2) ;

};

	Complex operator+(const Complex& z1, const Complex& z2) 
	{
		return Complex(z1.x+z2.x, z1.y+z2.y);
	}
	Complex operator-(const Complex& z1, const Complex& z2) 
	{
		return Complex(z1.x-z2.x, z1.y-z2.y);
	}
	Complex operator*(const Complex& z1, const Complex& z2) 
	{
		double re = z1.x*z2.x - z1.y*z2.y;
		double im = z1.y*z2.x + z1.x*z2.y;
		return Complex(re, im);
	}
	Complex operator/(const Complex& z1, const Complex& z2) 
	{
		Complex num = z1 * Complex(z2.x, -1*z2.y);
		double den = z2.getX()*z2.getX() + z2.getY()*z2.getY();
		return Complex(num.getX()/den, num.getY()/den);
	}


std::ostream& operator<<(std::ostream &os, const Complex& c)
{
	os << c.getX() << "+i(" << c.getY() << ")";
	return os;
};



int main()
{
	Complex a(3.0, 6.0);
	Complex b(2.3, 1.0);
	std::cout << "(a+b): " << (a+b) << std::endl
		<< "(a-b): " << (a-b) << std::endl
		<< "(a*b): " << (a*b) << std::endl
		<< "(a/b): " << (a/b) << std::endl;
	return 0;
}