//program demostruje użycie wskaźników na wektory

#include <vector>
#include <iostream>

void mnozenie(const std::vector<double>* const u, const std::vector<double>* const v)
{
	// sprawdzenie czy wskaznik jest pusty
	if(u==nullptr || v==nullptr)
	{
		std::cout<<"NULLPTR!"<<std::endl;
		exit(1); //koncze program z kodem 1
	}
	// bede uzywal iteratorow
	auto it1 = u->begin();
	auto it2 = v->begin();
	
	//pierwsza petla wykona sie do konca wektora u
	do
	{
		//sprawdz czy v sie nie skonczyl wczesniej niz u
		if(it2 != v->end())
		{
			std::cout << *it1 * *it2 << " ";
			++it2;
		}
		else
		{
			std::cout << *it1  << " ";
		}
		++it1;
	}
	while( it1 != u->end() );

	//druga petla wykona sie tylko jezeli v jest dluzszy od u
	while( it2 != v->end() )
	{
		std::cout << *it2  << " ";
		++it2;
	}
	// pusta linia dla czytelnosci
	std::cout << std::endl;
}

int main()
{
	//rownej dlugosci wektory
	const std::vector<double> v1 = {1.0, 2.0, 3.0, 4.0, 5.0};
	const std::vector<double> u1 = {-5.0, -4.0, -3.0, -2.0, -1.0};	
	mnozenie(&u1, &v1);
	//pierwszy krotszy
	const std::vector<double> v2 = {1.0, 2.0, 3.0, 4.0,};
	const std::vector<double> u2 = {-5.0, -4.0, -3.0, -2.0, -1.0};	
	mnozenie(&u2, &v2);
	// drugi krotszy
	const std::vector<double> v3 = {1.0, 2.0, 3.0, 4.0,};
	const std::vector<double> u3 = {-5.0, };	
	mnozenie(&u3, &v3);
	// safe check dla nullptr
	mnozenie(&u1, nullptr);

}