#include <iostream>
#include <typeinfo>
#include <math.h>
using namespace std;

template<typename T>
T power(T x, int n)
{
	if(n==0)
		return 1;
	else if(n<0)
		return NAN;

	for(int ii = 1; ii< n; ii++)
		x *= x;
	return x;
}

// Template Specialization: A function
template<>
float power(float x, int n)
{
	if(n==0)
		return 1;
	int sign = n/abs(n);
	for(int ii = 1; ii< n*sign; ii++)
		x *= x;
	if(sign>0)
		return x;
	else
		return 1.0/x;
}

template<>
double power(double x, int n)
{
	if(n==0)
		return 1;
	int sign = n/abs(n);
	for(int ii = 1; ii< n*sign; ii++)
		x *= x;
	if(sign>0)
		return x;
	else
		return 1.0/x;
}


int main()
{
	cout << "[int] -3^2=" << power(-3, 2) << "\ttype is: " << typeid(power(-3, 2)).name() << endl;
	cout << "[int] 5^0=" << power(5, 0) << "\ttype is: " << typeid(power(5, 0)).name() << endl;
	cout << "[unsigned] 4^2=" << power(4U, 2) << "\ttype is: " << typeid(power(4U, 2)).name() << endl;
	cout << "[unsigned] 5^0=" << power(5U, 0) << "\ttype is: " << typeid(power(5U, 0)).name() << endl;
	cout << "[long int] -3^2=" << power(-3L, 2) << "\ttype is: " << typeid(power(-3L, 2)).name() << endl;
	cout << "[long int] 5^0=" << power(5L, 0) << "\ttype is: " << typeid(power(5L, 0)).name() << endl;
	cout << "[float] 4^2=" << power(4.0f, 2) << "\ttype is: " << typeid(power(4.0f, 2)).name() << endl;
	cout << "[float] 2^-2=" << power(2.0f, -2) << "\ttype is: " << typeid(power(2.0f, -2)).name() << endl;
	cout << "[float] 5^0=" << power(5.0f, 0) << "\ttype is: " << typeid(power(5.0f, 0)).name() << endl;
	cout << "[double] 4^2=" << power(4.0, 2) << "\ttype is: " << typeid(power(4.0, 2)).name() << endl;
	cout << "[double] 5^0=" << power(5.0, 0) << "\ttype is: " << typeid(power(5.0, 0)).name() << endl;
	cout << "[double] 2^-2=" << power(2.0, -2) << "\ttype is: " << typeid(power(2.0, -2)).name() << endl;

	return 0;
}

