#include <iostream>
#include <vector>

using namespace std;

// Uwaga, U odpowiada alokatorowi. Możnaby je pominąć i pisać tylko T. 
template<typename T, class U>
vector<T, U>* concatenate(const vector<T,U> & A, const vector<T,U> & B)
{
	vector<T, U>* res = new vector<T,U>;
	for(auto a : A)
	{
		res->push_back(a);
	}
	for(auto b : B)
	{
		res->push_back(b);
	}
	return res;
}


int main()
{
	const vector<char> Achar = {'a', 'b', 'c'};
	const vector<char> Bchar = {'z', 'z', 'z', 'z'};
	vector<char>* Vchar = concatenate(Achar, Bchar);
	cout << "Vchar = [ ";
	for(auto em : *Vchar)
	{
		cout << em << " ";
	}
	cout << "]" << endl;
	delete Vchar; // <---- zwolnienie pamieci!

	const vector<int> Aint = {1, 2, 3};
	const vector<int> Bint = {0, 1, 5, 6, 7};
	vector<int>* Vint = concatenate(Aint, Bint);
	cout << "Vint = [ ";
	for(auto em : *Vint)
	{
		cout << em << " ";
	}
	cout << "]" << endl;
	delete Vint; // <---- zwolnienie pamieci!

	return 0;
}